/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps.renderer.textureview;

import android.graphics.SurfaceTexture;
import android.view.TextureView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.renderer.egl.EGLConfigChooser;
import com.mapbox.mapboxsdk.maps.renderer.textureview.TextureViewMapRenderer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL10;

class TextureViewRenderThread
extends Thread
implements TextureView.SurfaceTextureListener {
    private static final String TAG = "Mbgl-TextureViewRenderThread";
    @NonNull
    private final TextureViewMapRenderer mapRenderer;
    @NonNull
    private final EGLHolder eglHolder;
    private final Object lock = new Object();
    private final ArrayList<Runnable> eventQueue = new ArrayList();
    @Nullable
    private SurfaceTexture surface;
    private int width;
    private int height;
    private boolean requestRender;
    private boolean sizeChanged;
    private boolean paused;
    private boolean destroyContext;
    private boolean destroySurface;
    private boolean shouldExit;
    private boolean exited;

    @UiThread
    TextureViewRenderThread(@NonNull TextureView textureView, @NonNull TextureViewMapRenderer mapRenderer) {
        textureView.setOpaque(!mapRenderer.isTranslucentSurface());
        textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        this.mapRenderer = mapRenderer;
        this.eglHolder = new EGLHolder(new WeakReference<TextureView>(textureView), mapRenderer.isTranslucentSurface());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        Object object = this.lock;
        synchronized (object) {
            this.surface = surface;
            this.width = width;
            this.height = height;
            this.requestRender = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        Object object = this.lock;
        synchronized (object) {
            this.width = width;
            this.height = height;
            this.sizeChanged = true;
            this.requestRender = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        Object object = this.lock;
        synchronized (object) {
            this.surface = null;
            this.destroySurface = true;
            this.requestRender = false;
            this.lock.notifyAll();
        }
        return true;
    }

    @UiThread
    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestRender() {
        Object object = this.lock;
        synchronized (object) {
            this.requestRender = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueEvent(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable must not be null");
        }
        Object object = this.lock;
        synchronized (object) {
            this.eventQueue.add(runnable);
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    void onPause() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    void onResume() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    void onDestroy() {
        Object object = this.lock;
        synchronized (object) {
            this.shouldExit = true;
            this.lock.notifyAll();
            while (!this.exited) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [36[UNCONDITIONALDOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class EGLHolder {
        private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
        private final WeakReference<TextureView> textureViewWeakRef;
        private boolean translucentSurface;
        private EGL10 egl;
        @Nullable
        private EGLConfig eglConfig;
        private EGLDisplay eglDisplay = EGL10.EGL_NO_DISPLAY;
        private EGLContext eglContext = EGL10.EGL_NO_CONTEXT;
        private EGLSurface eglSurface = EGL10.EGL_NO_SURFACE;

        EGLHolder(WeakReference<TextureView> textureViewWeakRef, boolean translucentSurface) {
            this.textureViewWeakRef = textureViewWeakRef;
            this.translucentSurface = translucentSurface;
        }

        void prepare() {
            this.egl = (EGL10)EGLContext.getEGL();
            if (this.eglDisplay == EGL10.EGL_NO_DISPLAY) {
                this.eglDisplay = this.egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
                if (this.eglDisplay == EGL10.EGL_NO_DISPLAY) {
                    throw new RuntimeException("eglGetDisplay failed");
                }
                int[] version = new int[2];
                if (!this.egl.eglInitialize(this.eglDisplay, version)) {
                    throw new RuntimeException("eglInitialize failed");
                }
            }
            if (this.textureViewWeakRef == null) {
                this.eglConfig = null;
                this.eglContext = EGL10.EGL_NO_CONTEXT;
            } else if (this.eglContext == EGL10.EGL_NO_CONTEXT) {
                this.eglConfig = new EGLConfigChooser(this.translucentSurface).chooseConfig(this.egl, this.eglDisplay);
                int[] attrib_list = new int[]{12440, 2, 12344};
                this.eglContext = this.egl.eglCreateContext(this.eglDisplay, this.eglConfig, EGL10.EGL_NO_CONTEXT, attrib_list);
            }
            if (this.eglContext == EGL10.EGL_NO_CONTEXT) {
                throw new RuntimeException("createContext");
            }
        }

        @NonNull
        GL10 createGL() {
            return (GL10)this.eglContext.getGL();
        }

        boolean createSurface() {
            this.destroySurface();
            TextureView view = (TextureView)this.textureViewWeakRef.get();
            if (view != null) {
                int[] surfaceAttribs = new int[]{12344};
                this.eglSurface = this.egl.eglCreateWindowSurface(this.eglDisplay, this.eglConfig, (Object)view.getSurfaceTexture(), surfaceAttribs);
            } else {
                this.eglSurface = EGL10.EGL_NO_SURFACE;
            }
            if (this.eglSurface == null || this.eglSurface == EGL10.EGL_NO_SURFACE) {
                int error = this.egl.eglGetError();
                if (error == 12299) {
                    Logger.e(TextureViewRenderThread.TAG, "createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                }
                return false;
            }
            return this.makeCurrent();
        }

        boolean makeCurrent() {
            if (!this.egl.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext)) {
                Logger.w(TextureViewRenderThread.TAG, String.format("eglMakeCurrent: %s", this.egl.eglGetError()));
                return false;
            }
            return true;
        }

        int swap() {
            if (!this.egl.eglSwapBuffers(this.eglDisplay, this.eglSurface)) {
                return this.egl.eglGetError();
            }
            return 12288;
        }

        private void destroySurface() {
            if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
                return;
            }
            if (!this.egl.eglDestroySurface(this.eglDisplay, this.eglSurface)) {
                Logger.w(TextureViewRenderThread.TAG, String.format("Could not destroy egl surface. Display %s, Surface %s", this.eglDisplay, this.eglSurface));
            }
            this.eglSurface = EGL10.EGL_NO_SURFACE;
        }

        private void destroyContext() {
            if (this.eglContext == EGL10.EGL_NO_CONTEXT) {
                return;
            }
            if (!this.egl.eglDestroyContext(this.eglDisplay, this.eglContext)) {
                Logger.w(TextureViewRenderThread.TAG, String.format("Could not destroy egl context. Display %s, Context %s", this.eglDisplay, this.eglContext));
            }
            this.eglContext = EGL10.EGL_NO_CONTEXT;
        }

        private void terminate() {
            if (this.eglDisplay == EGL10.EGL_NO_DISPLAY) {
                return;
            }
            if (!this.egl.eglTerminate(this.eglDisplay)) {
                Logger.w(TextureViewRenderThread.TAG, String.format("Could not terminate egl. Display %s", this.eglDisplay));
            }
            this.eglDisplay = EGL10.EGL_NO_DISPLAY;
        }

        void cleanup() {
            this.destroySurface();
            this.destroyContext();
            this.terminate();
        }

        static /* synthetic */ void access$000(EGLHolder x0) {
            x0.destroySurface();
        }

        static /* synthetic */ void access$100(EGLHolder x0) {
            x0.destroyContext();
        }

        static /* synthetic */ EGLContext access$200(EGLHolder x0) {
            return x0.eglContext;
        }

        static /* synthetic */ EGLSurface access$300(EGLHolder x0) {
            return x0.eglSurface;
        }

        static /* synthetic */ EGLConfig access$400(EGLHolder x0) {
            return x0.eglConfig;
        }
    }
}

