/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.v4.util.LongSparseArray;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.maps.NativeMap;
import com.mapbox.mapboxsdk.maps.ShapeAnnotations;
import java.util.ArrayList;
import java.util.List;

class ShapeAnnotationContainer
implements ShapeAnnotations {
    private final NativeMap nativeMapView;
    private final LongSparseArray<Annotation> annotations;

    ShapeAnnotationContainer(NativeMap nativeMapView, LongSparseArray<Annotation> annotations) {
        this.nativeMapView = nativeMapView;
        this.annotations = annotations;
    }

    @Override
    @NonNull
    public List<Annotation> obtainAllIn(@NonNull RectF rectangle) {
        RectF rect = this.nativeMapView.getDensityDependantRectangle(rectangle);
        long[] annotationIds = this.nativeMapView.queryShapeAnnotations(rect);
        return this.getAnnotationsFromIds(annotationIds);
    }

    @NonNull
    private List<Annotation> getAnnotationsFromIds(long[] annotationIds) {
        ArrayList<Annotation> shapeAnnotations = new ArrayList<Annotation>();
        for (long annotationId : annotationIds) {
            Annotation annotation = (Annotation)this.annotations.get(annotationId);
            if (annotation == null) continue;
            shapeAnnotations.add(annotation);
        }
        return shapeAnnotations;
    }
}

