/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.JsonElement;
import com.mapbox.mapboxsdk.LibraryLoader;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.PaintPropertyValue;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.types.Formatted;
import com.mapbox.mapboxsdk.utils.ThreadUtils;

public abstract class Layer {
    private static final String TAG = "Mbgl-Layer";
    @Keep
    private long nativePtr;
    @Keep
    private boolean invalidated;
    private boolean detached;

    @Keep
    protected Layer(long nativePtr) {
        this.checkThread();
        this.nativePtr = nativePtr;
    }

    public Layer() {
        this.checkThread();
    }

    protected void checkThread() {
        ThreadUtils.checkThread(TAG);
    }

    public void setProperties(PropertyValue<?> ... properties) {
        if (this.detached) {
            return;
        }
        this.checkThread();
        if (properties.length == 0) {
            return;
        }
        for (PropertyValue<?> property : properties) {
            Object converted = this.convertValue(property.value);
            if (property instanceof PaintPropertyValue) {
                this.nativeSetPaintProperty(property.name, converted);
                continue;
            }
            this.nativeSetLayoutProperty(property.name, converted);
        }
    }

    @NonNull
    public String getId() {
        this.checkThread();
        return this.nativeGetId();
    }

    @NonNull
    public PropertyValue<String> getVisibility() {
        this.checkThread();
        return new PaintPropertyValue<String>("visibility", (String)this.nativeGetVisibility());
    }

    public float getMinZoom() {
        this.checkThread();
        return this.nativeGetMinZoom();
    }

    public float getMaxZoom() {
        this.checkThread();
        return this.nativeGetMaxZoom();
    }

    public void setMinZoom(float zoom) {
        this.checkThread();
        this.nativeSetMinZoom(zoom);
    }

    public void setMaxZoom(float zoom) {
        this.checkThread();
        this.nativeSetMaxZoom(zoom);
    }

    @Keep
    protected native void finalize() throws Throwable;

    @NonNull
    @Keep
    protected native String nativeGetId();

    @NonNull
    @Keep
    protected native Object nativeGetVisibility();

    @Keep
    protected native void nativeSetLayoutProperty(String var1, Object var2);

    @Keep
    protected native void nativeSetPaintProperty(String var1, Object var2);

    @Keep
    protected native void nativeSetFilter(Object[] var1);

    @Nullable
    @Keep
    protected native JsonElement nativeGetFilter();

    @Keep
    protected native void nativeSetSourceLayer(String var1);

    @NonNull
    @Keep
    protected native String nativeGetSourceLayer();

    @NonNull
    @Keep
    protected native String nativeGetSourceId();

    @Keep
    protected native float nativeGetMinZoom();

    @Keep
    protected native float nativeGetMaxZoom();

    @Keep
    protected native void nativeSetMinZoom(float var1);

    @Keep
    protected native void nativeSetMaxZoom(float var1);

    public long getNativePtr() {
        return this.nativePtr;
    }

    @Nullable
    private Object convertValue(@Nullable Object value) {
        if (value instanceof Expression) {
            return ((Expression)value).toArray();
        }
        if (value instanceof Formatted) {
            return ((Formatted)value).toArray();
        }
        return value;
    }

    public void setDetached() {
        this.detached = true;
    }

    public boolean isDetached() {
        return this.detached;
    }

    static {
        LibraryLoader.load();
    }
}

