/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.LibraryLoader;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.maps.TelemetryDefinition;
import com.mapbox.mapboxsdk.net.ConnectivityReceiver;
import com.mapbox.mapboxsdk.offline.OfflineRegion;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import com.mapbox.mapboxsdk.storage.FileSource;
import com.mapbox.mapboxsdk.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

@UiThread
public class OfflineManager {
    private static final String TAG = "Mbgl - OfflineManager";
    @Keep
    private long nativePtr;
    private final FileSource fileSource;
    private final Handler handler = new Handler(Looper.getMainLooper());
    @SuppressLint(value={"StaticFieldLeak"})
    private static OfflineManager instance;
    private Context context;

    private OfflineManager(Context context) {
        this.context = context.getApplicationContext();
        this.fileSource = FileSource.getInstance(this.context);
        this.initialize(this.fileSource);
        this.deleteAmbientDatabase(this.context);
    }

    private void deleteAmbientDatabase(Context context) {
        String path = FileSource.getInternalCachePath(context) + File.separator + "mbgl-cache.db";
        FileUtils.deleteFile(path);
    }

    public static synchronized OfflineManager getInstance(@NonNull Context context) {
        if (instance == null) {
            instance = new OfflineManager(context);
        }
        return instance;
    }

    public void listOfflineRegions(final @NonNull ListOfflineRegionsCallback callback) {
        this.fileSource.activate();
        this.listOfflineRegions(this.fileSource, new ListOfflineRegionsCallback(){

            @Override
            public void onList(final OfflineRegion[] offlineRegions) {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        callback.onList(offlineRegions);
                    }
                });
            }

            @Override
            public void onError(final String error) {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        callback.onError(error);
                    }
                });
            }
        });
    }

    public void mergeOfflineRegions(@NonNull String path, final @NonNull MergeOfflineRegionsCallback callback) {
        final File src = new File(path);
        new Thread(new Runnable(){

            @Override
            public void run() {
                String errorMessage = null;
                if (src.canWrite()) {
                    OfflineManager.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            OfflineManager.this.mergeOfflineDatabaseFiles(src, callback, false);
                        }
                    });
                } else if (src.canRead()) {
                    final File dst = new File(FileSource.getInternalCachePath(OfflineManager.this.context), src.getName());
                    try {
                        OfflineManager.copyTempDatabaseFile(src, dst);
                        OfflineManager.this.handler.post(new Runnable(){

                            @Override
                            public void run() {
                                OfflineManager.this.mergeOfflineDatabaseFiles(dst, callback, true);
                            }
                        });
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        errorMessage = ex.getMessage();
                    }
                } else {
                    errorMessage = "Secondary database needs to be located in a readable path.";
                }
                if (errorMessage != null) {
                    final String finalErrorMessage = errorMessage;
                    OfflineManager.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(finalErrorMessage);
                        }
                    });
                }
            }
        }).start();
    }

    public void resetDatabase(final @Nullable FileSourceCallback callback) {
        this.fileSource.activate();
        this.nativeResetDatabase(new FileSourceCallback(){

            @Override
            public void onSuccess() {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }
                });
            }

            @Override
            public void onError(final @NonNull String message) {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (callback != null) {
                            callback.onError(message);
                        }
                    }
                });
            }
        });
    }

    public void invalidateAmbientCache(final @Nullable FileSourceCallback callback) {
        this.fileSource.activate();
        this.nativeInvalidateAmbientCache(new FileSourceCallback(){

            @Override
            public void onSuccess() {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }
                });
            }

            @Override
            public void onError(final @NonNull String message) {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (callback != null) {
                            callback.onError(message);
                        }
                    }
                });
            }
        });
    }

    public void clearAmbientCache(final @Nullable FileSourceCallback callback) {
        this.fileSource.activate();
        this.nativeClearAmbientCache(new FileSourceCallback(){

            @Override
            public void onSuccess() {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }
                });
            }

            @Override
            public void onError(final @NonNull String message) {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (callback != null) {
                            callback.onError(message);
                        }
                    }
                });
            }
        });
    }

    public void setMaximumAmbientCacheSize(long size, final @Nullable FileSourceCallback callback) {
        this.fileSource.activate();
        this.nativeSetMaximumAmbientCacheSize(size, new FileSourceCallback(){

            @Override
            public void onSuccess() {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }
                });
            }

            @Override
            public void onError(final @NonNull String message) {
                OfflineManager.this.fileSource.activate();
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (callback != null) {
                            callback.onError(message);
                        }
                    }
                });
            }
        });
    }

    private static void copyTempDatabaseFile(@NonNull File sourceFile, File destFile) throws IOException {
        if (!destFile.exists() && !destFile.createNewFile()) {
            throw new IOException("Unable to copy database file for merge.");
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        catch (IOException ex) {
            throw new IOException(String.format("Unable to copy database file for merge. %s", ex.getMessage()));
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    private void mergeOfflineDatabaseFiles(final @NonNull File file, final @NonNull MergeOfflineRegionsCallback callback, final boolean isTemporaryFile) {
        this.fileSource.activate();
        this.mergeOfflineRegions(this.fileSource, file.getAbsolutePath(), new MergeOfflineRegionsCallback(){

            @Override
            public void onMerge(final OfflineRegion[] offlineRegions) {
                if (isTemporaryFile) {
                    file.delete();
                }
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        callback.onMerge(offlineRegions);
                    }
                });
            }

            @Override
            public void onError(final String error) {
                if (isTemporaryFile) {
                    file.delete();
                }
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        callback.onError(error);
                    }
                });
            }
        });
    }

    public void createOfflineRegion(@NonNull OfflineRegionDefinition definition, @NonNull byte[] metadata, final @NonNull CreateOfflineRegionCallback callback) {
        if (!this.isValidOfflineRegionDefinition(definition)) {
            callback.onError(String.format(this.context.getString(R.string.mapbox_offline_error_region_definition_invalid), definition.getBounds()));
            return;
        }
        ConnectivityReceiver.instance(this.context).activate();
        FileSource.getInstance(this.context).activate();
        this.createOfflineRegion(this.fileSource, definition, metadata, new CreateOfflineRegionCallback(){

            @Override
            public void onCreate(final OfflineRegion offlineRegion) {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        ConnectivityReceiver.instance(OfflineManager.this.context).deactivate();
                        FileSource.getInstance(OfflineManager.this.context).deactivate();
                        callback.onCreate(offlineRegion);
                    }
                });
            }

            @Override
            public void onError(final String error) {
                OfflineManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        ConnectivityReceiver.instance(OfflineManager.this.context).deactivate();
                        FileSource.getInstance(OfflineManager.this.context).deactivate();
                        callback.onError(error);
                    }
                });
            }
        });
        TelemetryDefinition telemetry = Mapbox.getTelemetry();
        if (telemetry != null) {
            LatLngBounds bounds = definition.getBounds();
            telemetry.onCreateOfflineRegion(definition);
        }
    }

    private boolean isValidOfflineRegionDefinition(OfflineRegionDefinition definition) {
        return LatLngBounds.world().contains(definition.getBounds());
    }

    @Keep
    public native void setOfflineMapboxTileCountLimit(long var1);

    @Keep
    private native void initialize(FileSource var1);

    @Keep
    protected native void finalize() throws Throwable;

    @Keep
    private native void listOfflineRegions(FileSource var1, ListOfflineRegionsCallback var2);

    @Keep
    private native void createOfflineRegion(FileSource var1, OfflineRegionDefinition var2, byte[] var3, CreateOfflineRegionCallback var4);

    @Keep
    private native void mergeOfflineRegions(FileSource var1, String var2, MergeOfflineRegionsCallback var3);

    @Keep
    private native void nativeResetDatabase(@Nullable FileSourceCallback var1);

    @Keep
    private native void nativeInvalidateAmbientCache(@Nullable FileSourceCallback var1);

    @Keep
    private native void nativeClearAmbientCache(@Nullable FileSourceCallback var1);

    @Keep
    private native void nativeSetMaximumAmbientCacheSize(long var1, @Nullable FileSourceCallback var3);

    @Keep
    public native void putResourceWithUrl(String var1, byte[] var2, long var3, long var5, String var7, boolean var8);

    static {
        LibraryLoader.load();
    }

    @Keep
    public static interface FileSourceCallback {
        public void onSuccess();

        public void onError(@NonNull String var1);
    }

    @Keep
    public static interface MergeOfflineRegionsCallback {
        public void onMerge(OfflineRegion[] var1);

        public void onError(String var1);
    }

    @Keep
    public static interface CreateOfflineRegionCallback {
        public void onCreate(OfflineRegion var1);

        public void onError(String var1);
    }

    @Keep
    public static interface ListOfflineRegionsCallback {
        public void onList(OfflineRegion[] var1);

        public void onError(String var1);
    }
}

