/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.module.loader;

import android.content.Context;
import com.getkeepsafe.relinker.ReLinker;
import com.mapbox.mapboxsdk.LibraryLoader;
import com.mapbox.mapboxsdk.LibraryLoaderProvider;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.exceptions.MapboxConfigurationException;
import com.mapbox.mapboxsdk.log.Logger;

public class LibraryLoaderProviderImpl
implements LibraryLoaderProvider {
    @Override
    public LibraryLoader getDefaultLibraryLoader() {
        return new ReLinkerLibraryLoader();
    }

    private static class ReLinkerLibraryLoader
    extends LibraryLoader {
        private ReLinkerLibraryLoader() {
        }

        @Override
        public void load(String name) {
            try {
                Context context = Mapbox.getApplicationContext();
                ReLinker.log((ReLinker.Logger)new LibraryLogger()).loadLibrary(context, name);
            }
            catch (MapboxConfigurationException exception) {
                Logger.e("Mbgl-LibraryLoader", "Couldn't load so file with relinker, application context missing, call Mapbox.getInstance(Context context, String accessToken) first");
            }
        }

        private static class LibraryLogger
        implements ReLinker.Logger {
            private static final String TAG = "Mbgl-LibraryLoader";

            private LibraryLogger() {
            }

            public void log(String message) {
                Logger.d(TAG, message);
            }
        }
    }
}

