/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.util.LongSparseArray;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.exceptions.MapboxConfigurationException;
import com.mapbox.mapboxsdk.location.LocationComponent;
import com.mapbox.mapboxsdk.maps.AnnotationContainer;
import com.mapbox.mapboxsdk.maps.AnnotationManager;
import com.mapbox.mapboxsdk.maps.AttributionDialogManager;
import com.mapbox.mapboxsdk.maps.CameraChangeDispatcher;
import com.mapbox.mapboxsdk.maps.FocalPointChangeListener;
import com.mapbox.mapboxsdk.maps.IconManager;
import com.mapbox.mapboxsdk.maps.MapChangeReceiver;
import com.mapbox.mapboxsdk.maps.MapGestureDetector;
import com.mapbox.mapboxsdk.maps.MapKeyListener;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.MarkerContainer;
import com.mapbox.mapboxsdk.maps.NativeMap;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import com.mapbox.mapboxsdk.maps.OnMapReadyCallback;
import com.mapbox.mapboxsdk.maps.PolygonContainer;
import com.mapbox.mapboxsdk.maps.PolylineContainer;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.ShapeAnnotationContainer;
import com.mapbox.mapboxsdk.maps.TelemetryDefinition;
import com.mapbox.mapboxsdk.maps.Transform;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.mapboxsdk.maps.renderer.MapRenderer;
import com.mapbox.mapboxsdk.maps.renderer.glsurfaceview.GLSurfaceViewMapRenderer;
import com.mapbox.mapboxsdk.maps.renderer.textureview.TextureViewMapRenderer;
import com.mapbox.mapboxsdk.maps.widgets.CompassView;
import com.mapbox.mapboxsdk.net.ConnectivityReceiver;
import com.mapbox.mapboxsdk.storage.FileSource;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class MapView
extends FrameLayout
implements NativeMapView.ViewCallback {
    private final MapChangeReceiver mapChangeReceiver = new MapChangeReceiver();
    private final MapCallback mapCallback = new MapCallback();
    private final InitialRenderCallback initialRenderCallback = new InitialRenderCallback();
    @Nullable
    private NativeMap nativeMapView;
    @Nullable
    private MapboxMap mapboxMap;
    private AttributionClickListener attributionClickListener;
    private MapboxMapOptions mapboxMapOptions;
    private MapRenderer mapRenderer;
    private boolean destroyed;
    private CompassView compassView;
    private PointF focalPoint;
    private ImageView attrView;
    private ImageView logoView;
    @Nullable
    private MapGestureDetector mapGestureDetector;
    @Nullable
    private MapKeyListener mapKeyListener;
    @Nullable
    private Bundle savedInstanceState;
    private boolean isStarted;

    @UiThread
    public MapView(@NonNull Context context) {
        super(context);
        this.initialize(context, MapboxMapOptions.createFromAttributes(context, null));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, MapboxMapOptions.createFromAttributes(context, attrs));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, MapboxMapOptions.createFromAttributes(context, attrs));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable MapboxMapOptions options) {
        super(context);
        this.initialize(context, options == null ? MapboxMapOptions.createFromAttributes(context, null) : options);
    }

    @CallSuper
    @UiThread
    protected void initialize(@NonNull Context context, @NonNull MapboxMapOptions options) {
        if (this.isInEditMode()) {
            return;
        }
        if (!Mapbox.hasInstance()) {
            throw new MapboxConfigurationException();
        }
        this.setForeground((Drawable)new ColorDrawable(options.getForegroundLoadColor()));
        this.mapboxMapOptions = options;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.mapbox_mapview_internal, (ViewGroup)this);
        this.compassView = (CompassView)view.findViewById(R.id.compassView);
        this.attrView = (ImageView)view.findViewById(R.id.attributionView);
        this.attrView.setImageDrawable(BitmapUtils.getDrawableFromRes(this.getContext(), R.drawable.mapbox_info_bg_selector));
        this.logoView = (ImageView)view.findViewById(R.id.logoView);
        this.logoView.setImageDrawable(BitmapUtils.getDrawableFromRes(this.getContext(), R.drawable.mapbox_logo_icon));
        this.setContentDescription(context.getString(R.string.mapbox_mapActionDescription));
        this.setWillNotDraw(false);
        this.initialiseDrawingSurface(options);
    }

    private void initialiseMap() {
        Context context = this.getContext();
        FocalPointInvalidator focalInvalidator = new FocalPointInvalidator();
        focalInvalidator.addListener(this.createFocalPointChangeListener());
        GesturesManagerInteractionListener registerTouchListener = new GesturesManagerInteractionListener();
        CameraChangeDispatcher cameraDispatcher = new CameraChangeDispatcher();
        Projection proj = new Projection(this.nativeMapView, this);
        UiSettings uiSettings = new UiSettings(proj, focalInvalidator, this.compassView, this.attrView, (View)this.logoView, this.getPixelRatio());
        LongSparseArray annotationsArray = new LongSparseArray();
        IconManager iconManager = new IconManager(this.nativeMapView);
        AnnotationContainer annotations = new AnnotationContainer(this.nativeMapView, (LongSparseArray<Annotation>)annotationsArray);
        MarkerContainer markers = new MarkerContainer(this.nativeMapView, (LongSparseArray<Annotation>)annotationsArray, iconManager);
        PolygonContainer polygons = new PolygonContainer(this.nativeMapView, (LongSparseArray<Annotation>)annotationsArray);
        PolylineContainer polylines = new PolylineContainer(this.nativeMapView, (LongSparseArray<Annotation>)annotationsArray);
        ShapeAnnotationContainer shapeAnnotations = new ShapeAnnotationContainer(this.nativeMapView, (LongSparseArray<Annotation>)annotationsArray);
        AnnotationManager annotationManager = new AnnotationManager(this, (LongSparseArray<Annotation>)annotationsArray, iconManager, annotations, markers, polygons, polylines, shapeAnnotations);
        Transform transform = new Transform(this, this.nativeMapView, cameraDispatcher);
        ArrayList<MapboxMap.OnDeveloperAnimationListener> developerAnimationListeners = new ArrayList<MapboxMap.OnDeveloperAnimationListener>();
        this.mapboxMap = new MapboxMap(this.nativeMapView, transform, uiSettings, proj, registerTouchListener, cameraDispatcher, developerAnimationListeners);
        this.mapboxMap.injectAnnotationManager(annotationManager);
        this.mapGestureDetector = new MapGestureDetector(context, transform, proj, uiSettings, annotationManager, cameraDispatcher);
        this.mapKeyListener = new MapKeyListener(transform, uiSettings, this.mapGestureDetector);
        this.compassView.injectCompassAnimationListener(this.createCompassAnimationListener(cameraDispatcher));
        this.compassView.setOnClickListener(this.createCompassClickListener(cameraDispatcher));
        this.mapboxMap.injectLocationComponent(new LocationComponent(this.mapboxMap, transform, developerAnimationListeners));
        this.attributionClickListener = new AttributionClickListener(context, this.mapboxMap);
        this.attrView.setOnClickListener((View.OnClickListener)this.attributionClickListener);
        this.setClickable(true);
        this.setLongClickable(true);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestDisallowInterceptTouchEvent(true);
        this.nativeMapView.setReachability(Mapbox.isConnected());
        if (this.savedInstanceState == null) {
            this.mapboxMap.initialise(context, this.mapboxMapOptions);
        } else {
            this.mapboxMap.onRestoreInstanceState(this.savedInstanceState);
        }
        this.mapCallback.initialised();
    }

    private FocalPointChangeListener createFocalPointChangeListener() {
        return new FocalPointChangeListener(){

            @Override
            public void onFocalPointChanged(PointF pointF) {
                MapView.this.focalPoint = pointF;
            }
        };
    }

    private MapboxMap.OnCompassAnimationListener createCompassAnimationListener(final @NonNull CameraChangeDispatcher cameraChangeDispatcher) {
        return new MapboxMap.OnCompassAnimationListener(){

            @Override
            public void onCompassAnimation() {
                cameraChangeDispatcher.onCameraMove();
            }

            @Override
            public void onCompassAnimationFinished() {
                MapView.this.compassView.isAnimating(false);
                cameraChangeDispatcher.onCameraIdle();
            }
        };
    }

    private View.OnClickListener createCompassClickListener(final @NonNull CameraChangeDispatcher cameraChangeDispatcher) {
        return new View.OnClickListener(){

            public void onClick(View v) {
                if (MapView.this.mapboxMap != null && MapView.this.compassView != null) {
                    if (MapView.this.focalPoint != null) {
                        MapView.this.mapboxMap.setFocalBearing(0.0, ((MapView)MapView.this).focalPoint.x, ((MapView)MapView.this).focalPoint.y, 150L);
                    } else {
                        MapView.this.mapboxMap.setFocalBearing(0.0, MapView.this.mapboxMap.getWidth() / 2.0f, MapView.this.mapboxMap.getHeight() / 2.0f, 150L);
                    }
                    cameraChangeDispatcher.onCameraMoveStarted(3);
                    MapView.this.compassView.isAnimating(true);
                    MapView.this.compassView.postDelayed(MapView.this.compassView, 650L);
                }
            }
        };
    }

    @UiThread
    public void onCreate(@Nullable Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            TelemetryDefinition telemetry = Mapbox.getTelemetry();
            if (telemetry != null) {
                telemetry.onAppUserTurnstileEvent();
            }
        } else if (savedInstanceState.getBoolean("mapbox_savedState")) {
            this.savedInstanceState = savedInstanceState;
        }
    }

    private void initialiseDrawingSurface(MapboxMapOptions options) {
        String localFontFamily = options.getLocalIdeographFontFamily();
        if (options.getTextureMode()) {
            TextureView textureView = new TextureView(this.getContext());
            boolean translucentSurface = options.getTranslucentTextureSurface();
            this.mapRenderer = new TextureViewMapRenderer(this.getContext(), textureView, localFontFamily, translucentSurface){

                @Override
                protected void onSurfaceCreated(GL10 gl, EGLConfig config) {
                    MapView.this.onSurfaceCreated();
                    super.onSurfaceCreated(gl, config);
                }
            };
            this.addView((View)textureView, 0);
        } else {
            GLSurfaceView glSurfaceView = new GLSurfaceView(this.getContext());
            glSurfaceView.setZOrderMediaOverlay(this.mapboxMapOptions.getRenderSurfaceOnTop());
            this.mapRenderer = new GLSurfaceViewMapRenderer(this.getContext(), glSurfaceView, localFontFamily){

                @Override
                public void onSurfaceCreated(GL10 gl, EGLConfig config) {
                    MapView.this.onSurfaceCreated();
                    super.onSurfaceCreated(gl, config);
                }
            };
            this.addView((View)glSurfaceView, 0);
        }
        boolean crossSourceCollisions = this.mapboxMapOptions.getCrossSourceCollisions();
        this.nativeMapView = new NativeMapView(this.getContext(), this.getPixelRatio(), crossSourceCollisions, this, this.mapChangeReceiver, this.mapRenderer);
    }

    private void onSurfaceCreated() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (!MapView.this.destroyed && MapView.this.mapboxMap == null) {
                    MapView.this.initialiseMap();
                    MapView.this.mapboxMap.onStart();
                }
            }
        });
    }

    @UiThread
    public void onSaveInstanceState(@NonNull Bundle outState) {
        if (this.mapboxMap != null) {
            outState.putBoolean("mapbox_savedState", true);
            this.mapboxMap.onSaveInstanceState(outState);
        }
    }

    @UiThread
    public void onStart() {
        if (!this.isStarted) {
            ConnectivityReceiver.instance(this.getContext()).activate();
            FileSource.getInstance(this.getContext()).activate();
            this.isStarted = true;
        }
        if (this.mapboxMap != null) {
            this.mapboxMap.onStart();
        }
        if (this.mapRenderer != null) {
            this.mapRenderer.onStart();
        }
    }

    @UiThread
    public void onResume() {
        if (this.mapRenderer != null) {
            this.mapRenderer.onResume();
        }
    }

    @UiThread
    public void onPause() {
        if (this.mapRenderer != null) {
            this.mapRenderer.onPause();
        }
    }

    @UiThread
    public void onStop() {
        if (this.attributionClickListener != null) {
            this.attributionClickListener.onStop();
        }
        if (this.mapboxMap != null) {
            this.mapGestureDetector.cancelAnimators();
            this.mapboxMap.onStop();
        }
        if (this.mapRenderer != null) {
            this.mapRenderer.onStop();
        }
        if (this.isStarted) {
            ConnectivityReceiver.instance(this.getContext()).deactivate();
            FileSource.getInstance(this.getContext()).deactivate();
            this.isStarted = false;
        }
    }

    @UiThread
    public void onDestroy() {
        this.destroyed = true;
        this.mapChangeReceiver.clear();
        this.mapCallback.onDestroy();
        this.initialRenderCallback.onDestroy();
        if (this.compassView != null) {
            this.compassView.resetAnimation();
        }
        if (this.mapboxMap != null) {
            this.mapboxMap.onDestroy();
        }
        if (this.nativeMapView != null) {
            this.nativeMapView.destroy();
            this.nativeMapView = null;
        }
        if (this.mapRenderer != null) {
            this.mapRenderer.onDestroy();
        }
    }

    public void setMaximumFps(int maximumFps) {
        if (this.mapRenderer == null) {
            throw new IllegalStateException("Calling MapView#setMaximumFps before mapRenderer is created.");
        }
        this.mapRenderer.setMaximumFps(maximumFps);
    }

    @UiThread
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isGestureDetectorInitialized()) {
            return super.onTouchEvent(event);
        }
        return this.mapGestureDetector.onTouchEvent(event) || super.onTouchEvent(event);
    }

    public boolean onKeyDown(int keyCode, @NonNull KeyEvent event) {
        return this.mapKeyListener.onKeyDown(keyCode, event) || super.onKeyDown(keyCode, event);
    }

    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        return this.mapKeyListener.onKeyLongPress(keyCode, event) || super.onKeyLongPress(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, @NonNull KeyEvent event) {
        return this.mapKeyListener.onKeyUp(keyCode, event) || super.onKeyUp(keyCode, event);
    }

    public boolean onTrackballEvent(@NonNull MotionEvent event) {
        return this.mapKeyListener.onTrackballEvent(event) || super.onTrackballEvent(event);
    }

    public boolean onGenericMotionEvent(@NonNull MotionEvent event) {
        if (!this.isGestureDetectorInitialized()) {
            return super.onGenericMotionEvent(event);
        }
        return this.mapGestureDetector.onGenericMotionEvent(event) || super.onGenericMotionEvent(event);
    }

    @UiThread
    public void onLowMemory() {
        if (this.nativeMapView != null && this.mapboxMap != null && !this.destroyed) {
            this.nativeMapView.onLowMemory();
        }
    }

    protected void onSizeChanged(int width, int height, int oldw, int oldh) {
        if (!this.isInEditMode() && this.nativeMapView != null) {
            this.nativeMapView.resizeView(width, height);
        }
    }

    private float getPixelRatio() {
        float pixelRatio = this.mapboxMapOptions.getPixelRatio();
        if (pixelRatio == 0.0f) {
            pixelRatio = this.getResources().getDisplayMetrics().density;
        }
        return pixelRatio;
    }

    @Override
    @Nullable
    public Bitmap getViewContent() {
        return BitmapUtils.createBitmapFromView((View)this);
    }

    public void addOnCameraWillChangeListener(@NonNull OnCameraWillChangeListener listener) {
        this.mapChangeReceiver.addOnCameraWillChangeListener(listener);
    }

    public void removeOnCameraWillChangeListener(@NonNull OnCameraWillChangeListener listener) {
        this.mapChangeReceiver.removeOnCameraWillChangeListener(listener);
    }

    public void addOnCameraIsChangingListener(@NonNull OnCameraIsChangingListener listener) {
        this.mapChangeReceiver.addOnCameraIsChangingListener(listener);
    }

    public void removeOnCameraIsChangingListener(@NonNull OnCameraIsChangingListener listener) {
        this.mapChangeReceiver.removeOnCameraIsChangingListener(listener);
    }

    public void addOnCameraDidChangeListener(@NonNull OnCameraDidChangeListener listener) {
        this.mapChangeReceiver.addOnCameraDidChangeListener(listener);
    }

    public void removeOnCameraDidChangeListener(@NonNull OnCameraDidChangeListener listener) {
        this.mapChangeReceiver.removeOnCameraDidChangeListener(listener);
    }

    public void addOnWillStartLoadingMapListener(@NonNull OnWillStartLoadingMapListener listener) {
        this.mapChangeReceiver.addOnWillStartLoadingMapListener(listener);
    }

    public void removeOnWillStartLoadingMapListener(@NonNull OnWillStartLoadingMapListener listener) {
        this.mapChangeReceiver.removeOnWillStartLoadingMapListener(listener);
    }

    public void addOnDidFinishLoadingMapListener(@NonNull OnDidFinishLoadingMapListener listener) {
        this.mapChangeReceiver.addOnDidFinishLoadingMapListener(listener);
    }

    public void removeOnDidFinishLoadingMapListener(@NonNull OnDidFinishLoadingMapListener listener) {
        this.mapChangeReceiver.removeOnDidFinishLoadingMapListener(listener);
    }

    public void addOnDidFailLoadingMapListener(@NonNull OnDidFailLoadingMapListener listener) {
        this.mapChangeReceiver.addOnDidFailLoadingMapListener(listener);
    }

    public void removeOnDidFailLoadingMapListener(@NonNull OnDidFailLoadingMapListener listener) {
        this.mapChangeReceiver.removeOnDidFailLoadingMapListener(listener);
    }

    public void addOnWillStartRenderingFrameListener(@NonNull OnWillStartRenderingFrameListener listener) {
        this.mapChangeReceiver.addOnWillStartRenderingFrameListener(listener);
    }

    public void removeOnWillStartRenderingFrameListener(@NonNull OnWillStartRenderingFrameListener listener) {
        this.mapChangeReceiver.removeOnWillStartRenderingFrameListener(listener);
    }

    public void addOnDidFinishRenderingFrameListener(@NonNull OnDidFinishRenderingFrameListener listener) {
        this.mapChangeReceiver.addOnDidFinishRenderingFrameListener(listener);
    }

    public void removeOnDidFinishRenderingFrameListener(@NonNull OnDidFinishRenderingFrameListener listener) {
        this.mapChangeReceiver.removeOnDidFinishRenderingFrameListener(listener);
    }

    public void addOnWillStartRenderingMapListener(@NonNull OnWillStartRenderingMapListener listener) {
        this.mapChangeReceiver.addOnWillStartRenderingMapListener(listener);
    }

    public void removeOnWillStartRenderingMapListener(@NonNull OnWillStartRenderingMapListener listener) {
        this.mapChangeReceiver.removeOnWillStartRenderingMapListener(listener);
    }

    public void addOnDidFinishRenderingMapListener(@NonNull OnDidFinishRenderingMapListener listener) {
        this.mapChangeReceiver.addOnDidFinishRenderingMapListener(listener);
    }

    public void removeOnDidFinishRenderingMapListener(OnDidFinishRenderingMapListener listener) {
        this.mapChangeReceiver.removeOnDidFinishRenderingMapListener(listener);
    }

    public void addOnDidBecomeIdleListener(@NonNull OnDidBecomeIdleListener listener) {
        this.mapChangeReceiver.addOnDidBecomeIdleListener(listener);
    }

    public void removeOnDidBecomeIdleListener(@NonNull OnDidBecomeIdleListener listener) {
        this.mapChangeReceiver.removeOnDidBecomeIdleListener(listener);
    }

    public void addOnDidFinishLoadingStyleListener(@NonNull OnDidFinishLoadingStyleListener listener) {
        this.mapChangeReceiver.addOnDidFinishLoadingStyleListener(listener);
    }

    public void removeOnDidFinishLoadingStyleListener(@NonNull OnDidFinishLoadingStyleListener listener) {
        this.mapChangeReceiver.removeOnDidFinishLoadingStyleListener(listener);
    }

    public void addOnSourceChangedListener(@NonNull OnSourceChangedListener listener) {
        this.mapChangeReceiver.addOnSourceChangedListener(listener);
    }

    public void removeOnSourceChangedListener(@NonNull OnSourceChangedListener listener) {
        this.mapChangeReceiver.removeOnSourceChangedListener(listener);
    }

    public void addOnStyleImageMissingListener(@NonNull OnStyleImageMissingListener listener) {
        this.mapChangeReceiver.addOnStyleImageMissingListener(listener);
    }

    public void removeOnStyleImageMissingListener(@NonNull OnStyleImageMissingListener listener) {
        this.mapChangeReceiver.removeOnStyleImageMissingListener(listener);
    }

    public void addOnCanRemoveUnusedStyleImageListener(@NonNull OnCanRemoveUnusedStyleImageListener listener) {
        this.mapChangeReceiver.addOnCanRemoveUnusedStyleImageListener(listener);
    }

    public void removeOnCanRemoveUnusedStyleImageListener(@NonNull OnCanRemoveUnusedStyleImageListener listener) {
        this.mapChangeReceiver.removeOnCanRemoveUnusedStyleImageListener(listener);
    }

    @UiThread
    public void getMapAsync(@NonNull OnMapReadyCallback callback) {
        if (this.mapboxMap == null) {
            this.mapCallback.addOnMapReadyCallback(callback);
        } else {
            callback.onMapReady(this.mapboxMap);
        }
    }

    private boolean isGestureDetectorInitialized() {
        return this.mapGestureDetector != null;
    }

    @Nullable
    MapboxMap getMapboxMap() {
        return this.mapboxMap;
    }

    void setMapboxMap(MapboxMap mapboxMap) {
        this.mapboxMap = mapboxMap;
    }

    public static void setMapStrictModeEnabled(boolean strictModeEnabled) {
        MapStrictMode.setStrictModeEnabled(strictModeEnabled);
    }

    private static class AttributionClickListener
    implements View.OnClickListener {
        @NonNull
        private final AttributionDialogManager defaultDialogManager;
        private UiSettings uiSettings;

        private AttributionClickListener(@NonNull Context context, @NonNull MapboxMap mapboxMap) {
            this.defaultDialogManager = new AttributionDialogManager(context, mapboxMap);
            this.uiSettings = mapboxMap.getUiSettings();
        }

        public void onClick(View v) {
            this.getDialogManager().onClick(v);
        }

        public void onStop() {
            this.getDialogManager().onStop();
        }

        private AttributionDialogManager getDialogManager() {
            AttributionDialogManager customDialogManager = this.uiSettings.getAttributionDialogManager();
            if (customDialogManager != null) {
                return this.uiSettings.getAttributionDialogManager();
            }
            return this.defaultDialogManager;
        }
    }

    private class MapCallback
    implements OnDidFinishLoadingStyleListener,
    OnDidFinishRenderingFrameListener,
    OnDidFinishLoadingMapListener,
    OnCameraIsChangingListener,
    OnCameraDidChangeListener,
    OnDidFailLoadingMapListener {
        private final List<OnMapReadyCallback> onMapReadyCallbackList = new ArrayList<OnMapReadyCallback>();

        MapCallback() {
            MapView.this.addOnDidFinishLoadingStyleListener(this);
            MapView.this.addOnDidFinishRenderingFrameListener(this);
            MapView.this.addOnDidFinishLoadingMapListener(this);
            MapView.this.addOnCameraIsChangingListener(this);
            MapView.this.addOnCameraDidChangeListener(this);
            MapView.this.addOnDidFailLoadingMapListener(this);
        }

        void initialised() {
            MapView.this.mapboxMap.onPreMapReady();
            this.onMapReady();
            MapView.this.mapboxMap.onPostMapReady();
        }

        private void onMapReady() {
            if (this.onMapReadyCallbackList.size() > 0) {
                Iterator<OnMapReadyCallback> iterator = this.onMapReadyCallbackList.iterator();
                while (iterator.hasNext()) {
                    OnMapReadyCallback callback = iterator.next();
                    if (callback != null) {
                        callback.onMapReady(MapView.this.mapboxMap);
                    }
                    iterator.remove();
                }
            }
        }

        void addOnMapReadyCallback(OnMapReadyCallback callback) {
            this.onMapReadyCallbackList.add(callback);
        }

        void onDestroy() {
            this.onMapReadyCallbackList.clear();
            MapView.this.removeOnDidFinishLoadingStyleListener(this);
            MapView.this.removeOnDidFinishRenderingFrameListener(this);
            MapView.this.removeOnDidFinishLoadingMapListener(this);
            MapView.this.removeOnCameraIsChangingListener(this);
            MapView.this.removeOnCameraDidChangeListener(this);
            MapView.this.removeOnDidFailLoadingMapListener(this);
        }

        @Override
        public void onDidFinishLoadingStyle() {
            if (MapView.this.mapboxMap != null) {
                MapView.this.mapboxMap.onFinishLoadingStyle();
            }
        }

        @Override
        public void onDidFailLoadingMap(String errorMessage) {
            if (MapView.this.mapboxMap != null) {
                MapView.this.mapboxMap.onFailLoadingStyle();
            }
        }

        @Override
        public void onDidFinishRenderingFrame(boolean fully) {
            if (MapView.this.mapboxMap != null) {
                MapView.this.mapboxMap.onUpdateFullyRendered();
            }
        }

        @Override
        public void onDidFinishLoadingMap() {
            if (MapView.this.mapboxMap != null) {
                MapView.this.mapboxMap.onUpdateRegionChange();
            }
        }

        @Override
        public void onCameraIsChanging() {
            if (MapView.this.mapboxMap != null) {
                MapView.this.mapboxMap.onUpdateRegionChange();
            }
        }

        @Override
        public void onCameraDidChange(boolean animated) {
            if (MapView.this.mapboxMap != null) {
                MapView.this.mapboxMap.onUpdateRegionChange();
            }
        }
    }

    private class GesturesManagerInteractionListener
    implements MapboxMap.OnGesturesManagerInteractionListener {
        private GesturesManagerInteractionListener() {
        }

        @Override
        public void onAddMapClickListener(MapboxMap.OnMapClickListener listener) {
            MapView.this.mapGestureDetector.addOnMapClickListener(listener);
        }

        @Override
        public void onRemoveMapClickListener(MapboxMap.OnMapClickListener listener) {
            MapView.this.mapGestureDetector.removeOnMapClickListener(listener);
        }

        @Override
        public void onAddMapLongClickListener(MapboxMap.OnMapLongClickListener listener) {
            MapView.this.mapGestureDetector.addOnMapLongClickListener(listener);
        }

        @Override
        public void onRemoveMapLongClickListener(MapboxMap.OnMapLongClickListener listener) {
            MapView.this.mapGestureDetector.removeOnMapLongClickListener(listener);
        }

        @Override
        public void onAddFlingListener(MapboxMap.OnFlingListener listener) {
            MapView.this.mapGestureDetector.addOnFlingListener(listener);
        }

        @Override
        public void onRemoveFlingListener(MapboxMap.OnFlingListener listener) {
            MapView.this.mapGestureDetector.removeOnFlingListener(listener);
        }

        @Override
        public void onAddMoveListener(MapboxMap.OnMoveListener listener) {
            MapView.this.mapGestureDetector.addOnMoveListener(listener);
        }

        @Override
        public void onRemoveMoveListener(MapboxMap.OnMoveListener listener) {
            MapView.this.mapGestureDetector.removeOnMoveListener(listener);
        }

        @Override
        public void onAddRotateListener(MapboxMap.OnRotateListener listener) {
            MapView.this.mapGestureDetector.addOnRotateListener(listener);
        }

        @Override
        public void onRemoveRotateListener(MapboxMap.OnRotateListener listener) {
            MapView.this.mapGestureDetector.removeOnRotateListener(listener);
        }

        @Override
        public void onAddScaleListener(MapboxMap.OnScaleListener listener) {
            MapView.this.mapGestureDetector.addOnScaleListener(listener);
        }

        @Override
        public void onRemoveScaleListener(MapboxMap.OnScaleListener listener) {
            MapView.this.mapGestureDetector.removeOnScaleListener(listener);
        }

        @Override
        public void onAddShoveListener(MapboxMap.OnShoveListener listener) {
            MapView.this.mapGestureDetector.addShoveListener(listener);
        }

        @Override
        public void onRemoveShoveListener(MapboxMap.OnShoveListener listener) {
            MapView.this.mapGestureDetector.removeShoveListener(listener);
        }

        @Override
        public AndroidGesturesManager getGesturesManager() {
            return MapView.this.mapGestureDetector.getGesturesManager();
        }

        @Override
        public void setGesturesManager(AndroidGesturesManager gesturesManager, boolean attachDefaultListeners, boolean setDefaultMutuallyExclusives) {
            MapView.this.mapGestureDetector.setGesturesManager(MapView.this.getContext(), gesturesManager, attachDefaultListeners, setDefaultMutuallyExclusives);
        }

        @Override
        public void cancelAllVelocityAnimations() {
            MapView.this.mapGestureDetector.cancelAnimators();
        }
    }

    private class InitialRenderCallback
    implements OnDidFinishRenderingFrameListener {
        private int renderCount;

        InitialRenderCallback() {
            MapView.this.addOnDidFinishRenderingFrameListener(this);
        }

        @Override
        public void onDidFinishRenderingFrame(boolean fully) {
            if (MapView.this.mapboxMap != null && MapView.this.mapboxMap.getStyle() != null && MapView.this.mapboxMap.getStyle().isFullyLoaded()) {
                ++this.renderCount;
                if (this.renderCount == 3) {
                    MapView.this.setForeground(null);
                    MapView.this.removeOnDidFinishRenderingFrameListener(this);
                }
            }
        }

        private void onDestroy() {
            MapView.this.removeOnDidFinishRenderingFrameListener(this);
        }
    }

    private class FocalPointInvalidator
    implements FocalPointChangeListener {
        private final List<FocalPointChangeListener> focalPointChangeListeners = new ArrayList<FocalPointChangeListener>();

        private FocalPointInvalidator() {
        }

        void addListener(FocalPointChangeListener focalPointChangeListener) {
            this.focalPointChangeListeners.add(focalPointChangeListener);
        }

        @Override
        public void onFocalPointChanged(PointF pointF) {
            MapView.this.mapGestureDetector.setFocalPoint(pointF);
            for (FocalPointChangeListener focalPointChangeListener : this.focalPointChangeListeners) {
                focalPointChangeListener.onFocalPointChanged(pointF);
            }
        }
    }

    public static interface OnCanRemoveUnusedStyleImageListener {
        public boolean onCanRemoveUnusedStyleImage(@NonNull String var1);
    }

    public static interface OnStyleImageMissingListener {
        public void onStyleImageMissing(@NonNull String var1);
    }

    public static interface OnSourceChangedListener {
        public void onSourceChangedListener(String var1);
    }

    public static interface OnDidFinishLoadingStyleListener {
        public void onDidFinishLoadingStyle();
    }

    public static interface OnDidBecomeIdleListener {
        public void onDidBecomeIdle();
    }

    public static interface OnDidFinishRenderingMapListener {
        public void onDidFinishRenderingMap(boolean var1);
    }

    public static interface OnWillStartRenderingMapListener {
        public void onWillStartRenderingMap();
    }

    public static interface OnDidFinishRenderingFrameListener {
        public void onDidFinishRenderingFrame(boolean var1);
    }

    public static interface OnWillStartRenderingFrameListener {
        public void onWillStartRenderingFrame();
    }

    public static interface OnDidFailLoadingMapListener {
        public void onDidFailLoadingMap(String var1);
    }

    public static interface OnDidFinishLoadingMapListener {
        public void onDidFinishLoadingMap();
    }

    public static interface OnWillStartLoadingMapListener {
        public void onWillStartLoadingMap();
    }

    public static interface OnCameraDidChangeListener {
        public void onCameraDidChange(boolean var1);
    }

    public static interface OnCameraIsChangingListener {
        public void onCameraIsChanging();
    }

    public static interface OnCameraWillChangeListener {
        public void onCameraWillChange(boolean var1);
    }
}

