/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.module.telemetry;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.mapbox.android.telemetry.Event;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class PerformanceEvent
extends Event {
    private static final String PERFORMANCE_TRACE = "mobile.performance_trace";
    private final String event;
    private final String created;
    private final String sessionId;
    private final List<Attribute<String>> attributes;
    private final List<Attribute<Double>> counters;
    private final JsonObject metadata;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
    public static final Parcelable.Creator<PerformanceEvent> CREATOR = new Parcelable.Creator<PerformanceEvent>(){

        public PerformanceEvent createFromParcel(Parcel in) {
            return new PerformanceEvent(in);
        }

        public PerformanceEvent[] newArray(int size) {
            return new PerformanceEvent[size];
        }
    };

    PerformanceEvent(String sessionId, Bundle bundle) {
        this.event = PERFORMANCE_TRACE;
        this.created = DATE_FORMAT.format(new Date());
        this.sessionId = sessionId;
        this.attributes = this.initList(bundle.getString("attributes"), (TypeToken)new TypeToken<ArrayList<Attribute<String>>>(){});
        this.counters = this.initList(bundle.getString("counters"), (TypeToken)new TypeToken<ArrayList<Attribute<Double>>>(){});
        this.metadata = this.initMetaData(bundle.getString("metadata"));
    }

    private PerformanceEvent(Parcel in) {
        this.event = in.readString();
        this.created = in.readString();
        this.sessionId = in.readString();
        this.attributes = this.initList(in.readString(), (TypeToken)new TypeToken<ArrayList<Attribute<String>>>(){});
        this.counters = this.initList(in.readString(), (TypeToken)new TypeToken<ArrayList<Attribute<Double>>>(){});
        this.metadata = this.initMetaData(in.readString());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.event);
        parcel.writeString(this.created);
        parcel.writeString(this.sessionId);
        Gson gson = new Gson();
        parcel.writeString(gson.toJson(this.attributes));
        parcel.writeString(gson.toJson(this.counters));
        if (this.metadata != null) {
            parcel.writeString(this.metadata.toString());
        }
    }

    private <T> ArrayList<Attribute<T>> initList(String fromString, TypeToken typeToken) {
        if (fromString == null || fromString.isEmpty()) {
            return new ArrayList<Attribute<T>>();
        }
        return (ArrayList)new Gson().fromJson(fromString, typeToken.getType());
    }

    private JsonObject initMetaData(String fromString) {
        if (fromString == null) {
            return new JsonObject();
        }
        return (JsonObject)new Gson().fromJson(fromString, JsonObject.class);
    }

    private class Attribute<T> {
        private final String name;
        private final T value;

        Attribute(String name, T value) {
            this.name = name;
            this.value = value;
        }
    }
}

