/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps.renderer.glsurfaceview;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.support.annotation.NonNull;
import android.view.SurfaceHolder;
import com.mapbox.mapboxsdk.maps.renderer.MapRenderer;
import com.mapbox.mapboxsdk.maps.renderer.egl.EGLConfigChooser;
import com.mapbox.mapboxsdk.maps.renderer.glsurfaceview.SurfaceHolderCallbackAdapter;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class GLSurfaceViewMapRenderer
extends MapRenderer
implements GLSurfaceView.Renderer {
    @NonNull
    private final GLSurfaceView glSurfaceView;

    public GLSurfaceViewMapRenderer(Context context, GLSurfaceView glSurfaceView, String localIdeographFontFamily) {
        super(context, localIdeographFontFamily);
        this.glSurfaceView = glSurfaceView;
        glSurfaceView.setEGLContextClientVersion(2);
        glSurfaceView.setEGLConfigChooser((GLSurfaceView.EGLConfigChooser)new EGLConfigChooser());
        glSurfaceView.setRenderer((GLSurfaceView.Renderer)this);
        glSurfaceView.setRenderMode(0);
        glSurfaceView.setPreserveEGLContextOnPause(true);
        glSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)new SurfaceHolderCallbackAdapter(){

            @Override
            public void surfaceCreated(SurfaceHolder holder) {
                super.surfaceCreated(holder);
                GLSurfaceViewMapRenderer.this.hasSurface = true;
            }

            @Override
            public void surfaceDestroyed(SurfaceHolder holder) {
                super.surfaceDestroyed(holder);
                GLSurfaceViewMapRenderer.this.hasSurface = false;
                GLSurfaceViewMapRenderer.this.nativeReset();
            }
        });
    }

    @Override
    public void onStop() {
        this.glSurfaceView.onPause();
    }

    @Override
    public void onPause() {
        super.onPause();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void onStart() {
        this.glSurfaceView.onResume();
    }

    @Override
    public void onResume() {
        super.onResume();
    }

    @Override
    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        super.onSurfaceCreated(gl, config);
    }

    @Override
    protected void onSurfaceDestroyed() {
        super.onSurfaceDestroyed();
    }

    @Override
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        super.onSurfaceChanged(gl, width, height);
    }

    @Override
    public void onDrawFrame(GL10 gl) {
        super.onDrawFrame(gl);
    }

    @Override
    public void requestRender() {
        if (!this.hasSurface) {
            return;
        }
        this.glSurfaceView.requestRender();
    }

    @Override
    public void queueEvent(Runnable runnable) {
        this.glSurfaceView.queueEvent(runnable);
    }
}

