/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.module.telemetry;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import com.mapbox.android.telemetry.AppUserTurnstile;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.SessionInterval;
import com.mapbox.android.telemetry.TelemetryEnabler;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.maps.TelemetryDefinition;
import com.mapbox.mapboxsdk.module.telemetry.MapEventFactory;
import com.mapbox.mapboxsdk.module.telemetry.MapState;
import com.mapbox.mapboxsdk.module.telemetry.PerformanceEvent;
import com.mapbox.mapboxsdk.module.telemetry.PhoneState;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import com.mapbox.mapboxsdk.offline.OfflineTilePyramidRegionDefinition;
import java.util.UUID;

public class TelemetryImpl
implements TelemetryDefinition {
    private final MapboxTelemetry telemetry;
    private final Context appContext = Mapbox.getApplicationContext();

    public TelemetryImpl() {
        String accessToken = Mapbox.getAccessToken();
        this.telemetry = new MapboxTelemetry(this.appContext, accessToken, "mapbox-maps-android/7.4.0-beta.2");
        TelemetryEnabler.State telemetryState = TelemetryEnabler.retrieveTelemetryStateFromPreferences();
        if (TelemetryEnabler.State.ENABLED.equals((Object)telemetryState)) {
            this.telemetry.enable();
        }
    }

    @Override
    public void onAppUserTurnstileEvent() {
        AppUserTurnstile turnstileEvent = new AppUserTurnstile("mapbox-maps-android", "7.4.0-beta.2");
        if (Mapbox.getSkuToken() != null) {
            turnstileEvent.setSkuId("00");
        }
        this.telemetry.push((Event)turnstileEvent);
        this.telemetry.push((Event)MapEventFactory.buildMapLoadEvent(new PhoneState(this.appContext)));
    }

    @Override
    public void onGestureInteraction(String eventType, double latitude, double longitude, @FloatRange(from=0.0, to=25.5) double zoom) {
        MapState state = new MapState(latitude, longitude, zoom);
        state.setGesture(eventType);
        this.telemetry.push((Event)MapEventFactory.buildMapClickEvent(new PhoneState(this.appContext), state));
    }

    @Override
    public void setUserTelemetryRequestState(boolean enabledTelemetry) {
        if (enabledTelemetry) {
            TelemetryEnabler.updateTelemetryState((TelemetryEnabler.State)TelemetryEnabler.State.ENABLED);
            this.telemetry.enable();
        } else {
            this.telemetry.disable();
            TelemetryEnabler.updateTelemetryState((TelemetryEnabler.State)TelemetryEnabler.State.DISABLED);
        }
    }

    @Override
    public void setDebugLoggingEnabled(boolean debugLoggingEnabled) {
        this.telemetry.updateDebugLoggingEnabled(debugLoggingEnabled);
    }

    @Override
    public boolean setSessionIdRotationInterval(int interval) {
        return this.telemetry.updateSessionIdRotationInterval(new SessionInterval(interval));
    }

    @Override
    public void onCreateOfflineRegion(@NonNull OfflineRegionDefinition offlineDefinition) {
        this.telemetry.push((Event)MapEventFactory.buildOfflineDownloadStartEvent(new PhoneState(this.appContext), offlineDefinition instanceof OfflineTilePyramidRegionDefinition ? "tileregion" : "shaperegion", offlineDefinition.getMinZoom(), offlineDefinition.getMaxZoom(), offlineDefinition.getStyleURL()));
    }

    @Override
    public void onPerformanceEvent(Bundle data) {
        if (data == null) {
            data = new Bundle();
        }
        this.telemetry.push((Event)new PerformanceEvent(UUID.randomUUID().toString(), data));
    }
}

