/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v4.widget.ImageViewCompat;
import android.util.TypedValue;
import android.widget.ImageView;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.exceptions.ConversionException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColorUtils {
    @ColorInt
    public static int getPrimaryColor(@NonNull Context context) {
        try {
            TypedValue typedValue = new TypedValue();
            Resources.Theme theme = context.getTheme();
            int id2 = context.getResources().getIdentifier("colorPrimary", "attrs", context.getPackageName());
            theme.resolveAttribute(id2, typedValue, true);
            return typedValue.data;
        }
        catch (Exception exception) {
            return ColorUtils.getColorCompat(context, R.color.mapbox_blue);
        }
    }

    @ColorInt
    public static int getPrimaryDarkColor(@NonNull Context context) {
        try {
            TypedValue typedValue = new TypedValue();
            Resources.Theme theme = context.getTheme();
            int id2 = context.getResources().getIdentifier("colorPrimaryDark", "attrs", context.getPackageName());
            theme.resolveAttribute(id2, typedValue, true);
            return typedValue.data;
        }
        catch (Exception exception) {
            return ColorUtils.getColorCompat(context, R.color.mapbox_blue);
        }
    }

    @ColorInt
    public static int getAccentColor(@NonNull Context context) {
        try {
            TypedValue typedValue = new TypedValue();
            Resources.Theme theme = context.getTheme();
            int id2 = context.getResources().getIdentifier("colorAccent", "attrs", context.getPackageName());
            theme.resolveAttribute(id2, typedValue, true);
            return typedValue.data;
        }
        catch (Exception exception) {
            return ColorUtils.getColorCompat(context, R.color.mapbox_gray);
        }
    }

    @NonNull
    public static ColorStateList getSelector(@ColorInt int color2) {
        return new ColorStateList((int[][])new int[][]{{16842919}, new int[0]}, new int[]{color2, color2});
    }

    public static void setTintList(@NonNull ImageView imageView, @ColorInt int tintColor) {
        ImageViewCompat.setImageTintList((ImageView)imageView, (ColorStateList)ColorUtils.getSelector(tintColor));
    }

    private static int normalizeColorComponent(String value) {
        return (int)(Float.parseFloat(value) * 255.0f);
    }

    @ColorInt
    public static int rgbaToColor(String value) {
        Pattern c = Pattern.compile("rgba?\\s*\\(\\s*(\\d+\\.?\\d*)\\s*,\\s*(\\d+\\.?\\d*)\\s*,\\s*(\\d+\\.?\\d*)\\s*,?\\s*(\\d+\\.?\\d*)?\\s*\\)");
        Matcher m = c.matcher(value);
        if (m.matches() && m.groupCount() == 3) {
            return Color.rgb((int)ColorUtils.normalizeColorComponent(m.group(1)), (int)ColorUtils.normalizeColorComponent(m.group(2)), (int)ColorUtils.normalizeColorComponent(m.group(3)));
        }
        if (m.matches() && m.groupCount() == 4) {
            return Color.argb((int)ColorUtils.normalizeColorComponent(m.group(4)), (int)ColorUtils.normalizeColorComponent(m.group(1)), (int)ColorUtils.normalizeColorComponent(m.group(2)), (int)ColorUtils.normalizeColorComponent(m.group(3)));
        }
        throw new ConversionException("Not a valid rgb/rgba value");
    }

    public static String colorToRgbaString(@ColorInt int color2) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
        decimalFormat.applyPattern("#.###");
        String alpha = decimalFormat.format((float)(color2 >> 24 & 0xFF) / 255.0f);
        return String.format(Locale.US, "rgba(%d, %d, %d, %s)", color2 >> 16 & 0xFF, color2 >> 8 & 0xFF, color2 & 0xFF, alpha);
    }

    public static float[] colorToRgbaArray(@ColorInt int color2) {
        return new float[]{color2 >> 16 & 0xFF, color2 >> 8 & 0xFF, color2 & 0xFF, (float)(color2 >> 24 & 0xFF) / 255.0f};
    }

    public static float[] colorToGlRgbaArray(@ColorInt int color2) {
        return new float[]{(float)(color2 >> 16 & 0xFF) / 255.0f, (float)(color2 >> 8 & 0xFF) / 255.0f, (float)(color2 & 0xFF) / 255.0f, (float)(color2 >> 24 & 0xFF) / 255.0f};
    }

    private static int getColorCompat(Context context, int id2) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context.getResources().getColor(id2, context.getTheme());
        }
        return context.getResources().getColor(id2);
    }
}

