/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.google.gson.JsonArray;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class CircleLayer
extends Layer {
    @Keep
    CircleLayer(long nativePtr) {
        super(nativePtr);
    }

    public CircleLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    @Keep
    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.checkThread();
        this.nativeSetSourceLayer(sourceLayer);
    }

    public CircleLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public String getSourceId() {
        this.checkThread();
        return this.nativeGetSourceId();
    }

    public String getSourceLayer() {
        this.checkThread();
        return this.nativeGetSourceLayer();
    }

    public void setFilter(Expression filter) {
        this.checkThread();
        this.nativeSetFilter(filter.toArray());
    }

    public CircleLayer withFilter(Expression filter) {
        this.setFilter(filter);
        return this;
    }

    @Nullable
    public Expression getFilter() {
        this.checkThread();
        Expression expression = null;
        JsonArray array = (JsonArray)this.nativeGetFilter();
        if (array != null) {
            expression = Expression.Converter.convert(array);
        }
        return expression;
    }

    public CircleLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<Float> getCircleRadius() {
        this.checkThread();
        return new PropertyValue<Object>("circle-radius", this.nativeGetCircleRadius());
    }

    public TransitionOptions getCircleRadiusTransition() {
        this.checkThread();
        return this.nativeGetCircleRadiusTransition();
    }

    public void setCircleRadiusTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetCircleRadiusTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getCircleColor() {
        this.checkThread();
        return new PropertyValue<Object>("circle-color", this.nativeGetCircleColor());
    }

    @ColorInt
    public int getCircleColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getCircleColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("circle-color was set as a Function");
    }

    public TransitionOptions getCircleColorTransition() {
        this.checkThread();
        return this.nativeGetCircleColorTransition();
    }

    public void setCircleColorTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetCircleColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getCircleBlur() {
        this.checkThread();
        return new PropertyValue<Object>("circle-blur", this.nativeGetCircleBlur());
    }

    public TransitionOptions getCircleBlurTransition() {
        this.checkThread();
        return this.nativeGetCircleBlurTransition();
    }

    public void setCircleBlurTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetCircleBlurTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getCircleOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("circle-opacity", this.nativeGetCircleOpacity());
    }

    public TransitionOptions getCircleOpacityTransition() {
        this.checkThread();
        return this.nativeGetCircleOpacityTransition();
    }

    public void setCircleOpacityTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetCircleOpacityTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float[]> getCircleTranslate() {
        this.checkThread();
        return new PropertyValue<Object>("circle-translate", this.nativeGetCircleTranslate());
    }

    public TransitionOptions getCircleTranslateTransition() {
        this.checkThread();
        return this.nativeGetCircleTranslateTransition();
    }

    public void setCircleTranslateTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetCircleTranslateTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getCircleTranslateAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("circle-translate-anchor", this.nativeGetCircleTranslateAnchor());
    }

    public PropertyValue<String> getCirclePitchScale() {
        this.checkThread();
        return new PropertyValue<Object>("circle-pitch-scale", this.nativeGetCirclePitchScale());
    }

    public PropertyValue<String> getCirclePitchAlignment() {
        this.checkThread();
        return new PropertyValue<Object>("circle-pitch-alignment", this.nativeGetCirclePitchAlignment());
    }

    public PropertyValue<Float> getCircleStrokeWidth() {
        this.checkThread();
        return new PropertyValue<Object>("circle-stroke-width", this.nativeGetCircleStrokeWidth());
    }

    public TransitionOptions getCircleStrokeWidthTransition() {
        this.checkThread();
        return this.nativeGetCircleStrokeWidthTransition();
    }

    public void setCircleStrokeWidthTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetCircleStrokeWidthTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getCircleStrokeColor() {
        this.checkThread();
        return new PropertyValue<Object>("circle-stroke-color", this.nativeGetCircleStrokeColor());
    }

    @ColorInt
    public int getCircleStrokeColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getCircleStrokeColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("circle-stroke-color was set as a Function");
    }

    public TransitionOptions getCircleStrokeColorTransition() {
        this.checkThread();
        return this.nativeGetCircleStrokeColorTransition();
    }

    public void setCircleStrokeColorTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetCircleStrokeColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getCircleStrokeOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("circle-stroke-opacity", this.nativeGetCircleStrokeOpacity());
    }

    public TransitionOptions getCircleStrokeOpacityTransition() {
        this.checkThread();
        return this.nativeGetCircleStrokeOpacityTransition();
    }

    public void setCircleStrokeOpacityTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetCircleStrokeOpacityTransition(options.getDuration(), options.getDelay());
    }

    @Keep
    private native Object nativeGetCircleRadius();

    @Keep
    private native TransitionOptions nativeGetCircleRadiusTransition();

    @Keep
    private native void nativeSetCircleRadiusTransition(long var1, long var3);

    @Keep
    private native Object nativeGetCircleColor();

    @Keep
    private native TransitionOptions nativeGetCircleColorTransition();

    @Keep
    private native void nativeSetCircleColorTransition(long var1, long var3);

    @Keep
    private native Object nativeGetCircleBlur();

    @Keep
    private native TransitionOptions nativeGetCircleBlurTransition();

    @Keep
    private native void nativeSetCircleBlurTransition(long var1, long var3);

    @Keep
    private native Object nativeGetCircleOpacity();

    @Keep
    private native TransitionOptions nativeGetCircleOpacityTransition();

    @Keep
    private native void nativeSetCircleOpacityTransition(long var1, long var3);

    @Keep
    private native Object nativeGetCircleTranslate();

    @Keep
    private native TransitionOptions nativeGetCircleTranslateTransition();

    @Keep
    private native void nativeSetCircleTranslateTransition(long var1, long var3);

    @Keep
    private native Object nativeGetCircleTranslateAnchor();

    @Keep
    private native Object nativeGetCirclePitchScale();

    @Keep
    private native Object nativeGetCirclePitchAlignment();

    @Keep
    private native Object nativeGetCircleStrokeWidth();

    @Keep
    private native TransitionOptions nativeGetCircleStrokeWidthTransition();

    @Keep
    private native void nativeSetCircleStrokeWidthTransition(long var1, long var3);

    @Keep
    private native Object nativeGetCircleStrokeColor();

    @Keep
    private native TransitionOptions nativeGetCircleStrokeColorTransition();

    @Keep
    private native void nativeSetCircleStrokeColorTransition(long var1, long var3);

    @Keep
    private native Object nativeGetCircleStrokeOpacity();

    @Keep
    private native TransitionOptions nativeGetCircleStrokeOpacityTransition();

    @Keep
    private native void nativeSetCircleStrokeOpacityTransition(long var1, long var3);

    @Override
    @Keep
    protected native void finalize() throws Throwable;
}

