/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.google.gson.JsonArray;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class LineLayer
extends Layer {
    @Keep
    LineLayer(long nativePtr) {
        super(nativePtr);
    }

    public LineLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    @Keep
    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.checkThread();
        this.nativeSetSourceLayer(sourceLayer);
    }

    public LineLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public String getSourceId() {
        this.checkThread();
        return this.nativeGetSourceId();
    }

    public String getSourceLayer() {
        this.checkThread();
        return this.nativeGetSourceLayer();
    }

    public void setFilter(Expression filter) {
        this.checkThread();
        this.nativeSetFilter(filter.toArray());
    }

    public LineLayer withFilter(Expression filter) {
        this.setFilter(filter);
        return this;
    }

    @Nullable
    public Expression getFilter() {
        this.checkThread();
        Expression expression = null;
        JsonArray array = (JsonArray)this.nativeGetFilter();
        if (array != null) {
            expression = Expression.Converter.convert(array);
        }
        return expression;
    }

    public LineLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<String> getLineCap() {
        this.checkThread();
        return new PropertyValue<Object>("line-cap", this.nativeGetLineCap());
    }

    public PropertyValue<String> getLineJoin() {
        this.checkThread();
        return new PropertyValue<Object>("line-join", this.nativeGetLineJoin());
    }

    public PropertyValue<Float> getLineMiterLimit() {
        this.checkThread();
        return new PropertyValue<Object>("line-miter-limit", this.nativeGetLineMiterLimit());
    }

    public PropertyValue<Float> getLineRoundLimit() {
        this.checkThread();
        return new PropertyValue<Object>("line-round-limit", this.nativeGetLineRoundLimit());
    }

    public PropertyValue<Float> getLineOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("line-opacity", this.nativeGetLineOpacity());
    }

    public TransitionOptions getLineOpacityTransition() {
        this.checkThread();
        return this.nativeGetLineOpacityTransition();
    }

    public void setLineOpacityTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetLineOpacityTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getLineColor() {
        this.checkThread();
        return new PropertyValue<Object>("line-color", this.nativeGetLineColor());
    }

    @ColorInt
    public int getLineColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getLineColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("line-color was set as a Function");
    }

    public TransitionOptions getLineColorTransition() {
        this.checkThread();
        return this.nativeGetLineColorTransition();
    }

    public void setLineColorTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetLineColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float[]> getLineTranslate() {
        this.checkThread();
        return new PropertyValue<Object>("line-translate", this.nativeGetLineTranslate());
    }

    public TransitionOptions getLineTranslateTransition() {
        this.checkThread();
        return this.nativeGetLineTranslateTransition();
    }

    public void setLineTranslateTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetLineTranslateTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getLineTranslateAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("line-translate-anchor", this.nativeGetLineTranslateAnchor());
    }

    public PropertyValue<Float> getLineWidth() {
        this.checkThread();
        return new PropertyValue<Object>("line-width", this.nativeGetLineWidth());
    }

    public TransitionOptions getLineWidthTransition() {
        this.checkThread();
        return this.nativeGetLineWidthTransition();
    }

    public void setLineWidthTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetLineWidthTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getLineGapWidth() {
        this.checkThread();
        return new PropertyValue<Object>("line-gap-width", this.nativeGetLineGapWidth());
    }

    public TransitionOptions getLineGapWidthTransition() {
        this.checkThread();
        return this.nativeGetLineGapWidthTransition();
    }

    public void setLineGapWidthTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetLineGapWidthTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getLineOffset() {
        this.checkThread();
        return new PropertyValue<Object>("line-offset", this.nativeGetLineOffset());
    }

    public TransitionOptions getLineOffsetTransition() {
        this.checkThread();
        return this.nativeGetLineOffsetTransition();
    }

    public void setLineOffsetTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetLineOffsetTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getLineBlur() {
        this.checkThread();
        return new PropertyValue<Object>("line-blur", this.nativeGetLineBlur());
    }

    public TransitionOptions getLineBlurTransition() {
        this.checkThread();
        return this.nativeGetLineBlurTransition();
    }

    public void setLineBlurTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetLineBlurTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float[]> getLineDasharray() {
        this.checkThread();
        return new PropertyValue<Object>("line-dasharray", this.nativeGetLineDasharray());
    }

    public TransitionOptions getLineDasharrayTransition() {
        this.checkThread();
        return this.nativeGetLineDasharrayTransition();
    }

    public void setLineDasharrayTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetLineDasharrayTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getLinePattern() {
        this.checkThread();
        return new PropertyValue<Object>("line-pattern", this.nativeGetLinePattern());
    }

    public TransitionOptions getLinePatternTransition() {
        this.checkThread();
        return this.nativeGetLinePatternTransition();
    }

    public void setLinePatternTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetLinePatternTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getLineGradient() {
        this.checkThread();
        return new PropertyValue<Object>("line-gradient", this.nativeGetLineGradient());
    }

    @ColorInt
    public int getLineGradientAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getLineGradient();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("line-gradient was set as a Function");
    }

    @Keep
    private native Object nativeGetLineCap();

    @Keep
    private native Object nativeGetLineJoin();

    @Keep
    private native Object nativeGetLineMiterLimit();

    @Keep
    private native Object nativeGetLineRoundLimit();

    @Keep
    private native Object nativeGetLineOpacity();

    @Keep
    private native TransitionOptions nativeGetLineOpacityTransition();

    @Keep
    private native void nativeSetLineOpacityTransition(long var1, long var3);

    @Keep
    private native Object nativeGetLineColor();

    @Keep
    private native TransitionOptions nativeGetLineColorTransition();

    @Keep
    private native void nativeSetLineColorTransition(long var1, long var3);

    @Keep
    private native Object nativeGetLineTranslate();

    @Keep
    private native TransitionOptions nativeGetLineTranslateTransition();

    @Keep
    private native void nativeSetLineTranslateTransition(long var1, long var3);

    @Keep
    private native Object nativeGetLineTranslateAnchor();

    @Keep
    private native Object nativeGetLineWidth();

    @Keep
    private native TransitionOptions nativeGetLineWidthTransition();

    @Keep
    private native void nativeSetLineWidthTransition(long var1, long var3);

    @Keep
    private native Object nativeGetLineGapWidth();

    @Keep
    private native TransitionOptions nativeGetLineGapWidthTransition();

    @Keep
    private native void nativeSetLineGapWidthTransition(long var1, long var3);

    @Keep
    private native Object nativeGetLineOffset();

    @Keep
    private native TransitionOptions nativeGetLineOffsetTransition();

    @Keep
    private native void nativeSetLineOffsetTransition(long var1, long var3);

    @Keep
    private native Object nativeGetLineBlur();

    @Keep
    private native TransitionOptions nativeGetLineBlurTransition();

    @Keep
    private native void nativeSetLineBlurTransition(long var1, long var3);

    @Keep
    private native Object nativeGetLineDasharray();

    @Keep
    private native TransitionOptions nativeGetLineDasharrayTransition();

    @Keep
    private native void nativeSetLineDasharrayTransition(long var1, long var3);

    @Keep
    private native Object nativeGetLinePattern();

    @Keep
    private native TransitionOptions nativeGetLinePatternTransition();

    @Keep
    private native void nativeSetLinePatternTransition(long var1, long var3);

    @Keep
    private native Object nativeGetLineGradient();

    @Override
    @Keep
    protected native void finalize() throws Throwable;
}

