/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.storage;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.AsyncTask;
import android.os.Environment;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.utils.ThreadUtils;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import timber.log.Timber;

public class FileSource {
    private static String resourcesCachePath;
    private static String internalCachePath;
    private static final Lock resourcesCachePathLoaderLock;
    private static final Lock internalCachePathLoaderLock;
    private static FileSource INSTANCE;
    @Keep
    private long nativePtr;

    @UiThread
    public static synchronized FileSource getInstance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new FileSource(FileSource.getResourcesCachePath(context), context.getResources().getAssets());
        }
        return INSTANCE;
    }

    @Deprecated
    public static String getCachePath(Context context) {
        boolean setStorageExternal = false;
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            setStorageExternal = appInfo.metaData.getBoolean("com.mapbox.SetStorageExternal", false);
        }
        catch (PackageManager.NameNotFoundException exception) {
            Timber.e((Throwable)exception, (String)"Failed to read the package metadata: ", (Object[])new Object[0]);
        }
        catch (Exception exception) {
            Timber.e((Throwable)exception, (String)"Failed to read the storage key: ", (Object[])new Object[0]);
        }
        String cachePath = null;
        if (setStorageExternal && FileSource.isExternalStorageReadable()) {
            try {
                cachePath = context.getExternalFilesDir(null).getAbsolutePath();
            }
            catch (NullPointerException exception) {
                Timber.e((Throwable)exception, (String)"Failed to obtain the external storage path: ", (Object[])new Object[0]);
            }
        }
        if (cachePath == null) {
            cachePath = context.getFilesDir().getAbsolutePath();
        }
        return cachePath;
    }

    public static boolean isExternalStorageReadable() {
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state) || "mounted_ro".equals(state)) {
            return true;
        }
        Timber.w((String)"External storage was requested but it isn't readable. For API level < 18 make sure you've requested READ_EXTERNAL_STORAGE or WRITE_EXTERNAL_STORAGE permissions in your app Manifest (defaulting to internal storage).", (Object[])new Object[0]);
        return false;
    }

    @UiThread
    public static void initializeFileDirsPaths(Context context) {
        ThreadUtils.checkThread("FileSource");
        FileSource.lockPathLoaders();
        if (resourcesCachePath == null || internalCachePath == null) {
            new FileDirsPathsTask().execute(new Context[]{context});
        }
    }

    public static String getResourcesCachePath(Context context) {
        resourcesCachePathLoaderLock.lock();
        try {
            if (resourcesCachePath == null) {
                resourcesCachePath = FileSource.getCachePath(context);
            }
            String string2 = resourcesCachePath;
            return string2;
        }
        finally {
            resourcesCachePathLoaderLock.unlock();
        }
    }

    public static String getInternalCachePath(Context context) {
        internalCachePathLoaderLock.lock();
        try {
            if (internalCachePath == null) {
                internalCachePath = context.getCacheDir().getAbsolutePath();
            }
            String string2 = internalCachePath;
            return string2;
        }
        finally {
            internalCachePathLoaderLock.unlock();
        }
    }

    private static void lockPathLoaders() {
        internalCachePathLoaderLock.lock();
        resourcesCachePathLoaderLock.lock();
    }

    private static void unlockPathLoaders() {
        resourcesCachePathLoaderLock.unlock();
        internalCachePathLoaderLock.unlock();
    }

    private FileSource(String cachePath, AssetManager assetManager) {
        this.initialize(Mapbox.getAccessToken(), cachePath, assetManager);
    }

    @Keep
    public native boolean isActivated();

    @Keep
    public native void activate();

    @Keep
    public native void deactivate();

    @Keep
    public native void setAccessToken(@NonNull String var1);

    @Keep
    public native String getAccessToken();

    @Keep
    public native void setApiBaseUrl(String var1);

    @Keep
    public native void setResourceTransform(ResourceTransformCallback var1);

    @Keep
    private native void initialize(String var1, String var2, AssetManager var3);

    @Keep
    protected native void finalize() throws Throwable;

    static {
        resourcesCachePathLoaderLock = new ReentrantLock();
        internalCachePathLoaderLock = new ReentrantLock();
    }

    private static class FileDirsPathsTask
    extends AsyncTask<Context, Void, String[]> {
        private FileDirsPathsTask() {
        }

        protected void onCancelled() {
            FileSource.unlockPathLoaders();
        }

        protected String[] doInBackground(Context ... contexts) {
            return new String[]{FileSource.getCachePath(contexts[0]), contexts[0].getCacheDir().getAbsolutePath()};
        }

        protected void onPostExecute(String[] paths) {
            resourcesCachePath = paths[0];
            internalCachePath = paths[1];
            FileSource.unlockPathLoaders();
        }
    }

    @Keep
    public static interface ResourceTransformCallback {
        public String onURL(int var1, String var2);
    }
}

