/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;

@UiThread
public class RasterLayer
extends Layer {
    public RasterLayer(long nativePtr) {
        super(nativePtr);
    }

    public RasterLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.checkThread();
        this.nativeSetSourceLayer(sourceLayer);
    }

    public RasterLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public RasterLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<Float> getRasterOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("raster-opacity", this.nativeGetRasterOpacity());
    }

    public TransitionOptions getRasterOpacityTransition() {
        this.checkThread();
        return this.nativeGetRasterOpacityTransition();
    }

    public void setRasterOpacityTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetRasterOpacityTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getRasterHueRotate() {
        this.checkThread();
        return new PropertyValue<Object>("raster-hue-rotate", this.nativeGetRasterHueRotate());
    }

    public TransitionOptions getRasterHueRotateTransition() {
        this.checkThread();
        return this.nativeGetRasterHueRotateTransition();
    }

    public void setRasterHueRotateTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetRasterHueRotateTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getRasterBrightnessMin() {
        this.checkThread();
        return new PropertyValue<Object>("raster-brightness-min", this.nativeGetRasterBrightnessMin());
    }

    public TransitionOptions getRasterBrightnessMinTransition() {
        this.checkThread();
        return this.nativeGetRasterBrightnessMinTransition();
    }

    public void setRasterBrightnessMinTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetRasterBrightnessMinTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getRasterBrightnessMax() {
        this.checkThread();
        return new PropertyValue<Object>("raster-brightness-max", this.nativeGetRasterBrightnessMax());
    }

    public TransitionOptions getRasterBrightnessMaxTransition() {
        this.checkThread();
        return this.nativeGetRasterBrightnessMaxTransition();
    }

    public void setRasterBrightnessMaxTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetRasterBrightnessMaxTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getRasterSaturation() {
        this.checkThread();
        return new PropertyValue<Object>("raster-saturation", this.nativeGetRasterSaturation());
    }

    public TransitionOptions getRasterSaturationTransition() {
        this.checkThread();
        return this.nativeGetRasterSaturationTransition();
    }

    public void setRasterSaturationTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetRasterSaturationTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getRasterContrast() {
        this.checkThread();
        return new PropertyValue<Object>("raster-contrast", this.nativeGetRasterContrast());
    }

    public TransitionOptions getRasterContrastTransition() {
        this.checkThread();
        return this.nativeGetRasterContrastTransition();
    }

    public void setRasterContrastTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetRasterContrastTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getRasterResampling() {
        this.checkThread();
        return new PropertyValue<Object>("raster-resampling", this.nativeGetRasterResampling());
    }

    public PropertyValue<Float> getRasterFadeDuration() {
        this.checkThread();
        return new PropertyValue<Object>("raster-fade-duration", this.nativeGetRasterFadeDuration());
    }

    private native Object nativeGetRasterOpacity();

    private native TransitionOptions nativeGetRasterOpacityTransition();

    private native void nativeSetRasterOpacityTransition(long var1, long var3);

    private native Object nativeGetRasterHueRotate();

    private native TransitionOptions nativeGetRasterHueRotateTransition();

    private native void nativeSetRasterHueRotateTransition(long var1, long var3);

    private native Object nativeGetRasterBrightnessMin();

    private native TransitionOptions nativeGetRasterBrightnessMinTransition();

    private native void nativeSetRasterBrightnessMinTransition(long var1, long var3);

    private native Object nativeGetRasterBrightnessMax();

    private native TransitionOptions nativeGetRasterBrightnessMaxTransition();

    private native void nativeSetRasterBrightnessMaxTransition(long var1, long var3);

    private native Object nativeGetRasterSaturation();

    private native TransitionOptions nativeGetRasterSaturationTransition();

    private native void nativeSetRasterSaturationTransition(long var1, long var3);

    private native Object nativeGetRasterContrast();

    private native TransitionOptions nativeGetRasterContrastTransition();

    private native void nativeSetRasterContrastTransition(long var1, long var3);

    private native Object nativeGetRasterResampling();

    private native Object nativeGetRasterFadeDuration();

    @Override
    protected native void finalize() throws Throwable;
}

