/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.PointF;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.geometry.ProjectedMeters;
import com.mapbox.mapboxsdk.geometry.VisibleRegion;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import java.util.ArrayList;

public class Projection {
    private final NativeMapView nativeMapView;
    private int[] contentPadding;

    Projection(@NonNull NativeMapView nativeMapView) {
        this.nativeMapView = nativeMapView;
        this.contentPadding = new int[]{0, 0, 0, 0};
    }

    void setContentPadding(int[] contentPadding) {
        this.contentPadding = contentPadding;
        this.nativeMapView.setContentPadding(contentPadding);
    }

    int[] getContentPadding() {
        return this.contentPadding;
    }

    public void invalidateContentPadding() {
        this.setContentPadding(this.contentPadding);
    }

    @NonNull
    public ProjectedMeters getProjectedMetersForLatLng(@NonNull LatLng latLng) {
        return this.nativeMapView.projectedMetersForLatLng(latLng);
    }

    @NonNull
    public LatLng getLatLngForProjectedMeters(@NonNull ProjectedMeters projectedMeters) {
        return this.nativeMapView.latLngForProjectedMeters(projectedMeters);
    }

    public double getMetersPerPixelAtLatitude(@FloatRange(from=-90.0, to=90.0) double latitude) {
        return this.nativeMapView.getMetersPerPixelAtLatitude(latitude);
    }

    @NonNull
    public LatLng fromScreenLocation(@NonNull PointF point) {
        return this.nativeMapView.latLngForPixel(point);
    }

    @NonNull
    public VisibleRegion getVisibleRegion() {
        return this.getVisibleRegion(true);
    }

    @NonNull
    public VisibleRegion getVisibleRegion(boolean ignorePadding) {
        double south;
        float bottom;
        float top;
        float right;
        float left;
        if (ignorePadding) {
            left = 0.0f;
            right = this.nativeMapView.getWidth();
            top = 0.0f;
            bottom = this.nativeMapView.getHeight();
        } else {
            left = this.contentPadding[0];
            right = this.nativeMapView.getWidth() - this.contentPadding[2];
            top = this.contentPadding[1];
            bottom = this.nativeMapView.getHeight() - this.contentPadding[3];
        }
        LatLng topLeft = this.fromScreenLocation(new PointF(left, top));
        LatLng topRight = this.fromScreenLocation(new PointF(right, top));
        LatLng bottomRight = this.fromScreenLocation(new PointF(right, bottom));
        LatLng bottomLeft = this.fromScreenLocation(new PointF(left, bottom));
        ArrayList<LatLng> boundsPoints = new ArrayList<LatLng>();
        boundsPoints.add(topLeft);
        boundsPoints.add(topRight);
        boundsPoints.add(bottomRight);
        boundsPoints.add(bottomLeft);
        while (((LatLng)boundsPoints.get(0)).getLatitude() < ((LatLng)boundsPoints.get(3)).getLatitude() || ((LatLng)boundsPoints.get(1)).getLatitude() < ((LatLng)boundsPoints.get(2)).getLatitude()) {
            LatLng first = (LatLng)boundsPoints.remove(0);
            boundsPoints.add(first);
        }
        double north = ((LatLng)boundsPoints.get(0)).getLatitude();
        if (north < ((LatLng)boundsPoints.get(1)).getLatitude()) {
            north = ((LatLng)boundsPoints.get(1)).getLatitude();
        }
        if ((south = ((LatLng)boundsPoints.get(2)).getLatitude()) > ((LatLng)boundsPoints.get(3)).getLatitude()) {
            south = ((LatLng)boundsPoints.get(3)).getLatitude();
        }
        double firstLon = ((LatLng)boundsPoints.get(0)).getLongitude();
        double secondLon = ((LatLng)boundsPoints.get(1)).getLongitude();
        double thridLon = ((LatLng)boundsPoints.get(2)).getLongitude();
        double fourthLon = ((LatLng)boundsPoints.get(3)).getLongitude();
        if (secondLon > fourthLon && firstLon < thridLon) {
            return new VisibleRegion(topLeft, topRight, bottomLeft, bottomRight, LatLngBounds.from(north, secondLon > thridLon ? secondLon : thridLon, south, firstLon < fourthLon ? firstLon : fourthLon));
        }
        return new VisibleRegion(topLeft, topRight, bottomLeft, bottomRight, LatLngBounds.from(north, secondLon < thridLon ? secondLon : thridLon, south, firstLon > fourthLon ? firstLon : fourthLon));
    }

    @NonNull
    public PointF toScreenLocation(@NonNull LatLng location) {
        return this.nativeMapView.pixelForLatLng(location);
    }

    float getHeight() {
        return this.nativeMapView.getHeight();
    }

    float getWidth() {
        return this.nativeMapView.getWidth();
    }

    public double calculateZoom(float minScale) {
        return this.nativeMapView.getZoom() + Math.log(minScale) / Math.log(2.0);
    }
}

