/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.http;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.mapbox.android.telemetry.TelemetryUtils;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.http.LocalRequestTask;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import timber.log.Timber;

class HTTPRequest
implements Callback {
    private static final int CONNECTION_ERROR = 0;
    private static final int TEMPORARY_ERROR = 1;
    private static final int PERMANENT_ERROR = 2;
    private static OkHttpClient client = new OkHttpClient.Builder().dispatcher(HTTPRequest.getDispatcher()).build();
    private static boolean logEnabled = true;
    private static boolean logRequestUrl = false;
    private ReentrantLock lock = new ReentrantLock();
    private String userAgentString;
    private long nativePtr = 0L;
    private Call call;

    private HTTPRequest(long nativePtr, String resourceUrl, String etag, String modified) {
        this.nativePtr = nativePtr;
        if (resourceUrl.startsWith("local://")) {
            this.executeLocalRequest(resourceUrl);
            return;
        }
        this.executeRequest(resourceUrl, etag, modified);
    }

    public void cancel() {
        if (this.call != null) {
            this.call.cancel();
        }
        this.lock.lock();
        this.nativePtr = 0L;
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
        byte[] body;
        if (response.isSuccessful()) {
            this.log(2, String.format("[HTTP] Request was successful (code = %s).", response.code()));
        } else {
            String message = !TextUtils.isEmpty((CharSequence)response.message()) ? response.message() : "No additional information";
            this.log(3, String.format("[HTTP] Request with response code = %s: %s", response.code(), message));
        }
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            this.log(6, "[HTTP] Received empty response body");
            return;
        }
        try {
            body = responseBody.bytes();
        }
        catch (IOException ioException) {
            this.onFailure(call, ioException);
            return;
        }
        finally {
            response.close();
        }
        this.lock.lock();
        if (this.nativePtr != 0L) {
            this.nativeOnResponse(response.code(), response.header("ETag"), response.header("Last-Modified"), response.header("Cache-Control"), response.header("Expires"), response.header("Retry-After"), response.header("x-rate-limit-reset"), body);
        }
        this.lock.unlock();
    }

    public void onFailure(@NonNull Call call, @NonNull IOException e) {
        this.handleFailure(call, e);
    }

    static void enableLog(boolean enabled) {
        logEnabled = enabled;
    }

    static void enablePrintRequestUrlOnFailure(boolean enabled) {
        logRequestUrl = enabled;
    }

    static void setOKHttpClient(OkHttpClient client) {
        HTTPRequest.client = client;
    }

    private static Dispatcher getDispatcher() {
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequestsPerHost(20);
        return dispatcher;
    }

    private void executeRequest(String resourceUrl, String etag, String modified) {
        try {
            HttpUrl httpUrl = HttpUrl.parse((String)resourceUrl);
            if (httpUrl == null) {
                this.log(6, String.format("[HTTP] Unable to parse resourceUrl %s", resourceUrl));
            }
            String host = httpUrl.host().toLowerCase(MapboxConstants.MAPBOX_LOCALE);
            if (!(Mapbox.isConnected().booleanValue() || host.equals("127.0.0.1") || host.equals("localhost"))) {
                throw new NoRouteToHostException("No Internet connection available.");
            }
            if (host.equals("mapbox.com") || host.endsWith(".mapbox.com") || host.equals("mapbox.cn") || host.endsWith(".mapbox.cn")) {
                resourceUrl = httpUrl.querySize() == 0 ? resourceUrl + "?" : resourceUrl + "&";
                resourceUrl = resourceUrl + "events=true";
            }
            Request.Builder builder = new Request.Builder().url(resourceUrl).tag((Object)resourceUrl.toLowerCase(MapboxConstants.MAPBOX_LOCALE)).addHeader("User-Agent", this.getUserAgent());
            if (etag.length() > 0) {
                builder = builder.addHeader("If-None-Match", etag);
            } else if (modified.length() > 0) {
                builder = builder.addHeader("If-Modified-Since", modified);
            }
            Request request = builder.build();
            this.call = client.newCall(request);
            this.call.enqueue((Callback)this);
        }
        catch (Exception exception) {
            this.handleFailure(this.call, exception);
        }
    }

    private void executeLocalRequest(String resourceUrl) {
        new LocalRequestTask(new LocalRequestTask.OnLocalRequestResponse(){

            @Override
            public void onResponse(byte[] bytes) {
                if (bytes != null) {
                    HTTPRequest.this.lock.lock();
                    if (HTTPRequest.this.nativePtr != 0L) {
                        HTTPRequest.this.nativeOnResponse(200, null, null, null, null, null, null, bytes);
                    }
                    HTTPRequest.this.lock.unlock();
                }
            }
        }).execute(new String[]{resourceUrl});
    }

    private void handleFailure(Call call, Exception e) {
        String errorMessage = e.getMessage() != null ? e.getMessage() : "Error processing the request";
        int type = this.getFailureType(e);
        if (logEnabled && call != null && call.request() != null) {
            String requestUrl = call.request().url().toString();
            this.logFailure(type, errorMessage, requestUrl);
        }
        this.lock.lock();
        if (this.nativePtr != 0L) {
            this.nativeOnFailure(type, errorMessage);
        }
        this.lock.unlock();
    }

    private int getFailureType(Exception e) {
        if (e instanceof NoRouteToHostException || e instanceof UnknownHostException || e instanceof SocketException || e instanceof ProtocolException || e instanceof SSLException) {
            return 0;
        }
        if (e instanceof InterruptedIOException) {
            return 1;
        }
        return 2;
    }

    private void log(int type, String errorMessage) {
        if (logEnabled) {
            Timber.log((int)type, (String)errorMessage, (Object[])new Object[0]);
        }
    }

    private void logFailure(int type, String errorMessage, String requestUrl) {
        this.log(type == 1 ? 3 : (type == 0 ? 4 : 5), String.format("Request failed due to a %s error: %s %s", type == 1 ? "temporary" : (type == 0 ? "connection" : "permanent"), errorMessage, logRequestUrl ? requestUrl : ""));
    }

    private String getUserAgent() {
        if (this.userAgentString == null) {
            this.userAgentString = TelemetryUtils.toHumanReadableAscii((String)String.format("%s %s (%s) Android/%s (%s)", this.getApplicationIdentifier(), "Mapbox/6.3.0-beta.1", "ad1c06a", Build.VERSION.SDK_INT, Build.CPU_ABI));
        }
        return this.userAgentString;
    }

    private String getApplicationIdentifier() {
        try {
            Context context = Mapbox.getApplicationContext();
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return String.format("%s/%s (%s)", context.getPackageName(), packageInfo.versionName, packageInfo.versionCode);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private native void nativeOnFailure(int var1, String var2);

    private native void nativeOnResponse(int var1, String var2, String var3, String var4, String var5, String var6, String var7, byte[] var8);
}

