/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class HillshadeLayer
extends Layer {
    public HillshadeLayer(long nativePtr) {
        super(nativePtr);
    }

    public HillshadeLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.nativeSetSourceLayer(sourceLayer);
    }

    public HillshadeLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public HillshadeLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<Float> getHillshadeIlluminationDirection() {
        return new PropertyValue<Object>("hillshade-illumination-direction", this.nativeGetHillshadeIlluminationDirection());
    }

    public PropertyValue<String> getHillshadeIlluminationAnchor() {
        return new PropertyValue<Object>("hillshade-illumination-anchor", this.nativeGetHillshadeIlluminationAnchor());
    }

    public PropertyValue<Float> getHillshadeExaggeration() {
        return new PropertyValue<Object>("hillshade-exaggeration", this.nativeGetHillshadeExaggeration());
    }

    public TransitionOptions getHillshadeExaggerationTransition() {
        return this.nativeGetHillshadeExaggerationTransition();
    }

    public void setHillshadeExaggerationTransition(TransitionOptions options) {
        this.nativeSetHillshadeExaggerationTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getHillshadeShadowColor() {
        return new PropertyValue<Object>("hillshade-shadow-color", this.nativeGetHillshadeShadowColor());
    }

    @ColorInt
    public int getHillshadeShadowColorAsInt() {
        PropertyValue<String> value = this.getHillshadeShadowColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("hillshade-shadow-color was set as a Function");
    }

    public TransitionOptions getHillshadeShadowColorTransition() {
        return this.nativeGetHillshadeShadowColorTransition();
    }

    public void setHillshadeShadowColorTransition(TransitionOptions options) {
        this.nativeSetHillshadeShadowColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getHillshadeHighlightColor() {
        return new PropertyValue<Object>("hillshade-highlight-color", this.nativeGetHillshadeHighlightColor());
    }

    @ColorInt
    public int getHillshadeHighlightColorAsInt() {
        PropertyValue<String> value = this.getHillshadeHighlightColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("hillshade-highlight-color was set as a Function");
    }

    public TransitionOptions getHillshadeHighlightColorTransition() {
        return this.nativeGetHillshadeHighlightColorTransition();
    }

    public void setHillshadeHighlightColorTransition(TransitionOptions options) {
        this.nativeSetHillshadeHighlightColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getHillshadeAccentColor() {
        return new PropertyValue<Object>("hillshade-accent-color", this.nativeGetHillshadeAccentColor());
    }

    @ColorInt
    public int getHillshadeAccentColorAsInt() {
        PropertyValue<String> value = this.getHillshadeAccentColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("hillshade-accent-color was set as a Function");
    }

    public TransitionOptions getHillshadeAccentColorTransition() {
        return this.nativeGetHillshadeAccentColorTransition();
    }

    public void setHillshadeAccentColorTransition(TransitionOptions options) {
        this.nativeSetHillshadeAccentColorTransition(options.getDuration(), options.getDelay());
    }

    private native Object nativeGetHillshadeIlluminationDirection();

    private native Object nativeGetHillshadeIlluminationAnchor();

    private native Object nativeGetHillshadeExaggeration();

    private native TransitionOptions nativeGetHillshadeExaggerationTransition();

    private native void nativeSetHillshadeExaggerationTransition(long var1, long var3);

    private native Object nativeGetHillshadeShadowColor();

    private native TransitionOptions nativeGetHillshadeShadowColorTransition();

    private native void nativeSetHillshadeShadowColorTransition(long var1, long var3);

    private native Object nativeGetHillshadeHighlightColor();

    private native TransitionOptions nativeGetHillshadeHighlightColorTransition();

    private native void nativeSetHillshadeHighlightColorTransition(long var1, long var3);

    private native Object nativeGetHillshadeAccentColor();

    private native TransitionOptions nativeGetHillshadeAccentColorTransition();

    private native void nativeSetHillshadeAccentColorTransition(long var1, long var3);

    @Override
    protected native void finalize() throws Throwable;
}

