/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.AsyncTask;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import com.mapbox.mapboxsdk.LibraryLoader;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.geometry.ProjectedMeters;
import com.mapbox.mapboxsdk.maps.Image;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.renderer.MapRenderer;
import com.mapbox.mapboxsdk.storage.FileSource;
import com.mapbox.mapboxsdk.style.layers.CannotAddLayerException;
import com.mapbox.mapboxsdk.style.layers.Filter;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.light.Light;
import com.mapbox.mapboxsdk.style.sources.CannotAddSourceException;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import com.mapbox.services.commons.geojson.Feature;
import com.mapbox.services.commons.geojson.Geometry;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import timber.log.Timber;

final class NativeMapView {
    private boolean destroyed = false;
    private long nativePtr = 0L;
    private MapView mapView;
    private final FileSource fileSource;
    private MapRenderer mapRenderer;
    private final float pixelRatio;
    private MapboxMap.SnapshotReadyCallback snapshotReadyCallback;

    public NativeMapView(MapView mapView, MapRenderer mapRenderer) {
        this.mapRenderer = mapRenderer;
        this.mapView = mapView;
        Context context = mapView.getContext();
        this.fileSource = FileSource.getInstance(context);
        this.pixelRatio = context.getResources().getDisplayMetrics().density;
        this.nativeInitialize(this, this.fileSource, mapRenderer, this.pixelRatio);
    }

    private boolean isDestroyedOn(String callingMethod) {
        if (this.destroyed && !TextUtils.isEmpty((CharSequence)callingMethod)) {
            Timber.e((String)"You're calling `%s` after the `MapView` was destroyed, were you invoking it after `onDestroy()`?", (Object[])new Object[]{callingMethod});
        }
        return this.destroyed;
    }

    public void destroy() {
        this.nativeDestroy();
        this.mapView = null;
        this.destroyed = true;
    }

    public void update() {
        if (this.isDestroyedOn("update")) {
            return;
        }
        this.mapRenderer.requestRender();
    }

    public void resizeView(int width, int height) {
        if (this.isDestroyedOn("resizeView")) {
            return;
        }
        width = (int)((float)width / this.pixelRatio);
        height = (int)((float)height / this.pixelRatio);
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be negative.");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be negative.");
        }
        if (width > 65535) {
            Timber.e((String)"Device returned an out of range width size, capping value at 65535 instead of %s", (Object[])new Object[]{width});
            width = 65535;
        }
        if (height > 65535) {
            Timber.e((String)"Device returned an out of range height size, capping value at 65535 instead of %s", (Object[])new Object[]{height});
            height = 65535;
        }
        this.nativeResizeView(width, height);
    }

    public void setStyleUrl(String url) {
        if (this.isDestroyedOn("setStyleUrl")) {
            return;
        }
        this.nativeSetStyleUrl(url);
    }

    public String getStyleUrl() {
        if (this.isDestroyedOn("getStyleUrl")) {
            return null;
        }
        return this.nativeGetStyleUrl();
    }

    public void setStyleJson(String newStyleJson) {
        if (this.isDestroyedOn("setStyleJson")) {
            return;
        }
        this.nativeSetStyleJson(newStyleJson);
    }

    public String getStyleJson() {
        if (this.isDestroyedOn("getStyleJson")) {
            return null;
        }
        return this.nativeGetStyleJson();
    }

    public void setLatLngBounds(LatLngBounds latLngBounds) {
        if (this.isDestroyedOn("setLatLngBounds")) {
            return;
        }
        this.nativeSetLatLngBounds(latLngBounds);
    }

    public void cancelTransitions() {
        if (this.isDestroyedOn("cancelTransitions")) {
            return;
        }
        this.nativeCancelTransitions();
    }

    public void setGestureInProgress(boolean inProgress) {
        if (this.isDestroyedOn("setGestureInProgress")) {
            return;
        }
        this.nativeSetGestureInProgress(inProgress);
    }

    public void moveBy(double dx, double dy) {
        if (this.isDestroyedOn("moveBy")) {
            return;
        }
        this.moveBy(dx, dy, 0L);
    }

    public void moveBy(double dx, double dy, long duration) {
        if (this.isDestroyedOn("moveBy")) {
            return;
        }
        this.nativeMoveBy(dx / (double)this.pixelRatio, dy / (double)this.pixelRatio, duration);
    }

    public void setLatLng(LatLng latLng) {
        if (this.isDestroyedOn("setLatLng")) {
            return;
        }
        this.setLatLng(latLng, 0L);
    }

    public void setLatLng(LatLng latLng, long duration) {
        if (this.isDestroyedOn("setLatLng")) {
            return;
        }
        this.nativeSetLatLng(latLng.getLatitude(), latLng.getLongitude(), duration);
    }

    public LatLng getLatLng() {
        if (this.isDestroyedOn("")) {
            return new LatLng();
        }
        return this.nativeGetLatLng().wrap();
    }

    public CameraPosition getCameraForLatLngBounds(LatLngBounds latLngBounds) {
        if (this.isDestroyedOn("getCameraForLatLngBounds")) {
            return null;
        }
        return this.nativeGetCameraForLatLngBounds(latLngBounds);
    }

    public CameraPosition getCameraForGeometry(Geometry geometry, double bearing) {
        if (this.isDestroyedOn("getCameraForGeometry")) {
            return null;
        }
        return this.nativeGetCameraForGeometry(geometry, bearing);
    }

    public void resetPosition() {
        if (this.isDestroyedOn("resetPosition")) {
            return;
        }
        this.nativeResetPosition();
    }

    public double getPitch() {
        if (this.isDestroyedOn("getPitch")) {
            return 0.0;
        }
        return this.nativeGetPitch();
    }

    public void setPitch(double pitch, long duration) {
        if (this.isDestroyedOn("setPitch")) {
            return;
        }
        this.nativeSetPitch(pitch, duration);
    }

    public void setZoom(double zoom, PointF focalPoint, long duration) {
        if (this.isDestroyedOn("setZoom")) {
            return;
        }
        this.nativeSetZoom(zoom, focalPoint.x / this.pixelRatio, focalPoint.y / this.pixelRatio, duration);
    }

    public double getZoom() {
        if (this.isDestroyedOn("getZoom")) {
            return 0.0;
        }
        return this.nativeGetZoom();
    }

    public void resetZoom() {
        if (this.isDestroyedOn("resetZoom")) {
            return;
        }
        this.nativeResetZoom();
    }

    public void setMinZoom(double zoom) {
        if (this.isDestroyedOn("setMinZoom")) {
            return;
        }
        this.nativeSetMinZoom(zoom);
    }

    public double getMinZoom() {
        if (this.isDestroyedOn("getMinZoom")) {
            return 0.0;
        }
        return this.nativeGetMinZoom();
    }

    public void setMaxZoom(double zoom) {
        if (this.isDestroyedOn("setMaxZoom")) {
            return;
        }
        this.nativeSetMaxZoom(zoom);
    }

    public double getMaxZoom() {
        if (this.isDestroyedOn("getMaxZoom")) {
            return 0.0;
        }
        return this.nativeGetMaxZoom();
    }

    public void rotateBy(double sx, double sy, double ex, double ey) {
        if (this.isDestroyedOn("rotateBy")) {
            return;
        }
        this.rotateBy(sx, sy, ex, ey, 0L);
    }

    public void rotateBy(double sx, double sy, double ex, double ey, long duration) {
        if (this.isDestroyedOn("rotateBy")) {
            return;
        }
        this.nativeRotateBy(sx / (double)this.pixelRatio, sy / (double)this.pixelRatio, ex, ey, duration);
    }

    public void setContentPadding(int[] padding) {
        if (this.isDestroyedOn("setContentPadding")) {
            return;
        }
        this.nativeSetContentPadding((float)padding[1] / this.pixelRatio, (float)padding[0] / this.pixelRatio, (float)padding[3] / this.pixelRatio, (float)padding[2] / this.pixelRatio);
    }

    public void setBearing(double degrees) {
        if (this.isDestroyedOn("setBearing")) {
            return;
        }
        this.setBearing(degrees, 0L);
    }

    public void setBearing(double degrees, long duration) {
        if (this.isDestroyedOn("setBearing")) {
            return;
        }
        this.nativeSetBearing(degrees, duration);
    }

    public void setBearing(double degrees, double cx, double cy) {
        if (this.isDestroyedOn("setBearing")) {
            return;
        }
        this.setBearing(degrees, cx, cy, 0L);
    }

    public void setBearing(double degrees, double fx, double fy, long duration) {
        if (this.isDestroyedOn("setBearing")) {
            return;
        }
        this.nativeSetBearingXY(degrees, fx / (double)this.pixelRatio, fy / (double)this.pixelRatio, duration);
    }

    public double getBearing() {
        if (this.isDestroyedOn("getBearing")) {
            return 0.0;
        }
        return this.nativeGetBearing();
    }

    public void resetNorth() {
        if (this.isDestroyedOn("resetNorth")) {
            return;
        }
        this.nativeResetNorth();
    }

    public long addMarker(Marker marker) {
        if (this.isDestroyedOn("addMarker")) {
            return 0L;
        }
        Marker[] markers = new Marker[]{marker};
        return this.nativeAddMarkers(markers)[0];
    }

    public long[] addMarkers(List<Marker> markers) {
        if (this.isDestroyedOn("addMarkers")) {
            return new long[0];
        }
        return this.nativeAddMarkers(markers.toArray(new Marker[markers.size()]));
    }

    public long addPolyline(Polyline polyline) {
        if (this.isDestroyedOn("addPolyline")) {
            return 0L;
        }
        Polyline[] polylines = new Polyline[]{polyline};
        return this.nativeAddPolylines(polylines)[0];
    }

    public long[] addPolylines(List<Polyline> polylines) {
        if (this.isDestroyedOn("addPolylines")) {
            return new long[0];
        }
        return this.nativeAddPolylines(polylines.toArray(new Polyline[polylines.size()]));
    }

    public long addPolygon(Polygon polygon) {
        if (this.isDestroyedOn("addPolygon")) {
            return 0L;
        }
        Polygon[] polygons = new Polygon[]{polygon};
        return this.nativeAddPolygons(polygons)[0];
    }

    public long[] addPolygons(List<Polygon> polygons) {
        if (this.isDestroyedOn("addPolygons")) {
            return new long[0];
        }
        return this.nativeAddPolygons(polygons.toArray(new Polygon[polygons.size()]));
    }

    public void updateMarker(Marker marker) {
        if (this.isDestroyedOn("updateMarker")) {
            return;
        }
        LatLng position = marker.getPosition();
        Icon icon = marker.getIcon();
        this.nativeUpdateMarker(marker.getId(), position.getLatitude(), position.getLongitude(), icon.getId());
    }

    public void updatePolygon(Polygon polygon) {
        if (this.isDestroyedOn("updatePolygon")) {
            return;
        }
        this.nativeUpdatePolygon(polygon.getId(), polygon);
    }

    public void updatePolyline(Polyline polyline) {
        if (this.isDestroyedOn("updatePolyline")) {
            return;
        }
        this.nativeUpdatePolyline(polyline.getId(), polyline);
    }

    public void removeAnnotation(long id2) {
        if (this.isDestroyedOn("removeAnnotation")) {
            return;
        }
        long[] ids = new long[]{id2};
        this.removeAnnotations(ids);
    }

    public void removeAnnotations(long[] ids) {
        if (this.isDestroyedOn("removeAnnotations")) {
            return;
        }
        this.nativeRemoveAnnotations(ids);
    }

    public long[] queryPointAnnotations(RectF rect) {
        if (this.isDestroyedOn("queryPointAnnotations")) {
            return new long[0];
        }
        return this.nativeQueryPointAnnotations(rect);
    }

    public long[] queryShapeAnnotations(RectF rectF) {
        if (this.isDestroyedOn("queryShapeAnnotations")) {
            return new long[0];
        }
        return this.nativeQueryShapeAnnotations(rectF);
    }

    public void addAnnotationIcon(String symbol, int width, int height, float scale, byte[] pixels) {
        if (this.isDestroyedOn("addAnnotationIcon")) {
            return;
        }
        this.nativeAddAnnotationIcon(symbol, width, height, scale, pixels);
    }

    public void removeAnnotationIcon(String symbol) {
        if (this.isDestroyedOn("removeAnnotationIcon")) {
            return;
        }
        this.nativeRemoveAnnotationIcon(symbol);
    }

    public void setVisibleCoordinateBounds(LatLng[] coordinates, RectF padding, double direction, long duration) {
        if (this.isDestroyedOn("setVisibleCoordinateBounds")) {
            return;
        }
        this.nativeSetVisibleCoordinateBounds(coordinates, padding, direction, duration);
    }

    public void onLowMemory() {
        if (this.isDestroyedOn("onLowMemory")) {
            return;
        }
        this.nativeOnLowMemory();
    }

    public void setDebug(boolean debug) {
        if (this.isDestroyedOn("setDebug")) {
            return;
        }
        this.nativeSetDebug(debug);
    }

    public void cycleDebugOptions() {
        if (this.isDestroyedOn("cycleDebugOptions")) {
            return;
        }
        this.nativeCycleDebugOptions();
    }

    public boolean getDebug() {
        if (this.isDestroyedOn("getDebug")) {
            return false;
        }
        return this.nativeGetDebug();
    }

    public boolean isFullyLoaded() {
        if (this.isDestroyedOn("isFullyLoaded")) {
            return false;
        }
        return this.nativeIsFullyLoaded();
    }

    public void setReachability(boolean status) {
        if (this.isDestroyedOn("setReachability")) {
            return;
        }
        this.nativeSetReachability(status);
    }

    public double getMetersPerPixelAtLatitude(double lat) {
        if (this.isDestroyedOn("getMetersPerPixelAtLatitude")) {
            return 0.0;
        }
        return this.nativeGetMetersPerPixelAtLatitude(lat, this.getZoom()) / (double)this.pixelRatio;
    }

    public ProjectedMeters projectedMetersForLatLng(LatLng latLng) {
        if (this.isDestroyedOn("projectedMetersForLatLng")) {
            return null;
        }
        return this.nativeProjectedMetersForLatLng(latLng.getLatitude(), latLng.getLongitude());
    }

    public LatLng latLngForProjectedMeters(ProjectedMeters projectedMeters) {
        if (this.isDestroyedOn("latLngForProjectedMeters")) {
            return new LatLng();
        }
        return this.nativeLatLngForProjectedMeters(projectedMeters.getNorthing(), projectedMeters.getEasting()).wrap();
    }

    public PointF pixelForLatLng(LatLng latLng) {
        if (this.isDestroyedOn("pixelForLatLng")) {
            return new PointF();
        }
        PointF pointF = this.nativePixelForLatLng(latLng.getLatitude(), latLng.getLongitude());
        pointF.set(pointF.x * this.pixelRatio, pointF.y * this.pixelRatio);
        return pointF;
    }

    public LatLng latLngForPixel(PointF pixel) {
        if (this.isDestroyedOn("latLngForPixel")) {
            return new LatLng();
        }
        return this.nativeLatLngForPixel(pixel.x / this.pixelRatio, pixel.y / this.pixelRatio).wrap();
    }

    public double getTopOffsetPixelsForAnnotationSymbol(String symbolName) {
        if (this.isDestroyedOn("getTopOffsetPixelsForAnnotationSymbol")) {
            return 0.0;
        }
        return this.nativeGetTopOffsetPixelsForAnnotationSymbol(symbolName);
    }

    public void jumpTo(double angle, LatLng center, double pitch, double zoom) {
        if (this.isDestroyedOn("jumpTo")) {
            return;
        }
        this.nativeJumpTo(angle, center.getLatitude(), center.getLongitude(), pitch, zoom);
    }

    public void easeTo(double angle, LatLng center, long duration, double pitch, double zoom, boolean easingInterpolator) {
        if (this.isDestroyedOn("easeTo")) {
            return;
        }
        this.nativeEaseTo(angle, center.getLatitude(), center.getLongitude(), duration, pitch, zoom, easingInterpolator);
    }

    public void flyTo(double angle, LatLng center, long duration, double pitch, double zoom) {
        if (this.isDestroyedOn("flyTo")) {
            return;
        }
        this.nativeFlyTo(angle, center.getLatitude(), center.getLongitude(), duration, pitch, zoom);
    }

    public CameraPosition getCameraPosition() {
        if (this.isDestroyedOn("getCameraValues")) {
            return new CameraPosition.Builder().build();
        }
        return this.nativeGetCameraPosition();
    }

    public void setPrefetchesTiles(boolean enable) {
        if (this.isDestroyedOn("setPrefetchesTiles")) {
            return;
        }
        this.nativeSetPrefetchesTiles(enable);
    }

    public boolean getPrefetchesTiles() {
        if (this.isDestroyedOn("getPrefetchesTiles")) {
            return false;
        }
        return this.nativeGetPrefetchesTiles();
    }

    public long getTransitionDuration() {
        return this.nativeGetTransitionDuration();
    }

    public void setTransitionDuration(long duration) {
        this.nativeSetTransitionDuration(duration);
    }

    public long getTransitionDelay() {
        return this.nativeGetTransitionDelay();
    }

    public void setTransitionDelay(long delay) {
        this.nativeSetTransitionDelay(delay);
    }

    public List<Layer> getLayers() {
        if (this.isDestroyedOn("getLayers")) {
            return null;
        }
        return Arrays.asList(this.nativeGetLayers());
    }

    public Layer getLayer(String layerId) {
        if (this.isDestroyedOn("getLayer")) {
            return null;
        }
        return this.nativeGetLayer(layerId);
    }

    public void addLayer(@NonNull Layer layer) {
        if (this.isDestroyedOn("addLayer")) {
            return;
        }
        this.nativeAddLayer(layer.getNativePtr(), null);
    }

    public void addLayerBelow(@NonNull Layer layer, @NonNull String below) {
        if (this.isDestroyedOn("addLayerBelow")) {
            return;
        }
        this.nativeAddLayer(layer.getNativePtr(), below);
    }

    public void addLayerAbove(@NonNull Layer layer, @NonNull String above) {
        if (this.isDestroyedOn("addLayerAbove")) {
            return;
        }
        this.nativeAddLayerAbove(layer.getNativePtr(), above);
    }

    public void addLayerAt(@NonNull Layer layer, @IntRange(from=0L) int index) {
        if (this.isDestroyedOn("addLayerAt")) {
            return;
        }
        this.nativeAddLayerAt(layer.getNativePtr(), index);
    }

    @Nullable
    public Layer removeLayer(@NonNull String layerId) {
        if (this.isDestroyedOn("removeLayer")) {
            return null;
        }
        return this.nativeRemoveLayerById(layerId);
    }

    @Nullable
    public Layer removeLayer(@NonNull Layer layer) {
        if (this.isDestroyedOn("removeLayer")) {
            return null;
        }
        this.nativeRemoveLayer(layer.getNativePtr());
        return layer;
    }

    @Nullable
    public Layer removeLayerAt(@IntRange(from=0L) int index) {
        if (this.isDestroyedOn("removeLayerAt")) {
            return null;
        }
        return this.nativeRemoveLayerAt(index);
    }

    public List<Source> getSources() {
        if (this.isDestroyedOn("getSources")) {
            return null;
        }
        return Arrays.asList(this.nativeGetSources());
    }

    public Source getSource(@NonNull String sourceId) {
        if (this.isDestroyedOn("getSource")) {
            return null;
        }
        return this.nativeGetSource(sourceId);
    }

    public void addSource(@NonNull Source source) {
        if (this.isDestroyedOn("addSource")) {
            return;
        }
        this.nativeAddSource(source, source.getNativePtr());
    }

    @Nullable
    public Source removeSource(@NonNull String sourceId) {
        if (this.isDestroyedOn("removeSource")) {
            return null;
        }
        Source source = this.getSource(sourceId);
        return this.removeSource(source);
    }

    public Source removeSource(@NonNull Source source) {
        if (this.isDestroyedOn("removeSource")) {
            return null;
        }
        this.nativeRemoveSource(source, source.getNativePtr());
        return source;
    }

    public void addImage(@NonNull String name, @NonNull Bitmap image) {
        if (this.isDestroyedOn("addImage")) {
            return;
        }
        if (image.getConfig() != Bitmap.Config.ARGB_8888) {
            image = image.copy(Bitmap.Config.ARGB_8888, false);
        }
        ByteBuffer buffer = ByteBuffer.allocate(image.getByteCount());
        image.copyPixelsToBuffer((Buffer)buffer);
        float density = image.getDensity() == 0 ? 0.0f : (float)image.getDensity();
        float pixelRatio = density / 160.0f;
        this.nativeAddImage(name, image.getWidth(), image.getHeight(), pixelRatio, buffer.array());
    }

    public void addImages(@NonNull HashMap<String, Bitmap> bitmapHashMap) {
        if (this.isDestroyedOn("addImages")) {
            return;
        }
        new BitmapImageConversionTask(this).execute(new HashMap[]{bitmapHashMap});
    }

    public void removeImage(String name) {
        if (this.isDestroyedOn("removeImage")) {
            return;
        }
        this.nativeRemoveImage(name);
    }

    public Bitmap getImage(String name) {
        if (this.isDestroyedOn("getImage")) {
            return null;
        }
        return this.nativeGetImage(name);
    }

    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull PointF coordinates, @Nullable String[] layerIds, @Nullable Filter.Statement filter) {
        if (this.isDestroyedOn("queryRenderedFeatures")) {
            return new ArrayList<Feature>();
        }
        Feature[] features = this.nativeQueryRenderedFeaturesForPoint(coordinates.x / this.pixelRatio, coordinates.y / this.pixelRatio, layerIds, filter != null ? filter.toArray() : null);
        return features != null ? Arrays.asList(features) : new ArrayList<Feature>();
    }

    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull RectF coordinates, @Nullable String[] layerIds, @Nullable Filter.Statement filter) {
        if (this.isDestroyedOn("queryRenderedFeatures")) {
            return new ArrayList<Feature>();
        }
        Feature[] features = this.nativeQueryRenderedFeaturesForBox(coordinates.left / this.pixelRatio, coordinates.top / this.pixelRatio, coordinates.right / this.pixelRatio, coordinates.bottom / this.pixelRatio, layerIds, filter != null ? filter.toArray() : null);
        return features != null ? Arrays.asList(features) : new ArrayList<Feature>();
    }

    public void setApiBaseUrl(String baseUrl) {
        if (this.isDestroyedOn("setApiBaseUrl")) {
            return;
        }
        this.fileSource.setApiBaseUrl(baseUrl);
    }

    public Light getLight() {
        if (this.isDestroyedOn("getLight")) {
            return null;
        }
        return this.nativeGetLight();
    }

    public float getPixelRatio() {
        return this.pixelRatio;
    }

    RectF getDensityDependantRectangle(RectF rectangle) {
        return new RectF(rectangle.left / this.pixelRatio, rectangle.top / this.pixelRatio, rectangle.right / this.pixelRatio, rectangle.bottom / this.pixelRatio);
    }

    protected void onMapChanged(int rawChange) {
        if (this.mapView != null) {
            this.mapView.onMapChange(rawChange);
        }
    }

    protected void onSnapshotReady(Bitmap mapContent) {
        if (this.isDestroyedOn("OnSnapshotReady")) {
            return;
        }
        Bitmap viewContent = BitmapUtils.createBitmapFromView((View)this.mapView);
        if (this.snapshotReadyCallback != null && mapContent != null && viewContent != null) {
            this.snapshotReadyCallback.onSnapshotReady(BitmapUtils.mergeBitmap(mapContent, viewContent));
        }
    }

    private native void nativeInitialize(NativeMapView var1, FileSource var2, MapRenderer var3, float var4);

    private native void nativeDestroy();

    private native void nativeResizeView(int var1, int var2);

    private native void nativeSetStyleUrl(String var1);

    private native String nativeGetStyleUrl();

    private native void nativeSetStyleJson(String var1);

    private native String nativeGetStyleJson();

    private native void nativeSetLatLngBounds(LatLngBounds var1);

    private native void nativeCancelTransitions();

    private native void nativeSetGestureInProgress(boolean var1);

    private native void nativeMoveBy(double var1, double var3, long var5);

    private native void nativeSetLatLng(double var1, double var3, long var5);

    private native LatLng nativeGetLatLng();

    private native CameraPosition nativeGetCameraForLatLngBounds(LatLngBounds var1);

    private native CameraPosition nativeGetCameraForGeometry(Geometry var1, double var2);

    private native void nativeResetPosition();

    private native double nativeGetPitch();

    private native void nativeSetPitch(double var1, long var3);

    private native void nativeSetZoom(double var1, double var3, double var5, long var7);

    private native double nativeGetZoom();

    private native void nativeResetZoom();

    private native void nativeSetMinZoom(double var1);

    private native double nativeGetMinZoom();

    private native void nativeSetMaxZoom(double var1);

    private native double nativeGetMaxZoom();

    private native void nativeRotateBy(double var1, double var3, double var5, double var7, long var9);

    private native void nativeSetContentPadding(double var1, double var3, double var5, double var7);

    private native void nativeSetBearing(double var1, long var3);

    private native void nativeSetBearingXY(double var1, double var3, double var5, long var7);

    private native double nativeGetBearing();

    private native void nativeResetNorth();

    private native void nativeUpdateMarker(long var1, double var3, double var5, String var7);

    private native long[] nativeAddMarkers(Marker[] var1);

    private native long[] nativeAddPolylines(Polyline[] var1);

    private native long[] nativeAddPolygons(Polygon[] var1);

    private native void nativeRemoveAnnotations(long[] var1);

    private native long[] nativeQueryPointAnnotations(RectF var1);

    private native long[] nativeQueryShapeAnnotations(RectF var1);

    private native void nativeAddAnnotationIcon(String var1, int var2, int var3, float var4, byte[] var5);

    private native void nativeRemoveAnnotationIcon(String var1);

    private native void nativeSetVisibleCoordinateBounds(LatLng[] var1, RectF var2, double var3, long var5);

    private native void nativeOnLowMemory();

    private native void nativeSetDebug(boolean var1);

    private native void nativeCycleDebugOptions();

    private native boolean nativeGetDebug();

    private native boolean nativeIsFullyLoaded();

    private native void nativeSetReachability(boolean var1);

    private native double nativeGetMetersPerPixelAtLatitude(double var1, double var3);

    private native ProjectedMeters nativeProjectedMetersForLatLng(double var1, double var3);

    private native LatLng nativeLatLngForProjectedMeters(double var1, double var3);

    private native PointF nativePixelForLatLng(double var1, double var3);

    private native LatLng nativeLatLngForPixel(float var1, float var2);

    private native double nativeGetTopOffsetPixelsForAnnotationSymbol(String var1);

    private native void nativeJumpTo(double var1, double var3, double var5, double var7, double var9);

    private native void nativeEaseTo(double var1, double var3, double var5, long var7, double var9, double var11, boolean var13);

    private native void nativeFlyTo(double var1, double var3, double var5, long var7, double var9, double var11);

    private native CameraPosition nativeGetCameraPosition();

    private native long nativeGetTransitionDuration();

    private native void nativeSetTransitionDuration(long var1);

    private native long nativeGetTransitionDelay();

    private native void nativeSetTransitionDelay(long var1);

    private native Layer[] nativeGetLayers();

    private native Layer nativeGetLayer(String var1);

    private native void nativeAddLayer(long var1, String var3) throws CannotAddLayerException;

    private native void nativeAddLayerAbove(long var1, String var3) throws CannotAddLayerException;

    private native void nativeAddLayerAt(long var1, int var3) throws CannotAddLayerException;

    private native Layer nativeRemoveLayerById(String var1);

    private native void nativeRemoveLayer(long var1);

    private native Layer nativeRemoveLayerAt(int var1);

    private native Source[] nativeGetSources();

    private native Source nativeGetSource(String var1);

    private native void nativeAddSource(Source var1, long var2) throws CannotAddSourceException;

    private native void nativeRemoveSource(Source var1, long var2);

    private native void nativeAddImage(String var1, int var2, int var3, float var4, byte[] var5);

    private native void nativeAddImages(Image[] var1);

    private native void nativeRemoveImage(String var1);

    private native Bitmap nativeGetImage(String var1);

    private native void nativeUpdatePolygon(long var1, Polygon var3);

    private native void nativeUpdatePolyline(long var1, Polyline var3);

    private native void nativeTakeSnapshot();

    private native Feature[] nativeQueryRenderedFeaturesForPoint(float var1, float var2, String[] var3, Object[] var4);

    private native Feature[] nativeQueryRenderedFeaturesForBox(float var1, float var2, float var3, float var4, String[] var5, Object[] var6);

    private native Light nativeGetLight();

    private native void nativeSetPrefetchesTiles(boolean var1);

    private native boolean nativeGetPrefetchesTiles();

    int getWidth() {
        if (this.isDestroyedOn("")) {
            return 0;
        }
        return this.mapView.getWidth();
    }

    int getHeight() {
        if (this.isDestroyedOn("")) {
            return 0;
        }
        return this.mapView.getHeight();
    }

    void addOnMapChangedListener(@NonNull MapView.OnMapChangedListener listener) {
        if (this.mapView != null) {
            this.mapView.addOnMapChangedListener(listener);
        }
    }

    void removeOnMapChangedListener(@NonNull MapView.OnMapChangedListener listener) {
        this.mapView.removeOnMapChangedListener(listener);
    }

    void addSnapshotCallback(@NonNull MapboxMap.SnapshotReadyCallback callback) {
        if (this.isDestroyedOn("addSnapshotCallback")) {
            return;
        }
        this.snapshotReadyCallback = callback;
        this.nativeTakeSnapshot();
    }

    public void setOnFpsChangedListener(final MapboxMap.OnFpsChangedListener listener) {
        this.mapRenderer.queueEvent(new Runnable(){

            @Override
            public void run() {
                NativeMapView.this.mapRenderer.setOnFpsChangedListener(new MapboxMap.OnFpsChangedListener(){

                    @Override
                    public void onFpsChanged(final double fps) {
                        NativeMapView.this.mapView.post(new Runnable(){

                            @Override
                            public void run() {
                                listener.onFpsChanged(fps);
                            }
                        });
                    }
                });
            }
        });
    }

    static {
        LibraryLoader.load();
    }

    private static class BitmapImageConversionTask
    extends AsyncTask<HashMap<String, Bitmap>, Void, List<Image>> {
        private NativeMapView nativeMapView;

        BitmapImageConversionTask(NativeMapView nativeMapView) {
            this.nativeMapView = nativeMapView;
        }

        protected List<Image> doInBackground(HashMap<String, Bitmap> ... params) {
            HashMap<String, Bitmap> bitmapHashMap = params[0];
            ArrayList<Image> images = new ArrayList<Image>();
            for (Map.Entry<String, Bitmap> stringBitmapEntry : bitmapHashMap.entrySet()) {
                String name = stringBitmapEntry.getKey();
                Bitmap bitmap = stringBitmapEntry.getValue();
                if (bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
                    bitmap = bitmap.copy(Bitmap.Config.ARGB_8888, false);
                }
                ByteBuffer buffer = ByteBuffer.allocate(bitmap.getByteCount());
                bitmap.copyPixelsToBuffer((Buffer)buffer);
                float density = bitmap.getDensity() == 0 ? 0.0f : (float)bitmap.getDensity();
                float pixelRatio = density / 160.0f;
                images.add(new Image(buffer.array(), pixelRatio, name, bitmap.getWidth(), bitmap.getHeight()));
            }
            return images;
        }

        protected void onPostExecute(List<Image> images) {
            super.onPostExecute(images);
            if (this.nativeMapView != null && !this.nativeMapView.isDestroyedOn("nativeAddImages")) {
                this.nativeMapView.nativeAddImages(images.toArray(new Image[images.size()]));
            }
        }
    }
}

