/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.http;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.text.TextUtils;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import timber.log.Timber;

class HTTPRequest
implements Callback {
    private static OkHttpClient mClient = new OkHttpClient.Builder().dispatcher(HTTPRequest.getDispatcher()).build();
    private static boolean logEnabled = true;
    private static boolean logRequestUrl = false;
    private String USER_AGENT_STRING = null;
    private static final int CONNECTION_ERROR = 0;
    private static final int TEMPORARY_ERROR = 1;
    private static final int PERMANENT_ERROR = 2;
    private ReentrantLock mLock = new ReentrantLock();
    private long mNativePtr = 0L;
    private Call mCall;
    private Request mRequest;

    private static Dispatcher getDispatcher() {
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequestsPerHost(20);
        return dispatcher;
    }

    private native void nativeOnFailure(int var1, String var2);

    private native void nativeOnResponse(int var1, String var2, String var3, String var4, String var5, String var6, String var7, byte[] var8);

    private HTTPRequest(long nativePtr, String resourceUrl, String etag, String modified) {
        this.mNativePtr = nativePtr;
        try {
            HttpUrl httpUrl = HttpUrl.parse((String)resourceUrl);
            String host = httpUrl.host().toLowerCase(MapboxConstants.MAPBOX_LOCALE);
            if (!(Mapbox.isConnected().booleanValue() || host.equals("127.0.0.1") || host.equals("localhost"))) {
                throw new NoRouteToHostException("No Internet connection available.");
            }
            if (host.equals("mapbox.com") || host.endsWith(".mapbox.com") || host.equals("mapbox.cn") || host.endsWith(".mapbox.cn")) {
                resourceUrl = httpUrl.querySize() == 0 ? resourceUrl + "?" : resourceUrl + "&";
                resourceUrl = resourceUrl + "events=true";
            }
            Request.Builder builder = new Request.Builder().url(resourceUrl).tag((Object)resourceUrl.toLowerCase(MapboxConstants.MAPBOX_LOCALE)).addHeader("User-Agent", this.getUserAgent());
            if (etag.length() > 0) {
                builder = builder.addHeader("If-None-Match", etag);
            } else if (modified.length() > 0) {
                builder = builder.addHeader("If-Modified-Since", modified);
            }
            this.mRequest = builder.build();
            this.mCall = mClient.newCall(this.mRequest);
            this.mCall.enqueue((Callback)this);
        }
        catch (Exception exception) {
            this.handleFailure(this.mCall, exception);
        }
    }

    public void cancel() {
        if (this.mCall != null) {
            this.mCall.cancel();
        }
        this.mLock.lock();
        this.mNativePtr = 0L;
        this.mLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(Call call, Response response) throws IOException {
        byte[] body;
        if (logEnabled) {
            if (response.isSuccessful()) {
                Timber.v((String)"[HTTP] Request was successful (code = %s).", (Object[])new Object[]{response.code()});
            } else {
                String message = !TextUtils.isEmpty((CharSequence)response.message()) ? response.message() : "No additional information";
                Timber.d((String)"[HTTP] Request with response code = %s: %s", (Object[])new Object[]{response.code(), message});
            }
        }
        try {
            body = response.body().bytes();
        }
        catch (IOException ioException) {
            this.onFailure(call, ioException);
            return;
        }
        finally {
            response.body().close();
        }
        this.mLock.lock();
        if (this.mNativePtr != 0L) {
            this.nativeOnResponse(response.code(), response.header("ETag"), response.header("Last-Modified"), response.header("Cache-Control"), response.header("Expires"), response.header("Retry-After"), response.header("x-rate-limit-reset"), body);
        }
        this.mLock.unlock();
    }

    public void onFailure(Call call, IOException e) {
        this.handleFailure(call, e);
    }

    private void handleFailure(Call call, Exception e) {
        String errorMessage = e.getMessage() != null ? e.getMessage() : "Error processing the request";
        int type = this.getFailureType(e);
        if (logEnabled && call != null && call.request() != null) {
            String requestUrl = call.request().url().toString();
            this.logFailure(type, errorMessage, requestUrl);
        }
        this.mLock.lock();
        if (this.mNativePtr != 0L) {
            this.nativeOnFailure(type, errorMessage);
        }
        this.mLock.unlock();
    }

    private int getFailureType(Exception e) {
        if (e instanceof NoRouteToHostException || e instanceof UnknownHostException || e instanceof SocketException || e instanceof ProtocolException || e instanceof SSLException) {
            return 0;
        }
        if (e instanceof InterruptedIOException) {
            return 1;
        }
        return 2;
    }

    private void logFailure(int type, String errorMessage, String requestUrl) {
        Timber.log((int)(type == 1 ? 3 : (type == 0 ? 4 : 5)), (String)"Request failed due to a %s error: %s %s", (Object[])new Object[]{type == 1 ? "temporary" : (type == 0 ? "connection" : "permanent"), errorMessage, logRequestUrl ? requestUrl : ""});
    }

    private String getUserAgent() {
        if (this.USER_AGENT_STRING == null) {
            this.USER_AGENT_STRING = Util.toHumanReadableAscii((String)String.format("%s %s (%s) Android/%s (%s)", this.getApplicationIdentifier(), "Mapbox/6.0.0-beta.1", "9c24617", Build.VERSION.SDK_INT, Build.CPU_ABI));
            return this.USER_AGENT_STRING;
        }
        return this.USER_AGENT_STRING;
    }

    private String getApplicationIdentifier() {
        try {
            Context context = Mapbox.getApplicationContext();
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return String.format("%s/%s (%s)", context.getPackageName(), packageInfo.versionName, packageInfo.versionCode);
        }
        catch (Exception exception) {
            return "";
        }
    }

    static void enableLog(boolean enabled) {
        logEnabled = enabled;
    }

    static void enablePrintRequestUrlOnFailure(boolean enabled) {
        logRequestUrl = enabled;
    }

    static void setOKHttpClient(OkHttpClient client) {
        mClient = client;
    }
}

