/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.geometry;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.mapboxsdk.exceptions.InvalidLatLngBoundsException;
import com.mapbox.mapboxsdk.geometry.ILatLng;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngSpan;
import java.util.ArrayList;
import java.util.List;

public class LatLngBounds
implements Parcelable {
    private final double latitudeNorth;
    private final double latitudeSouth;
    private final double longitudeEast;
    private final double longitudeWest;
    public static final Parcelable.Creator<LatLngBounds> CREATOR = new Parcelable.Creator<LatLngBounds>(){

        public LatLngBounds createFromParcel(Parcel in) {
            return LatLngBounds.readFromParcel(in);
        }

        public LatLngBounds[] newArray(int size) {
            return new LatLngBounds[size];
        }
    };

    LatLngBounds(double northLatitude, double eastLongitude, double southLatitude, double westLongitude) {
        this.latitudeNorth = northLatitude;
        this.longitudeEast = eastLongitude;
        this.latitudeSouth = southLatitude;
        this.longitudeWest = westLongitude;
    }

    public static LatLngBounds world() {
        return new Builder().include(new LatLng(90.0, 180.0)).include(new LatLng(-90.0, -180.0)).build();
    }

    public LatLng getCenter() {
        return new LatLng((this.latitudeNorth + this.latitudeSouth) / 2.0, (this.longitudeEast + this.longitudeWest) / 2.0);
    }

    public double getLatNorth() {
        return this.latitudeNorth;
    }

    public double getLatSouth() {
        return this.latitudeSouth;
    }

    public double getLonEast() {
        return this.longitudeEast;
    }

    public double getLonWest() {
        return this.longitudeWest;
    }

    public LatLng getSouthWest() {
        return new LatLng(this.latitudeSouth, this.longitudeWest);
    }

    public LatLng getNorthEast() {
        return new LatLng(this.latitudeNorth, this.longitudeEast);
    }

    public LatLng getSouthEast() {
        return new LatLng(this.latitudeSouth, this.longitudeEast);
    }

    public LatLng getNorthWest() {
        return new LatLng(this.latitudeNorth, this.longitudeWest);
    }

    public LatLngSpan getSpan() {
        return new LatLngSpan(this.getLatitudeSpan(), this.getLongitudeSpan());
    }

    public double getLatitudeSpan() {
        return Math.abs(this.latitudeNorth - this.latitudeSouth);
    }

    public double getLongitudeSpan() {
        return Math.abs(this.longitudeEast - this.longitudeWest);
    }

    public boolean isEmptySpan() {
        return this.getLongitudeSpan() == 0.0 || this.getLatitudeSpan() == 0.0;
    }

    public String toString() {
        return "N:" + this.latitudeNorth + "; E:" + this.longitudeEast + "; S:" + this.latitudeSouth + "; W:" + this.longitudeWest;
    }

    static LatLngBounds fromLatLngs(List<? extends ILatLng> latLngs) {
        double minLat = 90.0;
        double minLon = 180.0;
        double maxLat = -90.0;
        double maxLon = -180.0;
        for (ILatLng iLatLng : latLngs) {
            double latitude = iLatLng.getLatitude();
            double longitude = iLatLng.getLongitude();
            minLat = Math.min(minLat, latitude);
            minLon = Math.min(minLon, longitude);
            maxLat = Math.max(maxLat, latitude);
            maxLon = Math.max(maxLon, longitude);
        }
        return new LatLngBounds(maxLat, maxLon, minLat, minLon);
    }

    public LatLng[] toLatLngs() {
        return new LatLng[]{this.getNorthEast(), this.getSouthWest()};
    }

    public static LatLngBounds from(@FloatRange(from=-90.0, to=90.0) double latNorth, double lonEast, @FloatRange(from=-90.0, to=90.0) double latSouth, double lonWest) {
        if (Double.isNaN(latNorth) || Double.isNaN(latSouth)) {
            throw new IllegalArgumentException("latitude must not be NaN");
        }
        if (Double.isNaN(lonEast) || Double.isNaN(lonWest)) {
            throw new IllegalArgumentException("longitude must not be NaN");
        }
        if (Double.isInfinite(lonEast) || Double.isInfinite(lonWest)) {
            throw new IllegalArgumentException("longitude must not be infinite");
        }
        if (latNorth > 90.0 || latNorth < -90.0 || latSouth > 90.0 || latSouth < -90.0) {
            throw new IllegalArgumentException("latitude must be between -90 and 90");
        }
        lonEast = LatLng.wrap(lonEast, -180.0, 180.0);
        lonWest = LatLng.wrap(lonWest, -180.0, 180.0);
        return new LatLngBounds(latNorth, lonEast, latSouth, lonWest);
    }

    private static double lat_(int z, int y) {
        double n = Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, z);
        return Math.toDegrees(Math.atan(0.5 * (Math.exp(n) - Math.exp(-n))));
    }

    private static double lon_(int z, int x) {
        return (double)x / Math.pow(2.0, z) * 360.0 - 180.0;
    }

    public static LatLngBounds from(int z, int x, int y) {
        return new LatLngBounds(LatLngBounds.lat_(z, y), LatLngBounds.lon_(z, x + 1), LatLngBounds.lat_(z, y + 1), LatLngBounds.lon_(z, x));
    }

    public LatLngBounds include(LatLng latLng) {
        return new Builder().include(this.getNorthEast()).include(this.getSouthWest()).include(latLng).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LatLngBounds) {
            LatLngBounds other = (LatLngBounds)o;
            return this.latitudeNorth == other.getLatNorth() && this.latitudeSouth == other.getLatSouth() && this.longitudeEast == other.getLonEast() && this.longitudeWest == other.getLonWest();
        }
        return false;
    }

    public boolean contains(ILatLng latLng) {
        double latitude = latLng.getLatitude();
        double longitude = latLng.getLongitude();
        return latitude <= this.latitudeNorth && latitude >= this.latitudeSouth && longitude <= this.longitudeEast && longitude >= this.longitudeWest;
    }

    public boolean contains(LatLngBounds other) {
        return this.contains(other.getNorthEast()) && this.contains(other.getSouthWest());
    }

    public LatLngBounds union(LatLngBounds bounds) {
        return this.union(bounds.getLatNorth(), bounds.getLonEast(), bounds.getLatSouth(), bounds.getLonWest());
    }

    public LatLngBounds union(double latNorth, double lonEast, double latSouth, double lonWest) {
        return new LatLngBounds(this.latitudeNorth < latNorth ? latNorth : this.latitudeNorth, this.longitudeEast < lonEast ? lonEast : this.longitudeEast, this.latitudeSouth > latSouth ? latSouth : this.latitudeSouth, this.longitudeWest > lonWest ? lonWest : this.longitudeWest);
    }

    @Nullable
    public LatLngBounds intersect(LatLngBounds box) {
        double minLonWest = Math.max(this.getLonWest(), box.getLonWest());
        double maxLonEast = Math.min(this.getLonEast(), box.getLonEast());
        if (maxLonEast > minLonWest) {
            double minLatSouth = Math.max(this.getLatSouth(), box.getLatSouth());
            double maxLatNorth = Math.min(this.getLatNorth(), box.getLatNorth());
            if (maxLatNorth > minLatSouth) {
                return new LatLngBounds(maxLatNorth, maxLonEast, minLatSouth, minLonWest);
            }
        }
        return null;
    }

    public LatLngBounds intersect(double northLatitude, double eastLongitude, double southLatitude, double westLongitude) {
        return this.intersect(new LatLngBounds(northLatitude, eastLongitude, southLatitude, westLongitude));
    }

    public int hashCode() {
        return (int)(this.latitudeNorth + 90.0 + (this.latitudeSouth + 90.0) * 1000.0 + (this.longitudeEast + 180.0) * 1000000.0 + (this.longitudeEast + 180.0) * 1.0E9);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeDouble(this.latitudeNorth);
        out.writeDouble(this.longitudeEast);
        out.writeDouble(this.latitudeSouth);
        out.writeDouble(this.longitudeWest);
    }

    private static LatLngBounds readFromParcel(Parcel in) {
        double lonNorth = in.readDouble();
        double latEast = in.readDouble();
        double lonSouth = in.readDouble();
        double latWest = in.readDouble();
        return new LatLngBounds(lonNorth, latEast, lonSouth, latWest);
    }

    public static final class Builder {
        private List<LatLng> latLngList = new ArrayList<LatLng>();

        public LatLngBounds build() {
            if (this.latLngList.size() < 2) {
                throw new InvalidLatLngBoundsException(this.latLngList.size());
            }
            return LatLngBounds.fromLatLngs(this.latLngList);
        }

        public Builder includes(List<LatLng> latLngs) {
            for (LatLng point : latLngs) {
                this.include(point);
            }
            return this;
        }

        public Builder include(@NonNull LatLng latLng) {
            if (!this.latLngList.contains(latLng)) {
                this.latLngList.add(latLng);
            }
            return this;
        }
    }
}

