/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.snapshotter;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.util.DisplayMetrics;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.snapshotter.MapSnapshot;
import com.mapbox.mapboxsdk.storage.FileSource;

@UiThread
public class MapSnapshotter {
    private static final int LOGO_MARGIN_DP = 4;
    private long nativePtr = 0L;
    private final Context context;
    private SnapshotReadyCallback callback;
    private ErrorHandler errorHandler;

    public MapSnapshotter(@NonNull Context context, @NonNull Options options) {
        this.context = context.getApplicationContext();
        FileSource fileSource = FileSource.getInstance(context);
        String programCacheDir = context.getCacheDir().getAbsolutePath();
        this.nativeInitialize(this, fileSource, options.pixelRatio, options.width, options.height, options.styleUrl, options.region, options.cameraPosition, options.showLogo, programCacheDir);
    }

    public void start(@NonNull SnapshotReadyCallback callback) {
        this.start(callback, null);
    }

    public void start(@NonNull SnapshotReadyCallback callback, ErrorHandler errorHandler) {
        if (this.callback != null) {
            throw new IllegalStateException("Snapshotter was already started");
        }
        this.callback = callback;
        this.errorHandler = errorHandler;
        this.nativeStart();
    }

    public native void setSize(int var1, int var2);

    public native void setCameraPosition(CameraPosition var1);

    public native void setRegion(LatLngBounds var1);

    public native void setStyleUrl(String var1);

    public void cancel() {
        this.reset();
        this.nativeCancel();
    }

    protected void addOverlay(MapSnapshot mapSnapshot) {
        Bitmap original = mapSnapshot.getBitmap();
        Canvas canvas = new Canvas(original);
        this.addLogo(canvas, original);
    }

    private void addLogo(Canvas canvas, Bitmap original) {
        DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
        float margin = displayMetrics.density * 4.0f;
        Bitmap logo = this.createScaledLogo(original);
        canvas.drawBitmap(logo, margin, (float)(original.getHeight() - logo.getHeight()) - margin, null);
    }

    private Bitmap createScaledLogo(Bitmap snapshot) {
        Bitmap logo = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)R.drawable.mapbox_logo_icon, null);
        float scale = this.calculateLogoScale(snapshot, logo);
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        return Bitmap.createBitmap((Bitmap)logo, (int)0, (int)0, (int)logo.getWidth(), (int)logo.getHeight(), (Matrix)matrix, (boolean)true);
    }

    private float calculateLogoScale(Bitmap snapshot, Bitmap logo) {
        DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
        float widthRatio = displayMetrics.widthPixels / snapshot.getWidth();
        float heightRatio = displayMetrics.heightPixels / snapshot.getHeight();
        float prefWidth = (float)logo.getWidth() / widthRatio;
        float prefHeight = (float)logo.getHeight() / heightRatio;
        float calculatedScale = Math.min(prefWidth / (float)logo.getWidth(), prefHeight / (float)logo.getHeight()) * 2.0f;
        return calculatedScale < 1.0f ? calculatedScale : 1.0f;
    }

    protected void onSnapshotReady(MapSnapshot snapshot) {
        if (this.callback != null) {
            if (snapshot.isShowLogo()) {
                this.addOverlay(snapshot);
            }
            this.callback.onSnapshotReady(snapshot);
            this.reset();
        }
    }

    protected void onSnapshotFailed(String reason) {
        if (this.errorHandler != null) {
            this.errorHandler.onError(reason);
            this.reset();
        }
    }

    protected void reset() {
        this.callback = null;
        this.errorHandler = null;
    }

    protected native void nativeInitialize(MapSnapshotter var1, FileSource var2, float var3, int var4, int var5, String var6, LatLngBounds var7, CameraPosition var8, boolean var9, String var10);

    protected native void nativeStart();

    protected native void nativeCancel();

    protected native void finalize() throws Throwable;

    public static class Options {
        private int pixelRatio = 1;
        private int width;
        private int height;
        private String styleUrl = "mapbox://styles/mapbox/streets-v10";
        private LatLngBounds region;
        private CameraPosition cameraPosition;
        private boolean showLogo = true;

        public Options(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public Options withStyle(String url) {
            this.styleUrl = url;
            return this;
        }

        public Options withRegion(LatLngBounds region) {
            this.region = region;
            return this;
        }

        public Options withPixelRatio(int pixelRatio) {
            this.pixelRatio = pixelRatio;
            return this;
        }

        public Options withCameraPosition(CameraPosition cameraPosition) {
            this.cameraPosition = cameraPosition;
            return this;
        }

        public Options withLogo(boolean showLogo) {
            this.showLogo = showLogo;
            return this;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getPixelRatio() {
            return this.pixelRatio;
        }

        @Nullable
        public LatLngBounds getRegion() {
            return this.region;
        }

        public String getStyleUrl() {
            return this.styleUrl;
        }

        @Nullable
        public CameraPosition getCameraPosition() {
            return this.cameraPosition;
        }
    }

    public static interface ErrorHandler {
        public void onError(String var1);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(MapSnapshot var1);
    }
}

