/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.Bitmap;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.IconFactory;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import java.util.HashMap;
import java.util.Map;

class IconManager {
    private final Map<Icon, Integer> iconMap = new HashMap<Icon, Integer>();
    private NativeMapView nativeMapView;
    private int highestIconWidth;
    private int highestIconHeight;

    IconManager(NativeMapView nativeMapView) {
        this.nativeMapView = nativeMapView;
        this.loadIcon(IconFactory.recreate("com.mapbox.icons.icon_marker_view", IconFactory.ICON_MARKERVIEW_BITMAP));
    }

    Icon loadIconForMarker(Marker marker) {
        Icon icon = marker.getIcon();
        if (icon == null) {
            icon = this.loadDefaultIconForMarker(marker);
        } else {
            this.updateHighestIconSize(icon);
        }
        this.addIcon(icon);
        return icon;
    }

    void loadIconForMarkerView(MarkerView marker) {
        Icon icon = marker.getIcon();
        Bitmap bitmap = icon.getBitmap();
        this.updateHighestIconSize(bitmap);
        this.addIcon(icon, false);
    }

    int getTopOffsetPixelsForIcon(Icon icon) {
        return (int)(this.nativeMapView.getTopOffsetPixelsForAnnotationSymbol(icon.getId()) * (double)this.nativeMapView.getPixelRatio());
    }

    int getHighestIconWidth() {
        return this.highestIconWidth;
    }

    int getHighestIconHeight() {
        return this.highestIconHeight;
    }

    private Icon loadDefaultIconForMarker(Marker marker) {
        Icon icon = IconFactory.getInstance(Mapbox.getApplicationContext()).defaultMarker();
        Bitmap bitmap = icon.getBitmap();
        this.updateHighestIconSize(bitmap.getWidth(), bitmap.getHeight() / 2);
        marker.setIcon(icon);
        return icon;
    }

    private void addIcon(Icon icon) {
        this.addIcon(icon, true);
    }

    private void addIcon(Icon icon, boolean addIconToMap) {
        if (!this.iconMap.keySet().contains(icon)) {
            this.iconMap.put(icon, 1);
            if (addIconToMap) {
                this.loadIcon(icon);
            }
        } else {
            this.iconMap.put(icon, this.iconMap.get(icon) + 1);
        }
    }

    private void updateHighestIconSize(Icon icon) {
        this.updateHighestIconSize(icon.getBitmap());
    }

    private void updateHighestIconSize(Bitmap bitmap) {
        this.updateHighestIconSize(bitmap.getWidth(), bitmap.getHeight());
    }

    private void updateHighestIconSize(int width, int height) {
        if (width > this.highestIconWidth) {
            this.highestIconWidth = width;
        }
        if (height > this.highestIconHeight) {
            this.highestIconHeight = height;
        }
    }

    private void loadIcon(Icon icon) {
        Bitmap bitmap = icon.getBitmap();
        this.nativeMapView.addAnnotationIcon(icon.getId(), bitmap.getWidth(), bitmap.getHeight(), icon.getScale(), icon.toBytes());
    }

    void reloadIcons() {
        for (Icon icon : this.iconMap.keySet()) {
            this.loadIcon(icon);
        }
    }

    void ensureIconLoaded(Marker marker, MapboxMap mapboxMap) {
        Icon icon = marker.getIcon();
        if (icon == null) {
            icon = this.loadDefaultIconForMarker(marker);
        }
        this.addIcon(icon);
        this.setTopOffsetPixels(marker, mapboxMap, icon);
    }

    private void setTopOffsetPixels(Marker marker, MapboxMap mapboxMap, Icon icon) {
        Marker previousMarker;
        Marker marker2 = previousMarker = marker.getId() != -1L ? (Marker)mapboxMap.getAnnotation(marker.getId()) : null;
        if (previousMarker == null || previousMarker.getIcon() == null || previousMarker.getIcon() != marker.getIcon()) {
            marker.setTopOffsetPixels(this.getTopOffsetPixelsForIcon(icon));
        }
    }

    void iconCleanup(Icon icon) {
        int refCounter = this.iconMap.get(icon) - 1;
        if (refCounter == 0) {
            this.remove(icon);
        } else {
            this.updateIconRefCounter(icon, refCounter);
        }
    }

    private void remove(Icon icon) {
        this.nativeMapView.removeAnnotationIcon(icon.getId());
        this.iconMap.remove(icon);
    }

    private void updateIconRefCounter(Icon icon, int refCounter) {
        this.iconMap.put(icon, refCounter);
    }
}

