/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.content.Context;
import android.location.Location;
import android.support.annotation.Nullable;
import com.mapbox.services.android.telemetry.location.LocationEngine;
import com.mapbox.services.android.telemetry.location.LocationEngineListener;
import com.mapzen.android.lost.api.LocationListener;
import com.mapzen.android.lost.api.LocationRequest;
import com.mapzen.android.lost.api.LocationServices;
import com.mapzen.android.lost.api.LostApiClient;

@Deprecated
public class LocationSource
extends LocationEngine
implements LocationListener {
    private Context context;
    private LostApiClient lostApiClient;

    public LocationSource(Context context) {
        this.context = context.getApplicationContext();
        this.lostApiClient = new LostApiClient.Builder(this.context).build();
    }

    public LocationSource() {
    }

    public void activate() {
        if (!this.lostApiClient.isConnected()) {
            this.lostApiClient.connect();
        }
        for (LocationEngineListener listener : this.locationListeners) {
            listener.onConnected();
        }
    }

    public void deactivate() {
        if (this.lostApiClient.isConnected()) {
            this.lostApiClient.disconnect();
        }
    }

    public boolean isConnected() {
        return this.lostApiClient.isConnected();
    }

    @Nullable
    public Location getLastLocation() {
        if (this.lostApiClient.isConnected()) {
            return LocationServices.FusedLocationApi.getLastLocation();
        }
        return null;
    }

    public void requestLocationUpdates() {
        LocationRequest request = LocationRequest.create();
        if (this.interval != null) {
            request.setInterval((long)this.interval.intValue());
        }
        if (this.fastestInterval != null) {
            request.setFastestInterval((long)this.fastestInterval.intValue());
        }
        if (this.smallestDisplacement != null) {
            request.setSmallestDisplacement(this.smallestDisplacement.floatValue());
        }
        if (this.priority == 0) {
            request.setPriority(105);
        } else if (this.priority == 1) {
            request.setPriority(104);
        } else if (this.priority == 2) {
            request.setPriority(102);
        } else if (this.priority == 3) {
            request.setPriority(100);
        }
        if (this.lostApiClient.isConnected()) {
            LocationServices.FusedLocationApi.requestLocationUpdates(request, (LocationListener)this);
        }
    }

    public void removeLocationUpdates() {
        if (this.lostApiClient.isConnected()) {
            LocationServices.FusedLocationApi.removeLocationUpdates((LocationListener)this);
        }
    }

    public LocationEngine.Type obtainType() {
        return LocationEngine.Type.LOST;
    }

    public void onLocationChanged(Location location) {
        for (LocationEngineListener listener : this.locationListeners) {
            listener.onLocationChanged(location);
        }
    }
}

