/*
 * Decompiled with CFR 0.152.
 */
package com.almeros.android.multitouch.gesturedetectors;

import android.content.Context;
import android.graphics.PointF;
import android.view.MotionEvent;
import com.almeros.android.multitouch.gesturedetectors.BaseGestureDetector;

public class MoveGestureDetector
extends BaseGestureDetector {
    private static final PointF FOCUS_DELTA_ZERO = new PointF();
    private final OnMoveGestureListener listener;
    private PointF focusExternal = new PointF();
    private PointF focusDeltaExternal = new PointF();

    public MoveGestureDetector(Context context, OnMoveGestureListener listener) {
        super(context);
        this.listener = listener;
    }

    @Override
    protected void handleStartProgressEvent(int actionCode, MotionEvent event) {
        switch (actionCode) {
            case 0: {
                this.resetState();
                this.prevEvent = MotionEvent.obtain((MotionEvent)event);
                this.timeDelta = 0L;
                this.updateStateByEvent(event);
                break;
            }
            case 2: {
                this.gestureInProgress = this.listener.onMoveBegin(this);
            }
        }
    }

    @Override
    protected void handleInProgressEvent(int actionCode, MotionEvent event) {
        switch (actionCode) {
            case 1: 
            case 3: {
                this.listener.onMoveEnd(this);
                this.resetState();
                break;
            }
            case 2: {
                boolean updatePrevious;
                this.updateStateByEvent(event);
                if (!(this.currPressure / this.prevPressure > 0.67f) || !(updatePrevious = this.listener.onMove(this))) break;
                this.prevEvent.recycle();
                this.prevEvent = MotionEvent.obtain((MotionEvent)event);
            }
        }
    }

    @Override
    protected void updateStateByEvent(MotionEvent curr) {
        super.updateStateByEvent(curr);
        MotionEvent prev = this.prevEvent;
        PointF currFocusInternal = this.determineFocalPoint(curr);
        PointF prevFocusInternal = this.determineFocalPoint(prev);
        boolean skipNextMoveEvent = prev.getPointerCount() != curr.getPointerCount();
        this.focusDeltaExternal = skipNextMoveEvent ? FOCUS_DELTA_ZERO : new PointF(currFocusInternal.x - prevFocusInternal.x, currFocusInternal.y - prevFocusInternal.y);
        this.focusExternal.x += this.focusDeltaExternal.x;
        this.focusExternal.y += this.focusDeltaExternal.y;
    }

    private PointF determineFocalPoint(MotionEvent motionEvent) {
        int pCount = motionEvent.getPointerCount();
        float x = 0.0f;
        float y = 0.0f;
        for (int i = 0; i < pCount; ++i) {
            x += motionEvent.getX(i);
            y += motionEvent.getY(i);
        }
        return new PointF(x / (float)pCount, y / (float)pCount);
    }

    public float getFocusX() {
        return this.focusExternal.x;
    }

    public float getFocusY() {
        return this.focusExternal.y;
    }

    public PointF getFocusDelta() {
        return this.focusDeltaExternal;
    }

    public static class SimpleOnMoveGestureListener
    implements OnMoveGestureListener {
        @Override
        public boolean onMove(MoveGestureDetector detector) {
            return false;
        }

        @Override
        public boolean onMoveBegin(MoveGestureDetector detector) {
            return true;
        }

        @Override
        public void onMoveEnd(MoveGestureDetector detector) {
        }
    }

    public static interface OnMoveGestureListener {
        public boolean onMove(MoveGestureDetector var1);

        public boolean onMoveBegin(MoveGestureDetector var1);

        public void onMoveEnd(MoveGestureDetector var1);
    }
}

