/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.content.Context;
import android.location.Location;
import android.util.Log;
import com.mapbox.services.android.telemetry.location.LocationEngine;
import com.mapbox.services.android.telemetry.location.LocationEngineListener;
import com.mapbox.services.android.telemetry.permissions.PermissionsManager;
import com.mapzen.android.lost.api.LocationListener;
import com.mapzen.android.lost.api.LocationRequest;
import com.mapzen.android.lost.api.LocationServices;
import com.mapzen.android.lost.api.LostApiClient;
import java.lang.ref.WeakReference;

public class LocationSource
extends LocationEngine
implements LostApiClient.ConnectionCallbacks,
LocationListener {
    private static final String LOG_TAG = LocationSource.class.getSimpleName();
    private static LocationEngine instance;
    private WeakReference<Context> context;
    private LostApiClient lostApiClient;

    private LocationSource(Context context) {
        this.context = new WeakReference<Context>(context);
        this.lostApiClient = new LostApiClient.Builder((Context)this.context.get()).addConnectionCallbacks((LostApiClient.ConnectionCallbacks)this).build();
    }

    public static synchronized LocationEngine getLocationEngine(Context context) {
        if (instance == null) {
            instance = new LocationSource(context.getApplicationContext());
        }
        return instance;
    }

    public void activate() {
        if (this.lostApiClient != null && !this.lostApiClient.isConnected()) {
            this.lostApiClient.connect();
        }
    }

    public void deactivate() {
        if (this.lostApiClient != null && this.lostApiClient.isConnected()) {
            this.lostApiClient.disconnect();
        }
    }

    public boolean isConnected() {
        return this.lostApiClient.isConnected();
    }

    public void onConnected() {
        for (LocationEngineListener listener : this.locationListeners) {
            listener.onConnected();
        }
    }

    public void onConnectionSuspended() {
        Log.d((String)LOG_TAG, (String)"Connection suspended.");
    }

    public Location getLastLocation() {
        if (this.lostApiClient.isConnected() && PermissionsManager.areLocationPermissionsGranted((Context)((Context)this.context.get()))) {
            return LocationServices.FusedLocationApi.getLastLocation(this.lostApiClient);
        }
        return null;
    }

    public void requestLocationUpdates() {
        LocationRequest request = LocationRequest.create().setInterval(1000L).setFastestInterval(1000L).setSmallestDisplacement(3.0f);
        if (this.priority == 0) {
            request.setPriority(105);
        } else if (this.priority == 1) {
            request.setPriority(104);
        } else if (this.priority == 2) {
            request.setPriority(102);
        } else if (this.priority == 3) {
            request.setPriority(100);
        }
        if (this.lostApiClient.isConnected() && PermissionsManager.areLocationPermissionsGranted((Context)((Context)this.context.get()))) {
            LocationServices.FusedLocationApi.requestLocationUpdates(this.lostApiClient, request, (LocationListener)this);
        }
    }

    public void removeLocationUpdates() {
        if (this.lostApiClient.isConnected()) {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.lostApiClient, (LocationListener)this);
        }
    }

    public void onLocationChanged(Location location) {
        for (LocationEngineListener listener : this.locationListeners) {
            listener.onLocationChanged(location);
        }
    }
}

