/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.PointF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.annotations.MarkerViewManager;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.CameraChangeDispatcher;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import com.mapbox.mapboxsdk.maps.TrackingSettings;
import com.mapbox.mapboxsdk.maps.widgets.MyLocationView;
import timber.log.Timber;

final class Transform
implements MapView.OnMapChangedListener {
    private final NativeMapView mapView;
    private final MarkerViewManager markerViewManager;
    private final TrackingSettings trackingSettings;
    private final MyLocationView myLocationView;
    private CameraPosition cameraPosition;
    private MapboxMap.CancelableCallback cameraCancelableCallback;
    private MapboxMap.OnCameraChangeListener onCameraChangeListener;
    private CameraChangeDispatcher cameraChangeDispatcher;

    Transform(NativeMapView mapView, MarkerViewManager markerViewManager, TrackingSettings trackingSettings, CameraChangeDispatcher cameraChangeDispatcher) {
        this.mapView = mapView;
        this.markerViewManager = markerViewManager;
        this.trackingSettings = trackingSettings;
        this.myLocationView = trackingSettings.getMyLocationView();
        this.cameraChangeDispatcher = cameraChangeDispatcher;
    }

    void initialise(@NonNull MapboxMap mapboxMap, @NonNull MapboxMapOptions options) {
        CameraPosition position = options.getCamera();
        if (position != null && !position.equals(CameraPosition.DEFAULT)) {
            this.moveCamera(mapboxMap, CameraUpdateFactory.newCameraPosition(position), null);
        }
        this.setMinZoom(options.getMinZoomPreference());
        this.setMaxZoom(options.getMaxZoomPreference());
    }

    @UiThread
    public final CameraPosition getCameraPosition() {
        if (this.cameraPosition == null) {
            this.cameraPosition = this.invalidateCameraPosition();
        }
        return this.cameraPosition;
    }

    @UiThread
    void updateCameraPosition(@NonNull CameraPosition position) {
        if (this.myLocationView != null) {
            this.myLocationView.setCameraPosition(position);
        }
        this.markerViewManager.setTilt((float)position.tilt);
    }

    @Override
    public void onMapChanged(int change) {
        if (change == 4 && this.cameraCancelableCallback != null) {
            this.updateCameraPosition(this.invalidateCameraPosition());
            if (this.cameraCancelableCallback != null) {
                this.cameraCancelableCallback.onFinish();
                this.cameraCancelableCallback = null;
            }
            this.cameraChangeDispatcher.onCameraIdle();
            this.mapView.removeOnMapChangedListener(this);
        }
    }

    @UiThread
    final void moveCamera(MapboxMap mapboxMap, CameraUpdate update, MapboxMap.CancelableCallback callback) {
        CameraPosition cameraPosition = update.getCameraPosition(mapboxMap);
        if (!cameraPosition.equals(this.cameraPosition)) {
            this.trackingSettings.resetTrackingModesIfRequired(cameraPosition);
            this.cancelTransitions();
            this.cameraChangeDispatcher.onCameraMoveStarted(3);
            this.mapView.jumpTo(cameraPosition.bearing, cameraPosition.target, cameraPosition.tilt, cameraPosition.zoom);
            if (callback != null) {
                callback.onFinish();
            }
            this.cameraChangeDispatcher.onCameraIdle();
        }
    }

    @UiThread
    final void easeCamera(MapboxMap mapboxMap, CameraUpdate update, int durationMs, boolean easingInterpolator, MapboxMap.CancelableCallback callback) {
        CameraPosition cameraPosition = update.getCameraPosition(mapboxMap);
        if (!cameraPosition.equals(this.cameraPosition)) {
            this.trackingSettings.resetTrackingModesIfRequired(cameraPosition);
            this.cancelTransitions();
            this.cameraChangeDispatcher.onCameraMoveStarted(3);
            if (callback != null) {
                this.cameraCancelableCallback = callback;
                this.mapView.addOnMapChangedListener(this);
            }
            this.mapView.easeTo(cameraPosition.bearing, cameraPosition.target, durationMs, cameraPosition.tilt, cameraPosition.zoom, easingInterpolator);
        }
    }

    @UiThread
    final void animateCamera(MapboxMap mapboxMap, CameraUpdate update, int durationMs, MapboxMap.CancelableCallback callback) {
        CameraPosition cameraPosition = update.getCameraPosition(mapboxMap);
        if (!cameraPosition.equals(this.cameraPosition)) {
            this.trackingSettings.resetTrackingModesIfRequired(cameraPosition);
            this.cancelTransitions();
            this.cameraChangeDispatcher.onCameraMoveStarted(3);
            if (callback != null) {
                this.cameraCancelableCallback = callback;
                this.mapView.addOnMapChangedListener(this);
            }
            this.mapView.flyTo(cameraPosition.bearing, cameraPosition.target, durationMs, cameraPosition.tilt, cameraPosition.zoom);
        }
    }

    @UiThread
    @Nullable
    CameraPosition invalidateCameraPosition() {
        if (this.mapView != null) {
            CameraPosition cameraPosition = this.mapView.getCameraPosition();
            if (this.cameraPosition != null && !this.cameraPosition.equals(cameraPosition)) {
                this.cameraChangeDispatcher.onCameraMove();
            }
            this.cameraPosition = cameraPosition;
            if (this.onCameraChangeListener != null) {
                this.onCameraChangeListener.onCameraChange(this.cameraPosition);
            }
        }
        return this.cameraPosition;
    }

    void cancelTransitions() {
        this.cameraChangeDispatcher.onCameraMoveCanceled();
        if (this.cameraCancelableCallback != null) {
            this.cameraChangeDispatcher.onCameraIdle();
            this.cameraCancelableCallback.onCancel();
            this.cameraCancelableCallback = null;
        }
        this.mapView.cancelTransitions();
    }

    @UiThread
    void resetNorth() {
        this.cancelTransitions();
        this.mapView.resetNorth();
    }

    void setOnCameraChangeListener(@Nullable MapboxMap.OnCameraChangeListener listener) {
        this.onCameraChangeListener = listener;
    }

    double getZoom() {
        return this.cameraPosition.zoom;
    }

    void zoom(boolean zoomIn, @NonNull PointF focalPoint) {
        CameraPosition cameraPosition = this.invalidateCameraPosition();
        if (cameraPosition != null) {
            int newZoom = (int)Math.round(cameraPosition.zoom + (double)(zoomIn ? 1 : -1));
            this.setZoom(newZoom, focalPoint, 300L);
        }
    }

    void setZoom(double zoom, @NonNull PointF focalPoint) {
        this.setZoom(zoom, focalPoint, 0L);
    }

    void setZoom(double zoom, @NonNull PointF focalPoint, long duration) {
        this.mapView.addOnMapChangedListener(new MapView.OnMapChangedListener(){

            @Override
            public void onMapChanged(int change) {
                if (change == 4) {
                    Transform.this.mapView.removeOnMapChangedListener(this);
                    Transform.this.cameraChangeDispatcher.onCameraIdle();
                }
            }
        });
        this.mapView.setZoom(zoom, focalPoint, duration);
    }

    double getBearing() {
        double direction;
        for (direction = -this.mapView.getBearing(); direction > 360.0; direction -= 360.0) {
        }
        while (direction < 0.0) {
            direction += 360.0;
        }
        return direction;
    }

    double getRawBearing() {
        return this.mapView.getBearing();
    }

    void setBearing(double bearing) {
        if (this.myLocationView != null) {
            this.myLocationView.setBearing(bearing);
        }
        this.mapView.setBearing(bearing);
    }

    void setBearing(double bearing, float focalX, float focalY) {
        if (this.myLocationView != null) {
            this.myLocationView.setBearing(bearing);
        }
        this.mapView.setBearing(bearing, focalX, focalY);
    }

    void setBearing(double bearing, float focalX, float focalY, long duration) {
        if (this.myLocationView != null) {
            this.myLocationView.setBearing(bearing);
        }
        this.mapView.setBearing(bearing, focalX, focalY, duration);
    }

    LatLng getLatLng() {
        return this.mapView.getLatLng();
    }

    double getTilt() {
        return this.mapView.getPitch();
    }

    void setTilt(Double pitch) {
        if (this.myLocationView != null) {
            this.myLocationView.setTilt(pitch);
        }
        this.markerViewManager.setTilt(pitch.floatValue());
        this.mapView.setPitch(pitch, 0L);
    }

    LatLng getCenterCoordinate() {
        return this.mapView.getLatLng();
    }

    void setCenterCoordinate(LatLng centerCoordinate) {
        this.mapView.setLatLng(centerCoordinate);
    }

    void setGestureInProgress(boolean gestureInProgress) {
        this.mapView.setGestureInProgress(gestureInProgress);
        if (!gestureInProgress) {
            this.invalidateCameraPosition();
        }
    }

    void zoomBy(double z, float x, float y) {
        this.mapView.setZoom(this.mapView.getZoom() + z, new PointF(x, y), 0L);
    }

    void moveBy(double offsetX, double offsetY, long duration) {
        if (duration > 0L) {
            this.mapView.addOnMapChangedListener(new MapView.OnMapChangedListener(){

                @Override
                public void onMapChanged(int change) {
                    if (change == 13) {
                        Transform.this.mapView.removeOnMapChangedListener(this);
                        Transform.this.cameraChangeDispatcher.onCameraIdle();
                    }
                }
            });
        }
        this.mapView.moveBy(offsetX, offsetY, duration);
    }

    void setMinZoom(double minZoom) {
        if (minZoom < 0.0 || minZoom > 20.0) {
            Timber.e((String)("Not setting minZoomPreference, value is in unsupported range: " + minZoom), (Object[])new Object[0]);
            return;
        }
        this.mapView.setMinZoom(minZoom);
    }

    double getMinZoom() {
        return this.mapView.getMinZoom();
    }

    void setMaxZoom(double maxZoom) {
        if (maxZoom < 0.0 || maxZoom > 20.0) {
            Timber.e((String)("Not setting maxZoomPreference, value is in unsupported range: " + maxZoom), (Object[])new Object[0]);
            return;
        }
        this.mapView.setMaxZoom(maxZoom);
    }

    double getMaxZoom() {
        return this.mapView.getMaxZoom();
    }
}

