/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.PointF;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.LongSparseArray;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.BaseMarkerOptions;
import com.mapbox.mapboxsdk.annotations.BaseMarkerViewOptions;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerView;
import com.mapbox.mapboxsdk.annotations.MarkerViewManager;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.PolygonOptions;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.annotations.PolylineOptions;
import com.mapbox.mapboxsdk.maps.IconManager;
import com.mapbox.mapboxsdk.maps.InfoWindowManager;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import timber.log.Timber;

class AnnotationManager {
    private final NativeMapView nativeMapView;
    private final MapView mapView;
    private final IconManager iconManager;
    private final InfoWindowManager infoWindowManager = new InfoWindowManager();
    private final MarkerViewManager markerViewManager;
    private final LongSparseArray<Annotation> annotations = new LongSparseArray();
    private final List<Marker> selectedMarkers = new ArrayList<Marker>();
    private MapboxMap mapboxMap;
    private MapboxMap.OnMarkerClickListener onMarkerClickListener;

    AnnotationManager(NativeMapView view, MapView mapView, MarkerViewManager markerViewManager) {
        this.nativeMapView = view;
        this.mapView = mapView;
        this.iconManager = new IconManager(this.nativeMapView);
        this.markerViewManager = markerViewManager;
        if (view != null) {
            this.nativeMapView.addOnMapChangedListener(markerViewManager);
        }
    }

    AnnotationManager bind(MapboxMap mapboxMap) {
        this.mapboxMap = mapboxMap;
        this.markerViewManager.bind(mapboxMap);
        return this;
    }

    void update() {
        this.markerViewManager.update();
        this.infoWindowManager.update();
    }

    Annotation getAnnotation(long id2) {
        return (Annotation)this.annotations.get(id2);
    }

    List<Annotation> getAnnotations() {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            annotations.add((Annotation)this.annotations.get(this.annotations.keyAt(i)));
        }
        return annotations;
    }

    void removeAnnotation(@NonNull Annotation annotation) {
        if (annotation instanceof Marker) {
            Marker marker = (Marker)annotation;
            marker.hideInfoWindow();
            if (marker instanceof MarkerView) {
                this.markerViewManager.removeMarkerView((MarkerView)marker);
            }
        }
        long id2 = annotation.getId();
        if (this.nativeMapView != null) {
            this.nativeMapView.removeAnnotation(id2);
        }
        this.annotations.remove(id2);
    }

    void removeAnnotation(long id2) {
        if (this.nativeMapView != null) {
            this.nativeMapView.removeAnnotation(id2);
        }
        this.annotations.remove(id2);
    }

    void removeAnnotations(@NonNull List<? extends Annotation> annotationList) {
        int count = annotationList.size();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            Annotation annotation = annotationList.get(i);
            if (annotation instanceof Marker) {
                Marker marker = (Marker)annotation;
                marker.hideInfoWindow();
                if (marker instanceof MarkerView) {
                    this.markerViewManager.removeMarkerView((MarkerView)marker);
                }
            }
            ids[i] = annotationList.get(i).getId();
        }
        if (this.nativeMapView != null) {
            this.nativeMapView.removeAnnotations(ids);
        }
        for (long id2 : ids) {
            this.annotations.remove(id2);
        }
    }

    void removeAnnotations() {
        int count = this.annotations.size();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = this.annotations.keyAt(i);
            Annotation annotation = (Annotation)this.annotations.get(ids[i]);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            marker.hideInfoWindow();
            if (!(marker instanceof MarkerView)) continue;
            this.markerViewManager.removeMarkerView((MarkerView)marker);
        }
        if (this.nativeMapView != null) {
            this.nativeMapView.removeAnnotations(ids);
        }
        this.annotations.clear();
    }

    Marker addMarker(@NonNull BaseMarkerOptions markerOptions, @NonNull MapboxMap mapboxMap) {
        Marker marker = this.prepareMarker(markerOptions);
        long id2 = this.nativeMapView != null ? this.nativeMapView.addMarker(marker) : 0L;
        marker.setMapboxMap(mapboxMap);
        marker.setId(id2);
        this.annotations.put(id2, (Object)marker);
        return marker;
    }

    List<Marker> addMarkers(@NonNull List<? extends BaseMarkerOptions> markerOptionsList, @NonNull MapboxMap mapboxMap) {
        int count = markerOptionsList.size();
        ArrayList<Marker> markers = new ArrayList<Marker>(count);
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                BaseMarkerOptions markerOptions = markerOptionsList.get(i);
                Marker marker = this.prepareMarker(markerOptions);
                markers.add(marker);
            }
            if (markers.size() > 0) {
                long[] ids = null;
                if (this.nativeMapView != null) {
                    ids = this.nativeMapView.addMarkers(markers);
                }
                long id2 = 0L;
                for (int i = 0; i < markers.size(); ++i) {
                    Marker m = (Marker)markers.get(i);
                    m.setMapboxMap(mapboxMap);
                    id2 = ids != null ? ids[i] : ++id2;
                    m.setId(id2);
                    this.annotations.put(id2, (Object)m);
                }
            }
        }
        return markers;
    }

    private Marker prepareMarker(BaseMarkerOptions markerOptions) {
        Object marker = markerOptions.getMarker();
        Icon icon = this.iconManager.loadIconForMarker((Marker)marker);
        ((Marker)marker).setTopOffsetPixels(this.iconManager.getTopOffsetPixelsForIcon(icon));
        return marker;
    }

    MarkerView addMarker(@NonNull BaseMarkerViewOptions markerOptions, @NonNull MapboxMap mapboxMap, @Nullable MarkerViewManager.OnMarkerViewAddedListener onMarkerViewAddedListener) {
        MarkerView marker = this.prepareViewMarker(markerOptions);
        marker.setMapboxMap(mapboxMap);
        long id2 = this.nativeMapView.addMarker(marker);
        marker.setId(id2);
        this.annotations.put(id2, (Object)marker);
        if (onMarkerViewAddedListener != null) {
            this.markerViewManager.addOnMarkerViewAddedListener(marker, onMarkerViewAddedListener);
        }
        this.markerViewManager.setEnabled(true);
        this.markerViewManager.setWaitingForRenderInvoke(true);
        return marker;
    }

    List<MarkerView> addMarkerViews(@NonNull List<? extends BaseMarkerViewOptions> markerViewOptions, @NonNull MapboxMap mapboxMap) {
        ArrayList<MarkerView> markers = new ArrayList<MarkerView>();
        for (BaseMarkerViewOptions baseMarkerViewOptions : markerViewOptions) {
            if (markerViewOptions.indexOf(baseMarkerViewOptions) == markerViewOptions.size() - 1) {
                this.markerViewManager.setWaitingForRenderInvoke(true);
            }
            MarkerView marker = this.prepareViewMarker(baseMarkerViewOptions);
            marker.setMapboxMap(mapboxMap);
            long id2 = this.nativeMapView.addMarker(marker);
            marker.setId(id2);
            this.annotations.put(id2, (Object)marker);
            markers.add(marker);
        }
        this.markerViewManager.setEnabled(true);
        this.markerViewManager.update();
        return markers;
    }

    private MarkerView prepareViewMarker(BaseMarkerViewOptions markerViewOptions) {
        Object marker = markerViewOptions.getMarker();
        this.iconManager.loadIconForMarkerView((MarkerView)marker);
        return marker;
    }

    void updateMarker(@NonNull Marker updatedMarker) {
        if (!this.isAddedToMap(updatedMarker)) {
            Timber.w((String)"Attempting to update non-added Marker with value %s", (Object[])new Object[]{updatedMarker});
            return;
        }
        this.ensureIconLoaded(updatedMarker);
        this.nativeMapView.updateMarker(updatedMarker);
        this.annotations.setValueAt(this.annotations.indexOfKey(updatedMarker.getId()), (Object)updatedMarker);
    }

    private boolean isAddedToMap(Annotation annotation) {
        return annotation != null && annotation.getId() != -1L && this.annotations.indexOfKey(annotation.getId()) != -1;
    }

    private void ensureIconLoaded(Marker marker) {
        if (!(marker instanceof MarkerView)) {
            this.iconManager.ensureIconLoaded(marker, this.mapboxMap);
        }
    }

    List<Marker> getMarkers() {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Annotation annotation = (Annotation)this.annotations.get(this.annotations.keyAt(i));
            if (!(annotation instanceof Marker)) continue;
            markers.add((Marker)annotation);
        }
        return markers;
    }

    void setOnMarkerClickListener(@Nullable MapboxMap.OnMarkerClickListener listener) {
        this.onMarkerClickListener = listener;
    }

    void selectMarker(@NonNull Marker marker) {
        if (this.selectedMarkers.contains(marker)) {
            return;
        }
        if (!this.infoWindowManager.isAllowConcurrentMultipleOpenInfoWindows()) {
            this.deselectMarkers();
        }
        if (marker instanceof MarkerView) {
            this.markerViewManager.select((MarkerView)marker, false);
            this.markerViewManager.ensureInfoWindowOffset((MarkerView)marker);
        }
        if (this.infoWindowManager.isInfoWindowValidForMarker(marker) || this.infoWindowManager.getInfoWindowAdapter() != null) {
            this.infoWindowManager.add(marker.showInfoWindow(this.mapboxMap, this.mapView));
        }
        this.selectedMarkers.add(marker);
    }

    void deselectMarkers() {
        if (this.selectedMarkers.isEmpty()) {
            return;
        }
        for (Marker marker : this.selectedMarkers) {
            if (marker.isInfoWindowShown()) {
                marker.hideInfoWindow();
            }
            if (!(marker instanceof MarkerView)) continue;
            this.markerViewManager.deselect((MarkerView)marker, false);
        }
        this.selectedMarkers.clear();
    }

    void deselectMarker(@NonNull Marker marker) {
        if (!this.selectedMarkers.contains(marker)) {
            return;
        }
        if (marker.isInfoWindowShown()) {
            marker.hideInfoWindow();
        }
        if (marker instanceof MarkerView) {
            this.markerViewManager.deselect((MarkerView)marker, false);
        }
        this.selectedMarkers.remove(marker);
    }

    List<Marker> getSelectedMarkers() {
        return this.selectedMarkers;
    }

    @NonNull
    List<Marker> getMarkersInRect(@NonNull RectF rectangle) {
        float pixelRatio = this.nativeMapView.getPixelRatio();
        RectF rect = new RectF(rectangle.left / pixelRatio, rectangle.top / pixelRatio, rectangle.right / pixelRatio, rectangle.bottom / pixelRatio);
        long[] ids = this.nativeMapView.queryPointAnnotations(rect);
        ArrayList<Long> idsList = new ArrayList<Long>(ids.length);
        for (long id2 : ids) {
            idsList.add(id2);
        }
        ArrayList<Marker> annotations = new ArrayList<Marker>(ids.length);
        List<Annotation> annotationList = this.getAnnotations();
        int count = annotationList.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = annotationList.get(i);
            if (!(annotation instanceof Marker) || !idsList.contains(annotation.getId())) continue;
            annotations.add((Marker)annotation);
        }
        return new ArrayList<Marker>(annotations);
    }

    List<MarkerView> getMarkerViewsInRect(@NonNull RectF rectangle) {
        float pixelRatio = this.nativeMapView.getPixelRatio();
        RectF rect = new RectF(rectangle.left / pixelRatio, rectangle.top / pixelRatio, rectangle.right / pixelRatio, rectangle.bottom / pixelRatio);
        long[] ids = this.nativeMapView.queryPointAnnotations(rect);
        ArrayList<Long> idsList = new ArrayList<Long>(ids.length);
        for (long id2 : ids) {
            idsList.add(id2);
        }
        ArrayList<MarkerView> annotations = new ArrayList<MarkerView>(ids.length);
        List<Annotation> annotationList = this.getAnnotations();
        int count = annotationList.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = annotationList.get(i);
            if (!(annotation instanceof MarkerView) || !idsList.contains(annotation.getId())) continue;
            annotations.add((MarkerView)annotation);
        }
        return new ArrayList<MarkerView>(annotations);
    }

    Polygon addPolygon(@NonNull PolygonOptions polygonOptions, @NonNull MapboxMap mapboxMap) {
        Polygon polygon = polygonOptions.getPolygon();
        if (!polygon.getPoints().isEmpty()) {
            long id2 = this.nativeMapView != null ? this.nativeMapView.addPolygon(polygon) : 0L;
            polygon.setId(id2);
            polygon.setMapboxMap(mapboxMap);
            this.annotations.put(id2, (Object)polygon);
        }
        return polygon;
    }

    List<Polygon> addPolygons(@NonNull List<PolygonOptions> polygonOptionsList, @NonNull MapboxMap mapboxMap) {
        int count = polygonOptionsList.size();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(count);
        if (count > 0) {
            Polygon polygon;
            for (PolygonOptions polygonOptions : polygonOptionsList) {
                polygon = polygonOptions.getPolygon();
                if (polygon.getPoints().isEmpty()) continue;
                polygons.add(polygon);
            }
            long[] ids = null;
            if (this.nativeMapView != null) {
                ids = this.nativeMapView.addPolygons(polygons);
            }
            long id2 = 0L;
            for (int i = 0; i < polygons.size(); ++i) {
                polygon = (Polygon)polygons.get(i);
                polygon.setMapboxMap(mapboxMap);
                id2 = ids != null ? ids[i] : ++id2;
                polygon.setId(id2);
                this.annotations.put(id2, (Object)polygon);
            }
        }
        return polygons;
    }

    void updatePolygon(@NonNull Polygon polygon) {
        if (!this.isAddedToMap(polygon)) {
            Timber.w((String)"Attempting to update non-added Polygon with value %s", (Object[])new Object[]{polygon});
            return;
        }
        this.nativeMapView.updatePolygon(polygon);
        this.annotations.setValueAt(this.annotations.indexOfKey(polygon.getId()), (Object)polygon);
    }

    List<Polygon> getPolygons() {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Annotation annotation = (Annotation)this.annotations.get(this.annotations.keyAt(i));
            if (!(annotation instanceof Polygon)) continue;
            polygons.add((Polygon)annotation);
        }
        return polygons;
    }

    Polyline addPolyline(@NonNull PolylineOptions polylineOptions, @NonNull MapboxMap mapboxMap) {
        Polyline polyline = polylineOptions.getPolyline();
        if (!polyline.getPoints().isEmpty()) {
            long id2 = this.nativeMapView != null ? this.nativeMapView.addPolyline(polyline) : 0L;
            polyline.setMapboxMap(mapboxMap);
            polyline.setId(id2);
            this.annotations.put(id2, (Object)polyline);
        }
        return polyline;
    }

    List<Polyline> addPolylines(@NonNull List<PolylineOptions> polylineOptionsList, @NonNull MapboxMap mapboxMap) {
        int count = polylineOptionsList.size();
        ArrayList<Polyline> polylines = new ArrayList<Polyline>(count);
        if (count > 0) {
            for (PolylineOptions options : polylineOptionsList) {
                Polyline polyline = options.getPolyline();
                if (polyline.getPoints().isEmpty()) continue;
                polylines.add(polyline);
            }
            long[] ids = null;
            if (this.nativeMapView != null) {
                ids = this.nativeMapView.addPolylines(polylines);
            }
            long id2 = 0L;
            for (int i = 0; i < polylines.size(); ++i) {
                Polyline p = (Polyline)polylines.get(i);
                p.setMapboxMap(mapboxMap);
                id2 = ids != null ? ids[i] : ++id2;
                p.setId(id2);
                this.annotations.put(id2, (Object)p);
            }
        }
        return polylines;
    }

    void updatePolyline(@NonNull Polyline polyline) {
        if (!this.isAddedToMap(polyline)) {
            Timber.w((String)"Attempting to update non-added Polyline with value %s", (Object[])new Object[]{polyline});
        }
        this.nativeMapView.updatePolyline(polyline);
        this.annotations.setValueAt(this.annotations.indexOfKey(polyline.getId()), (Object)polyline);
    }

    List<Polyline> getPolylines() {
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Annotation annotation = (Annotation)this.annotations.get(this.annotations.keyAt(i));
            if (!(annotation instanceof Polyline)) continue;
            polylines.add((Polyline)annotation);
        }
        return polylines;
    }

    InfoWindowManager getInfoWindowManager() {
        return this.infoWindowManager;
    }

    MarkerViewManager getMarkerViewManager() {
        return this.markerViewManager;
    }

    void adjustTopOffsetPixels(MapboxMap mapboxMap) {
        int count = this.annotations.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = (Annotation)this.annotations.get((long)i);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            marker.setTopOffsetPixels(this.iconManager.getTopOffsetPixelsForIcon(marker.getIcon()));
        }
        for (Marker marker : this.selectedMarkers) {
            if (!marker.isInfoWindowShown()) continue;
            marker.hideInfoWindow();
            marker.showInfoWindow(mapboxMap, this.mapView);
        }
    }

    void reloadMarkers() {
        this.iconManager.reloadIcons();
        int count = this.annotations.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = (Annotation)this.annotations.get((long)i);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            this.nativeMapView.removeAnnotation(annotation.getId());
            long newId = this.nativeMapView.addMarker(marker);
            marker.setId(newId);
        }
    }

    boolean onTap(PointF tapPoint, float screenDensity) {
        block12: {
            List<Marker> nearbyMarkers;
            boolean handledDefaultClick;
            block11: {
                float toleranceSides = 4.0f * screenDensity;
                float toleranceTopBottom = 10.0f * screenDensity;
                handledDefaultClick = false;
                RectF tapRect = new RectF(tapPoint.x - (float)(this.iconManager.getAverageIconWidth() / 2) - toleranceSides, tapPoint.y - (float)(this.iconManager.getAverageIconHeight() / 2) - toleranceTopBottom, tapPoint.x + (float)(this.iconManager.getAverageIconWidth() / 2) + toleranceSides, tapPoint.y + (float)(this.iconManager.getAverageIconHeight() / 2) + toleranceTopBottom);
                nearbyMarkers = this.getMarkersInRect(tapRect);
                long newSelectedMarkerId = -1L;
                if (nearbyMarkers.size() > 0) {
                    Collections.sort(nearbyMarkers);
                    for (Marker nearbyMarker : nearbyMarkers) {
                        boolean found = false;
                        for (Marker selectedMarker : this.selectedMarkers) {
                            if (!selectedMarker.equals(nearbyMarker)) continue;
                            found = true;
                        }
                        if (found) continue;
                        newSelectedMarkerId = nearbyMarker.getId();
                        break;
                    }
                }
                if (newSelectedMarkerId < 0L) break block11;
                List<Annotation> annotations = this.getAnnotations();
                int count = annotations.size();
                for (int i = 0; i < count; ++i) {
                    Annotation annotation = annotations.get(i);
                    if (!(annotation instanceof Marker) || annotation.getId() != newSelectedMarkerId) continue;
                    Marker marker = (Marker)annotation;
                    if (marker instanceof MarkerView) {
                        handledDefaultClick = this.markerViewManager.onClickMarkerView((MarkerView)marker);
                    } else if (this.onMarkerClickListener != null) {
                        handledDefaultClick = this.onMarkerClickListener.onMarkerClick(marker);
                    }
                    if (!handledDefaultClick) {
                        this.selectMarker(marker);
                    }
                    return true;
                }
                break block12;
            }
            if (nearbyMarkers.size() <= 0) break block12;
            for (Marker nearbyMarker : nearbyMarkers) {
                for (Marker selectedMarker : this.selectedMarkers) {
                    if (!nearbyMarker.equals(selectedMarker)) continue;
                    if (this.onMarkerClickListener != null && !(handledDefaultClick = this.onMarkerClickListener.onMarkerClick(nearbyMarker))) {
                        this.deselectMarker(nearbyMarker);
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

