/*
 * Decompiled with CFR 0.152.
 */
package com.almeros.android.multitouch.gesturedetectors;

import android.content.Context;
import android.graphics.PointF;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import com.almeros.android.multitouch.gesturedetectors.BaseGestureDetector;

public abstract class TwoFingerGestureDetector
extends BaseGestureDetector {
    private final float edgeSlop;
    protected float prevFingerDiffX;
    protected float prevFingerDiffY;
    protected float currFingerDiffX;
    protected float currFingerDiffY;
    private float currLen;
    private float prevLen;
    private PointF focus;

    public TwoFingerGestureDetector(Context context) {
        super(context);
        ViewConfiguration config = ViewConfiguration.get((Context)context);
        this.edgeSlop = config.getScaledEdgeSlop() / 2;
    }

    @Override
    protected abstract void handleStartProgressEvent(int var1, MotionEvent var2);

    @Override
    protected abstract void handleInProgressEvent(int var1, MotionEvent var2);

    @Override
    protected void updateStateByEvent(MotionEvent curr) {
        super.updateStateByEvent(curr);
        MotionEvent prev = this.prevEvent;
        this.currLen = -1.0f;
        this.prevLen = -1.0f;
        float px0 = prev.getX(0);
        float py0 = prev.getY(0);
        float px1 = prev.getX(1);
        float py1 = prev.getY(1);
        float pvx = px1 - px0;
        float pvy = py1 - py0;
        this.prevFingerDiffX = pvx;
        this.prevFingerDiffY = pvy;
        float cx0 = curr.getX(0);
        float cy0 = curr.getY(0);
        float cx1 = curr.getX(1);
        float cy1 = curr.getY(1);
        float cvx = cx1 - cx0;
        float cvy = cy1 - cy0;
        this.currFingerDiffX = cvx;
        this.currFingerDiffY = cvy;
        this.focus = TwoFingerGestureDetector.determineFocalPoint(curr);
    }

    public float getCurrentSpan() {
        if (this.currLen == -1.0f) {
            float cvx = this.currFingerDiffX;
            float cvy = this.currFingerDiffY;
            this.currLen = (float)Math.sqrt(cvx * cvx + cvy * cvy);
        }
        return this.currLen;
    }

    public float getPreviousSpan() {
        if (this.prevLen == -1.0f) {
            float pvx = this.prevFingerDiffX;
            float pvy = this.prevFingerDiffY;
            this.prevLen = (float)Math.sqrt(pvx * pvx + pvy * pvy);
        }
        return this.prevLen;
    }

    protected static float getRawX(MotionEvent event, int pointerIndex) {
        float offset = event.getRawX() - event.getX();
        if (pointerIndex < event.getPointerCount()) {
            return event.getX(pointerIndex) + offset;
        }
        return 0.0f;
    }

    protected static float getRawY(MotionEvent event, int pointerIndex) {
        float offset = event.getRawY() - event.getY();
        if (pointerIndex < event.getPointerCount()) {
            return event.getY(pointerIndex) + offset;
        }
        return 0.0f;
    }

    protected boolean isSloppyGesture(MotionEvent event) {
        boolean p1sloppy;
        DisplayMetrics metrics = this.context.getResources().getDisplayMetrics();
        float rightSlopEdge = (float)metrics.widthPixels - this.edgeSlop;
        float bottomSlopEdge = (float)metrics.heightPixels - this.edgeSlop;
        float edgeSlop = this.edgeSlop;
        float x0 = event.getRawX();
        float y0 = event.getRawY();
        float x1 = TwoFingerGestureDetector.getRawX(event, 1);
        float y1 = TwoFingerGestureDetector.getRawY(event, 1);
        boolean p0sloppy = x0 < edgeSlop || y0 < edgeSlop || x0 > rightSlopEdge || y0 > bottomSlopEdge;
        boolean bl = p1sloppy = x1 < edgeSlop || y1 < edgeSlop || x1 > rightSlopEdge || y1 > bottomSlopEdge;
        if (p0sloppy && p1sloppy) {
            return true;
        }
        if (p0sloppy) {
            return true;
        }
        return p1sloppy;
    }

    public static PointF determineFocalPoint(MotionEvent motionEvent) {
        int pCount = motionEvent.getPointerCount();
        float x = 0.0f;
        float y = 0.0f;
        for (int i = 0; i < pCount; ++i) {
            x += motionEvent.getX(i);
            y += motionEvent.getY(i);
        }
        return new PointF(x / (float)pCount, y / (float)pCount);
    }

    public float getFocusX() {
        return this.focus.x;
    }

    public float getFocusY() {
        return this.focus.y;
    }
}

