/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.functions;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.mapboxsdk.style.functions.Function;
import com.mapbox.mapboxsdk.style.functions.stops.CategoricalStops;
import com.mapbox.mapboxsdk.style.functions.stops.ExponentialStops;
import com.mapbox.mapboxsdk.style.functions.stops.IntervalStops;
import com.mapbox.mapboxsdk.style.functions.stops.Stop;
import com.mapbox.mapboxsdk.style.functions.stops.Stops;
import java.util.Map;

public class CompositeFunction<Z extends Number, I, O>
extends Function<Stop.CompositeValue<Z, I>, O> {
    private final String property;
    private O defaultValue;

    CompositeFunction(@NonNull String property, @NonNull CategoricalStops<Stop.CompositeValue<Z, I>, O> stops) {
        this(null, property, stops);
    }

    CompositeFunction(@NonNull String property, @NonNull ExponentialStops<Stop.CompositeValue<Z, I>, O> stops) {
        this(null, property, stops);
    }

    CompositeFunction(@NonNull String property, @NonNull IntervalStops<Stop.CompositeValue<Z, I>, O> stops) {
        this(null, property, stops);
    }

    private CompositeFunction(@Nullable O defaultValue, @NonNull String property, @NonNull Stops<Stop.CompositeValue<Z, I>, O> stops) {
        super(stops);
        this.defaultValue = defaultValue;
        this.property = property;
    }

    public CompositeFunction<Z, I, O> withDefaultValue(O defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Nullable
    public O getDefaultValue() {
        return this.defaultValue;
    }

    public String getProperty() {
        return this.property;
    }

    @Override
    public Map<String, Object> toValueObject() {
        Map<String, Object> valueObject = super.toValueObject();
        valueObject.put("property", this.property);
        if (this.defaultValue != null) {
            valueObject.put("default", this.defaultValue);
        }
        return valueObject;
    }
}

