/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.os.Handler;
import android.support.annotation.NonNull;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import com.mapbox.mapboxsdk.maps.TrackingSettings;
import com.mapbox.mapboxsdk.maps.Transform;
import com.mapbox.mapboxsdk.maps.UiSettings;

final class MapKeyListener {
    private final TrackingSettings trackingSettings;
    private final Transform transform;
    private final UiSettings uiSettings;
    private TrackballLongPressTimeOut currentTrackballLongPressTimeOut;

    MapKeyListener(@NonNull Transform transform, @NonNull TrackingSettings trackingSettings, @NonNull UiSettings uiSettings) {
        this.transform = transform;
        this.trackingSettings = trackingSettings;
        this.uiSettings = uiSettings;
    }

    boolean onKeyDown(int keyCode, @NonNull KeyEvent event) {
        double scrollDist = event.getRepeatCount() >= 5 ? 50.0 : 10.0;
        switch (keyCode) {
            case 23: 
            case 66: {
                event.startTracking();
                return true;
            }
            case 21: {
                if (!this.trackingSettings.isScrollGestureCurrentlyEnabled()) {
                    return false;
                }
                this.transform.cancelTransitions();
                this.transform.moveBy(scrollDist, 0.0, 0L);
                return true;
            }
            case 22: {
                if (!this.trackingSettings.isScrollGestureCurrentlyEnabled()) {
                    return false;
                }
                this.transform.cancelTransitions();
                this.transform.moveBy(-scrollDist, 0.0, 0L);
                return true;
            }
            case 19: {
                if (!this.trackingSettings.isScrollGestureCurrentlyEnabled()) {
                    return false;
                }
                this.transform.cancelTransitions();
                this.transform.moveBy(0.0, scrollDist, 0L);
                return true;
            }
            case 20: {
                if (!this.trackingSettings.isScrollGestureCurrentlyEnabled()) {
                    return false;
                }
                this.transform.cancelTransitions();
                this.transform.moveBy(0.0, -scrollDist, 0L);
                return true;
            }
        }
        return false;
    }

    boolean onKeyLongPress(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 23: 
            case 66: {
                if (!this.uiSettings.isZoomGesturesEnabled()) {
                    return false;
                }
                this.transform.zoom(false, this.uiSettings.getWidth() / 2.0f, this.uiSettings.getHeight() / 2.0f);
                return true;
            }
        }
        return false;
    }

    boolean onKeyUp(int keyCode, KeyEvent event) {
        if (event.isCanceled()) {
            return false;
        }
        switch (keyCode) {
            case 23: 
            case 66: {
                if (!this.uiSettings.isZoomGesturesEnabled()) {
                    return false;
                }
                this.transform.zoom(true, this.uiSettings.getWidth() / 2.0f, this.uiSettings.getHeight() / 2.0f);
                return true;
            }
        }
        return false;
    }

    boolean onTrackballEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 2: {
                if (!this.trackingSettings.isScrollGestureCurrentlyEnabled()) {
                    return false;
                }
                this.transform.cancelTransitions();
                this.transform.moveBy(-10.0 * (double)event.getX(), -10.0 * (double)event.getY(), 0L);
                return true;
            }
            case 0: {
                if (this.currentTrackballLongPressTimeOut != null) {
                    this.currentTrackballLongPressTimeOut.cancel();
                    this.currentTrackballLongPressTimeOut = null;
                }
                this.currentTrackballLongPressTimeOut = new TrackballLongPressTimeOut();
                new Handler().postDelayed((Runnable)this.currentTrackballLongPressTimeOut, (long)ViewConfiguration.getLongPressTimeout());
                return true;
            }
            case 1: {
                if (!this.uiSettings.isZoomGesturesEnabled()) {
                    return false;
                }
                if (this.currentTrackballLongPressTimeOut != null) {
                    this.transform.zoom(true, this.uiSettings.getWidth() / 2.0f, this.uiSettings.getHeight() / 2.0f);
                }
                return true;
            }
            case 3: {
                if (this.currentTrackballLongPressTimeOut != null) {
                    this.currentTrackballLongPressTimeOut.cancel();
                    this.currentTrackballLongPressTimeOut = null;
                }
                return true;
            }
        }
        return false;
    }

    private class TrackballLongPressTimeOut
    implements Runnable {
        private boolean cancelled = false;

        TrackballLongPressTimeOut() {
        }

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                MapKeyListener.this.transform.zoom(false, MapKeyListener.this.uiSettings.getWidth() / 2.0f, MapKeyListener.this.uiSettings.getHeight() / 2.0f);
                MapKeyListener.this.currentTrackballLongPressTimeOut = null;
            }
        }
    }
}

