/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class BackgroundLayer
extends Layer {
    public BackgroundLayer(long nativePtr) {
        super(nativePtr);
    }

    public BackgroundLayer(String layerId) {
        this.initialize(layerId);
    }

    protected native void initialize(String var1);

    public BackgroundLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<String> getBackgroundColor() {
        return new PropertyValue<Object>("background-color", this.nativeGetBackgroundColor());
    }

    @ColorInt
    public int getBackgroundColorAsInt() {
        PropertyValue<String> value = this.getBackgroundColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("background-color was set as a Function");
    }

    public PropertyValue<String> getBackgroundPattern() {
        return new PropertyValue<Object>("background-pattern", this.nativeGetBackgroundPattern());
    }

    public PropertyValue<Float> getBackgroundOpacity() {
        return new PropertyValue<Object>("background-opacity", this.nativeGetBackgroundOpacity());
    }

    private native Object nativeGetBackgroundColor();

    private native Object nativeGetBackgroundPattern();

    private native Object nativeGetBackgroundOpacity();

    @Override
    protected native void finalize() throws Throwable;
}

