/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.functions;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.mapboxsdk.style.functions.Function;
import com.mapbox.mapboxsdk.style.functions.stops.Stops;
import java.util.Map;

public class SourceFunction<I, O>
extends Function<I, O> {
    private final String property;
    private O defaultValue;

    SourceFunction(@NonNull String property, @NonNull Stops<I, O> stops) {
        this(null, property, stops);
    }

    private SourceFunction(@Nullable O defaultValue, @NonNull String property, @NonNull Stops<I, O> stops) {
        super(stops);
        this.property = property;
        this.defaultValue = defaultValue;
    }

    public String getProperty() {
        return this.property;
    }

    public SourceFunction<I, O> withDefaultValue(O defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Nullable
    public O getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Map<String, Object> toValueObject() {
        Map<String, Object> valueObject = super.toValueObject();
        valueObject.put("property", this.property);
        if (this.defaultValue != null) {
            valueObject.put("defaultValue", this.defaultValue);
        }
        return valueObject;
    }
}

