/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.Surface;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.ProjectedMeters;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.offline.OfflineManager;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.NoSuchLayerException;
import com.mapbox.mapboxsdk.style.sources.NoSuchSourceException;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.services.commons.geojson.Feature;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import timber.log.Timber;

final class NativeMapView {
    private boolean destroyed = false;
    private long nativeMapViewPtr = 0L;
    private MapView mapView;
    private final float pixelRatio;
    private CopyOnWriteArrayList<MapView.OnMapChangedListener> onMapChangedListeners;
    private MapboxMap.SnapshotReadyCallback snapshotReadyCallback;

    public NativeMapView(MapView mapView) {
        String dataPath;
        Context context = mapView.getContext();
        String cachePath = dataPath = OfflineManager.getDatabasePath(context);
        this.pixelRatio = context.getResources().getDisplayMetrics().density;
        String apkPath = context.getPackageCodePath();
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        activityManager.getMemoryInfo(memoryInfo);
        long totalMemory = memoryInfo.availMem;
        if (Build.VERSION.SDK_INT >= 16) {
            totalMemory = memoryInfo.totalMem;
        }
        if (availableProcessors < 0) {
            throw new IllegalArgumentException("availableProcessors cannot be negative.");
        }
        if (totalMemory < 0L) {
            throw new IllegalArgumentException("totalMemory cannot be negative.");
        }
        this.onMapChangedListeners = new CopyOnWriteArrayList();
        this.mapView = mapView;
        this.nativeMapViewPtr = this.nativeCreate(cachePath, dataPath, apkPath, this.pixelRatio, availableProcessors, totalMemory);
    }

    private boolean isDestroyedOn(String callingMethod) {
        if (this.destroyed && !TextUtils.isEmpty((CharSequence)callingMethod)) {
            Timber.e((String)String.format(MapboxConstants.MAPBOX_LOCALE, "You're calling `%s` after the `MapView` was destroyed, were you invoking it after `onDestroy()`?", callingMethod), (Object[])new Object[0]);
        }
        return this.destroyed;
    }

    public void destroy() {
        this.nativeDestroy(this.nativeMapViewPtr);
        this.nativeMapViewPtr = 0L;
        this.mapView = null;
        this.destroyed = true;
    }

    public void initializeDisplay() {
        if (this.isDestroyedOn("initializeDisplay")) {
            return;
        }
        this.nativeInitializeDisplay(this.nativeMapViewPtr);
    }

    public void terminateDisplay() {
        if (this.isDestroyedOn("terminateDisplay")) {
            return;
        }
        this.nativeTerminateDisplay(this.nativeMapViewPtr);
    }

    public void initializeContext() {
        if (this.isDestroyedOn("initializeContext")) {
            return;
        }
        this.nativeInitializeContext(this.nativeMapViewPtr);
    }

    public void terminateContext() {
        if (this.isDestroyedOn("terminateContext")) {
            return;
        }
        this.nativeTerminateContext(this.nativeMapViewPtr);
    }

    public void createSurface(Surface surface) {
        if (this.isDestroyedOn("createSurface")) {
            return;
        }
        this.nativeCreateSurface(this.nativeMapViewPtr, surface);
    }

    public void destroySurface() {
        if (this.isDestroyedOn("destroySurface")) {
            return;
        }
        this.nativeDestroySurface(this.nativeMapViewPtr);
    }

    public void update() {
        if (this.isDestroyedOn("update")) {
            return;
        }
        this.nativeUpdate(this.nativeMapViewPtr);
    }

    public void render() {
        if (this.isDestroyedOn("render")) {
            return;
        }
        this.nativeRender(this.nativeMapViewPtr);
    }

    public void resizeView(int width, int height) {
        if (this.isDestroyedOn("resizeView")) {
            return;
        }
        width = (int)((float)width / this.pixelRatio);
        height = (int)((float)height / this.pixelRatio);
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be negative.");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be negative.");
        }
        if (width > 65535) {
            Timber.e((String)("Device returned an out of range width size, capping value at 65535 instead of " + width), (Object[])new Object[0]);
            width = 65535;
        }
        if (height > 65535) {
            Timber.e((String)("Device returned an out of range height size, capping value at 65535 instead of " + height), (Object[])new Object[0]);
            height = 65535;
        }
        this.nativeViewResize(this.nativeMapViewPtr, width, height);
    }

    public void resizeFramebuffer(int fbWidth, int fbHeight) {
        if (this.isDestroyedOn("resizeFramebuffer")) {
            return;
        }
        if (fbWidth < 0) {
            throw new IllegalArgumentException("fbWidth cannot be negative.");
        }
        if (fbHeight < 0) {
            throw new IllegalArgumentException("fbHeight cannot be negative.");
        }
        if (fbWidth > 65535) {
            throw new IllegalArgumentException("fbWidth cannot be greater than 65535.");
        }
        if (fbHeight > 65535) {
            throw new IllegalArgumentException("fbHeight cannot be greater than 65535.");
        }
        this.nativeFramebufferResize(this.nativeMapViewPtr, fbWidth, fbHeight);
    }

    public void addClass(String clazz) {
        if (this.isDestroyedOn("addClass")) {
            return;
        }
        this.nativeAddClass(this.nativeMapViewPtr, clazz);
    }

    public void removeClass(String clazz) {
        if (this.isDestroyedOn("removeClass")) {
            return;
        }
        this.nativeRemoveClass(this.nativeMapViewPtr, clazz);
    }

    public boolean hasClass(String clazz) {
        if (this.isDestroyedOn("hasClass")) {
            return false;
        }
        return this.nativeHasClass(this.nativeMapViewPtr, clazz);
    }

    public void setClasses(List<String> classes) {
        if (this.isDestroyedOn("setClasses")) {
            return;
        }
        this.nativeSetClasses(this.nativeMapViewPtr, classes);
    }

    public List<String> getClasses() {
        if (this.isDestroyedOn("getClasses")) {
            return new ArrayList<String>();
        }
        return this.nativeGetClasses(this.nativeMapViewPtr);
    }

    public void setStyleUrl(String url) {
        if (this.isDestroyedOn("setStyleUrl")) {
            return;
        }
        this.nativeSetStyleUrl(this.nativeMapViewPtr, url);
    }

    public String getStyleUrl() {
        if (this.isDestroyedOn("getStyleUrl")) {
            return null;
        }
        return this.nativeGetStyleUrl(this.nativeMapViewPtr);
    }

    public void setStyleJson(String newStyleJson) {
        if (this.isDestroyedOn("setStyleJson")) {
            return;
        }
        this.nativeSetStyleJson(this.nativeMapViewPtr, newStyleJson);
    }

    public String getStyleJson() {
        if (this.isDestroyedOn("getStyleJson")) {
            return null;
        }
        return this.nativeGetStyleJson(this.nativeMapViewPtr);
    }

    public void setAccessToken(String accessToken) {
        if (this.isDestroyedOn("setAccessToken")) {
            return;
        }
        this.nativeSetAccessToken(this.nativeMapViewPtr, accessToken);
    }

    public String getAccessToken() {
        if (this.isDestroyedOn("getAccessToken")) {
            return null;
        }
        return this.nativeGetAccessToken(this.nativeMapViewPtr);
    }

    public void cancelTransitions() {
        if (this.isDestroyedOn("cancelTransitions")) {
            return;
        }
        this.nativeCancelTransitions(this.nativeMapViewPtr);
    }

    public void setGestureInProgress(boolean inProgress) {
        if (this.isDestroyedOn("setGestureInProgress")) {
            return;
        }
        this.nativeSetGestureInProgress(this.nativeMapViewPtr, inProgress);
    }

    public void moveBy(double dx, double dy) {
        if (this.isDestroyedOn("moveBy")) {
            return;
        }
        this.moveBy(dx, dy, 0L);
    }

    public void moveBy(double dx, double dy, long duration) {
        if (this.isDestroyedOn("moveBy")) {
            return;
        }
        this.nativeMoveBy(this.nativeMapViewPtr, dx / (double)this.pixelRatio, dy / (double)this.pixelRatio, duration);
    }

    public void setLatLng(LatLng latLng) {
        if (this.isDestroyedOn("setLatLng")) {
            return;
        }
        this.setLatLng(latLng, 0L);
    }

    public void setLatLng(LatLng latLng, long duration) {
        if (this.isDestroyedOn("setLatLng")) {
            return;
        }
        this.nativeSetLatLng(this.nativeMapViewPtr, latLng.getLatitude(), latLng.getLongitude(), duration);
    }

    public LatLng getLatLng() {
        if (this.isDestroyedOn("")) {
            return new LatLng();
        }
        return this.nativeGetLatLng(this.nativeMapViewPtr).wrap();
    }

    public void resetPosition() {
        if (this.isDestroyedOn("resetPosition")) {
            return;
        }
        this.nativeResetPosition(this.nativeMapViewPtr);
    }

    public double getPitch() {
        if (this.isDestroyedOn("getPitch")) {
            return 0.0;
        }
        return this.nativeGetPitch(this.nativeMapViewPtr);
    }

    public void setPitch(double pitch, long duration) {
        if (this.isDestroyedOn("setPitch")) {
            return;
        }
        this.nativeSetPitch(this.nativeMapViewPtr, pitch, duration);
    }

    public void scaleBy(double ds) {
        if (this.isDestroyedOn("scaleBy")) {
            return;
        }
        this.scaleBy(ds, Double.NaN, Double.NaN);
    }

    public void scaleBy(double ds, double cx, double cy) {
        if (this.isDestroyedOn("scaleBy")) {
            return;
        }
        this.scaleBy(ds, cx, cy, 0L);
    }

    public void scaleBy(double ds, double cx, double cy, long duration) {
        if (this.isDestroyedOn("scaleBy")) {
            return;
        }
        this.nativeScaleBy(this.nativeMapViewPtr, ds, cx / (double)this.pixelRatio, cy / (double)this.pixelRatio, duration);
    }

    public void setScale(double scale) {
        if (this.isDestroyedOn("setScale")) {
            return;
        }
        this.setScale(scale, Double.NaN, Double.NaN);
    }

    public void setScale(double scale, double cx, double cy) {
        if (this.isDestroyedOn("setScale")) {
            return;
        }
        this.setScale(scale, cx, cy, 0L);
    }

    public void setScale(double scale, double cx, double cy, long duration) {
        if (this.isDestroyedOn("setScale")) {
            return;
        }
        this.nativeSetScale(this.nativeMapViewPtr, scale, cx / (double)this.pixelRatio, cy / (double)this.pixelRatio, duration);
    }

    public double getScale() {
        if (this.isDestroyedOn("getScale")) {
            return 0.0;
        }
        return this.nativeGetScale(this.nativeMapViewPtr);
    }

    public void setZoom(double zoom) {
        if (this.isDestroyedOn("setZoom")) {
            return;
        }
        this.setZoom(zoom, 0L);
    }

    public void setZoom(double zoom, long duration) {
        if (this.isDestroyedOn("setZoom")) {
            return;
        }
        this.nativeSetZoom(this.nativeMapViewPtr, zoom, duration);
    }

    public double getZoom() {
        if (this.isDestroyedOn("getZoom")) {
            return 0.0;
        }
        return this.nativeGetZoom(this.nativeMapViewPtr);
    }

    public void resetZoom() {
        if (this.isDestroyedOn("resetZoom")) {
            return;
        }
        this.nativeResetZoom(this.nativeMapViewPtr);
    }

    public void setMinZoom(double zoom) {
        if (this.isDestroyedOn("setMinZoom")) {
            return;
        }
        this.nativeSetMinZoom(this.nativeMapViewPtr, zoom);
    }

    public double getMinZoom() {
        if (this.isDestroyedOn("getMinZoom")) {
            return 0.0;
        }
        return this.nativeGetMinZoom(this.nativeMapViewPtr);
    }

    public void setMaxZoom(double zoom) {
        if (this.isDestroyedOn("setMaxZoom")) {
            return;
        }
        this.nativeSetMaxZoom(this.nativeMapViewPtr, zoom);
    }

    public double getMaxZoom() {
        if (this.isDestroyedOn("getMaxZoom")) {
            return 0.0;
        }
        return this.nativeGetMaxZoom(this.nativeMapViewPtr);
    }

    public void rotateBy(double sx, double sy, double ex, double ey) {
        if (this.isDestroyedOn("rotateBy")) {
            return;
        }
        this.rotateBy(sx, sy, ex, ey, 0L);
    }

    public void rotateBy(double sx, double sy, double ex, double ey, long duration) {
        if (this.isDestroyedOn("rotateBy")) {
            return;
        }
        this.nativeRotateBy(this.nativeMapViewPtr, sx / (double)this.pixelRatio, sy / (double)this.pixelRatio, ex, ey, duration);
    }

    public void setContentPadding(int[] padding) {
        if (this.isDestroyedOn("setContentPadding")) {
            return;
        }
        this.nativeSetContentPadding(this.nativeMapViewPtr, (float)padding[1] / this.pixelRatio, (float)padding[0] / this.pixelRatio, (float)padding[3] / this.pixelRatio, (float)padding[2] / this.pixelRatio);
    }

    public void setBearing(double degrees) {
        if (this.isDestroyedOn("setBearing")) {
            return;
        }
        this.setBearing(degrees, 0L);
    }

    public void setBearing(double degrees, long duration) {
        if (this.isDestroyedOn("setBearing")) {
            return;
        }
        this.nativeSetBearing(this.nativeMapViewPtr, degrees, duration);
    }

    public void setBearing(double degrees, double cx, double cy) {
        if (this.isDestroyedOn("setBearing")) {
            return;
        }
        this.nativeSetBearingXY(this.nativeMapViewPtr, degrees, cx / (double)this.pixelRatio, cy / (double)this.pixelRatio);
    }

    public void setBearing(double degrees, double fx, double fy, long duration) {
        if (this.isDestroyedOn("setBearing")) {
            return;
        }
        this.nativeSetFocalBearing(this.nativeMapViewPtr, degrees, fx / (double)this.pixelRatio, fy / (double)this.pixelRatio, duration);
    }

    public double getBearing() {
        if (this.isDestroyedOn("getBearing")) {
            return 0.0;
        }
        return this.nativeGetBearing(this.nativeMapViewPtr);
    }

    public void resetNorth() {
        if (this.isDestroyedOn("resetNorth")) {
            return;
        }
        this.nativeResetNorth(this.nativeMapViewPtr);
    }

    public long addMarker(Marker marker) {
        if (this.isDestroyedOn("addMarker")) {
            return 0L;
        }
        Marker[] markers = new Marker[]{marker};
        return this.nativeAddMarkers(this.nativeMapViewPtr, markers)[0];
    }

    public long[] addMarkers(List<Marker> markers) {
        if (this.isDestroyedOn("addMarkers")) {
            return new long[0];
        }
        return this.nativeAddMarkers(this.nativeMapViewPtr, markers.toArray(new Marker[markers.size()]));
    }

    public long addPolyline(Polyline polyline) {
        if (this.isDestroyedOn("addPolyline")) {
            return 0L;
        }
        Polyline[] polylines = new Polyline[]{polyline};
        return this.nativeAddPolylines(this.nativeMapViewPtr, polylines)[0];
    }

    public long[] addPolylines(List<Polyline> polylines) {
        if (this.isDestroyedOn("addPolylines")) {
            return new long[0];
        }
        return this.nativeAddPolylines(this.nativeMapViewPtr, polylines.toArray(new Polyline[polylines.size()]));
    }

    public long addPolygon(Polygon polygon) {
        if (this.isDestroyedOn("addPolygon")) {
            return 0L;
        }
        Polygon[] polygons = new Polygon[]{polygon};
        return this.nativeAddPolygons(this.nativeMapViewPtr, polygons)[0];
    }

    public long[] addPolygons(List<Polygon> polygons) {
        if (this.isDestroyedOn("addPolygons")) {
            return new long[0];
        }
        return this.nativeAddPolygons(this.nativeMapViewPtr, polygons.toArray(new Polygon[polygons.size()]));
    }

    public void updateMarker(Marker marker) {
        if (this.isDestroyedOn("updateMarker")) {
            return;
        }
        LatLng position = marker.getPosition();
        Icon icon = marker.getIcon();
        this.nativeUpdateMarker(this.nativeMapViewPtr, marker.getId(), position.getLatitude(), position.getLongitude(), icon.getId());
    }

    public void updatePolygon(Polygon polygon) {
        if (this.isDestroyedOn("updatePolygon")) {
            return;
        }
        this.nativeUpdatePolygon(this.nativeMapViewPtr, polygon.getId(), polygon);
    }

    public void updatePolyline(Polyline polyline) {
        if (this.isDestroyedOn("updatePolyline")) {
            return;
        }
        this.nativeUpdatePolyline(this.nativeMapViewPtr, polyline.getId(), polyline);
    }

    public void removeAnnotation(long id2) {
        if (this.isDestroyedOn("removeAnnotation")) {
            return;
        }
        long[] ids = new long[]{id2};
        this.removeAnnotations(ids);
    }

    public void removeAnnotations(long[] ids) {
        if (this.isDestroyedOn("removeAnnotations")) {
            return;
        }
        this.nativeRemoveAnnotations(this.nativeMapViewPtr, ids);
    }

    public long[] queryPointAnnotations(RectF rect) {
        if (this.isDestroyedOn("queryPointAnnotations")) {
            return new long[0];
        }
        return this.nativeQueryPointAnnotations(this.nativeMapViewPtr, rect);
    }

    public void addAnnotationIcon(String symbol, int width, int height, float scale, byte[] pixels) {
        if (this.isDestroyedOn("addAnnotationIcon")) {
            return;
        }
        this.nativeAddAnnotationIcon(this.nativeMapViewPtr, symbol, width, height, scale, pixels);
    }

    public void setVisibleCoordinateBounds(LatLng[] coordinates, RectF padding, double direction, long duration) {
        if (this.isDestroyedOn("setVisibleCoordinateBounds")) {
            return;
        }
        this.nativeSetVisibleCoordinateBounds(this.nativeMapViewPtr, coordinates, padding, direction, duration);
    }

    public void onLowMemory() {
        if (this.isDestroyedOn("onLowMemory")) {
            return;
        }
        this.nativeOnLowMemory(this.nativeMapViewPtr);
    }

    public void setDebug(boolean debug) {
        if (this.isDestroyedOn("setDebug")) {
            return;
        }
        this.nativeSetDebug(this.nativeMapViewPtr, debug);
    }

    public void cycleDebugOptions() {
        if (this.isDestroyedOn("cycleDebugOptions")) {
            return;
        }
        this.nativeToggleDebug(this.nativeMapViewPtr);
    }

    public boolean getDebug() {
        if (this.isDestroyedOn("getDebug")) {
            return false;
        }
        return this.nativeGetDebug(this.nativeMapViewPtr);
    }

    public boolean isFullyLoaded() {
        if (this.isDestroyedOn("isFullyLoaded")) {
            return false;
        }
        return this.nativeIsFullyLoaded(this.nativeMapViewPtr);
    }

    public void setReachability(boolean status) {
        if (this.isDestroyedOn("setReachability")) {
            return;
        }
        this.nativeSetReachability(this.nativeMapViewPtr, status);
    }

    public double getMetersPerPixelAtLatitude(double lat) {
        if (this.isDestroyedOn("getMetersPerPixelAtLatitude")) {
            return 0.0;
        }
        return this.nativeGetMetersPerPixelAtLatitude(this.nativeMapViewPtr, lat, this.getZoom());
    }

    public ProjectedMeters projectedMetersForLatLng(LatLng latLng) {
        if (this.isDestroyedOn("projectedMetersForLatLng")) {
            return null;
        }
        return this.nativeProjectedMetersForLatLng(this.nativeMapViewPtr, latLng.getLatitude(), latLng.getLongitude());
    }

    public LatLng latLngForProjectedMeters(ProjectedMeters projectedMeters) {
        if (this.isDestroyedOn("latLngForProjectedMeters")) {
            return new LatLng();
        }
        return this.nativeLatLngForProjectedMeters(this.nativeMapViewPtr, projectedMeters.getNorthing(), projectedMeters.getEasting()).wrap();
    }

    public PointF pixelForLatLng(LatLng latLng) {
        if (this.isDestroyedOn("pixelForLatLng")) {
            return new PointF();
        }
        PointF pointF = this.nativePixelForLatLng(this.nativeMapViewPtr, latLng.getLatitude(), latLng.getLongitude());
        pointF.set(pointF.x * this.pixelRatio, pointF.y * this.pixelRatio);
        return pointF;
    }

    public LatLng latLngForPixel(PointF pixel) {
        if (this.isDestroyedOn("latLngForPixel")) {
            return new LatLng();
        }
        return this.nativeLatLngForPixel(this.nativeMapViewPtr, pixel.x / this.pixelRatio, pixel.y / this.pixelRatio).wrap();
    }

    public double getTopOffsetPixelsForAnnotationSymbol(String symbolName) {
        if (this.isDestroyedOn("getTopOffsetPixelsForAnnotationSymbol")) {
            return 0.0;
        }
        return this.nativeGetTopOffsetPixelsForAnnotationSymbol(this.nativeMapViewPtr, symbolName);
    }

    public void jumpTo(double angle, LatLng center, double pitch, double zoom) {
        if (this.isDestroyedOn("jumpTo")) {
            return;
        }
        this.nativeJumpTo(this.nativeMapViewPtr, angle, center.getLatitude(), center.getLongitude(), pitch, zoom);
    }

    public void easeTo(double angle, LatLng center, long duration, double pitch, double zoom, boolean easingInterpolator) {
        if (this.isDestroyedOn("easeTo")) {
            return;
        }
        this.nativeEaseTo(this.nativeMapViewPtr, angle, center.getLatitude(), center.getLongitude(), duration, pitch, zoom, easingInterpolator);
    }

    public void flyTo(double angle, LatLng center, long duration, double pitch, double zoom) {
        if (this.isDestroyedOn("flyTo")) {
            return;
        }
        this.nativeFlyTo(this.nativeMapViewPtr, angle, center.getLatitude(), center.getLongitude(), duration, pitch, zoom);
    }

    public double[] getCameraValues() {
        if (this.isDestroyedOn("getCameraValues")) {
            return new double[0];
        }
        return this.nativeGetCameraValues(this.nativeMapViewPtr);
    }

    public long getTransitionDuration() {
        return this.nativeGetTransitionDuration(this.nativeMapViewPtr);
    }

    public void setTransitionDuration(long duration) {
        this.nativeSetTransitionDuration(this.nativeMapViewPtr, duration);
    }

    public long getTransitionDelay() {
        return this.nativeGetTransitionDelay(this.nativeMapViewPtr);
    }

    public void setTransitionDelay(long delay) {
        this.nativeSetTransitionDelay(this.nativeMapViewPtr, delay);
    }

    public Layer getLayer(String layerId) {
        if (this.isDestroyedOn("getLayer")) {
            return null;
        }
        return this.nativeGetLayer(this.nativeMapViewPtr, layerId);
    }

    public void addLayer(@NonNull Layer layer, @Nullable String before) {
        if (this.isDestroyedOn("")) {
            return;
        }
        this.nativeAddLayer(this.nativeMapViewPtr, layer.getNativePtr(), before);
    }

    public void removeLayer(@NonNull String layerId) throws NoSuchLayerException {
        if (this.isDestroyedOn("removeLayer")) {
            return;
        }
        this.nativeRemoveLayerById(this.nativeMapViewPtr, layerId);
    }

    public void removeLayer(@NonNull Layer layer) throws NoSuchLayerException {
        if (this.isDestroyedOn("removeLayer")) {
            return;
        }
        this.nativeRemoveLayer(this.nativeMapViewPtr, layer.getNativePtr());
    }

    public Source getSource(@NonNull String sourceId) {
        if (this.isDestroyedOn("getSource")) {
            return null;
        }
        return this.nativeGetSource(this.nativeMapViewPtr, sourceId);
    }

    public void addSource(@NonNull Source source) {
        if (this.isDestroyedOn("addSource")) {
            return;
        }
        this.nativeAddSource(this.nativeMapViewPtr, source.getNativePtr());
    }

    public void removeSource(@NonNull String sourceId) throws NoSuchSourceException {
        if (this.isDestroyedOn("removeSource")) {
            return;
        }
        this.nativeRemoveSourceById(this.nativeMapViewPtr, sourceId);
    }

    public void removeSource(@NonNull Source source) throws NoSuchSourceException {
        if (this.isDestroyedOn("removeSource")) {
            return;
        }
        this.nativeRemoveSource(this.nativeMapViewPtr, source.getNativePtr());
    }

    public void addImage(@NonNull String name, @NonNull Bitmap image) {
        if (this.isDestroyedOn("addImage")) {
            return;
        }
        if (image.getConfig() != Bitmap.Config.ARGB_8888) {
            image = image.copy(Bitmap.Config.ARGB_8888, false);
        }
        ByteBuffer buffer = ByteBuffer.allocate(image.getByteCount());
        image.copyPixelsToBuffer((Buffer)buffer);
        float density = image.getDensity() == 0 ? 0.0f : (float)image.getDensity();
        float pixelRatio = density / 160.0f;
        this.nativeAddImage(this.nativeMapViewPtr, name, image.getWidth(), image.getHeight(), pixelRatio, buffer.array());
    }

    public void removeImage(String name) {
        if (this.isDestroyedOn("removeImage")) {
            return;
        }
        this.nativeRemoveImage(this.nativeMapViewPtr, name);
    }

    @NonNull
    public List<Feature> queryRenderedFeatures(PointF coordinates, String ... layerIds) {
        if (this.isDestroyedOn("queryRenderedFeatures")) {
            return new ArrayList<Feature>();
        }
        Feature[] features = this.nativeQueryRenderedFeaturesForPoint(this.nativeMapViewPtr, coordinates.x / this.pixelRatio, coordinates.y / this.pixelRatio, layerIds);
        return features != null ? Arrays.asList(features) : new ArrayList<Feature>();
    }

    @NonNull
    public List<Feature> queryRenderedFeatures(RectF coordinates, String ... layerIds) {
        if (this.isDestroyedOn("queryRenderedFeatures")) {
            return new ArrayList<Feature>();
        }
        Feature[] features = this.nativeQueryRenderedFeaturesForBox(this.nativeMapViewPtr, coordinates.left / this.pixelRatio, coordinates.top / this.pixelRatio, coordinates.right / this.pixelRatio, coordinates.bottom / this.pixelRatio, layerIds);
        return features != null ? Arrays.asList(features) : new ArrayList<Feature>();
    }

    public void scheduleTakeSnapshot() {
        if (this.isDestroyedOn("scheduleTakeSnapshot")) {
            return;
        }
        this.nativeScheduleTakeSnapshot(this.nativeMapViewPtr);
    }

    public void setApiBaseUrl(String baseUrl) {
        if (this.isDestroyedOn("setApiBaseUrl")) {
            return;
        }
        this.nativeSetAPIBaseURL(this.nativeMapViewPtr, baseUrl);
    }

    public float getPixelRatio() {
        return this.pixelRatio;
    }

    public Context getContext() {
        return this.mapView.getContext();
    }

    protected void onInvalidate() {
        this.mapView.onInvalidate();
    }

    protected void onMapChanged(int rawChange) {
        if (this.onMapChangedListeners != null) {
            for (MapView.OnMapChangedListener onMapChangedListener : this.onMapChangedListeners) {
                onMapChangedListener.onMapChanged(rawChange);
            }
        }
    }

    protected void onFpsChanged(double fps) {
        this.mapView.onFpsChanged(fps);
    }

    protected void onSnapshotReady(Bitmap bitmap) {
        if (this.snapshotReadyCallback != null && bitmap != null) {
            this.snapshotReadyCallback.onSnapshotReady(bitmap);
        }
    }

    private native long nativeCreate(String var1, String var2, String var3, float var4, int var5, long var6);

    private native void nativeDestroy(long var1);

    private native void nativeInitializeDisplay(long var1);

    private native void nativeTerminateDisplay(long var1);

    private native void nativeInitializeContext(long var1);

    private native void nativeTerminateContext(long var1);

    private native void nativeCreateSurface(long var1, Surface var3);

    private native void nativeDestroySurface(long var1);

    private native void nativeUpdate(long var1);

    private native void nativeRender(long var1);

    private native void nativeViewResize(long var1, int var3, int var4);

    private native void nativeFramebufferResize(long var1, int var3, int var4);

    private native void nativeAddClass(long var1, String var3);

    private native void nativeRemoveClass(long var1, String var3);

    private native boolean nativeHasClass(long var1, String var3);

    private native void nativeSetClasses(long var1, List<String> var3);

    private native List<String> nativeGetClasses(long var1);

    private native void nativeSetStyleUrl(long var1, String var3);

    private native String nativeGetStyleUrl(long var1);

    private native void nativeSetStyleJson(long var1, String var3);

    private native String nativeGetStyleJson(long var1);

    private native void nativeSetAccessToken(long var1, String var3);

    private native String nativeGetAccessToken(long var1);

    private native void nativeCancelTransitions(long var1);

    private native void nativeSetGestureInProgress(long var1, boolean var3);

    private native void nativeMoveBy(long var1, double var3, double var5, long var7);

    private native void nativeSetLatLng(long var1, double var3, double var5, long var7);

    private native LatLng nativeGetLatLng(long var1);

    private native void nativeResetPosition(long var1);

    private native double nativeGetPitch(long var1);

    private native void nativeSetPitch(long var1, double var3, long var5);

    private native void nativeScaleBy(long var1, double var3, double var5, double var7, long var9);

    private native void nativeSetScale(long var1, double var3, double var5, double var7, long var9);

    private native double nativeGetScale(long var1);

    private native void nativeSetZoom(long var1, double var3, long var5);

    private native double nativeGetZoom(long var1);

    private native void nativeResetZoom(long var1);

    private native void nativeSetMinZoom(long var1, double var3);

    private native double nativeGetMinZoom(long var1);

    private native void nativeSetMaxZoom(long var1, double var3);

    private native double nativeGetMaxZoom(long var1);

    private native void nativeRotateBy(long var1, double var3, double var5, double var7, double var9, long var11);

    private native void nativeSetContentPadding(long var1, double var3, double var5, double var7, double var9);

    private native void nativeSetBearing(long var1, double var3, long var5);

    private native void nativeSetBearingXY(long var1, double var3, double var5, double var7);

    private native void nativeSetFocalBearing(long var1, double var3, double var5, double var7, long var9);

    private native double nativeGetBearing(long var1);

    private native void nativeResetNorth(long var1);

    private native void nativeUpdateMarker(long var1, long var3, double var5, double var7, String var9);

    private native long[] nativeAddMarkers(long var1, Marker[] var3);

    private native long[] nativeAddPolylines(long var1, Polyline[] var3);

    private native long[] nativeAddPolygons(long var1, Polygon[] var3);

    private native void nativeRemoveAnnotations(long var1, long[] var3);

    private native long[] nativeQueryPointAnnotations(long var1, RectF var3);

    private native void nativeAddAnnotationIcon(long var1, String var3, int var4, int var5, float var6, byte[] var7);

    private native void nativeSetVisibleCoordinateBounds(long var1, LatLng[] var3, RectF var4, double var5, long var7);

    private native void nativeOnLowMemory(long var1);

    private native void nativeSetDebug(long var1, boolean var3);

    private native void nativeToggleDebug(long var1);

    private native boolean nativeGetDebug(long var1);

    private native boolean nativeIsFullyLoaded(long var1);

    private native void nativeSetReachability(long var1, boolean var3);

    private native double nativeGetMetersPerPixelAtLatitude(long var1, double var3, double var5);

    private native ProjectedMeters nativeProjectedMetersForLatLng(long var1, double var3, double var5);

    private native LatLng nativeLatLngForProjectedMeters(long var1, double var3, double var5);

    private native PointF nativePixelForLatLng(long var1, double var3, double var5);

    private native LatLng nativeLatLngForPixel(long var1, float var3, float var4);

    private native double nativeGetTopOffsetPixelsForAnnotationSymbol(long var1, String var3);

    private native void nativeJumpTo(long var1, double var3, double var5, double var7, double var9, double var11);

    private native void nativeEaseTo(long var1, double var3, double var5, double var7, long var9, double var11, double var13, boolean var15);

    private native void nativeFlyTo(long var1, double var3, double var5, double var7, long var9, double var11, double var13);

    private native double[] nativeGetCameraValues(long var1);

    private native long nativeGetTransitionDuration(long var1);

    private native void nativeSetTransitionDuration(long var1, long var3);

    private native long nativeGetTransitionDelay(long var1);

    private native void nativeSetTransitionDelay(long var1, long var3);

    private native Layer nativeGetLayer(long var1, String var3);

    private native void nativeAddLayer(long var1, long var3, String var5);

    private native void nativeRemoveLayerById(long var1, String var3) throws NoSuchLayerException;

    private native void nativeRemoveLayer(long var1, long var3) throws NoSuchLayerException;

    private native Source nativeGetSource(long var1, String var3);

    private native void nativeAddSource(long var1, long var3);

    private native void nativeRemoveSourceById(long var1, String var3) throws NoSuchSourceException;

    private native void nativeRemoveSource(long var1, long var3) throws NoSuchSourceException;

    private native void nativeAddImage(long var1, String var3, int var4, int var5, float var6, byte[] var7);

    private native void nativeRemoveImage(long var1, String var3);

    private native void nativeUpdatePolygon(long var1, long var3, Polygon var5);

    private native void nativeUpdatePolyline(long var1, long var3, Polyline var5);

    private native void nativeScheduleTakeSnapshot(long var1);

    private native Feature[] nativeQueryRenderedFeaturesForPoint(long var1, float var3, float var4, String[] var5);

    private native Feature[] nativeQueryRenderedFeaturesForBox(long var1, float var3, float var4, float var5, float var6, String[] var7);

    private native void nativeSetAPIBaseURL(long var1, String var3);

    int getWidth() {
        if (this.isDestroyedOn("")) {
            return 0;
        }
        return this.mapView.getWidth();
    }

    int getHeight() {
        if (this.isDestroyedOn("")) {
            return 0;
        }
        return this.mapView.getHeight();
    }

    void addOnMapChangedListener(@NonNull MapView.OnMapChangedListener listener) {
        this.onMapChangedListeners.add(listener);
    }

    void removeOnMapChangedListener(@NonNull MapView.OnMapChangedListener listener) {
        this.onMapChangedListeners.remove(listener);
    }

    void addSnapshotCallback(@NonNull MapboxMap.SnapshotReadyCallback callback) {
        this.snapshotReadyCallback = callback;
        this.scheduleTakeSnapshot();
        this.render();
    }

    static {
        System.loadLibrary("mapbox-gl");
    }
}

