/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.telemetry;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.mapbox.mapboxsdk.telemetry.MapboxEventManager;
import com.mapbox.mapboxsdk.telemetry.TelemetryLocationReceiver;

public class TelemetryService
extends Service {
    private static final String TAG = "TelemetryService";
    private TelemetryLocationReceiver telemetryLocationReceiver = null;

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).registerReceiver((BroadcastReceiver)new TelemetryLocationReceiver(), new IntentFilter("com.mapbox.mapboxsdk.telemetry.TelemetryLocationReceiver"));
    }

    public void onDestroy() {
        this.shutdownTelemetry();
        super.onDestroy();
    }

    public void onTaskRemoved(Intent rootIntent) {
        this.shutdownTelemetry();
        super.onTaskRemoved(rootIntent);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.i((String)TAG, (String)"onStartCommand() called");
        return 2;
    }

    private void shutdownTelemetry() {
        MapboxEventManager.getMapboxEventManager().flushEventsQueueImmediately();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error while trying to sleep for 1 second: " + e));
        }
        try {
            this.unregisterReceiver(this.telemetryLocationReceiver);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)("Error when unregisterReceiver: " + e));
        }
    }
}

