/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.telemetry;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.ServiceInfo;
import android.location.Location;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import com.mapbox.mapboxsdk.MapboxAccountManager;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.exceptions.TelemetryServiceNotConfiguredException;
import com.mapbox.mapboxsdk.location.LocationServices;
import com.mapbox.mapboxsdk.telemetry.GzipRequestInterceptor;
import com.mapbox.mapboxsdk.telemetry.TelemetryService;
import com.mapbox.mapboxsdk.utils.MathUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.Vector;
import okhttp3.CertificatePinner;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import org.json.JSONArray;
import org.json.JSONObject;

public class MapboxEventManager {
    private static final String TAG = "MapboxEventManager";
    private static MapboxEventManager mapboxEventManager = null;
    private boolean initialized = false;
    private boolean stagingEnv;
    private boolean telemetryEnabled;
    private final Vector<Hashtable<String, Object>> events = new Vector();
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", MapboxConstants.MAPBOX_LOCALE);
    private Context context = null;
    private String accessToken = null;
    private String eventsURL = "https://events.mapbox.com";
    private String userAgent = "MapboxEventsAndroid/4.2.1";
    private Intent batteryStatus = null;
    private final String operatingSystem = "Android - " + Build.VERSION.RELEASE;
    private DisplayMetrics displayMetrics = null;
    private String mapboxVendorId = null;
    private String mapboxSessionId = null;
    private long mapboxSessionIdLastSet = 0L;
    private static long hourInMillis = 3600000L;
    private static long flushDelayInitialInMillis = 10000L;
    private static long flushDelayInMillis = 180000L;
    private static final int SESSION_ID_ROTATION_HOURS = 24;
    private static final int FLUSH_EVENTS_CAP = 1000;
    private static MessageDigest messageDigest = null;
    private static final double locationEventAccuracy = 1.0E7;
    private Timer timer = null;

    private MapboxEventManager() {
    }

    public void initialize(@NonNull Context context, @NonNull String accessToken) {
        Log.i((String)TAG, (String)"Telemetry initialize() called...");
        if (this.initialized) {
            Log.i((String)TAG, (String)"Mapbox Telemetry has already been initialized.");
            return;
        }
        this.context = context.getApplicationContext();
        this.accessToken = accessToken;
        this.validateTelemetryServiceConfigured();
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            Log.w((String)TAG, (String)("Error getting Encryption Algorithm: " + e));
        }
        this.rotateSessionId();
        SharedPreferences prefs = context.getSharedPreferences("MapboxSharedPreferences", 0);
        Log.i((String)TAG, (String)"Right before Telemetry set enabled in initialized()");
        this.setTelemetryEnabled(prefs.getBoolean("mapboxTelemetryEnabled", true));
        if (prefs.contains("mapboxVendorId")) {
            this.mapboxVendorId = prefs.getString("mapboxVendorId", "");
        }
        if (TextUtils.isEmpty((CharSequence)this.mapboxVendorId)) {
            String vendorId = UUID.randomUUID().toString();
            this.mapboxVendorId = this.encodeString(vendorId);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString("mapboxVendorId", this.mapboxVendorId);
            editor.apply();
            editor.commit();
        }
        this.displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(this.displayMetrics);
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            String stagingURL = appInfo.metaData.getString("com.mapbox.TestEventsServer");
            String stagingAccessToken = appInfo.metaData.getString("com.mapbox.TestEventsAccessToken");
            if (TextUtils.isEmpty((CharSequence)stagingURL) || TextUtils.isEmpty((CharSequence)stagingAccessToken)) {
                Log.d((String)TAG, (String)"Looking in SharedPreferences for Staging Credentials");
                stagingURL = prefs.getString("mapboxTelemetryStagingUrl", null);
                stagingAccessToken = prefs.getString("mapboxTelemetryStagingAccessToken", null);
            }
            if (!TextUtils.isEmpty((CharSequence)stagingURL) && !TextUtils.isEmpty((CharSequence)stagingAccessToken)) {
                this.eventsURL = stagingURL;
                this.accessToken = accessToken;
                this.stagingEnv = true;
            }
            String appIdentifier = this.getApplicationIdentifier();
            if (TextUtils.equals((CharSequence)this.userAgent, (CharSequence)"MapboxEventsAndroid/4.2.1") && !TextUtils.isEmpty((CharSequence)appIdentifier)) {
                this.userAgent = Util.toHumanReadableAscii((String)String.format(MapboxConstants.MAPBOX_LOCALE, "%s %s", appIdentifier, this.userAgent));
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error Trying to load Staging Credentials: " + e.toString()));
        }
        IntentFilter iFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        this.batteryStatus = context.registerReceiver(null, iFilter);
        this.initialized = true;
    }

    public static MapboxEventManager getMapboxEventManager() {
        if (mapboxEventManager == null) {
            mapboxEventManager = new MapboxEventManager();
        }
        return mapboxEventManager;
    }

    private void validateTelemetryServiceConfigured() {
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 4);
            if (packageInfo.services != null) {
                for (ServiceInfo service : packageInfo.services) {
                    if (!TextUtils.equals((CharSequence)"com.mapbox.mapboxsdk.telemetry.TelemetryService", (CharSequence)service.name)) continue;
                    return;
                }
            }
        }
        catch (Exception e) {
            Log.w((String)"MapboxMap", (String)("Error checking for Telemetry Service Config: " + e));
        }
        throw new TelemetryServiceNotConfiguredException();
    }

    public static String generateCreateDate() {
        return dateFormat.format(new Date());
    }

    public boolean isTelemetryEnabled() {
        return this.telemetryEnabled;
    }

    public void setTelemetryEnabled(boolean telemetryEnabled) {
        Log.i((String)TAG, (String)("setTelemetryEnabled(); this.telemetryEnabled = " + this.telemetryEnabled + "; telemetryEnabled = " + telemetryEnabled));
        if (this.telemetryEnabled == telemetryEnabled) {
            Log.d((String)TAG, (String)"No need to start / stop telemetry as it's already in that state.");
            return;
        }
        if (telemetryEnabled) {
            Log.d((String)TAG, (String)"Starting Telemetry Up!");
            this.context.startService(new Intent(this.context, TelemetryService.class));
            if (LocationServices.getLocationServices(this.context).areLocationPermissionsGranted()) {
                Log.i((String)TAG, (String)"Permissions are good, see if GPS is enabled and if not then setup Ambient.");
                if (LocationServices.getLocationServices(this.context).isGPSEnabled()) {
                    LocationServices.getLocationServices(this.context).toggleGPS(false);
                }
            } else {
                Log.i((String)TAG, (String)"Permissions are not good.  Need to do some looping to check on stuff.");
                final Handler permsHandler = new Handler();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (LocationServices.getLocationServices(MapboxEventManager.this.context).areLocationPermissionsGranted()) {
                            Log.i((String)MapboxEventManager.TAG, (String)"Permissions finally granted, so starting Ambient if GPS isn't already enabled");
                            if (LocationServices.getLocationServices(MapboxEventManager.this.context).isGPSEnabled()) {
                                LocationServices.getLocationServices(MapboxEventManager.this.context).toggleGPS(false);
                            }
                        } else {
                            Log.i((String)MapboxEventManager.TAG, (String)"Permissions not granted yet... let's try again in 30 seconds");
                            permsHandler.postDelayed((Runnable)this, 30000L);
                        }
                    }
                };
                permsHandler.postDelayed(runnable, 10000L);
            }
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new FlushEventsTimerTask(), flushDelayInitialInMillis, flushDelayInMillis);
        } else {
            Log.d((String)TAG, (String)"Shutting Telemetry Down");
            this.events.removeAllElements();
            this.context.stopService(new Intent(this.context, TelemetryService.class));
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
        this.telemetryEnabled = telemetryEnabled;
        SharedPreferences prefs = this.context.getSharedPreferences("MapboxSharedPreferences", 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean("mapboxTelemetryEnabled", telemetryEnabled);
        editor.apply();
        editor.commit();
    }

    void flushEventsQueueImmediately() {
        Log.i((String)TAG, (String)"flushEventsQueueImmediately() called...");
        new FlushTheEventsTask().execute(new Void[0]);
    }

    private void putEventOnQueue(@NonNull Hashtable<String, Object> event) {
        if (event == null) {
            return;
        }
        this.events.add(event);
        if (this.events.size() == 1000) {
            Log.d((String)TAG, (String)"eventsSize == flushCap so send data.");
            this.flushEventsQueueImmediately();
        }
    }

    public void addLocationEvent(Location location) {
        if (Double.isNaN(location.getLatitude()) || Double.isNaN(location.getLongitude()) || Double.isNaN(location.getAltitude()) || Float.isNaN(location.getAccuracy())) {
            return;
        }
        if (Double.isInfinite(location.getLatitude()) || Double.isInfinite(location.getLongitude()) || Double.isInfinite(location.getAltitude()) || Float.isInfinite(location.getAccuracy())) {
            return;
        }
        Hashtable<String, Object> event = new Hashtable<String, Object>();
        event.put("event", "location");
        event.put("created", MapboxEventManager.generateCreateDate());
        event.put("source", "mapbox");
        event.put("sessionId", this.encodeString(this.mapboxSessionId));
        event.put("lat", Math.floor(location.getLatitude() * 1.0E7) / 1.0E7);
        event.put("lng", Math.floor(location.getLongitude() * 1.0E7) / 1.0E7);
        event.put("altitude", location.getAltitude());
        event.put("horizontalAccuracy", Math.round(location.getAccuracy()));
        event.put("operatingSystem", this.operatingSystem);
        event.put("applicationState", this.getApplicationState());
        this.putEventOnQueue(event);
        this.rotateSessionId();
    }

    public void pushEvent(Hashtable<String, Object> eventWithAttributes) {
        if (this.context == null || this.accessToken == null) {
            return;
        }
        if (eventWithAttributes == null) {
            return;
        }
        String eventType = (String)eventWithAttributes.get("event");
        if (TextUtils.isEmpty((CharSequence)eventType)) {
            return;
        }
        if (eventType.equalsIgnoreCase("map.load")) {
            eventWithAttributes.put("userId", this.mapboxVendorId);
            eventWithAttributes.put("model", Build.MODEL);
            eventWithAttributes.put("operatingSystem", this.operatingSystem);
            eventWithAttributes.put("resolution", Float.valueOf(this.displayMetrics.density));
            eventWithAttributes.put("accessibilityFontScale", Float.valueOf(this.getAccesibilityFontScaleSize()));
            eventWithAttributes.put("orientation", this.getOrientation());
            eventWithAttributes.put("batteryLevel", this.getBatteryLevel());
            eventWithAttributes.put("pluggedIn", this.isPluggedIn());
            eventWithAttributes.put("carrier", this.getCellularCarrier());
            eventWithAttributes.put("cellularNetworkType", this.getCellularNetworkType());
            eventWithAttributes.put("wifi", this.getConnectedToWifi());
            this.putEventOnQueue(eventWithAttributes);
            this.pushTurnstileEvent();
            return;
        }
        if (eventType.equalsIgnoreCase("map.click")) {
            eventWithAttributes.put("orientation", this.getOrientation());
            eventWithAttributes.put("batteryLevel", this.getBatteryLevel());
            eventWithAttributes.put("pluggedIn", this.isPluggedIn());
            eventWithAttributes.put("carrier", this.getCellularCarrier());
            eventWithAttributes.put("cellularNetworkType", this.getCellularNetworkType());
            eventWithAttributes.put("wifi", this.getConnectedToWifi());
        } else if (eventType.equalsIgnoreCase("map.dragend")) {
            eventWithAttributes.put("orientation", this.getOrientation());
            eventWithAttributes.put("batteryLevel", this.getBatteryLevel());
            eventWithAttributes.put("pluggedIn", this.isPluggedIn());
            eventWithAttributes.put("carrier", this.getCellularCarrier());
            eventWithAttributes.put("cellularNetworkType", this.getCellularNetworkType());
            eventWithAttributes.put("wifi", this.getConnectedToWifi());
        } else {
            Log.w((String)TAG, (String)"This is not an event type in the Events Data Model.");
            return;
        }
        this.putEventOnQueue(eventWithAttributes);
    }

    private void pushTurnstileEvent() {
        Hashtable<String, Object> event = new Hashtable<String, Object>();
        event.put("event", "appUserTurnstile");
        event.put("created", MapboxEventManager.generateCreateDate());
        event.put("userId", this.mapboxVendorId);
        event.put("enabled.telemetry", this.telemetryEnabled);
        this.events.add(event);
        this.flushEventsQueueImmediately();
        Log.d((String)TAG, (String)"turnstile event pushed.");
    }

    private String encodeString(String string2) {
        try {
            if (messageDigest != null) {
                messageDigest.reset();
                messageDigest.update(string2.getBytes("UTF-8"));
                byte[] bytes = messageDigest.digest();
                StringBuilder sb = new StringBuilder();
                for (byte b : bytes) {
                    sb.append(String.format("%02X", b));
                }
                String hex = sb.toString();
                return hex;
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Error encoding string, will return in original form." + e));
        }
        return string2;
    }

    private void rotateSessionId() {
        long now = System.currentTimeMillis();
        if (TextUtils.isEmpty((CharSequence)this.mapboxSessionId) || now - this.mapboxSessionIdLastSet > 24L * hourInMillis) {
            this.mapboxSessionId = UUID.randomUUID().toString();
            this.mapboxSessionIdLastSet = System.currentTimeMillis();
        }
    }

    private String getOrientation() {
        switch (this.context.getResources().getConfiguration().orientation) {
            case 2: {
                return "Landscape";
            }
            case 1: {
                return "Portrait";
            }
        }
        return "";
    }

    private int getBatteryLevel() {
        int level = this.batteryStatus.getIntExtra("level", -1);
        int scale = this.batteryStatus.getIntExtra("scale", -1);
        return Math.round((float)level / (float)scale * 100.0f);
    }

    private boolean isPluggedIn() {
        int chargePlug = this.batteryStatus.getIntExtra("plugged", -1);
        return chargePlug == 2 || chargePlug == 1;
    }

    private String getApplicationState() {
        ActivityManager activityManager = (ActivityManager)this.context.getSystemService("activity");
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return "";
        }
        String packageName = this.context.getPackageName();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (appProcess.importance != 100 || !appProcess.processName.equals(packageName)) continue;
            return "Foreground";
        }
        return "Background";
    }

    private float getAccesibilityFontScaleSize() {
        return this.context.getResources().getConfiguration().fontScale;
    }

    private String getCellularCarrier() {
        TelephonyManager manager = (TelephonyManager)this.context.getSystemService("phone");
        String carrierName = manager.getNetworkOperatorName();
        if (TextUtils.isEmpty((CharSequence)carrierName)) {
            carrierName = "";
        }
        return carrierName;
    }

    private String getCellularNetworkType() {
        TelephonyManager manager = (TelephonyManager)this.context.getSystemService("phone");
        switch (manager.getNetworkType()) {
            case 7: {
                return "1xRTT";
            }
            case 4: {
                return "CDMA";
            }
            case 2: {
                return "EDGE";
            }
            case 14: {
                return "EHRPD";
            }
            case 5: {
                return "EVDO_0";
            }
            case 6: {
                return "EVDO_A";
            }
            case 12: {
                return "EVDO_B";
            }
            case 1: {
                return "GPRS";
            }
            case 8: {
                return "HSDPA";
            }
            case 10: {
                return "HSPA";
            }
            case 15: {
                return "HSPAP";
            }
            case 9: {
                return "HSUPA";
            }
            case 11: {
                return "IDEN";
            }
            case 13: {
                return "LTE";
            }
            case 3: {
                return "UMTS";
            }
            case 0: {
                return "Unknown";
            }
        }
        return "";
    }

    public Boolean getConnectedToWifi() {
        Boolean status = false;
        WifiManager wifiMgr = (WifiManager)this.context.getSystemService("wifi");
        if (wifiMgr.isWifiEnabled()) {
            try {
                WifiInfo wifiInfo = wifiMgr.getConnectionInfo();
                if (wifiInfo.getNetworkId() != -1) {
                    status = true;
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)("Error getting Wifi Connection Status: " + e));
                status = false;
            }
        }
        return status;
    }

    private String getApplicationIdentifier() {
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            return String.format(MapboxConstants.MAPBOX_LOCALE, "%s/%s/%s", this.context.getPackageName(), packageInfo.versionName, packageInfo.versionCode);
        }
        catch (Exception e) {
            return "";
        }
    }

    private class FlushEventsTimerTask
    extends TimerTask {
        private FlushEventsTimerTask() {
        }

        @Override
        public void run() {
            new FlushTheEventsTask().execute(new Void[0]);
        }
    }

    private class FlushTheEventsTask
    extends AsyncTask<Void, Void, Void> {
        private FlushTheEventsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void doInBackground(Void ... voids) {
            if (MapboxEventManager.this.events.isEmpty()) {
                Log.d((String)MapboxEventManager.TAG, (String)"No events in the queue to send so returning.");
                return null;
            }
            if (!MapboxAccountManager.getInstance().isConnected().booleanValue()) {
                Log.w((String)MapboxEventManager.TAG, (String)"Not connected to network, so empty events cache and return without attempting to send events");
                MapboxEventManager.this.events.removeAllElements();
                return null;
            }
            Response response = null;
            try {
                JSONArray jsonArray = new JSONArray();
                Vector eventsClone = (Vector)MapboxEventManager.this.events.clone();
                for (Hashtable evt : eventsClone) {
                    String eventType;
                    String appState;
                    String carrier;
                    String orientation;
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.putOpt("event", evt.get("event"));
                    jsonObject.putOpt("created", evt.get("created"));
                    jsonObject.putOpt("userId", evt.get("userId"));
                    jsonObject.putOpt("enabled.telemetry", evt.get("enabled.telemetry"));
                    jsonObject.putOpt("source", evt.get("source"));
                    jsonObject.putOpt("sessionId", evt.get("sessionId"));
                    jsonObject.putOpt("lat", evt.get("lat"));
                    if (evt.containsKey("lng")) {
                        double lon = (Double)evt.get("lng");
                        if (lon < -180.0 || lon > 180.0) {
                            lon = MathUtils.wrap(lon, -180.0, 180.0);
                        }
                        jsonObject.put("lng", lon);
                    }
                    jsonObject.putOpt("altitude", evt.get("altitude"));
                    jsonObject.putOpt("zoom", evt.get("zoom"));
                    jsonObject.putOpt("operatingSystem", evt.get("operatingSystem"));
                    jsonObject.putOpt("userId", evt.get("userId"));
                    jsonObject.putOpt("model", evt.get("model"));
                    jsonObject.putOpt("resolution", evt.get("resolution"));
                    jsonObject.putOpt("accessibilityFontScale", evt.get("accessibilityFontScale"));
                    jsonObject.putOpt("batteryLevel", evt.get("batteryLevel"));
                    jsonObject.putOpt("pluggedIn", evt.get("pluggedIn"));
                    jsonObject.putOpt("wifi", evt.get("wifi"));
                    if (evt.containsKey("orientation") && !TextUtils.isEmpty((CharSequence)(orientation = (String)evt.get("orientation")))) {
                        jsonObject.putOpt("orientation", (Object)orientation);
                    }
                    if (evt.containsKey("carrier") && !TextUtils.isEmpty((CharSequence)(carrier = (String)evt.get("carrier")))) {
                        jsonObject.putOpt("carrier", (Object)carrier);
                    }
                    if (evt.containsKey("applicationState") && !TextUtils.isEmpty((CharSequence)(appState = (String)evt.get("applicationState")))) {
                        jsonObject.putOpt("applicationState", evt.get("applicationState"));
                    }
                    if (!TextUtils.isEmpty((CharSequence)(eventType = (String)evt.get("event"))) && eventType.equalsIgnoreCase("map.click")) {
                        jsonObject.put("gesture", evt.get("gesture"));
                    }
                    if (evt.containsKey("cellularNetworkType")) {
                        String cellularNetworkType = (String)evt.get("cellularNetworkType");
                        if (TextUtils.isEmpty((CharSequence)cellularNetworkType)) {
                            jsonObject.put("cellularNetworkType", null);
                        } else {
                            jsonObject.put("cellularNetworkType", evt.get("cellularNetworkType"));
                        }
                    }
                    jsonArray.put((Object)jsonObject);
                }
                CertificatePinner.Builder certificatePinnerBuilder = new CertificatePinner.Builder();
                if (MapboxEventManager.this.stagingEnv) {
                    certificatePinnerBuilder.add("cloudfront-staging.tilestream.net", new String[]{"sha256/3euxrJOrEZI15R4104UsiAkDqe007EPyZ6eTL/XxdAY="}).add("cloudfront-staging.tilestream.net", new String[]{"sha256/5kJvNEMw0KjrCAu7eXY5HZdvyCS13BbA0VJG1RSP91w="}).add("cloudfront-staging.tilestream.net", new String[]{"sha256/r/mIkG3eEpVdm+u/ko/cwxzOMo1bk4TyHIlByibiA5E="});
                } else {
                    certificatePinnerBuilder.add("events.mapbox.com", new String[]{"sha256/BhynraKizavqoC5U26qgYuxLZst6pCu9J5stfL6RSYY="}).add("events.mapbox.com", new String[]{"sha256/owrR9U9FWDWtrFF+myoRIu75JwU4sJwzvhCNLZoY37g="}).add("events.mapbox.com", new String[]{"sha256/SQVGZiOrQXi+kqxcvWWE96HhfydlLVqFr4lQTqI5qqo="}).add("events.mapbox.com", new String[]{"sha256/Tb0uHZ/KQjWh8N9+CZFLc4zx36LONQ55l6laDi1qtT4="}).add("events.mapbox.com", new String[]{"sha256/RRM1dGqnDFsCJXBTHky16vi1obOlCgFFn/yOhI/y+ho="}).add("events.mapbox.com", new String[]{"sha256/WoiWRyIOVNa9ihaBciRSC7XHjliYS9VwUGOIud4PB18="});
                }
                OkHttpClient client = new OkHttpClient.Builder().certificatePinner(certificatePinnerBuilder.build()).addInterceptor((Interceptor)new GzipRequestInterceptor()).build();
                RequestBody body = RequestBody.create((MediaType)JSON, (String)jsonArray.toString());
                String url = MapboxEventManager.this.eventsURL + "/events/v2?access_token=" + MapboxEventManager.this.accessToken;
                Request request = new Request.Builder().url(url).header("User-Agent", MapboxEventManager.this.userAgent).post(body).build();
                response = client.newCall(request).execute();
                Log.d((String)MapboxEventManager.TAG, (String)("response code = " + response.code() + " for events " + MapboxEventManager.this.events.size()));
            }
            catch (Exception e) {
                Log.e((String)MapboxEventManager.TAG, (String)("FlushTheEventsTask borked: " + e));
                e.printStackTrace();
            }
            finally {
                if (response != null && response.body() != null) {
                    response.body().close();
                }
                MapboxEventManager.this.events.removeAllElements();
            }
            return null;
        }
    }
}

