/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.sources;

import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.services.commons.geojson.FeatureCollection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public class GeoJsonSource
extends Source {
    public GeoJsonSource(long nativePtr) {
        super(nativePtr);
    }

    public GeoJsonSource(String id) {
        this.initialize(id, null);
        this.setGeoJson(FeatureCollection.fromFeatures(new ArrayList()));
    }

    public GeoJsonSource(String id, GeoJsonOptions options) {
        this.initialize(id, options);
        this.setGeoJson(FeatureCollection.fromFeatures(new ArrayList()));
    }

    public GeoJsonSource(String id, String geoJson) {
        if (geoJson == null || geoJson.startsWith("http")) {
            throw new IllegalArgumentException("Expected a raw json body");
        }
        this.initialize(id, null);
        this.setGeoJson(geoJson);
    }

    public GeoJsonSource(String id, String geoJson, GeoJsonOptions options) {
        if (geoJson == null || geoJson.startsWith("http")) {
            throw new IllegalArgumentException("Expected a raw json body");
        }
        this.initialize(id, options);
        this.setGeoJson(geoJson);
    }

    public GeoJsonSource(String id, URL url) {
        this.initialize(id, null);
        this.nativeSetUrl(url.toExternalForm());
    }

    public GeoJsonSource(String id, URL url, GeoJsonOptions options) {
        this.initialize(id, options);
        this.nativeSetUrl(url.toExternalForm());
    }

    public GeoJsonSource(String id, FeatureCollection features) {
        this.initialize(id, null);
        this.setGeoJson(features);
    }

    public GeoJsonSource(String id, FeatureCollection features, GeoJsonOptions options) {
        this.initialize(id, options);
        this.setGeoJson(features);
    }

    public void setGeoJson(FeatureCollection features) {
        this.checkValidity();
        this.setGeoJson(features.toJson());
    }

    public void setGeoJson(String json) {
        this.checkValidity();
        this.setRawJson(json);
    }

    public void setUrl(URL url) {
        this.checkValidity();
        this.setUrl(url.toExternalForm());
    }

    public void setUrl(String url) {
        this.checkValidity();
        this.nativeSetUrl(url);
    }

    protected void setRawJson(String geoJson) {
        HashMap<String, String> wrapper = new HashMap<String, String>();
        wrapper.put("data", geoJson);
        this.nativeSetGeoJson(wrapper);
    }

    protected native void initialize(String var1, Object var2);

    protected native void nativeSetUrl(String var1);

    private native void nativeSetGeoJson(Object var1);

    protected native void finalize() throws Throwable;
}

