/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.mapbox.mapboxsdk.MapboxAccountManager;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.exceptions.InvalidAccessTokenException;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.OnMapReadyCallback;

public class SupportMapFragment
extends Fragment {
    private MapView map;
    private OnMapReadyCallback onMapReadyCallback;

    public static SupportMapFragment newInstance() {
        return new SupportMapFragment();
    }

    public static SupportMapFragment newInstance(@Nullable MapboxMapOptions mapboxMapOptions) {
        SupportMapFragment mapFragment = new SupportMapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapboxMapOptions", (Parcelable)mapboxMapOptions);
        mapFragment.setArguments(bundle);
        return mapFragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        Context context = inflater.getContext();
        MapboxMapOptions options = null;
        Bundle bundle = this.getArguments();
        if (bundle != null && bundle.containsKey("MapboxMapOptions")) {
            options = (MapboxMapOptions)bundle.getParcelable("MapboxMapOptions");
        }
        if (options == null || options.getAccessToken() == null) {
            String token = null;
            token = MapboxAccountManager.getInstance() != null ? MapboxAccountManager.getInstance().getAccessToken() : this.getToken(inflater.getContext());
            if (TextUtils.isEmpty((CharSequence)token)) {
                throw new InvalidAccessTokenException();
            }
            if (options == null) {
                options = new MapboxMapOptions().accessToken(token);
            } else {
                options.accessToken(token);
            }
        }
        Drawable foregroundDrawable = options.getMyLocationForegroundDrawable();
        Drawable foregroundBearingDrawable = options.getMyLocationForegroundBearingDrawable();
        if (foregroundDrawable == null || foregroundBearingDrawable == null) {
            if (foregroundDrawable == null) {
                foregroundDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_mylocationview_normal);
            }
            if (foregroundBearingDrawable == null) {
                foregroundBearingDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_mylocationview_bearing);
            }
            options.myLocationForegroundDrawables(foregroundDrawable, foregroundBearingDrawable);
        }
        if (options.getMyLocationBackgroundDrawable() == null) {
            options.myLocationBackgroundDrawable(ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_mylocationview_background));
        }
        this.map = new MapView(inflater.getContext(), options);
        return this.map;
    }

    @Deprecated
    private String getToken(@NonNull Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            String token = appInfo.metaData.getString("com.mapbox.AccessToken");
            if (token == null || token.isEmpty()) {
                throw new IllegalArgumentException();
            }
            return token;
        }
        catch (Exception exception) {
            int tokenResId = context.getResources().getIdentifier("mapbox_access_token", "string", context.getPackageName());
            return tokenResId != 0 ? context.getString(tokenResId) : null;
        }
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.map.onCreate(savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.map.getMapAsync(this.onMapReadyCallback);
    }

    public void onResume() {
        super.onResume();
        this.map.onResume();
    }

    public void onPause() {
        super.onPause();
        this.map.onPause();
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        this.map.onSaveInstanceState(outState);
    }

    public void onStop() {
        super.onStop();
    }

    public void onLowMemory() {
        super.onLowMemory();
        this.map.onLowMemory();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.map.onDestroy();
    }

    public void getMapAsync(@NonNull OnMapReadyCallback onMapReadyCallback) {
        this.onMapReadyCallback = onMapReadyCallback;
    }
}

