/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.UiSettings;

public class TrackingSettings {
    private MapView mapView;
    private UiSettings uiSettings;
    private boolean dismissTrackingOnGesture = true;
    private int mMyLocationTrackingMode;
    private int mMyBearingTrackingMode;

    TrackingSettings(@NonNull MapView mapView, UiSettings uiSettings) {
        this.mapView = mapView;
        this.uiSettings = uiSettings;
    }

    @UiThread
    public void setMyLocationTrackingMode(int myLocationTrackingMode) {
        this.mMyLocationTrackingMode = myLocationTrackingMode;
        this.mapView.setMyLocationTrackingMode(myLocationTrackingMode);
        this.validateGesturesForTrackingModes();
    }

    @UiThread
    public int getMyLocationTrackingMode() {
        return this.mMyLocationTrackingMode;
    }

    @UiThread
    public void setMyBearingTrackingMode(int myBearingTrackingMode) {
        this.mMyBearingTrackingMode = myBearingTrackingMode;
        this.mapView.setMyBearingTrackingMode(myBearingTrackingMode);
    }

    @UiThread
    public int getMyBearingTrackingMode() {
        return this.mMyBearingTrackingMode;
    }

    public boolean isDismissTrackingOnGesture() {
        return this.dismissTrackingOnGesture;
    }

    public void setDismissTrackingOnGesture(boolean dismissTrackingOnGesture) {
        this.dismissTrackingOnGesture = dismissTrackingOnGesture;
        this.validateGesturesForTrackingModes();
    }

    private void validateGesturesForTrackingModes() {
        if (!this.dismissTrackingOnGesture) {
            int myLocationTrackingMode = this.getMyLocationTrackingMode();
            int myBearingTrackingMode = this.getMyBearingTrackingMode();
            if (myLocationTrackingMode == 0) {
                this.uiSettings.setScrollGesturesEnabled(true);
                this.uiSettings.setRotateGesturesEnabled(true);
            } else {
                this.uiSettings.setScrollGesturesEnabled(false);
                this.uiSettings.setRotateGesturesEnabled(myBearingTrackingMode == 0);
            }
        }
    }

    public boolean isLocationTrackingDisabled() {
        return this.mMyLocationTrackingMode == 0;
    }
}

