/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.camera.CameraPosition;

public class MapboxMapOptions
implements Parcelable {
    private static final float DIMENSION_SEVEN_DP = 7.0f;
    private static final float DIMENSION_TEN_DP = 10.0f;
    private static final float DIMENSION_SIXTEEN_DP = 16.0f;
    private static final float DIMENSION_SEVENTY_SIX_DP = 76.0f;
    private CameraPosition cameraPosition;
    private boolean debugActive;
    private boolean compassEnabled = true;
    private int compassGravity = 8388661;
    private int[] compassMargins;
    private boolean logoEnabled = true;
    private int logoGravity = 8388691;
    private int[] logoMargins;
    private boolean attributionEnabled = true;
    private int attributionGravity = 80;
    private int[] attributionMargins;
    private float minZoom = 0.0f;
    private float maxZoom = 25.5f;
    private boolean rotateGesturesEnabled = true;
    private boolean scrollGesturesEnabled = true;
    private boolean tiltGesturesEnabled = true;
    private boolean zoomGesturesEnabled = true;
    private boolean zoomControlsEnabled = false;
    private boolean locationEnabled;
    private String style;
    private String accessToken;
    public static final Parcelable.Creator<MapboxMapOptions> CREATOR = new Parcelable.Creator<MapboxMapOptions>(){

        public MapboxMapOptions createFromParcel(Parcel in) {
            return new MapboxMapOptions(in);
        }

        public MapboxMapOptions[] newArray(int size) {
            return new MapboxMapOptions[size];
        }
    };

    public MapboxMapOptions() {
    }

    private MapboxMapOptions(Parcel in) {
        this.cameraPosition = (CameraPosition)in.readParcelable(CameraPosition.class.getClassLoader());
        this.debugActive = in.readByte() != 0;
        this.compassEnabled = in.readByte() != 0;
        this.compassGravity = in.readInt();
        this.compassMargins = in.createIntArray();
        this.logoEnabled = in.readByte() != 0;
        this.logoGravity = in.readInt();
        this.logoMargins = in.createIntArray();
        this.attributionEnabled = in.readByte() != 0;
        this.attributionGravity = in.readInt();
        this.attributionMargins = in.createIntArray();
        this.minZoom = in.readFloat();
        this.maxZoom = in.readFloat();
        this.rotateGesturesEnabled = in.readByte() != 0;
        this.scrollGesturesEnabled = in.readByte() != 0;
        this.tiltGesturesEnabled = in.readByte() != 0;
        this.zoomControlsEnabled = in.readByte() != 0;
        this.zoomGesturesEnabled = in.readByte() != 0;
        this.locationEnabled = in.readByte() != 0;
        this.style = in.readString();
        this.accessToken = in.readString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MapboxMapOptions createFromAttributes(@NonNull Context context, @Nullable AttributeSet attrs) {
        MapboxMapOptions mapboxMapOptions = new MapboxMapOptions();
        float screenDensity = context.getResources().getDisplayMetrics().density;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MapView, 0, 0);
        try {
            mapboxMapOptions.debugActive(typedArray.getBoolean(R.styleable.MapView_debug_active, false));
            mapboxMapOptions.camera(new CameraPosition.Builder(typedArray).build());
            mapboxMapOptions.accessToken(typedArray.getString(R.styleable.MapView_access_token));
            mapboxMapOptions.styleUrl(typedArray.getString(R.styleable.MapView_style_url));
            mapboxMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapView_zoom_enabled, true));
            mapboxMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapView_scroll_enabled, true));
            mapboxMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapView_rotate_enabled, true));
            mapboxMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapView_tilt_enabled, true));
            mapboxMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapView_zoom_controls_enabled, false));
            mapboxMapOptions.maxZoom(typedArray.getFloat(R.styleable.MapView_zoom_max, 25.5f));
            mapboxMapOptions.minZoom(typedArray.getFloat(R.styleable.MapView_zoom_min, 0.0f));
            mapboxMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapView_compass_enabled, true));
            mapboxMapOptions.compassGravity(typedArray.getInt(R.styleable.MapView_compass_gravity, 8388661));
            mapboxMapOptions.compassMargins(new int[]{(int)(typedArray.getDimension(R.styleable.MapView_compass_margin_left, 10.0f) * screenDensity), (int)typedArray.getDimension(R.styleable.MapView_compass_margin_top, 10.0f * screenDensity), (int)typedArray.getDimension(R.styleable.MapView_compass_margin_right, 10.0f * screenDensity), (int)typedArray.getDimension(R.styleable.MapView_compass_margin_bottom, 10.0f * screenDensity)});
            mapboxMapOptions.logoEnabled(typedArray.getBoolean(R.styleable.MapView_logo_enabled, true));
            mapboxMapOptions.logoGravity(typedArray.getInt(R.styleable.MapView_logo_gravity, 8388691));
            mapboxMapOptions.logoMargins(new int[]{(int)(typedArray.getDimension(R.styleable.MapView_logo_margin_left, 16.0f) * screenDensity), (int)(typedArray.getDimension(R.styleable.MapView_logo_margin_top, 16.0f) * screenDensity), (int)(typedArray.getDimension(R.styleable.MapView_logo_margin_right, 16.0f) * screenDensity), (int)(typedArray.getDimension(R.styleable.MapView_logo_margin_bottom, 16.0f) * screenDensity)});
            mapboxMapOptions.attributionEnabled(typedArray.getBoolean(R.styleable.MapView_attribution_enabled, true));
            mapboxMapOptions.attributionGravity(typedArray.getInt(R.styleable.MapView_attribution_gravity, 80));
            mapboxMapOptions.attributionMargins(new int[]{(int)(typedArray.getDimension(R.styleable.MapView_attribution_margin_left, 76.0f) * screenDensity), (int)(typedArray.getDimension(R.styleable.MapView_attribution_margin_top, 7.0f) * screenDensity), (int)(typedArray.getDimension(R.styleable.MapView_attribution_margin_right, 7.0f) * screenDensity), (int)(typedArray.getDimension(R.styleable.MapView_attribution_margin_bottom, 7.0f) * screenDensity)});
            mapboxMapOptions.locationEnabled(typedArray.getBoolean(R.styleable.MapView_my_location_enabled, false));
        }
        finally {
            typedArray.recycle();
        }
        return mapboxMapOptions;
    }

    public MapboxMapOptions camera(CameraPosition cameraPosition) {
        this.cameraPosition = cameraPosition;
        return this;
    }

    public MapboxMapOptions accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public MapboxMapOptions styleUrl(String styleUrl) {
        this.style = styleUrl;
        return this;
    }

    public MapboxMapOptions debugActive(boolean enabled) {
        this.debugActive = enabled;
        return this;
    }

    public MapboxMapOptions minZoom(float minZoom) {
        this.minZoom = minZoom;
        return this;
    }

    public MapboxMapOptions maxZoom(float maxZoom) {
        this.maxZoom = maxZoom;
        return this;
    }

    public MapboxMapOptions compassEnabled(boolean enabled) {
        this.compassEnabled = enabled;
        return this;
    }

    public MapboxMapOptions compassGravity(int gravity) {
        this.compassGravity = gravity;
        return this;
    }

    public MapboxMapOptions compassMargins(int[] margins) {
        this.compassMargins = margins;
        return this;
    }

    public MapboxMapOptions logoEnabled(boolean enabled) {
        this.logoEnabled = enabled;
        return this;
    }

    public MapboxMapOptions logoGravity(int gravity) {
        this.logoGravity = gravity;
        return this;
    }

    public MapboxMapOptions logoMargins(int[] margins) {
        this.logoMargins = margins;
        return this;
    }

    public MapboxMapOptions attributionEnabled(boolean enabled) {
        this.attributionEnabled = enabled;
        return this;
    }

    public MapboxMapOptions attributionGravity(int gravity) {
        this.attributionGravity = gravity;
        return this;
    }

    public MapboxMapOptions attributionMargins(int[] margins) {
        this.attributionMargins = margins;
        return this;
    }

    public MapboxMapOptions rotateGesturesEnabled(boolean enabled) {
        this.rotateGesturesEnabled = enabled;
        return this;
    }

    public MapboxMapOptions scrollGesturesEnabled(boolean enabled) {
        this.scrollGesturesEnabled = enabled;
        return this;
    }

    public MapboxMapOptions tiltGesturesEnabled(boolean enabled) {
        this.tiltGesturesEnabled = enabled;
        return this;
    }

    public MapboxMapOptions zoomControlsEnabled(boolean enabled) {
        this.zoomControlsEnabled = enabled;
        return this;
    }

    public MapboxMapOptions zoomGesturesEnabled(boolean enabled) {
        this.zoomGesturesEnabled = enabled;
        return this;
    }

    public MapboxMapOptions locationEnabled(boolean locationEnabled) {
        this.locationEnabled = locationEnabled;
        return this;
    }

    public CameraPosition getCamera() {
        return this.cameraPosition;
    }

    public float getMinZoom() {
        return this.minZoom;
    }

    public float getMaxZoom() {
        return this.maxZoom;
    }

    public boolean getCompassEnabled() {
        return this.compassEnabled;
    }

    public int getCompassGravity() {
        return this.compassGravity;
    }

    public int[] getCompassMargins() {
        return this.compassMargins;
    }

    public boolean getLogoEnabled() {
        return this.logoEnabled;
    }

    public int getLogoGravity() {
        return this.logoGravity;
    }

    public int[] getLogoMargins() {
        return this.logoMargins;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getStyle() {
        return this.style;
    }

    public boolean getRotateGesturesEnabled() {
        return this.rotateGesturesEnabled;
    }

    public boolean getScrollGesturesEnabled() {
        return this.scrollGesturesEnabled;
    }

    public boolean getTiltGesturesEnabled() {
        return this.tiltGesturesEnabled;
    }

    public boolean getZoomControlsEnabled() {
        return this.zoomControlsEnabled;
    }

    public boolean getZoomGesturesEnabled() {
        return this.zoomGesturesEnabled;
    }

    public boolean getAttributionEnabled() {
        return this.attributionEnabled;
    }

    public int getAttributionGravity() {
        return this.attributionGravity;
    }

    public int[] getAttributionMargins() {
        return this.attributionMargins;
    }

    public boolean getLocationEnabled() {
        return this.locationEnabled;
    }

    public boolean getDebugActive() {
        return this.debugActive;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.cameraPosition, flags);
        dest.writeByte((byte)(this.debugActive ? 1 : 0));
        dest.writeByte((byte)(this.compassEnabled ? 1 : 0));
        dest.writeInt(this.compassGravity);
        dest.writeIntArray(this.compassMargins);
        dest.writeByte((byte)(this.logoEnabled ? 1 : 0));
        dest.writeInt(this.logoGravity);
        dest.writeIntArray(this.logoMargins);
        dest.writeByte((byte)(this.attributionEnabled ? 1 : 0));
        dest.writeInt(this.attributionGravity);
        dest.writeIntArray(this.attributionMargins);
        dest.writeFloat(this.minZoom);
        dest.writeFloat(this.maxZoom);
        dest.writeByte((byte)(this.rotateGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.scrollGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.tiltGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.zoomControlsEnabled ? 1 : 0));
        dest.writeByte((byte)(this.zoomGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.locationEnabled ? 1 : 0));
        dest.writeString(this.style);
        dest.writeString(this.accessToken);
    }
}

