/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Build;
import android.view.Surface;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.geometry.ProjectedMeters;
import com.mapbox.mapboxsdk.layers.CustomLayer;
import com.mapbox.mapboxsdk.maps.MapView;
import java.util.List;

final class NativeMapView {
    boolean mDestroyed = false;
    private long mNativeMapViewPtr = 0L;
    private MapView mMapView;

    public NativeMapView(MapView mapView) {
        String dataPath;
        Context context = mapView.getContext();
        String cachePath = dataPath = context.getFilesDir().getAbsolutePath();
        float pixelRatio = context.getResources().getDisplayMetrics().density;
        String apkPath = context.getPackageCodePath();
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        activityManager.getMemoryInfo(memoryInfo);
        long totalMemory = memoryInfo.availMem;
        if (Build.VERSION.SDK_INT >= 16) {
            totalMemory = memoryInfo.totalMem;
        }
        if (availableProcessors < 0) {
            throw new IllegalArgumentException("availableProcessors cannot be negative.");
        }
        if (totalMemory < 0L) {
            throw new IllegalArgumentException("totalMemory cannot be negative.");
        }
        this.mMapView = mapView;
        this.mNativeMapViewPtr = this.nativeCreate(cachePath, dataPath, apkPath, pixelRatio, availableProcessors, totalMemory);
    }

    public void destroy() {
        this.nativeDestroy(this.mNativeMapViewPtr);
        this.mNativeMapViewPtr = 0L;
        this.mMapView = null;
        this.mDestroyed = true;
    }

    public boolean wasDestroyed() {
        return this.mDestroyed;
    }

    public void initializeDisplay() {
        this.nativeInitializeDisplay(this.mNativeMapViewPtr);
    }

    public void terminateDisplay() {
        this.nativeTerminateDisplay(this.mNativeMapViewPtr);
    }

    public void initializeContext() {
        this.nativeInitializeContext(this.mNativeMapViewPtr);
    }

    public void terminateContext() {
        this.nativeTerminateContext(this.mNativeMapViewPtr);
    }

    public void createSurface(Surface surface) {
        this.nativeCreateSurface(this.mNativeMapViewPtr, surface);
    }

    public void destroySurface() {
        this.nativeDestroySurface(this.mNativeMapViewPtr);
    }

    public void pause() {
        this.nativePause(this.mNativeMapViewPtr);
    }

    public boolean isPaused() {
        return this.nativeIsPaused(this.mNativeMapViewPtr);
    }

    public void resume() {
        this.nativeResume(this.mNativeMapViewPtr);
    }

    public void update() {
        this.nativeUpdate(this.mNativeMapViewPtr);
    }

    public void renderSync() {
        this.nativeRenderSync(this.mNativeMapViewPtr);
    }

    public void resizeView(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be negative.");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be negative.");
        }
        if (width > 65535) {
            throw new IllegalArgumentException("width cannot be greater than 65535.");
        }
        if (height > 65535) {
            throw new IllegalArgumentException("height cannot be greater than 65535.");
        }
        this.nativeViewResize(this.mNativeMapViewPtr, width, height);
    }

    public void resizeFramebuffer(int fbWidth, int fbHeight) {
        if (fbWidth < 0) {
            throw new IllegalArgumentException("fbWidth cannot be negative.");
        }
        if (fbHeight < 0) {
            throw new IllegalArgumentException("fbHeight cannot be negative.");
        }
        if (fbWidth > 65535) {
            throw new IllegalArgumentException("fbWidth cannot be greater than 65535.");
        }
        if (fbHeight > 65535) {
            throw new IllegalArgumentException("fbHeight cannot be greater than 65535.");
        }
        this.nativeFramebufferResize(this.mNativeMapViewPtr, fbWidth, fbHeight);
    }

    public void addClass(String clazz) {
        this.nativeAddClass(this.mNativeMapViewPtr, clazz);
    }

    public void removeClass(String clazz) {
        this.nativeRemoveClass(this.mNativeMapViewPtr, clazz);
    }

    public boolean hasClass(String clazz) {
        return this.nativeHasClass(this.mNativeMapViewPtr, clazz);
    }

    public void setClasses(List<String> classes) {
        this.nativeSetClasses(this.mNativeMapViewPtr, classes);
    }

    public List<String> getClasses() {
        return this.nativeGetClasses(this.mNativeMapViewPtr);
    }

    public void setDefaultTransitionDuration() {
        this.setDefaultTransitionDuration(0L);
    }

    public long getDefaultTransitionDuration() {
        return this.nativeGetDefaultTransitionDuration(this.mNativeMapViewPtr);
    }

    public void setDefaultTransitionDuration(long milliseconds) {
        if (milliseconds < 0L) {
            throw new IllegalArgumentException("milliseconds cannot be negative.");
        }
        this.nativeSetDefaultTransitionDuration(this.mNativeMapViewPtr, milliseconds);
    }

    public void setStyleUrl(String url) {
        this.nativeSetStyleUrl(this.mNativeMapViewPtr, url);
    }

    public void setStyleJson(String newStyleJson) {
        this.setStyleJson(newStyleJson, "");
    }

    public void setStyleJson(String newStyleJson, String base) {
        this.nativeSetStyleJson(this.mNativeMapViewPtr, newStyleJson, base);
    }

    public String getStyleJson() {
        return this.nativeGetStyleJson(this.mNativeMapViewPtr);
    }

    public void setAccessToken(String accessToken) {
        this.nativeSetAccessToken(this.mNativeMapViewPtr, accessToken);
    }

    public String getAccessToken() {
        return this.nativeGetAccessToken(this.mNativeMapViewPtr);
    }

    public void cancelTransitions() {
        this.nativeCancelTransitions(this.mNativeMapViewPtr);
    }

    public void setGestureInProgress(boolean inProgress) {
        this.nativeSetGestureInProgress(this.mNativeMapViewPtr, inProgress);
    }

    public void moveBy(double dx, double dy) {
        this.moveBy(dx, dy, 0L);
    }

    public void moveBy(double dx, double dy, long duration) {
        this.nativeMoveBy(this.mNativeMapViewPtr, dx, dy, duration);
    }

    public void setLatLng(LatLng latLng) {
        this.setLatLng(latLng, 0L);
    }

    public void setLatLng(LatLng latLng, long duration) {
        this.nativeSetLatLng(this.mNativeMapViewPtr, latLng, duration);
    }

    public LatLng getLatLng() {
        return this.nativeGetLatLng(this.mNativeMapViewPtr);
    }

    public void resetPosition() {
        this.nativeResetPosition(this.mNativeMapViewPtr);
    }

    public double getPitch() {
        return this.nativeGetPitch(this.mNativeMapViewPtr);
    }

    public void setPitch(double pitch, long duration) {
        this.nativeSetPitch(this.mNativeMapViewPtr, pitch, duration);
    }

    public void scaleBy(double ds) {
        this.scaleBy(ds, Double.NaN, Double.NaN);
    }

    public void scaleBy(double ds, double cx, double cy) {
        this.scaleBy(ds, cx, cy, 0L);
    }

    public void scaleBy(double ds, double cx, double cy, long duration) {
        this.nativeScaleBy(this.mNativeMapViewPtr, ds, cx, cy, duration);
    }

    public void setScale(double scale) {
        this.setScale(scale, Double.NaN, Double.NaN);
    }

    public void setScale(double scale, double cx, double cy) {
        this.setScale(scale, cx, cy, 0L);
    }

    public void setScale(double scale, double cx, double cy, long duration) {
        this.nativeSetScale(this.mNativeMapViewPtr, scale, cx, cy, duration);
    }

    public double getScale() {
        return this.nativeGetScale(this.mNativeMapViewPtr);
    }

    public void setZoom(double zoom) {
        this.setZoom(zoom, 0L);
    }

    public void setZoom(double zoom, long duration) {
        this.nativeSetZoom(this.mNativeMapViewPtr, zoom, duration);
    }

    public double getZoom() {
        return this.nativeGetZoom(this.mNativeMapViewPtr);
    }

    public void resetZoom() {
        this.nativeResetZoom(this.mNativeMapViewPtr);
    }

    public void setMinZoom(double zoom) {
        this.nativeSetMinZoom(this.mNativeMapViewPtr, zoom);
    }

    public double getMinZoom() {
        return this.nativeGetMinZoom(this.mNativeMapViewPtr);
    }

    public void setMaxZoom(double zoom) {
        this.nativeSetMaxZoom(this.mNativeMapViewPtr, zoom);
    }

    public double getMaxZoom() {
        return this.nativeGetMaxZoom(this.mNativeMapViewPtr);
    }

    public void rotateBy(double sx, double sy, double ex, double ey) {
        this.rotateBy(sx, sy, ex, ey, 0L);
    }

    public void rotateBy(double sx, double sy, double ex, double ey, long duration) {
        this.nativeRotateBy(this.mNativeMapViewPtr, sx, sy, ex, ey, duration);
    }

    public void setContentPadding(double top, double left, double bottom, double right) {
        this.nativeSetContentPadding(this.mNativeMapViewPtr, top, left, bottom, right);
    }

    public void setBearing(double degrees) {
        this.setBearing(degrees, 0L);
    }

    public void setBearing(double degrees, long duration) {
        this.nativeSetBearing(this.mNativeMapViewPtr, degrees, duration);
    }

    public void setBearing(double degrees, double cx, double cy) {
        this.nativeSetBearingXY(this.mNativeMapViewPtr, degrees, cx, cy);
    }

    public double getBearing() {
        return this.nativeGetBearing(this.mNativeMapViewPtr);
    }

    public void resetNorth() {
        this.nativeResetNorth(this.mNativeMapViewPtr);
    }

    public long addMarker(Marker marker) {
        return this.nativeAddMarker(this.mNativeMapViewPtr, marker);
    }

    public long[] addMarkers(List<Marker> markers) {
        return this.nativeAddMarkers(this.mNativeMapViewPtr, markers);
    }

    public long addPolyline(Polyline polyline) {
        return this.nativeAddPolyline(this.mNativeMapViewPtr, polyline);
    }

    public long[] addPolylines(List<Polyline> polylines) {
        return this.nativeAddPolylines(this.mNativeMapViewPtr, polylines);
    }

    public long addPolygon(Polygon polygon) {
        return this.nativeAddPolygon(this.mNativeMapViewPtr, polygon);
    }

    public long[] addPolygons(List<Polygon> polygon) {
        return this.nativeAddPolygons(this.mNativeMapViewPtr, polygon);
    }

    public void updateMarker(Marker marker) {
        this.nativeUpdateMarker(this.mNativeMapViewPtr, marker);
    }

    public void removeAnnotation(long id2) {
        this.nativeRemoveAnnotation(this.mNativeMapViewPtr, id2);
    }

    public void removeAnnotations(long[] ids) {
        this.nativeRemoveAnnotations(this.mNativeMapViewPtr, ids);
    }

    public long[] getAnnotationsInBounds(LatLngBounds bbox) {
        return this.nativeGetAnnotationsInBounds(this.mNativeMapViewPtr, bbox);
    }

    public void addAnnotationIcon(String symbol, int width, int height, float scale, byte[] pixels) {
        this.nativeAddAnnotationIcon(this.mNativeMapViewPtr, symbol, width, height, scale, pixels);
    }

    public void setVisibleCoordinateBounds(LatLng[] coordinates, RectF padding, double direction, long duration) {
        this.nativeSetVisibleCoordinateBounds(this.mNativeMapViewPtr, coordinates, padding, direction, duration);
    }

    public void onLowMemory() {
        this.nativeOnLowMemory(this.mNativeMapViewPtr);
    }

    public void setDebug(boolean debug) {
        this.nativeSetDebug(this.mNativeMapViewPtr, debug);
    }

    public void cycleDebugOptions() {
        this.nativeToggleDebug(this.mNativeMapViewPtr);
    }

    public boolean getDebug() {
        return this.nativeGetDebug(this.mNativeMapViewPtr);
    }

    public boolean isFullyLoaded() {
        return this.nativeIsFullyLoaded(this.mNativeMapViewPtr);
    }

    public void setReachability(boolean status) {
        this.nativeSetReachability(this.mNativeMapViewPtr, status);
    }

    public double getMetersPerPixelAtLatitude(double lat, double zoom) {
        return this.nativeGetMetersPerPixelAtLatitude(this.mNativeMapViewPtr, lat, zoom);
    }

    public ProjectedMeters projectedMetersForLatLng(LatLng latLng) {
        return this.nativeProjectedMetersForLatLng(this.mNativeMapViewPtr, latLng);
    }

    public LatLng latLngForProjectedMeters(ProjectedMeters projectedMeters) {
        return this.nativeLatLngForProjectedMeters(this.mNativeMapViewPtr, projectedMeters);
    }

    public PointF pixelForLatLng(LatLng latLng) {
        return this.nativePixelForLatLng(this.mNativeMapViewPtr, latLng);
    }

    public LatLng latLngForPixel(PointF pixel) {
        return this.nativeLatLngForPixel(this.mNativeMapViewPtr, pixel);
    }

    public double getTopOffsetPixelsForAnnotationSymbol(String symbolName) {
        return this.nativeGetTopOffsetPixelsForAnnotationSymbol(this.mNativeMapViewPtr, symbolName);
    }

    public void jumpTo(double angle, LatLng center, double pitch, double zoom) {
        this.nativeJumpTo(this.mNativeMapViewPtr, angle, center, pitch, zoom);
    }

    public void easeTo(double angle, LatLng center, long duration, double pitch, double zoom) {
        this.nativeEaseTo(this.mNativeMapViewPtr, angle, center, duration, pitch, zoom);
    }

    public void flyTo(double angle, LatLng center, long duration, double pitch, double zoom) {
        this.nativeFlyTo(this.mNativeMapViewPtr, angle, center, duration, pitch, zoom);
    }

    public void addCustomLayer(CustomLayer customLayer, String before) {
        this.nativeAddCustomLayer(this.mNativeMapViewPtr, customLayer, before);
    }

    public void removeCustomLayer(String id2) {
        this.nativeRemoveCustomLayer(this.mNativeMapViewPtr, id2);
    }

    public double[] getCameraValues() {
        return this.nativeGetCameraValues(this.mNativeMapViewPtr);
    }

    protected void onInvalidate() {
        this.mMapView.onInvalidate();
    }

    protected void onMapChanged(int rawChange) {
        this.mMapView.onMapChanged(rawChange);
    }

    protected void onFpsChanged(double fps) {
        this.mMapView.onFpsChanged(fps);
    }

    private native long nativeCreate(String var1, String var2, String var3, float var4, int var5, long var6);

    private native void nativeDestroy(long var1);

    private native void nativeInitializeDisplay(long var1);

    private native void nativeTerminateDisplay(long var1);

    private native void nativeInitializeContext(long var1);

    private native void nativeTerminateContext(long var1);

    private native void nativeCreateSurface(long var1, Surface var3);

    private native void nativeDestroySurface(long var1);

    private native void nativePause(long var1);

    private native boolean nativeIsPaused(long var1);

    private native void nativeResume(long var1);

    private native void nativeUpdate(long var1);

    private native void nativeRenderSync(long var1);

    private native void nativeViewResize(long var1, int var3, int var4);

    private native void nativeFramebufferResize(long var1, int var3, int var4);

    private native void nativeAddClass(long var1, String var3);

    private native void nativeRemoveClass(long var1, String var3);

    private native boolean nativeHasClass(long var1, String var3);

    private native void nativeSetClasses(long var1, List<String> var3);

    private native List<String> nativeGetClasses(long var1);

    private native void nativeSetDefaultTransitionDuration(long var1, long var3);

    private native long nativeGetDefaultTransitionDuration(long var1);

    private native void nativeSetStyleUrl(long var1, String var3);

    private native void nativeSetStyleJson(long var1, String var3, String var4);

    private native String nativeGetStyleJson(long var1);

    private native void nativeSetAccessToken(long var1, String var3);

    private native String nativeGetAccessToken(long var1);

    private native void nativeCancelTransitions(long var1);

    private native void nativeSetGestureInProgress(long var1, boolean var3);

    private native void nativeMoveBy(long var1, double var3, double var5, long var7);

    private native void nativeSetLatLng(long var1, LatLng var3, long var4);

    private native LatLng nativeGetLatLng(long var1);

    private native void nativeResetPosition(long var1);

    private native double nativeGetPitch(long var1);

    private native void nativeSetPitch(long var1, double var3, long var5);

    private native void nativeScaleBy(long var1, double var3, double var5, double var7, long var9);

    private native void nativeSetScale(long var1, double var3, double var5, double var7, long var9);

    private native double nativeGetScale(long var1);

    private native void nativeSetZoom(long var1, double var3, long var5);

    private native double nativeGetZoom(long var1);

    private native void nativeResetZoom(long var1);

    private native void nativeSetMinZoom(long var1, double var3);

    private native double nativeGetMinZoom(long var1);

    private native void nativeSetMaxZoom(long var1, double var3);

    private native double nativeGetMaxZoom(long var1);

    private native void nativeRotateBy(long var1, double var3, double var5, double var7, double var9, long var11);

    private native void nativeSetContentPadding(long var1, double var3, double var5, double var7, double var9);

    private native void nativeSetBearing(long var1, double var3, long var5);

    private native void nativeSetBearingXY(long var1, double var3, double var5, double var7);

    private native double nativeGetBearing(long var1);

    private native void nativeResetNorth(long var1);

    private native long nativeAddMarker(long var1, Marker var3);

    private native void nativeUpdateMarker(long var1, Marker var3);

    private native long[] nativeAddMarkers(long var1, List<Marker> var3);

    private native long nativeAddPolyline(long var1, Polyline var3);

    private native long[] nativeAddPolylines(long var1, List<Polyline> var3);

    private native long nativeAddPolygon(long var1, Polygon var3);

    private native long[] nativeAddPolygons(long var1, List<Polygon> var3);

    private native void nativeRemoveAnnotation(long var1, long var3);

    private native void nativeRemoveAnnotations(long var1, long[] var3);

    private native long[] nativeGetAnnotationsInBounds(long var1, LatLngBounds var3);

    private native void nativeAddAnnotationIcon(long var1, String var3, int var4, int var5, float var6, byte[] var7);

    private native void nativeSetVisibleCoordinateBounds(long var1, LatLng[] var3, RectF var4, double var5, long var7);

    private native void nativeOnLowMemory(long var1);

    private native void nativeSetDebug(long var1, boolean var3);

    private native void nativeToggleDebug(long var1);

    private native boolean nativeGetDebug(long var1);

    private native boolean nativeIsFullyLoaded(long var1);

    private native void nativeSetReachability(long var1, boolean var3);

    private native double nativeGetMetersPerPixelAtLatitude(long var1, double var3, double var5);

    private native ProjectedMeters nativeProjectedMetersForLatLng(long var1, LatLng var3);

    private native LatLng nativeLatLngForProjectedMeters(long var1, ProjectedMeters var3);

    private native PointF nativePixelForLatLng(long var1, LatLng var3);

    private native LatLng nativeLatLngForPixel(long var1, PointF var3);

    private native double nativeGetTopOffsetPixelsForAnnotationSymbol(long var1, String var3);

    private native void nativeJumpTo(long var1, double var3, LatLng var5, double var6, double var8);

    private native void nativeEaseTo(long var1, double var3, LatLng var5, long var6, double var8, double var10);

    private native void nativeFlyTo(long var1, double var3, LatLng var5, long var6, double var8, double var10);

    private native void nativeAddCustomLayer(long var1, CustomLayer var3, String var4);

    private native void nativeRemoveCustomLayer(long var1, String var3);

    private native double[] nativeGetCameraValues(long var1);

    static {
        System.loadLibrary("mapbox-gl");
    }
}

