/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PointF;
import android.support.annotation.LayoutRes;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.InfoWindowView;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import java.lang.ref.WeakReference;

public class InfoWindow {
    private WeakReference<Marker> mBoundMarker;
    private WeakReference<MapboxMap> mMapboxMap;
    protected WeakReference<View> mView;
    private float mMarkerHeightOffset;
    private float mViewWidthOffset;
    private PointF mCoordinates;
    private boolean mIsVisible;
    @LayoutRes
    private int mLayoutRes;

    InfoWindow(MapView mapView, int layoutResId, MapboxMap mapboxMap) {
        this.mLayoutRes = layoutResId;
        View view = LayoutInflater.from((Context)mapView.getContext()).inflate(layoutResId, (ViewGroup)mapView, false);
        this.initialize(view, mapboxMap);
    }

    InfoWindow(View view, MapboxMap mapboxMap) {
        this.initialize(view, mapboxMap);
    }

    private void initialize(View view, MapboxMap mapboxMap) {
        this.mMapboxMap = new WeakReference<MapboxMap>(mapboxMap);
        this.mIsVisible = false;
        this.mView = new WeakReference<View>(view);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MapboxMap mapboxMap = (MapboxMap)InfoWindow.this.mMapboxMap.get();
                if (mapboxMap != null) {
                    MapboxMap.OnInfoWindowClickListener onInfoWindowClickListener = mapboxMap.getOnInfoWindowClickListener();
                    boolean handledDefaultClick = false;
                    if (onInfoWindowClickListener != null) {
                        handledDefaultClick = onInfoWindowClickListener.onInfoWindowClick(InfoWindow.this.getBoundMarker());
                    }
                    if (!handledDefaultClick) {
                        InfoWindow.this.close();
                    }
                }
            }
        });
        view.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                MapboxMap.OnInfoWindowLongClickListener listener;
                MapboxMap mapboxMap = (MapboxMap)InfoWindow.this.mMapboxMap.get();
                if (mapboxMap != null && (listener = mapboxMap.getOnInfoWindowLongClickListener()) != null) {
                    listener.onInfoWindowLongClick(InfoWindow.this.getBoundMarker());
                }
                return true;
            }
        });
    }

    InfoWindow open(MapView mapView, Marker boundMarker, LatLng position, int offsetX, int offsetY) {
        this.setBoundMarker(boundMarker);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
        MapboxMap mapboxMap = (MapboxMap)this.mMapboxMap.get();
        View view = (View)this.mView.get();
        if (view != null && mapboxMap != null) {
            view.measure(0, 0);
            this.mMarkerHeightOffset = -view.getMeasuredHeight() + offsetY;
            this.mCoordinates = mapboxMap.getProjection().toScreenLocation(position);
            float x = this.mCoordinates.x - (float)(view.getMeasuredWidth() / 2) + (float)offsetX;
            float y = this.mCoordinates.y - (float)view.getMeasuredHeight() + (float)offsetY;
            if (view instanceof InfoWindowView) {
                Resources resources = mapView.getContext().getResources();
                float rightSideInfowWindow = x + (float)view.getMeasuredWidth();
                float leftSideInfoWindow = x;
                float mapRight = mapView.getRight();
                float mapLeft = mapView.getLeft();
                float marginHorizontal = resources.getDimension(R.dimen.infowindow_margin);
                float tipViewOffset = resources.getDimension(R.dimen.infowindow_tipview_width) / 2.0f;
                float tipViewMarginLeft = (float)(view.getMeasuredWidth() / 2) - tipViewOffset;
                boolean outOfBoundsLeft = false;
                boolean outOfBoundsRight = false;
                if (rightSideInfowWindow > mapRight) {
                    outOfBoundsRight = true;
                    x -= rightSideInfowWindow - mapRight;
                    tipViewMarginLeft += rightSideInfowWindow - mapRight + tipViewOffset;
                    rightSideInfowWindow = x + (float)view.getMeasuredWidth();
                }
                if (leftSideInfoWindow < mapLeft) {
                    outOfBoundsLeft = true;
                    x += mapLeft - leftSideInfoWindow;
                    tipViewMarginLeft -= mapLeft - leftSideInfoWindow + tipViewOffset;
                    leftSideInfoWindow = x;
                }
                if (outOfBoundsRight && mapRight - rightSideInfowWindow < marginHorizontal) {
                    tipViewMarginLeft += marginHorizontal - (mapRight - rightSideInfowWindow) - tipViewOffset;
                    leftSideInfoWindow = x -= marginHorizontal - (mapRight - rightSideInfowWindow);
                }
                if (outOfBoundsLeft && leftSideInfoWindow - mapLeft < marginHorizontal) {
                    x += marginHorizontal - (leftSideInfoWindow - mapLeft);
                    tipViewMarginLeft -= marginHorizontal - (leftSideInfoWindow - mapLeft) - tipViewOffset;
                }
                InfoWindowView infoWindowView = (InfoWindowView)view;
                infoWindowView.setTipViewMarginLeft((int)tipViewMarginLeft);
            }
            view.setX(x);
            view.setY(y);
            this.mViewWidthOffset = x - this.mCoordinates.x - (float)offsetX;
            this.close();
            mapView.addView(view, (ViewGroup.LayoutParams)lp);
            this.mIsVisible = true;
        }
        return this;
    }

    InfoWindow close() {
        MapboxMap mapboxMap = (MapboxMap)this.mMapboxMap.get();
        if (this.mIsVisible && mapboxMap != null) {
            this.mIsVisible = false;
            View view = (View)this.mView.get();
            if (view != null && view.getParent() != null) {
                ((ViewGroup)view.getParent()).removeView(view);
            }
            Marker marker = this.getBoundMarker();
            MapboxMap.OnInfoWindowCloseListener listener = mapboxMap.getOnInfoWindowCloseListener();
            if (listener != null) {
                listener.onInfoWindowClose(marker);
            }
            this.setBoundMarker(null);
        }
        return this;
    }

    void adaptDefaultMarker(Marker overlayItem, MapboxMap mapboxMap, MapView mapView) {
        View view = (View)this.mView.get();
        if (view == null) {
            view = LayoutInflater.from((Context)mapView.getContext()).inflate(this.mLayoutRes, (ViewGroup)mapView, false);
            this.initialize(view, mapboxMap);
        }
        this.mMapboxMap = new WeakReference<MapboxMap>(mapboxMap);
        String title = overlayItem.getTitle();
        ((TextView)view.findViewById(R.id.infowindow_title)).setText((CharSequence)title);
        String snippet = overlayItem.getSnippet();
        ((TextView)view.findViewById(R.id.infowindow_description)).setText((CharSequence)snippet);
    }

    InfoWindow setBoundMarker(Marker boundMarker) {
        this.mBoundMarker = new WeakReference<Marker>(boundMarker);
        return this;
    }

    Marker getBoundMarker() {
        if (this.mBoundMarker == null) {
            return null;
        }
        return (Marker)this.mBoundMarker.get();
    }

    public void update() {
        MapboxMap mapboxMap = (MapboxMap)this.mMapboxMap.get();
        Marker marker = (Marker)this.mBoundMarker.get();
        View view = (View)this.mView.get();
        if (mapboxMap != null && marker != null && view != null) {
            this.mCoordinates = mapboxMap.getProjection().toScreenLocation(marker.getPosition());
            view.setX(this.mCoordinates.x + this.mViewWidthOffset);
            view.setY(this.mCoordinates.y + this.mMarkerHeightOffset);
        }
    }

    boolean isVisible() {
        return this.mIsVisible;
    }
}

