/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.geometry;

import android.os.Parcel;
import android.os.Parcelable;
import com.mapbox.mapboxsdk.geometry.CoordinateSpan;
import com.mapbox.mapboxsdk.geometry.ILatLng;
import com.mapbox.mapboxsdk.geometry.LatLng;
import java.util.List;

public final class BoundingBox
implements Parcelable {
    private final double mLatNorth;
    private final double mLatSouth;
    private final double mLonEast;
    private final double mLonWest;
    private final boolean mIsValid;
    public static final Parcelable.Creator<BoundingBox> CREATOR = new Parcelable.Creator<BoundingBox>(){

        public BoundingBox createFromParcel(Parcel in) {
            return BoundingBox.readFromParcel(in);
        }

        public BoundingBox[] newArray(int size) {
            return new BoundingBox[size];
        }
    };

    public BoundingBox(double northLatitude, double eastLongitude, double southLatitude, double westLongitude) {
        this.mLatNorth = northLatitude;
        this.mLonEast = eastLongitude;
        this.mLatSouth = southLatitude;
        this.mLonWest = westLongitude;
        this.mIsValid = this.mLonWest < this.mLonEast && this.mLatNorth > this.mLatSouth;
    }

    public BoundingBox(LatLng northEast, LatLng southWest) {
        this(northEast.getLatitude(), northEast.getLongitude(), southWest.getLatitude(), southWest.getLongitude());
    }

    public BoundingBox(BoundingBox other) {
        this.mLatNorth = other.getLatNorth();
        this.mLonEast = other.getLonEast();
        this.mLatSouth = other.getLatSouth();
        this.mLonWest = other.getLonWest();
        this.mIsValid = other.isValid();
    }

    public LatLng getCenter() {
        return new LatLng((this.mLatNorth + this.mLatSouth) / 2.0, (this.mLonEast + this.mLonWest) / 2.0);
    }

    public double getLatNorth() {
        return this.mLatNorth;
    }

    public double getLatSouth() {
        return this.mLatSouth;
    }

    public double getLonEast() {
        return this.mLonEast;
    }

    public double getLonWest() {
        return this.mLonWest;
    }

    public boolean isValid() {
        return this.mIsValid;
    }

    public CoordinateSpan getSpan() {
        return new CoordinateSpan(this.getLatitudeSpan(), this.getLongitudeSpan());
    }

    public double getLatitudeSpan() {
        return Math.abs(this.mLatNorth - this.mLatSouth);
    }

    public double getLongitudeSpan() {
        return Math.abs(this.mLonEast - this.mLonWest);
    }

    public boolean isEmpty() {
        return this.getLongitudeSpan() == 0.0 || this.getLatitudeSpan() == 0.0;
    }

    public String toString() {
        return "N:" + this.mLatNorth + "; E:" + this.mLonEast + "; S:" + this.mLatSouth + "; W:" + this.mLonWest;
    }

    public static BoundingBox fromLatLngs(List<? extends ILatLng> latLngs) {
        double minLat = 90.0;
        double minLon = 180.0;
        double maxLat = -90.0;
        double maxLon = -180.0;
        for (ILatLng iLatLng : latLngs) {
            double latitude = iLatLng.getLatitude();
            double longitude = iLatLng.getLongitude();
            minLat = Math.min(minLat, latitude);
            minLon = Math.min(minLon, longitude);
            maxLat = Math.max(maxLat, latitude);
            maxLon = Math.max(maxLon, longitude);
        }
        return new BoundingBox(maxLat, maxLon, minLat, minLon);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BoundingBox) {
            BoundingBox other = (BoundingBox)o;
            return this.mLatNorth == other.getLatNorth() && this.mLatSouth == other.getLatSouth() && this.mLonEast == other.getLonEast() && this.mLonWest == other.getLonWest();
        }
        return false;
    }

    public boolean contains(ILatLng pGeoPoint) {
        double latitude = pGeoPoint.getLatitude();
        double longitude = pGeoPoint.getLongitude();
        return latitude < this.mLatNorth && latitude > this.mLatSouth && longitude < this.mLonEast && longitude > this.mLonWest;
    }

    public BoundingBox union(BoundingBox box) {
        return this.union(box.getLatNorth(), box.getLonEast(), box.getLatSouth(), box.getLonWest());
    }

    public BoundingBox union(double lonNorth, double latEast, double lonSouth, double latWest) {
        return new BoundingBox(this.mLatNorth < lonNorth ? lonNorth : this.mLatNorth, this.mLonEast < latEast ? latEast : this.mLonEast, this.mLatSouth > lonSouth ? lonSouth : this.mLatSouth, this.mLonWest > latWest ? latWest : this.mLonWest);
    }

    public BoundingBox intersect(BoundingBox box) {
        double minLatWest = Math.max(this.getLonWest(), box.getLonWest());
        double maxLatEast = Math.min(this.getLonEast(), box.getLonEast());
        if (maxLatEast > minLatWest) {
            double minLonSouth = Math.max(this.getLatSouth(), box.getLatSouth());
            double maxLonNorth = Math.min(this.getLatNorth(), box.getLatNorth());
            if (maxLonNorth > minLonSouth) {
                return new BoundingBox(maxLonNorth, maxLatEast, minLonSouth, minLatWest);
            }
        }
        return null;
    }

    public BoundingBox intersect(double northLongitude, double eastLatitude, double southLongitude, double westLatitude) {
        return this.intersect(new BoundingBox(northLongitude, eastLatitude, southLongitude, westLatitude));
    }

    public int hashCode() {
        return (int)(this.mLatNorth + 90.0 + (this.mLatSouth + 90.0) * 1000.0 + (this.mLonEast + 180.0) * 1000000.0 + (this.mLonEast + 180.0) * 1.0E9);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int arg1) {
        out.writeDouble(this.mLatNorth);
        out.writeDouble(this.mLonEast);
        out.writeDouble(this.mLatSouth);
        out.writeDouble(this.mLonWest);
    }

    private static BoundingBox readFromParcel(Parcel in) {
        double lonNorth = in.readDouble();
        double latEast = in.readDouble();
        double lonSouth = in.readDouble();
        double latWest = in.readDouble();
        return new BoundingBox(lonNorth, latEast, lonSouth, latWest);
    }
}

