/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.http;

import android.text.TextUtils;
import android.util.Log;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

class HTTPContext {
    private static final int CONNECTION_ERROR = 0;
    private static final int TEMPORARY_ERROR = 1;
    private static final int PERMANENT_ERROR = 2;
    private static final int CANCELED_ERROR = 3;
    private static HTTPContext mInstance = null;
    private OkHttpClient mClient = new OkHttpClient();

    private HTTPContext() {
    }

    public static HTTPContext getInstance() {
        if (mInstance == null) {
            mInstance = new HTTPContext();
        }
        return mInstance;
    }

    public HTTPRequest createRequest(long nativePtr, String resourceUrl, String userAgent, String etag, String modified) {
        return new HTTPRequest(nativePtr, resourceUrl, userAgent, etag, modified);
    }

    class LoggingInterceptor
    implements Interceptor {
        private static final String LOG_TAG = "LoggingInterceptor";

        LoggingInterceptor() {
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            long t1 = System.nanoTime();
            Log.i((String)LOG_TAG, (String)String.format("Sending request %s on %s%n%s", request.url(), chain.connection(), request.headers()));
            Response response = chain.proceed(request);
            long t2 = System.nanoTime();
            Log.i((String)LOG_TAG, (String)String.format("Received response for %s in %.1fms%n%s", response.request().url(), (double)(t2 - t1) / 1000000.0, response.headers()));
            return response;
        }
    }

    public class HTTPRequest
    implements Callback {
        private final String LOG_TAG = HTTPRequest.class.getName();
        private long mNativePtr = 0L;
        private Call mCall;
        private Request mRequest;

        private native void nativeOnFailure(long var1, int var3, String var4);

        private native void nativeOnResponse(long var1, int var3, String var4, String var5, String var6, String var7, String var8, byte[] var9);

        private HTTPRequest(long nativePtr, String resourceUrl, String userAgent, String etag, String modified) {
            this.mNativePtr = nativePtr;
            Request.Builder builder = new Request.Builder().url(resourceUrl).tag((Object)resourceUrl.toLowerCase(MapboxConstants.MAPBOX_LOCALE)).addHeader("User-Agent", userAgent);
            if (etag.length() > 0) {
                builder = builder.addHeader("If-None-Match", etag);
            } else if (modified.length() > 0) {
                builder = builder.addHeader("If-Modified-Since", modified);
            }
            this.mRequest = builder.build();
        }

        public void start() {
            this.mCall = HTTPContext.getInstance().mClient.newCall(this.mRequest);
            this.mCall.enqueue((Callback)this);
        }

        public void cancel() {
            this.mCall.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(Call call, Response response) throws IOException {
            byte[] body;
            if (response.isSuccessful()) {
                Log.d((String)this.LOG_TAG, (String)String.format("[HTTP] Request was successful (code = %d).", response.code()));
            } else {
                String message = !TextUtils.isEmpty((CharSequence)response.message()) ? response.message() : "No additional information";
                Log.d((String)this.LOG_TAG, (String)String.format("[HTTP] Request with response code = %d: %s", response.code(), message));
            }
            try {
                body = response.body().bytes();
            }
            catch (IOException e) {
                this.onFailure(null, e);
                return;
            }
            finally {
                response.body().close();
            }
            this.nativeOnResponse(this.mNativePtr, response.code(), response.message(), response.header("ETag"), response.header("Last-Modified"), response.header("Cache-Control"), response.header("Expires"), body);
        }

        public void onFailure(Call call, IOException e) {
            Log.w((String)this.LOG_TAG, (String)String.format("[HTTP] Request could not be executed: %s", e.getMessage()));
            int type = 2;
            if (e instanceof UnknownHostException || e instanceof SocketException || e instanceof ProtocolException || e instanceof SSLException) {
                type = 0;
            } else if (e instanceof InterruptedIOException) {
                type = 1;
            } else if (this.mCall.isCanceled()) {
                type = 3;
            }
            String errorMessage = e.getMessage() != null ? e.getMessage() : "Error processing the request";
            this.nativeOnFailure(this.mNativePtr, type, errorMessage);
        }
    }
}

