/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.InfoWindow;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.views.MapView;

public final class Marker
extends Annotation {
    private LatLng position;
    private String snippet;
    private Icon icon;
    private String title;
    private InfoWindow infoWindow = null;
    private boolean infoWindowShown = false;
    private int topOffsetPixels;

    Marker() {
    }

    public LatLng getPosition() {
        return this.position;
    }

    public String getSnippet() {
        return this.snippet;
    }

    public String getTitle() {
        return this.title;
    }

    public void hideInfoWindow() {
        if (this.infoWindow != null) {
            this.infoWindow.close();
        }
        this.infoWindowShown = false;
    }

    public boolean isInfoWindowShown() {
        return this.infoWindowShown;
    }

    void setPosition(LatLng position) {
        this.position = position;
    }

    void setSnippet(String snippet) {
        this.snippet = snippet;
    }

    public void setIcon(@Nullable Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    void setTitle(String title) {
        this.title = title;
    }

    public InfoWindow showInfoWindow(@NonNull MapView mapView) {
        View content;
        this.setMapView(mapView);
        MapView.InfoWindowAdapter infoWindowAdapter = this.getMapView().getInfoWindowAdapter();
        if (infoWindowAdapter != null && (content = infoWindowAdapter.getInfoWindow(this)) != null) {
            this.infoWindow = new InfoWindow(content, this.getMapView());
            this.showInfoWindow(this.infoWindow, mapView);
            return this.infoWindow;
        }
        this.getInfoWindow().adaptDefaultMarker(this, mapView);
        return this.showInfoWindow(this.getInfoWindow(), mapView);
    }

    private InfoWindow showInfoWindow(InfoWindow iw, MapView mapView) {
        iw.open(mapView, this, this.getPosition(), 0, this.topOffsetPixels);
        this.infoWindowShown = true;
        return iw;
    }

    private InfoWindow getInfoWindow() {
        if (this.infoWindow == null) {
            this.infoWindow = new InfoWindow(R.layout.infowindow_view, this.getMapView());
        }
        return this.infoWindow;
    }

    public void setTopOffsetPixels(int topOffsetPixels) {
        this.topOffsetPixels = topOffsetPixels;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Marker marker = (Marker)o;
        return !(this.getPosition() == null ? marker.getPosition() != null : !this.getPosition().equals(marker.getPosition()));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getPosition() != null ? this.getPosition().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Marker [position[" + this.getPosition() + "]]";
    }
}

