/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.views;

import android.app.ActivityManager;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.CallSuper;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.annotation.UiThread;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.view.ScaleGestureDetectorCompat;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ZoomButtonsController;
import com.almeros.android.multitouch.gesturedetectors.RotateGestureDetector;
import com.almeros.android.multitouch.gesturedetectors.ShoveGestureDetector;
import com.almeros.android.multitouch.gesturedetectors.TwoFingerGestureDetector;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.IconFactory;
import com.mapbox.mapboxsdk.annotations.InfoWindow;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerOptions;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.PolygonOptions;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.annotations.PolylineOptions;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.exceptions.IconBitmapChangedException;
import com.mapbox.mapboxsdk.exceptions.InvalidAccessTokenException;
import com.mapbox.mapboxsdk.geometry.BoundingBox;
import com.mapbox.mapboxsdk.geometry.CoordinateBounds;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngZoom;
import com.mapbox.mapboxsdk.layers.CustomLayer;
import com.mapbox.mapboxsdk.utils.MathUtils;
import com.mapbox.mapboxsdk.views.CompassView;
import com.mapbox.mapboxsdk.views.NativeMapView;
import com.mapbox.mapboxsdk.views.UserLocationView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class MapView
extends FrameLayout {
    private static final String TAG = "MapView";
    private static final long ANIMATION_DURATION = 300L;
    private static final String STATE_CENTER_LATLNG = "centerLatLng";
    private static final String STATE_CENTER_DIRECTION = "centerDirection";
    private static final String STATE_ZOOM = "zoomLevel";
    private static final String STATE_TILT = "tilt";
    private static final String STATE_ZOOM_ENABLED = "zoomEnabled";
    private static final String STATE_SCROLL_ENABLED = "scrollEnabled";
    private static final String STATE_ROTATE_ENABLED = "rotateEnabled";
    private static final String STATE_TILT_ENABLED = "tiltEnabled";
    private static final String STATE_ZOOM_CONTROLS_ENABLED = "zoomControlsEnabled";
    private static final String STATE_DEBUG_ACTIVE = "debugActive";
    private static final String STATE_STYLE_URL = "styleUrl";
    private static final String STATE_ACCESS_TOKEN = "accessToken";
    private static final String STATE_STYLE_CLASSES = "styleClasses";
    private static final String STATE_DEFAULT_TRANSITION_DURATION = "defaultTransitionDuration";
    private static final String STATE_MY_LOCATION_ENABLED = "myLocationEnabled";
    private static final String STATE_MY_LOCATION_TRACKING_MODE = "myLocationTracking";
    private static final String STATE_MY_BEARING_TRACKING_MODE = "myBearingTracking";
    private static final String STATE_COMPASS_ENABLED = "compassEnabled";
    private static final String STATE_COMPASS_GRAVITY = "compassGravity";
    private static final String STATE_COMPASS_MARGIN_LEFT = "compassMarginLeft";
    private static final String STATE_COMPASS_MARGIN_TOP = "compassMarginTop";
    private static final String STATE_COMPASS_MARGIN_RIGHT = "compassMarginRight";
    private static final String STATE_COMPASS_MARGIN_BOTTOM = "compassMarginBottom";
    private static final String STATE_LOGO_GRAVITY = "logoGravity";
    private static final String STATE_LOGO_MARGIN_LEFT = "logoMarginLeft";
    private static final String STATE_LOGO_MARGIN_TOP = "logoMarginTop";
    private static final String STATE_LOGO_MARGIN_RIGHT = "logoMarginRight";
    private static final String STATE_LOGO_MARGIN_BOTTOM = "logoMarginBottom";
    private static final String STATE_LOGO_VISIBILITY = "logoVisibility";
    private static final String STATE_ATTRIBUTION_GRAVITY = "attrGravity";
    private static final String STATE_ATTRIBUTION_MARGIN_LEFT = "attrMarginLeft";
    private static final String STATE_ATTRIBUTION_MARGIN_TOP = "attrMarginTop";
    private static final String STATE_ATTRIBUTION_MARGIN_RIGHT = "attrMarginRight";
    private static final String STATE_ATTRIBUTION_MARGIN_BOTTOM = "atrrMarginBottom";
    private static final String STATE_ATTRIBUTION_VISIBILITY = "atrrVisibility";
    private static final float DIMENSION_SEVEN_DP = 7.0f;
    private static final float DIMENSION_TEN_DP = 10.0f;
    private static final float DIMENSION_SIXTEEN_DP = 16.0f;
    private static final float DIMENSION_SEVENTYSIX_DP = 76.0f;
    private static final int ATTRIBUTION_INDEX_IMPROVE_THIS_MAP = 2;
    public static final double MAXIMUM_ZOOM_LEVEL = 18.0;
    public static final double MAXIMUM_ZOOM = 18.0;
    private static final double MINIMUM_TILT = 0.0;
    private static final double MAXIMUM_TILT = 60.0;
    private NativeMapView mNativeMapView;
    private TextureView mTextureView;
    private float mScreenDensity = 1.0f;
    private GestureDetectorCompat mGestureDetector;
    private ScaleGestureDetector mScaleGestureDetector;
    private RotateGestureDetector mRotateGestureDetector;
    private ShoveGestureDetector mShoveGestureDetector;
    private boolean mTwoTap = false;
    private boolean mZoomStarted = false;
    private boolean mQuickZoom = false;
    private ZoomButtonsController mZoomButtonsController;
    private boolean mZoomControlsEnabled = false;
    private TrackballLongPressTimeOut mCurrentTrackballLongPressTimeOut;
    private ConnectivityReceiver mConnectivityReceiver;
    private UserLocationView mUserLocationView;
    private CompassView mCompassView;
    private final List<Annotation> mAnnotations = new ArrayList<Annotation>();
    private List<Marker> mMarkersNearLastTap = new ArrayList<Marker>();
    private List<Marker> mSelectedMarkers = new ArrayList<Marker>();
    private List<InfoWindow> mInfoWindows = new ArrayList<InfoWindow>();
    private InfoWindowAdapter mInfoWindowAdapter;
    private List<Icon> mIcons = new ArrayList<Icon>();
    private ImageView mLogoView;
    private ImageView mAttributionsView;
    private List<OnMapChangedListener> mOnMapChangedListener = new ArrayList<OnMapChangedListener>();
    private OnMapClickListener mOnMapClickListener;
    private OnMapLongClickListener mOnMapLongClickListener;
    private OnFlingListener mOnFlingListener;
    private OnScrollListener mOnScrollListener;
    private OnMarkerClickListener mOnMarkerClickListener;
    private OnInfoWindowClickListener mOnInfoWindowClickListener;
    private OnFpsChangedListener mOnFpsChangedListener;
    private OnMyLocationTrackingModeChangeListener mOnMyLocationTrackingModeChangeListener;
    private OnMyBearingTrackingModeChangeListener mOnMyBearingTrackingModeChangeListener;
    private boolean mZoomEnabled = true;
    private boolean mScrollEnabled = true;
    private boolean mRotateEnabled = true;
    private boolean mTiltEnabled = true;
    private boolean mAllowConcurrentMultipleOpenInfoWindows = false;
    private String mStyleUrl;
    public static final int REGION_WILL_CHANGE = 0;
    public static final int REGION_WILL_CHANGE_ANIMATED = 1;
    public static final int REGION_IS_CHANGING = 2;
    public static final int REGION_DID_CHANGE = 3;
    public static final int REGION_DID_CHANGE_ANIMATED = 4;
    public static final int WILL_START_LOADING_MAP = 5;
    public static final int DID_FINISH_LOADING_MAP = 6;
    public static final int DID_FAIL_LOADING_MAP = 7;
    public static final int WILL_START_RENDERING_FRAME = 8;
    public static final int DID_FINISH_RENDERING_FRAME = 9;
    public static final int DID_FINISH_RENDERING_FRAME_FULLY_RENDERED = 10;
    public static final int WILL_START_RENDERING_MAP = 11;
    public static final int DID_FINISH_RENDERING_MAP = 12;
    public static final int DID_FINISH_RENDERING_MAP_FULLY_RENDERED = 13;

    @UiThread
    public MapView(@NonNull Context context, @NonNull String accessToken) {
        super(context);
        if (accessToken == null) {
            Log.w((String)TAG, (String)"accessToken was null, so just returning");
            return;
        }
        this.initialize(context, null);
        this.setAccessToken(accessToken);
        this.setStyleUrl(null);
    }

    @UiThread
    public MapView(@NonNull Context context, @NonNull String accessToken, @NonNull String styleUrl) {
        super(context);
        if (accessToken == null) {
            Log.w((String)TAG, (String)"accessToken was null, so just returning");
            return;
        }
        if (styleUrl == null) {
            Log.w((String)TAG, (String)"styleUrl was null, so just returning");
            return;
        }
        this.initialize(context, null);
        this.setAccessToken(accessToken);
        this.setStyleUrl(styleUrl);
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs);
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(Context context, AttributeSet attrs) {
        if (context == null) {
            Log.w((String)TAG, (String)"context was null, so just returning");
            return;
        }
        View view = LayoutInflater.from((Context)context).inflate(R.layout.mapview_internal, (ViewGroup)this);
        if (!this.isInEditMode()) {
            this.setWillNotDraw(false);
        }
        this.mTextureView = (TextureView)view.findViewById(R.id.textureView);
        this.mTextureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)new SurfaceTextureListener());
        if (this.isInEditMode()) {
            return;
        }
        this.mScreenDensity = context.getResources().getDisplayMetrics().density;
        String cachePath = context.getCacheDir().getAbsolutePath();
        String dataPath = context.getFilesDir().getAbsolutePath();
        String apkPath = context.getPackageCodePath();
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        activityManager.getMemoryInfo(memoryInfo);
        long maxMemory = memoryInfo.availMem;
        if (Build.VERSION.SDK_INT >= 16) {
            maxMemory = memoryInfo.totalMem;
        }
        this.mNativeMapView = new NativeMapView(this, cachePath, dataPath, apkPath, this.mScreenDensity, availableProcessors, maxMemory);
        this.setClickable(true);
        this.setLongClickable(true);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.mGestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)new GestureListener());
        this.mGestureDetector.setIsLongpressEnabled(true);
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureListener());
        ScaleGestureDetectorCompat.setQuickScaleEnabled((Object)this.mScaleGestureDetector, (boolean)true);
        this.mRotateGestureDetector = new RotateGestureDetector(context, new RotateGestureListener());
        this.mShoveGestureDetector = new ShoveGestureDetector(context, new ShoveGestureListener());
        if (!context.getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch")) {
            this.mZoomControlsEnabled = true;
        }
        this.mZoomButtonsController = new ZoomButtonsController((View)this);
        this.mZoomButtonsController.setZoomSpeed(300L);
        this.mZoomButtonsController.setOnZoomListener((ZoomButtonsController.OnZoomListener)new OnZoomListener());
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
        boolean isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
        this.onConnectivityChanged(isConnected);
        this.mUserLocationView = (UserLocationView)view.findViewById(R.id.userLocationView);
        this.mUserLocationView.setMapView(this);
        this.mCompassView = (CompassView)view.findViewById(R.id.compassView);
        this.mCompassView.setOnClickListener(new CompassView.CompassClickListener(this));
        this.mLogoView = (ImageView)view.findViewById(R.id.logoView);
        this.mAttributionsView = (ImageView)view.findViewById(R.id.attributionView);
        this.mAttributionsView.setOnClickListener((View.OnClickListener)new AttributionOnClickListener(this));
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MapView, 0, 0);
        try {
            double centerLatitude = typedArray.getFloat(R.styleable.MapView_center_latitude, 0.0f);
            double centerLongitude = typedArray.getFloat(R.styleable.MapView_center_longitude, 0.0f);
            this.setLatLng(new LatLng(centerLatitude, centerLongitude));
            float zoom = typedArray.getFloat(R.styleable.MapView_zoom, 0.0f);
            if (zoom != 0.0f) {
                this.setZoom(zoom);
            } else {
                this.setZoomLevel(typedArray.getFloat(R.styleable.MapView_zoom_level, 0.0f));
            }
            this.setDirection(typedArray.getFloat(R.styleable.MapView_direction, 0.0f));
            this.setZoomEnabled(typedArray.getBoolean(R.styleable.MapView_zoom_enabled, true));
            this.setScrollEnabled(typedArray.getBoolean(R.styleable.MapView_scroll_enabled, true));
            this.setRotateEnabled(typedArray.getBoolean(R.styleable.MapView_rotate_enabled, true));
            this.setTiltEnabled(typedArray.getBoolean(R.styleable.MapView_tilt_enabled, true));
            this.setZoomControlsEnabled(typedArray.getBoolean(R.styleable.MapView_zoom_controls_enabled, this.isZoomControlsEnabled()));
            this.setDebugActive(typedArray.getBoolean(R.styleable.MapView_debug_active, false));
            if (typedArray.getString(R.styleable.MapView_style_url) != null) {
                this.setStyleUrl(typedArray.getString(R.styleable.MapView_style_url));
            }
            if (typedArray.getString(R.styleable.MapView_access_token) != null) {
                this.setAccessToken(typedArray.getString(R.styleable.MapView_access_token));
            }
            if (typedArray.getString(R.styleable.MapView_style_classes) != null) {
                List<String> styleClasses = Arrays.asList(typedArray.getString(R.styleable.MapView_style_classes).split("\\s*,\\s*"));
                for (String styleClass : styleClasses) {
                    if (styleClass.length() != 0) continue;
                    styleClasses.remove(styleClass);
                }
                this.setStyleClasses(styleClasses);
            }
            this.setCompassEnabled(typedArray.getBoolean(R.styleable.MapView_compass_enabled, true));
            this.setCompassGravity(typedArray.getInt(R.styleable.MapView_compass_gravity, 8388661));
            this.setWidgetMargins((View)this.mCompassView, typedArray.getDimension(R.styleable.MapView_compass_margin_left, 10.0f), typedArray.getDimension(R.styleable.MapView_compass_margin_top, 10.0f), typedArray.getDimension(R.styleable.MapView_compass_margin_right, 10.0f), typedArray.getDimension(R.styleable.MapView_compass_margin_bottom, 10.0f));
            this.setLogoVisibility(typedArray.getInt(R.styleable.MapView_logo_visibility, 0));
            this.setLogoGravity(typedArray.getInt(R.styleable.MapView_logo_gravity, 8388691));
            this.setWidgetMargins((View)this.mLogoView, typedArray.getDimension(R.styleable.MapView_logo_margin_left, 16.0f), typedArray.getDimension(R.styleable.MapView_logo_margin_top, 16.0f), typedArray.getDimension(R.styleable.MapView_logo_margin_right, 16.0f), typedArray.getDimension(R.styleable.MapView_logo_margin_bottom, 16.0f));
            this.setAttributionVisibility(typedArray.getInt(R.styleable.MapView_attribution_visibility, 0));
            this.setAttributionGravity(typedArray.getInt(R.styleable.MapView_attribution_gravity, 80));
            this.setWidgetMargins((View)this.mAttributionsView, typedArray.getDimension(R.styleable.MapView_attribution_margin_left, 76.0f), typedArray.getDimension(R.styleable.MapView_attribution_margin_top, 7.0f), typedArray.getDimension(R.styleable.MapView_attribution_margin_right, 7.0f), typedArray.getDimension(R.styleable.MapView_attribution_margin_bottom, 7.0f));
            try {
                this.setMyLocationEnabled(typedArray.getBoolean(R.styleable.MapView_my_location_enabled, false));
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
        }
        finally {
            typedArray.recycle();
        }
    }

    @UiThread
    public void onCreate(@Nullable Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.setLatLng((LatLng)savedInstanceState.getParcelable(STATE_CENTER_LATLNG));
            this.setZoom(savedInstanceState.getDouble(STATE_ZOOM));
            this.setDirection(savedInstanceState.getDouble(STATE_CENTER_DIRECTION));
            this.setTilt(savedInstanceState.getDouble(STATE_TILT), null);
            this.setZoomEnabled(savedInstanceState.getBoolean(STATE_ZOOM_ENABLED));
            this.setScrollEnabled(savedInstanceState.getBoolean(STATE_SCROLL_ENABLED));
            this.setRotateEnabled(savedInstanceState.getBoolean(STATE_ROTATE_ENABLED));
            this.setTiltEnabled(savedInstanceState.getBoolean(STATE_TILT_ENABLED));
            this.setZoomControlsEnabled(savedInstanceState.getBoolean(STATE_ZOOM_CONTROLS_ENABLED));
            this.setDebugActive(savedInstanceState.getBoolean(STATE_DEBUG_ACTIVE));
            this.setStyleUrl(savedInstanceState.getString(STATE_STYLE_URL));
            this.setAccessToken(savedInstanceState.getString(STATE_ACCESS_TOKEN));
            ArrayList appliedStyleClasses = savedInstanceState.getStringArrayList(STATE_STYLE_CLASSES);
            if (!appliedStyleClasses.isEmpty()) {
                this.setStyleClasses(appliedStyleClasses);
            }
            this.mNativeMapView.setDefaultTransitionDuration(savedInstanceState.getLong(STATE_DEFAULT_TRANSITION_DURATION));
            try {
                this.setMyLocationEnabled(savedInstanceState.getBoolean(STATE_MY_LOCATION_ENABLED));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.setCompassEnabled(savedInstanceState.getBoolean(STATE_COMPASS_ENABLED));
            this.setCompassGravity(savedInstanceState.getInt(STATE_COMPASS_GRAVITY));
            this.setCompassMargins(savedInstanceState.getInt(STATE_COMPASS_MARGIN_LEFT), savedInstanceState.getInt(STATE_COMPASS_MARGIN_TOP), savedInstanceState.getInt(STATE_COMPASS_MARGIN_RIGHT), savedInstanceState.getInt(STATE_COMPASS_MARGIN_BOTTOM));
            this.setLogoVisibility(savedInstanceState.getInt(STATE_LOGO_VISIBILITY));
            this.setLogoGravity(savedInstanceState.getInt(STATE_LOGO_GRAVITY));
            this.setLogoMargins(savedInstanceState.getInt(STATE_LOGO_MARGIN_LEFT), savedInstanceState.getInt(STATE_LOGO_MARGIN_TOP), savedInstanceState.getInt(STATE_LOGO_MARGIN_RIGHT), savedInstanceState.getInt(STATE_LOGO_MARGIN_BOTTOM));
            this.setAttributionVisibility(savedInstanceState.getInt(STATE_ATTRIBUTION_VISIBILITY));
            this.setAttributionGravity(savedInstanceState.getInt(STATE_ATTRIBUTION_GRAVITY));
            this.setAttributionMargins(savedInstanceState.getInt(STATE_ATTRIBUTION_MARGIN_LEFT), savedInstanceState.getInt(STATE_ATTRIBUTION_MARGIN_TOP), savedInstanceState.getInt(STATE_ATTRIBUTION_MARGIN_RIGHT), savedInstanceState.getInt(STATE_ATTRIBUTION_MARGIN_BOTTOM));
            this.setMyLocationTrackingMode(savedInstanceState.getInt(STATE_MY_LOCATION_TRACKING_MODE, 0));
            this.setMyBearingTrackingMode(savedInstanceState.getInt(STATE_MY_BEARING_TRACKING_MODE, 0));
        }
        this.validateAccessToken(this.getAccessToken());
        this.mNativeMapView.initializeDisplay();
        this.mNativeMapView.initializeContext();
        this.addOnMapChangedListener(new OnMapChangedListener(){

            @Override
            public void onMapChanged(int change) {
                if (change == 6) {
                    MapView.this.reloadIcons();
                    MapView.this.reloadMarkers();
                    MapView.this.adjustTopOffsetPixels();
                }
            }
        });
    }

    @UiThread
    public void onSaveInstanceState(@NonNull Bundle outState) {
        if (outState == null) {
            Log.w((String)TAG, (String)"outState was null, so just returning");
            return;
        }
        outState.putParcelable(STATE_CENTER_LATLNG, (Parcelable)this.getLatLng());
        outState.putDouble(STATE_ZOOM, this.getZoom());
        outState.putDouble(STATE_CENTER_DIRECTION, this.getDirection());
        outState.putDouble(STATE_TILT, this.getTilt());
        outState.putBoolean(STATE_ZOOM_ENABLED, this.isZoomEnabled());
        outState.putBoolean(STATE_SCROLL_ENABLED, this.isScrollEnabled());
        outState.putBoolean(STATE_ROTATE_ENABLED, this.isRotateEnabled());
        outState.putBoolean(STATE_TILT_ENABLED, this.isTiltEnabled());
        outState.putBoolean(STATE_ZOOM_CONTROLS_ENABLED, this.isZoomControlsEnabled());
        outState.putBoolean(STATE_DEBUG_ACTIVE, this.isDebugActive());
        outState.putString(STATE_STYLE_URL, this.getStyleUrl());
        outState.putString(STATE_ACCESS_TOKEN, this.getAccessToken());
        outState.putStringArrayList(STATE_STYLE_CLASSES, new ArrayList<String>(this.getStyleClasses()));
        outState.putLong(STATE_DEFAULT_TRANSITION_DURATION, this.mNativeMapView.getDefaultTransitionDuration());
        outState.putBoolean(STATE_MY_LOCATION_ENABLED, this.isMyLocationEnabled());
        outState.putInt(STATE_MY_LOCATION_TRACKING_MODE, this.mUserLocationView.getMyLocationTrackingMode());
        outState.putInt(STATE_MY_BEARING_TRACKING_MODE, this.mUserLocationView.getMyBearingTrackingMode());
        FrameLayout.LayoutParams compassParams = (FrameLayout.LayoutParams)this.mCompassView.getLayoutParams();
        outState.putBoolean(STATE_COMPASS_ENABLED, this.isCompassEnabled());
        outState.putInt(STATE_COMPASS_GRAVITY, compassParams.gravity);
        outState.putInt(STATE_COMPASS_MARGIN_LEFT, compassParams.leftMargin);
        outState.putInt(STATE_COMPASS_MARGIN_TOP, compassParams.topMargin);
        outState.putInt(STATE_COMPASS_MARGIN_BOTTOM, compassParams.bottomMargin);
        outState.putInt(STATE_COMPASS_MARGIN_RIGHT, compassParams.rightMargin);
        FrameLayout.LayoutParams logoParams = (FrameLayout.LayoutParams)this.mLogoView.getLayoutParams();
        outState.putInt(STATE_LOGO_GRAVITY, logoParams.gravity);
        outState.putInt(STATE_LOGO_MARGIN_LEFT, logoParams.leftMargin);
        outState.putInt(STATE_LOGO_MARGIN_TOP, logoParams.topMargin);
        outState.putInt(STATE_LOGO_MARGIN_RIGHT, logoParams.rightMargin);
        outState.putInt(STATE_LOGO_MARGIN_BOTTOM, logoParams.bottomMargin);
        outState.putInt(STATE_LOGO_VISIBILITY, this.mLogoView.getVisibility());
        FrameLayout.LayoutParams attrParams = (FrameLayout.LayoutParams)this.mAttributionsView.getLayoutParams();
        outState.putInt(STATE_ATTRIBUTION_GRAVITY, attrParams.gravity);
        outState.putInt(STATE_ATTRIBUTION_MARGIN_LEFT, attrParams.leftMargin);
        outState.putInt(STATE_ATTRIBUTION_MARGIN_TOP, attrParams.topMargin);
        outState.putInt(STATE_ATTRIBUTION_MARGIN_RIGHT, attrParams.rightMargin);
        outState.putInt(STATE_ATTRIBUTION_MARGIN_BOTTOM, attrParams.bottomMargin);
        outState.putInt(STATE_ATTRIBUTION_VISIBILITY, this.mAttributionsView.getVisibility());
    }

    @UiThread
    public void onDestroy() {
        this.mNativeMapView.terminateContext();
        this.mNativeMapView.terminateDisplay();
        this.mNativeMapView.destroySurface();
        this.mNativeMapView.destroy();
        this.mNativeMapView = null;
    }

    @UiThread
    public void onStart() {
        this.mUserLocationView.onStart();
    }

    @UiThread
    public void onStop() {
        this.mUserLocationView.onStop();
    }

    @UiThread
    public void onPause() {
        this.getContext().unregisterReceiver((BroadcastReceiver)this.mConnectivityReceiver);
        this.mConnectivityReceiver = null;
        this.mUserLocationView.pause();
        this.mNativeMapView.pause();
    }

    @UiThread
    public void onResume() {
        this.mConnectivityReceiver = new ConnectivityReceiver();
        this.getContext().registerReceiver((BroadcastReceiver)this.mConnectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        this.mNativeMapView.resume();
        this.mNativeMapView.update();
        this.mUserLocationView.resume();
    }

    @UiThread
    public void onLowMemory() {
        this.mNativeMapView.onLowMemory();
    }

    @UiThread
    @NonNull
    public LatLng getLatLng() {
        return this.mNativeMapView.getLatLng();
    }

    @UiThread
    public void setLatLng(@NonNull LatLng latLng) {
        this.setLatLng(latLng, false);
    }

    @UiThread
    public void setLatLng(@NonNull LatLng latLng, boolean animated) {
        if (latLng == null) {
            Log.w((String)TAG, (String)"latLng was null, so just returning");
            return;
        }
        if (animated) {
            CameraPosition cameraPosition = new CameraPosition.Builder(this.getCameraPosition()).target(latLng).build();
            this.animateCamera(CameraUpdateFactory.newCameraPosition(cameraPosition), 300, null);
        } else {
            this.jumpTo(this.mNativeMapView.getBearing(), latLng, this.mNativeMapView.getPitch(), this.mNativeMapView.getZoom());
        }
    }

    @UiThread
    public void setLatLng(@NonNull LatLngZoom latLngZoom) {
        this.setLatLng(latLngZoom, false);
    }

    @UiThread
    public void setLatLng(@NonNull LatLngZoom latLngZoom, boolean animated) {
        if (latLngZoom == null) {
            Log.w((String)TAG, (String)"latLngZoom was null, so just returning");
            return;
        }
        long duration = animated ? 300L : 0L;
        this.mNativeMapView.cancelTransitions();
        this.mNativeMapView.setLatLngZoom(latLngZoom, duration);
    }

    @Deprecated
    @UiThread
    @NonNull
    public LatLng getCenterCoordinate() {
        return this.mNativeMapView.getLatLng();
    }

    @Deprecated
    @UiThread
    public void setCenterCoordinate(@NonNull LatLng centerCoordinate) {
        this.setCenterCoordinate(centerCoordinate, false);
    }

    @Deprecated
    @UiThread
    public void setCenterCoordinate(@NonNull LatLng centerCoordinate, boolean animated) {
        if (centerCoordinate == null) {
            Log.w((String)TAG, (String)"centerCoordinate was null, so just returning");
            return;
        }
        if (animated) {
            CameraPosition cameraPosition = new CameraPosition.Builder(this.getCameraPosition()).target(centerCoordinate).build();
            this.animateCamera(CameraUpdateFactory.newCameraPosition(cameraPosition), 300, null);
        } else {
            this.jumpTo(this.mNativeMapView.getBearing(), centerCoordinate, this.mNativeMapView.getPitch(), this.mNativeMapView.getZoom());
        }
    }

    @Deprecated
    @UiThread
    public void setCenterCoordinate(@NonNull LatLngZoom centerCoordinate) {
        this.setCenterCoordinate(centerCoordinate, false);
    }

    @Deprecated
    @UiThread
    public void setCenterCoordinate(@NonNull LatLngZoom centerCoordinate, boolean animated) {
        if (centerCoordinate == null) {
            Log.w((String)TAG, (String)"centerCoordinate was null, so just returning");
            return;
        }
        long duration = animated ? 300L : 0L;
        this.mNativeMapView.cancelTransitions();
        this.mNativeMapView.setLatLngZoom(centerCoordinate, duration);
    }

    @UiThread
    public void resetPosition() {
        this.mNativeMapView.cancelTransitions();
        this.mNativeMapView.resetPosition();
    }

    @UiThread
    public boolean isScrollEnabled() {
        return this.mScrollEnabled;
    }

    @UiThread
    public void setScrollEnabled(boolean scrollEnabled) {
        this.mScrollEnabled = scrollEnabled;
    }

    public double getTilt() {
        return this.mNativeMapView.getPitch();
    }

    @FloatRange(from=0.0, to=60.0)
    public void setTilt(Double pitch, @Nullable Long duration) {
        long actualDuration = 0L;
        if (duration != null) {
            actualDuration = duration;
        }
        this.mNativeMapView.setPitch(pitch, actualDuration);
    }

    @UiThread
    @FloatRange(from=0.0, to=360.0)
    public double getDirection() {
        double direction;
        for (direction = -this.mNativeMapView.getBearing(); direction > 360.0; direction -= 360.0) {
        }
        while (direction < 0.0) {
            direction += 360.0;
        }
        return direction;
    }

    @UiThread
    public void setDirection(@FloatRange(from=0.0, to=360.0) double direction) {
        this.setDirection(direction, false);
    }

    @UiThread
    public void setDirection(@FloatRange(from=0.0, to=360.0) double direction, boolean animated) {
        long duration = animated ? 300L : 0L;
        this.mNativeMapView.cancelTransitions();
        this.mNativeMapView.setBearing(-direction, duration);
    }

    @UiThread
    public void resetNorth() {
        this.mNativeMapView.cancelTransitions();
        this.mNativeMapView.resetNorth();
    }

    @UiThread
    public boolean isRotateEnabled() {
        return this.mRotateEnabled;
    }

    @UiThread
    public void setRotateEnabled(boolean rotateEnabled) {
        this.mRotateEnabled = rotateEnabled;
    }

    @UiThread
    @FloatRange(from=0.0, to=18.0)
    public double getZoom() {
        return this.mNativeMapView.getZoom();
    }

    @UiThread
    public void setZoom(@FloatRange(from=0.0, to=18.0) double zoomLevel) {
        this.setZoom(zoomLevel, false);
        this.setZoom(zoomLevel, false);
    }

    @UiThread
    public void setZoom(@FloatRange(from=0.0, to=18.0) double zoomLevel, boolean animated) {
        if (zoomLevel < 0.0 || zoomLevel > 18.0) {
            throw new IllegalArgumentException("zoomLevel is < 0 or > MapView.MAXIMUM_ZOOM_LEVEL");
        }
        long duration = animated ? 300L : 0L;
        this.mNativeMapView.cancelTransitions();
        this.mNativeMapView.setZoom(zoomLevel, duration);
    }

    @Deprecated
    @UiThread
    @FloatRange(from=0.0, to=18.0)
    public double getZoomLevel() {
        return this.mNativeMapView.getZoom();
    }

    @Deprecated
    @UiThread
    public void setZoomLevel(@FloatRange(from=0.0, to=18.0) double zoomLevel) {
        this.setZoomLevel(zoomLevel, false);
    }

    @Deprecated
    @UiThread
    public void setZoomLevel(@FloatRange(from=0.0, to=18.0) double zoomLevel, boolean animated) {
        if (zoomLevel < 0.0 || zoomLevel > 18.0) {
            throw new IllegalArgumentException("zoomLevel is < 0 or > MapView.MAXIMUM_ZOOM_LEVEL");
        }
        long duration = animated ? 300L : 0L;
        this.mNativeMapView.cancelTransitions();
        this.mNativeMapView.setZoom(zoomLevel, duration);
    }

    @UiThread
    public boolean isZoomEnabled() {
        return this.mZoomEnabled;
    }

    @UiThread
    public void setZoomEnabled(boolean zoomEnabled) {
        this.mZoomEnabled = zoomEnabled;
        if (this.mZoomControlsEnabled && this.getVisibility() == 0 && this.mZoomEnabled) {
            this.mZoomButtonsController.setVisible(true);
        } else {
            this.mZoomButtonsController.setVisible(false);
        }
    }

    public boolean isZoomControlsEnabled() {
        return this.mZoomControlsEnabled;
    }

    public void setZoomControlsEnabled(boolean enabled) {
        this.mZoomControlsEnabled = enabled;
        if (this.mZoomControlsEnabled && this.getVisibility() == 0 && this.mZoomEnabled) {
            this.mZoomButtonsController.setVisible(true);
        } else {
            this.mZoomButtonsController.setVisible(false);
        }
    }

    private void zoom(boolean zoomIn) {
        this.zoom(zoomIn, -1.0f, -1.0f);
    }

    private void zoom(boolean zoomIn, float x, float y) {
        this.mNativeMapView.cancelTransitions();
        if (zoomIn) {
            this.mNativeMapView.scaleBy(2.0, x / this.mScreenDensity, y / this.mScreenDensity, 300L);
        } else {
            this.mNativeMapView.scaleBy(0.5, x / this.mScreenDensity, y / this.mScreenDensity, 300L);
        }
    }

    @UiThread
    public boolean isTiltEnabled() {
        return this.mTiltEnabled;
    }

    @UiThread
    public void setTiltEnabled(boolean tiltEnabled) {
        this.mTiltEnabled = tiltEnabled;
    }

    public final CameraPosition getCameraPosition() {
        return new CameraPosition(this.getLatLng(), (float)this.getZoom(), (float)this.getTilt(), (float)this.getBearing());
    }

    @UiThread
    public final void animateCamera(CameraUpdate update) {
        this.animateCamera(update, 1, null);
    }

    @UiThread
    public final void animateCamera(CameraUpdate update, CancelableCallback callback) {
        this.animateCamera(update, 1, callback);
    }

    @UiThread
    public final void animateCamera(CameraUpdate update, int durationMs, final CancelableCallback callback) {
        if (update.getTarget() == null) {
            Log.w((String)TAG, (String)"animateCamera with null target coordinate passed in.  Will immediately return without animating camera.");
            return;
        }
        this.mNativeMapView.cancelTransitions();
        if (callback != null) {
            MapView view = this;
            this.addOnMapChangedListener(new OnMapChangedListener(){

                @Override
                public void onMapChanged(int change) {
                    if (change == 4) {
                        callback.onFinish();
                        MapView.this.removeOnMapChangedListener(this);
                    }
                }
            });
        }
        double angle = -1.0;
        if (update.getBearing() >= 0.0f) {
            angle = (double)(-update.getBearing()) * (Math.PI / 180);
        }
        double pitch = -1.0;
        if (update.getTilt() >= 0.0f) {
            double dp = MathUtils.clamp(update.getTilt(), 0.0, 60.0);
            pitch = dp * (Math.PI / 180);
        }
        double zoom = -1.0;
        if (update.getZoom() >= 0.0f) {
            zoom = update.getZoom();
        }
        long durationNano = 0L;
        if (durationMs > 0) {
            durationNano = TimeUnit.NANOSECONDS.convert(durationMs, TimeUnit.MILLISECONDS);
        }
        this.flyTo(angle, update.getTarget(), durationNano, pitch, zoom);
    }

    @UiThread
    public final void easeCamera(CameraUpdate update, int durationMs, final CancelableCallback callback) {
        if (update.getTarget() == null) {
            Log.w((String)TAG, (String)"easeCamera with null target coordinate passed in.  Will immediately return without easing camera.");
            return;
        }
        this.mNativeMapView.cancelTransitions();
        if (callback != null) {
            MapView view = this;
            this.addOnMapChangedListener(new OnMapChangedListener(){

                @Override
                public void onMapChanged(int change) {
                    if (change == 4) {
                        callback.onFinish();
                        MapView.this.removeOnMapChangedListener(this);
                    }
                }
            });
        }
        double angle = -1.0;
        if (update.getBearing() >= 0.0f) {
            angle = (double)(-update.getBearing()) * (Math.PI / 180);
        }
        double pitch = -1.0;
        if (update.getTilt() >= 0.0f) {
            double dp = MathUtils.clamp(update.getTilt(), 0.0, 60.0);
            pitch = dp * (Math.PI / 180);
        }
        double zoom = -1.0;
        if (update.getZoom() >= 0.0f) {
            zoom = update.getZoom();
        }
        long durationNano = 0L;
        if (durationMs > 0) {
            durationNano = TimeUnit.NANOSECONDS.convert(durationMs, TimeUnit.MILLISECONDS);
        }
        this.easeTo(angle, update.getTarget(), durationNano, pitch, zoom);
    }

    @UiThread
    public final void moveCamera(CameraUpdate update) {
        if (update.getTarget() == null) {
            Log.w((String)TAG, (String)"moveCamera with null target coordinate passed in.  Will immediately return without moving camera.");
            return;
        }
        this.mNativeMapView.cancelTransitions();
        double angle = -1.0;
        if (update.getBearing() >= 0.0f) {
            angle = (double)(-update.getBearing()) * (Math.PI / 180);
        }
        double pitch = -1.0;
        if (update.getTilt() >= 0.0f) {
            double dp = MathUtils.clamp(update.getTilt(), 0.0, 60.0);
            pitch = dp * (Math.PI / 180);
        }
        double zoom = -1.0;
        if (update.getZoom() >= 0.0f) {
            zoom = update.getZoom();
        }
        this.jumpTo(angle, update.getTarget(), pitch, zoom);
    }

    @UiThread
    public void setAllowConcurrentMultipleOpenInfoWindows(boolean allow) {
        this.mAllowConcurrentMultipleOpenInfoWindows = allow;
    }

    @UiThread
    public boolean isAllowConcurrentMultipleOpenInfoWindows() {
        return this.mAllowConcurrentMultipleOpenInfoWindows;
    }

    @UiThread
    public boolean isDebugActive() {
        return this.mNativeMapView.getDebug();
    }

    @UiThread
    public void setDebugActive(boolean debugActive) {
        this.mNativeMapView.setDebug(debugActive);
    }

    @UiThread
    public void cycleDebugOptions() {
        this.mNativeMapView.cycleDebugOptions();
    }

    private boolean isFullyLoaded() {
        return this.mNativeMapView.isFullyLoaded();
    }

    @UiThread
    public void setStyleUrl(@Nullable String url) {
        if (url == null) {
            url = "mapbox://styles/mapbox/streets-v8";
        }
        this.mStyleUrl = url;
        this.mNativeMapView.setStyleUrl(url);
    }

    @UiThread
    public void setStyle(String style2) {
        this.setStyleUrl(style2);
    }

    @UiThread
    @NonNull
    public String getStyleUrl() {
        return this.mStyleUrl;
    }

    @UiThread
    @NonNull
    public List<String> getStyleClasses() {
        return Collections.unmodifiableList(this.mNativeMapView.getClasses());
    }

    @UiThread
    public void setStyleClasses(@NonNull List<String> styleClasses) {
        this.setStyleClasses(styleClasses, 0L);
    }

    @UiThread
    public void setStyleClasses(@NonNull List<String> styleClasses, @IntRange(from=0L) long transitionDuration) {
        if (styleClasses == null) {
            Log.w((String)TAG, (String)"styleClasses was null, so just returning");
            return;
        }
        if (transitionDuration < 0L) {
            throw new IllegalArgumentException("transitionDuration is < 0");
        }
        this.mNativeMapView.setDefaultTransitionDuration(transitionDuration);
        this.mNativeMapView.setClasses(styleClasses);
    }

    @UiThread
    public void addStyleClass(@NonNull String styleClass) {
        if (styleClass == null) {
            Log.w((String)TAG, (String)"styleClass was null, so just returning");
            return;
        }
        this.mNativeMapView.addClass(styleClass);
    }

    @UiThread
    public void removeStyleClass(@NonNull String styleClass) {
        if (styleClass == null) {
            Log.w((String)TAG, (String)"styleClass was null, so just returning");
            return;
        }
        this.mNativeMapView.removeClass(styleClass);
    }

    @UiThread
    public boolean hasStyleClass(@NonNull String styleClass) {
        if (styleClass == null) {
            Log.w((String)TAG, (String)"centerCoordinate was null, so just returning false");
            return false;
        }
        return this.mNativeMapView.hasClass(styleClass);
    }

    @UiThread
    public void removeAllStyleClasses() {
        this.removeAllStyleClasses(0L);
    }

    @UiThread
    public void removeAllStyleClasses(@IntRange(from=0L) long transitionDuration) {
        if (transitionDuration < 0L) {
            throw new IllegalArgumentException("transitionDuration is < 0");
        }
        this.mNativeMapView.setDefaultTransitionDuration(transitionDuration);
        ArrayList<String> styleClasses = new ArrayList<String>(0);
        this.setStyleClasses(styleClasses);
    }

    private void validateAccessToken(String accessToken) {
        if (TextUtils.isEmpty((CharSequence)accessToken) || !accessToken.startsWith("pk.") && !accessToken.startsWith("sk.")) {
            throw new InvalidAccessTokenException();
        }
    }

    @UiThread
    public void setAccessToken(@NonNull String accessToken) {
        if (!TextUtils.isEmpty((CharSequence)accessToken)) {
            accessToken = accessToken.trim();
        }
        this.validateAccessToken(accessToken);
        this.mNativeMapView.setAccessToken(accessToken);
    }

    @UiThread
    @Nullable
    public String getAccessToken() {
        return this.mNativeMapView.getAccessToken();
    }

    @UiThread
    @NonNull
    public LatLng fromScreenLocation(@NonNull PointF point) {
        if (point == null) {
            Log.w((String)TAG, (String)"point was null, so just returning (0, 0)");
            return new LatLng();
        }
        float x = point.x;
        float y = point.y;
        y = (float)this.getHeight() - y;
        return this.mNativeMapView.latLngForPixel(new PointF(x / this.mScreenDensity, y / this.mScreenDensity));
    }

    @UiThread
    @NonNull
    public PointF toScreenLocation(@NonNull LatLng location) {
        if (location == null) {
            Log.w((String)TAG, (String)"location was null, so just returning (0, 0)");
            return new PointF();
        }
        PointF point = this.mNativeMapView.pixelForLatLng(location);
        float x = point.x * this.mScreenDensity;
        float y = point.y * this.mScreenDensity;
        y = (float)this.getHeight() - y;
        return new PointF(x, y);
    }

    public IconFactory getIconFactory() {
        return IconFactory.getInstance(this.getContext());
    }

    private void loadIcon(Icon icon) {
        Bitmap bitmap = icon.getBitmap();
        String id2 = icon.getId();
        if (bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
            bitmap = bitmap.copy(Bitmap.Config.ARGB_8888, false);
        }
        ByteBuffer buffer = ByteBuffer.allocate(bitmap.getRowBytes() * bitmap.getHeight());
        bitmap.copyPixelsToBuffer((Buffer)buffer);
        float density = bitmap.getDensity();
        if (density == 0.0f) {
            density = 160.0f;
        }
        float scale = density / 160.0f;
        this.mNativeMapView.addAnnotationIcon(id2, (int)((float)bitmap.getWidth() / scale), (int)((float)bitmap.getHeight() / scale), scale, buffer.array());
    }

    private void reloadIcons() {
        int count = this.mIcons.size();
        for (int i = 0; i < count; ++i) {
            Icon icon = this.mIcons.get(i);
            this.loadIcon(icon);
        }
    }

    private Marker prepareMarker(MarkerOptions markerOptions) {
        Marker marker = markerOptions.getMarker();
        Icon icon = marker.getIcon();
        if (icon == null) {
            icon = this.getIconFactory().defaultMarker();
            marker.setIcon(icon);
        }
        if (!this.mIcons.contains(icon)) {
            this.mIcons.add(icon);
            this.loadIcon(icon);
        } else {
            Icon oldIcon = this.mIcons.get(this.mIcons.indexOf(icon));
            if (!oldIcon.getBitmap().sameAs(icon.getBitmap())) {
                throw new IconBitmapChangedException();
            }
        }
        marker.setTopOffsetPixels(this.getTopOffsetPixelsForIcon(icon));
        return marker;
    }

    @UiThread
    @NonNull
    public Marker addMarker(@NonNull MarkerOptions markerOptions) {
        if (markerOptions == null) {
            Log.w((String)TAG, (String)"markerOptions was null, so just returning null");
            return null;
        }
        Marker marker = this.prepareMarker(markerOptions);
        long id2 = this.mNativeMapView.addMarker(marker);
        marker.setId(id2);
        marker.setMapView(this);
        this.mAnnotations.add(marker);
        return marker;
    }

    @UiThread
    @NonNull
    public List<Marker> addMarkers(@NonNull List<MarkerOptions> markerOptionsList) {
        if (markerOptionsList == null) {
            Log.w((String)TAG, (String)"markerOptionsList was null, so just returning null");
            return null;
        }
        int count = markerOptionsList.size();
        ArrayList<Marker> markers = new ArrayList<Marker>(count);
        for (int i = 0; i < count; ++i) {
            MarkerOptions markerOptions = markerOptionsList.get(i);
            Marker marker = this.prepareMarker(markerOptions);
            markers.add(marker);
        }
        long[] ids = this.mNativeMapView.addMarkers(markers);
        for (int i = 0; i < count; ++i) {
            Marker m = (Marker)markers.get(i);
            m.setId(ids[i]);
            m.setMapView(this);
            this.mAnnotations.add(m);
        }
        return new ArrayList<Marker>(markers);
    }

    @UiThread
    @NonNull
    public Polyline addPolyline(@NonNull PolylineOptions polylineOptions) {
        if (polylineOptions == null) {
            Log.w((String)TAG, (String)"polylineOptions was null, so just returning null");
            return null;
        }
        Polyline polyline = polylineOptions.getPolyline();
        long id2 = this.mNativeMapView.addPolyline(polyline);
        polyline.setId(id2);
        polyline.setMapView(this);
        this.mAnnotations.add(polyline);
        return polyline;
    }

    @UiThread
    @NonNull
    public List<Polyline> addPolylines(@NonNull List<PolylineOptions> polylineOptionsList) {
        if (polylineOptionsList == null) {
            Log.w((String)TAG, (String)"polylineOptionsList was null, so just returning null");
            return null;
        }
        int count = polylineOptionsList.size();
        ArrayList<Polyline> polylines = new ArrayList<Polyline>(count);
        for (PolylineOptions options : polylineOptionsList) {
            polylines.add(options.getPolyline());
        }
        long[] ids = this.mNativeMapView.addPolylines(polylines);
        for (int i = 0; i < count; ++i) {
            Polyline p = (Polyline)polylines.get(i);
            p.setId(ids[i]);
            p.setMapView(this);
            this.mAnnotations.add(p);
        }
        return new ArrayList<Polyline>(polylines);
    }

    @UiThread
    @NonNull
    public Polygon addPolygon(@NonNull PolygonOptions polygonOptions) {
        if (polygonOptions == null) {
            Log.w((String)TAG, (String)"polygonOptions was null, so just returning null");
            return null;
        }
        Polygon polygon = polygonOptions.getPolygon();
        long id2 = this.mNativeMapView.addPolygon(polygon);
        polygon.setId(id2);
        polygon.setMapView(this);
        this.mAnnotations.add(polygon);
        return polygon;
    }

    @UiThread
    @NonNull
    public List<Polygon> addPolygons(@NonNull List<PolygonOptions> polygonOptionsList) {
        if (polygonOptionsList == null) {
            Log.w((String)TAG, (String)"polygonOptionsList was null, so just returning null");
            return null;
        }
        int count = polygonOptionsList.size();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(count);
        for (PolygonOptions polygonOptions : polygonOptionsList) {
            polygons.add(polygonOptions.getPolygon());
        }
        long[] ids = this.mNativeMapView.addPolygons(polygons);
        for (int i = 0; i < count; ++i) {
            Polygon p = (Polygon)polygons.get(i);
            p.setId(ids[i]);
            p.setMapView(this);
            this.mAnnotations.add(p);
        }
        return new ArrayList<Polygon>(polygons);
    }

    @UiThread
    public void removeMarker(@NonNull Marker marker) {
        this.removeAnnotation(marker);
    }

    @UiThread
    public void removeAnnotation(@NonNull Annotation annotation) {
        if (annotation == null) {
            Log.w((String)TAG, (String)"annotation was null, so just returning");
            return;
        }
        if (annotation instanceof Marker) {
            ((Marker)annotation).hideInfoWindow();
        }
        long id2 = annotation.getId();
        this.mNativeMapView.removeAnnotation(id2);
        this.mAnnotations.remove(annotation);
    }

    @UiThread
    public void removeAnnotations(@NonNull List<? extends Annotation> annotationList) {
        if (annotationList == null) {
            Log.w((String)TAG, (String)"annotationList was null, so just returning");
            return;
        }
        int count = annotationList.size();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = annotationList.get(i).getId();
        }
        this.mNativeMapView.removeAnnotations(ids);
    }

    @UiThread
    public void removeAllAnnotations() {
        int count = this.mAnnotations.size();
        long[] ids = new long[this.mAnnotations.size()];
        for (int i = 0; i < count; ++i) {
            long id2;
            Annotation annotation = this.mAnnotations.get(i);
            ids[i] = id2 = annotation.getId();
            if (!(annotation instanceof Marker)) continue;
            ((Marker)annotation).hideInfoWindow();
        }
        this.mNativeMapView.removeAnnotations(ids);
        this.mAnnotations.clear();
    }

    @NonNull
    public List<Annotation> getAllAnnotations() {
        return new ArrayList<Annotation>(this.mAnnotations);
    }

    private List<Marker> getMarkersInBounds(@NonNull BoundingBox bbox) {
        if (bbox == null) {
            Log.w((String)TAG, (String)"bbox was null, so just returning null");
            return null;
        }
        long[] ids = this.mNativeMapView.getAnnotationsInBounds(bbox);
        ArrayList<Long> idsList = new ArrayList<Long>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            idsList.add(ids[i]);
        }
        ArrayList<Marker> annotations = new ArrayList<Marker>(ids.length);
        int count = this.mAnnotations.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = this.mAnnotations.get(i);
            if (!(annotation instanceof Marker) || !idsList.contains(annotation.getId())) continue;
            annotations.add((Marker)annotation);
        }
        return new ArrayList<Marker>(annotations);
    }

    private int getTopOffsetPixelsForIcon(Icon icon) {
        if (this.mNativeMapView.isPaused()) {
            return 0;
        }
        return (int)(this.mNativeMapView.getTopOffsetPixelsForAnnotationSymbol(icon.getId()) * (double)this.mScreenDensity);
    }

    @UiThread
    public double getMetersPerPixelAtLatitude(@FloatRange(from=-180.0, to=180.0) double latitude) {
        return this.mNativeMapView.getMetersPerPixelAtLatitude(latitude, this.getZoom()) / (double)this.mScreenDensity;
    }

    @UiThread
    public void selectMarker(@NonNull Marker marker) {
        if (marker == null) {
            Log.w((String)TAG, (String)"marker was null, so just returning");
            return;
        }
        if (this.mSelectedMarkers.contains(marker)) {
            return;
        }
        if (!this.isAllowConcurrentMultipleOpenInfoWindows()) {
            this.deselectMarkers();
        }
        boolean handledDefaultClick = false;
        if (this.mOnMarkerClickListener != null) {
            handledDefaultClick = this.mOnMarkerClickListener.onMarkerClick(marker);
        }
        if (!handledDefaultClick && this.isInfoWindowValidForMarker(marker)) {
            this.mInfoWindows.add(marker.showInfoWindow(this));
        }
        this.mSelectedMarkers.add(marker);
    }

    @UiThread
    public void deselectMarkers() {
        if (this.mSelectedMarkers.isEmpty()) {
            return;
        }
        for (Marker marker : this.mSelectedMarkers) {
            if (!marker.isInfoWindowShown()) continue;
            marker.hideInfoWindow();
        }
        this.mSelectedMarkers.clear();
    }

    @UiThread
    public void deselectMarker(@NonNull Marker marker) {
        if (!this.mSelectedMarkers.contains(marker)) {
            return;
        }
        if (marker.isInfoWindowShown()) {
            marker.hideInfoWindow();
        }
        this.mSelectedMarkers.remove(marker);
    }

    private boolean isInfoWindowValidForMarker(@NonNull Marker marker) {
        return !TextUtils.isEmpty((CharSequence)marker.getTitle()) || !TextUtils.isEmpty((CharSequence)marker.getSnippet());
    }

    @UiThread
    private void jumpTo(double bearing, LatLng center, double pitch, double zoom) {
        this.mNativeMapView.jumpTo(bearing, center, pitch, zoom);
    }

    @UiThread
    private void easeTo(double bearing, LatLng center, long duration, double pitch, double zoom) {
        this.mNativeMapView.easeTo(bearing, center, duration, pitch, zoom);
    }

    @UiThread
    private void flyTo(double bearing, LatLng center, long duration, double pitch, double zoom) {
        this.mNativeMapView.flyTo(bearing, center, duration, pitch, zoom);
    }

    @UiThread
    public void setVisibleCoordinateBounds(@NonNull CoordinateBounds bounds) {
        this.setVisibleCoordinateBounds(bounds, false);
    }

    @UiThread
    public void setVisibleCoordinateBounds(@NonNull CoordinateBounds bounds, boolean animated) {
        this.setVisibleCoordinateBounds(bounds, new RectF(), animated);
    }

    @UiThread
    public void setVisibleCoordinateBounds(@NonNull CoordinateBounds bounds, @NonNull RectF padding, boolean animated) {
        LatLng[] coordinates = new LatLng[]{new LatLng(bounds.getNorthEast().getLatitude(), bounds.getSouthWest().getLongitude()), bounds.getSouthWest(), new LatLng(bounds.getSouthWest().getLatitude(), bounds.getNorthEast().getLongitude()), bounds.getNorthEast()};
        this.setVisibleCoordinateBounds(coordinates, padding, animated);
    }

    @UiThread
    public void setVisibleCoordinateBounds(@NonNull LatLng[] coordinates, @NonNull RectF padding, boolean animated) {
        this.setVisibleCoordinateBounds(coordinates, padding, this.getDirection(), animated);
    }

    private void setVisibleCoordinateBounds(LatLng[] coordinates, RectF padding, double direction, boolean animated) {
        this.setVisibleCoordinateBounds(coordinates, padding, direction, animated ? 300L : 0L);
    }

    private void setVisibleCoordinateBounds(LatLng[] coordinates, RectF padding, double direction, long duration) {
        this.mNativeMapView.setVisibleCoordinateBounds(coordinates, new RectF(padding.left / this.mScreenDensity, padding.top / this.mScreenDensity, padding.right / this.mScreenDensity, padding.bottom / this.mScreenDensity), direction, duration);
    }

    @UiThread
    @Nullable
    public List<Marker> getSelectedMarkers() {
        return this.mSelectedMarkers;
    }

    private void adjustTopOffsetPixels() {
        int count = this.mAnnotations.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = this.mAnnotations.get(i);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            marker.setTopOffsetPixels(this.getTopOffsetPixelsForIcon(marker.getIcon()));
        }
        for (Marker marker : this.mSelectedMarkers) {
            if (!marker.isInfoWindowShown()) continue;
            marker.hideInfoWindow();
            marker.showInfoWindow(this);
        }
    }

    private void reloadMarkers() {
        int count = this.mAnnotations.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = this.mAnnotations.get(i);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            this.mNativeMapView.removeAnnotation(annotation.getId());
            long newId = this.mNativeMapView.addMarker(marker);
            marker.setId(newId);
        }
    }

    protected void onInvalidate() {
        this.postInvalidate();
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInEditMode()) {
            return;
        }
        if (!this.mNativeMapView.isPaused()) {
            this.mNativeMapView.renderSync();
        }
    }

    protected void onSizeChanged(int width, int height, int oldw, int oldh) {
        if (!this.isInEditMode()) {
            this.mNativeMapView.resizeView((int)((float)width / this.mScreenDensity), (int)((float)height / this.mScreenDensity));
        }
    }

    void update() {
        if (this.mNativeMapView != null) {
            this.mNativeMapView.update();
        }
    }

    public double getBearing() {
        return this.mNativeMapView.getBearing();
    }

    public void setBearing(float bearing) {
        this.mNativeMapView.setBearing(bearing);
    }

    public void setBearing(float bearing, long duration) {
        this.mNativeMapView.setBearing(bearing, duration);
    }

    @CallSuper
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mZoomControlsEnabled) {
            this.mZoomButtonsController.setVisible(false);
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        if (this.mZoomControlsEnabled && visibility != 0) {
            this.mZoomButtonsController.setVisible(false);
        }
        if (this.mZoomControlsEnabled && visibility == 0 && this.mZoomEnabled) {
            this.mZoomButtonsController.setVisible(true);
        }
    }

    public void setAllGesturesEnabled(boolean enabled) {
        this.setZoomEnabled(enabled);
        this.setScrollEnabled(enabled);
        this.setRotateEnabled(enabled);
        this.setTiltEnabled(enabled);
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (event.getButtonState() != 0 && event.getButtonState() != 1) {
            return false;
        }
        this.mRotateGestureDetector.onTouchEvent(event);
        this.mScaleGestureDetector.onTouchEvent(event);
        this.mShoveGestureDetector.onTouchEvent(event);
        switch (event.getActionMasked()) {
            case 0: {
                this.mNativeMapView.setGestureInProgress(true);
                break;
            }
            case 5: {
                this.mTwoTap = event.getPointerCount() == 2;
                break;
            }
            case 6: {
                break;
            }
            case 1: {
                boolean inProgress;
                long tapInterval = event.getEventTime() - event.getDownTime();
                boolean isTap = tapInterval <= (long)ViewConfiguration.getTapTimeout();
                boolean bl = inProgress = this.mRotateGestureDetector.isInProgress() || this.mScaleGestureDetector.isInProgress() || this.mShoveGestureDetector.isInProgress();
                if (this.mTwoTap && isTap && !inProgress) {
                    PointF focalPoint = TwoFingerGestureDetector.determineFocalPoint(event);
                    this.zoom(false, focalPoint.x, focalPoint.y);
                    this.mTwoTap = false;
                    return true;
                }
                this.mTwoTap = false;
                this.mNativeMapView.setGestureInProgress(false);
                break;
            }
            case 3: {
                this.mTwoTap = false;
                this.mNativeMapView.setGestureInProgress(false);
            }
        }
        boolean retVal = this.mGestureDetector.onTouchEvent(event);
        return retVal || super.onTouchEvent(event);
    }

    public boolean onKeyDown(int keyCode, @NonNull KeyEvent event) {
        double scrollDist = event.getRepeatCount() >= 5 ? 50.0 : 10.0;
        switch (keyCode) {
            case 23: 
            case 66: {
                event.startTracking();
                return true;
            }
            case 21: {
                if (!this.mScrollEnabled) {
                    return false;
                }
                this.mNativeMapView.cancelTransitions();
                this.mNativeMapView.moveBy(scrollDist / (double)this.mScreenDensity, 0.0 / (double)this.mScreenDensity);
                return true;
            }
            case 22: {
                if (!this.mScrollEnabled) {
                    return false;
                }
                this.mNativeMapView.cancelTransitions();
                this.mNativeMapView.moveBy(-scrollDist / (double)this.mScreenDensity, 0.0 / (double)this.mScreenDensity);
                return true;
            }
            case 19: {
                if (!this.mScrollEnabled) {
                    return false;
                }
                this.mNativeMapView.cancelTransitions();
                this.mNativeMapView.moveBy(0.0 / (double)this.mScreenDensity, scrollDist / (double)this.mScreenDensity);
                return true;
            }
            case 20: {
                if (!this.mScrollEnabled) {
                    return false;
                }
                this.mNativeMapView.cancelTransitions();
                this.mNativeMapView.moveBy(0.0 / (double)this.mScreenDensity, -scrollDist / (double)this.mScreenDensity);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 23: 
            case 66: {
                if (!this.mZoomEnabled) {
                    return false;
                }
                this.zoom(false);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (event.isCanceled()) {
            return super.onKeyUp(keyCode, event);
        }
        switch (keyCode) {
            case 23: 
            case 66: {
                if (!this.mZoomEnabled) {
                    return false;
                }
                this.zoom(true);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public boolean onTrackballEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 2: {
                if (!this.mScrollEnabled) {
                    return false;
                }
                this.mNativeMapView.cancelTransitions();
                this.mNativeMapView.moveBy(-10.0 * (double)event.getX() / (double)this.mScreenDensity, -10.0 * (double)event.getY() / (double)this.mScreenDensity);
                return true;
            }
            case 0: {
                if (this.mCurrentTrackballLongPressTimeOut != null) {
                    this.mCurrentTrackballLongPressTimeOut.cancel();
                    this.mCurrentTrackballLongPressTimeOut = null;
                }
                this.mCurrentTrackballLongPressTimeOut = new TrackballLongPressTimeOut();
                this.postDelayed(this.mCurrentTrackballLongPressTimeOut, ViewConfiguration.getLongPressTimeout());
                return true;
            }
            case 1: {
                if (!this.mZoomEnabled) {
                    return false;
                }
                if (this.mCurrentTrackballLongPressTimeOut != null) {
                    this.zoom(true);
                }
                return true;
            }
            case 3: {
                if (this.mCurrentTrackballLongPressTimeOut != null) {
                    this.mCurrentTrackballLongPressTimeOut.cancel();
                    this.mCurrentTrackballLongPressTimeOut = null;
                }
                return true;
            }
        }
        return super.onTrackballEvent(event);
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        if ((event.getSource() & 2) == 2) {
            switch (event.getActionMasked()) {
                case 8: {
                    if (!this.mZoomEnabled) {
                        return false;
                    }
                    this.mNativeMapView.cancelTransitions();
                    float scrollDist = event.getAxisValue(9);
                    this.mNativeMapView.scaleBy(Math.pow(2.0, scrollDist), event.getX() / this.mScreenDensity, event.getY() / this.mScreenDensity);
                    return true;
                }
            }
            return super.onGenericMotionEvent(event);
        }
        return super.onGenericMotionEvent(event);
    }

    public boolean onHoverEvent(@NonNull MotionEvent event) {
        switch (event.getActionMasked()) {
            case 7: 
            case 9: {
                if (this.mZoomControlsEnabled && this.mZoomEnabled) {
                    this.mZoomButtonsController.setVisible(true);
                }
                return true;
            }
            case 10: {
                if (!this.mZoomControlsEnabled) break;
                this.mZoomButtonsController.setVisible(false);
            }
        }
        return super.onHoverEvent(event);
    }

    private void onConnectivityChanged(boolean isConnected) {
        this.mNativeMapView.setReachability(isConnected);
    }

    @UiThread
    public void addOnMapChangedListener(@Nullable OnMapChangedListener listener) {
        if (listener != null) {
            this.mOnMapChangedListener.add(listener);
        }
    }

    @UiThread
    public void removeOnMapChangedListener(@Nullable OnMapChangedListener listener) {
        if (listener != null) {
            this.mOnMapChangedListener.remove(listener);
        }
    }

    protected void onMapChanged(int mapChange) {
        if (this.mOnMapChangedListener != null) {
            int count = this.mOnMapChangedListener.size();
            for (int i = 0; i < count; ++i) {
                this.mOnMapChangedListener.get(i).onMapChanged(mapChange);
            }
        }
    }

    @UiThread
    public void setInfoWindowAdapter(@Nullable InfoWindowAdapter infoWindowAdapter) {
        this.mInfoWindowAdapter = infoWindowAdapter;
    }

    @UiThread
    @Nullable
    public InfoWindowAdapter getInfoWindowAdapter() {
        return this.mInfoWindowAdapter;
    }

    @UiThread
    public void setOnFpsChangedListener(@Nullable OnFpsChangedListener listener) {
        this.mOnFpsChangedListener = listener;
    }

    protected void onFpsChanged(final double fps) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (MapView.this.mOnFpsChangedListener != null) {
                    MapView.this.mOnFpsChangedListener.onFpsChanged(fps);
                }
            }
        });
    }

    @UiThread
    public void setOnScrollListener(@Nullable OnScrollListener listener) {
        this.mOnScrollListener = listener;
    }

    @UiThread
    public void setOnFlingListener(@Nullable OnFlingListener listener) {
        this.mOnFlingListener = listener;
    }

    @UiThread
    public void setOnMapClickListener(@Nullable OnMapClickListener listener) {
        this.mOnMapClickListener = listener;
    }

    @UiThread
    public void setOnMapLongClickListener(@Nullable OnMapLongClickListener listener) {
        this.mOnMapLongClickListener = listener;
    }

    @UiThread
    public void setOnMarkerClickListener(@Nullable OnMarkerClickListener listener) {
        this.mOnMarkerClickListener = listener;
    }

    @UiThread
    @Nullable
    public OnInfoWindowClickListener getOnInfoWindowClickListener() {
        return this.mOnInfoWindowClickListener;
    }

    @UiThread
    public void setOnInfoWindowClickListener(@Nullable OnInfoWindowClickListener listener) {
        this.mOnInfoWindowClickListener = listener;
    }

    @UiThread
    public boolean isMyLocationEnabled() {
        return this.mUserLocationView.isEnabled();
    }

    @UiThread
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void setMyLocationEnabled(boolean enabled) {
        this.mUserLocationView.setEnabled(enabled);
    }

    @UiThread
    @Nullable
    public Location getMyLocation() {
        return this.mUserLocationView.getLocation();
    }

    @UiThread
    public void setOnMyLocationChangeListener(@Nullable OnMyLocationChangeListener listener) {
        this.mUserLocationView.setOnMyLocationChangeListener(listener);
    }

    @UiThread
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void setMyLocationTrackingMode(int myLocationTrackingMode) {
        if (myLocationTrackingMode != 0 && !this.isMyLocationEnabled()) {
            this.setMyLocationEnabled(true);
        }
        this.mUserLocationView.setMyLocationTrackingMode(myLocationTrackingMode);
        if (this.mOnMyLocationTrackingModeChangeListener != null) {
            this.mOnMyLocationTrackingModeChangeListener.onMyLocationTrackingModeChange(myLocationTrackingMode);
        }
    }

    @UiThread
    public int getMyLocationTrackingMode() {
        return this.mUserLocationView.getMyLocationTrackingMode();
    }

    @UiThread
    public void setOnMyLocationTrackingModeChangeListener(@Nullable OnMyLocationTrackingModeChangeListener listener) {
        this.mOnMyLocationTrackingModeChangeListener = listener;
    }

    @UiThread
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void setMyBearingTrackingMode(int myBearingTrackingMode) {
        if (myBearingTrackingMode != 0 && !this.isMyLocationEnabled()) {
            this.setMyLocationEnabled(true);
        }
        this.mUserLocationView.setMyBearingTrackingMode(myBearingTrackingMode);
        if (this.mOnMyBearingTrackingModeChangeListener != null) {
            this.mOnMyBearingTrackingModeChangeListener.onMyBearingTrackingModeChange(myBearingTrackingMode);
        }
    }

    @UiThread
    public int getMyBearingTrackingMode() {
        return this.mUserLocationView.getMyBearingTrackingMode();
    }

    @UiThread
    public void setOnMyBearingTrackingModeChangeListener(@Nullable OnMyBearingTrackingModeChangeListener listener) {
        this.mOnMyBearingTrackingModeChangeListener = listener;
    }

    private void resetTrackingModes() {
        try {
            this.setMyLocationTrackingMode(0);
            this.setMyBearingTrackingMode(0);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @UiThread
    public boolean isCompassEnabled() {
        return this.mCompassView.isEnabled();
    }

    @UiThread
    public void setCompassEnabled(boolean compassEnabled) {
        this.mCompassView.setEnabled(compassEnabled);
    }

    @UiThread
    public void setCompassGravity(int gravity) {
        this.setWidgetGravity((View)this.mCompassView, gravity);
    }

    @UiThread
    public void setCompassMargins(int left, int top, int right, int bottom) {
        this.setWidgetMargins((View)this.mCompassView, left, top, right, bottom);
    }

    @UiThread
    public void setLogoGravity(int gravity) {
        this.setWidgetGravity((View)this.mLogoView, gravity);
    }

    @UiThread
    public void setLogoMargins(int left, int top, int right, int bottom) {
        this.setWidgetMargins((View)this.mLogoView, left, top, right, bottom);
    }

    @UiThread
    public void setLogoVisibility(int visibility) {
        this.mLogoView.setVisibility(visibility);
    }

    @UiThread
    public void setAttributionGravity(int gravity) {
        this.setWidgetGravity((View)this.mAttributionsView, gravity);
    }

    @UiThread
    public void setAttributionMargins(int left, int top, int right, int bottom) {
        this.setWidgetMargins((View)this.mAttributionsView, left, top, right, bottom);
    }

    @UiThread
    public void setAttributionVisibility(int visibility) {
        this.mAttributionsView.setVisibility(visibility);
    }

    @UiThread
    public void addCustomLayer(CustomLayer customLayer, String before) {
        this.mNativeMapView.addCustomLayer(customLayer, before);
    }

    @UiThread
    public void removeCustomLayer(String id2) {
        this.mNativeMapView.removeCustomLayer(id2);
    }

    @UiThread
    public void invalidateCustomLayers() {
        this.mNativeMapView.update();
    }

    private void setWidgetGravity(@NonNull View view, int gravity) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.gravity = gravity;
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void setWidgetMargins(@NonNull View view, int left, int top, int right, int bottom) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.setMargins(left, top, right, bottom);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void setWidgetMargins(@NonNull View view, float leftDp, float topDp, float rightDp, float bottomDp) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.setMargins((int)(leftDp * this.mScreenDensity), (int)(topDp * this.mScreenDensity), (int)(rightDp * this.mScreenDensity), (int)(bottomDp * this.mScreenDensity));
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private static class AttributionOnClickListener
    implements View.OnClickListener,
    DialogInterface.OnClickListener {
        private MapView mMapView;

        public AttributionOnClickListener(MapView mapView) {
            this.mMapView = mapView;
        }

        public void onClick(View v) {
            Context context = v.getContext();
            Object[] items = context.getResources().getStringArray(R.array.attribution_names);
            AlertDialog.Builder builder = new AlertDialog.Builder(context, R.style.AttributionAlertDialogStyle);
            builder.setTitle(R.string.attributionsDialogTitle);
            builder.setAdapter((ListAdapter)new ArrayAdapter(context, R.layout.attribution_list_item, items), (DialogInterface.OnClickListener)this);
            builder.show();
        }

        public void onClick(DialogInterface dialog, int which) {
            Context context = ((Dialog)dialog).getContext();
            String url = context.getResources().getStringArray(R.array.attribution_links)[which];
            if (which == 2) {
                LatLng latLng = this.mMapView.getLatLng();
                url = String.format(url, latLng.getLongitude(), latLng.getLatitude(), (int)this.mMapView.getZoom());
            }
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            context.startActivity(intent);
        }
    }

    private class ConnectivityReceiver
    extends BroadcastReceiver {
        private ConnectivityReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                boolean noConnectivity = intent.getBooleanExtra("noConnectivity", false);
                MapView.this.onConnectivityChanged(!noConnectivity);
            }
        }
    }

    private class TrackballLongPressTimeOut
    implements Runnable {
        private boolean cancelled = false;

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                MapView.this.zoom(false);
                MapView.this.mCurrentTrackballLongPressTimeOut = null;
            }
        }
    }

    private class OnZoomListener
    implements ZoomButtonsController.OnZoomListener {
        private OnZoomListener() {
        }

        public void onVisibilityChanged(boolean visible) {
        }

        public void onZoom(boolean zoomIn) {
            if (!MapView.this.mZoomEnabled) {
                return;
            }
            MapView.this.zoom(zoomIn);
        }
    }

    private class ShoveGestureListener
    implements ShoveGestureDetector.OnShoveGestureListener {
        long mBeginTime = 0L;
        float mTotalDelta = 0.0f;
        boolean mStarted = false;

        private ShoveGestureListener() {
        }

        @Override
        public boolean onShoveBegin(ShoveGestureDetector detector) {
            if (!MapView.this.mTiltEnabled) {
                return false;
            }
            MapView.this.resetTrackingModes();
            this.mBeginTime = detector.getEventTime();
            return true;
        }

        @Override
        public void onShoveEnd(ShoveGestureDetector detector) {
            this.mBeginTime = 0L;
            this.mTotalDelta = 0.0f;
            this.mStarted = false;
        }

        @Override
        public boolean onShove(ShoveGestureDetector detector) {
            if (!MapView.this.mTiltEnabled) {
                return false;
            }
            this.mTotalDelta += detector.getShovePixelsDelta();
            if (!MapView.this.mZoomStarted && (this.mTotalDelta > 10.0f || this.mTotalDelta < -10.0f)) {
                this.mStarted = true;
            }
            long time = detector.getEventTime();
            long interval = time - this.mBeginTime;
            if (!this.mStarted && interval <= (long)ViewConfiguration.getTapTimeout()) {
                return false;
            }
            if (!this.mStarted) {
                return false;
            }
            MapView.this.mNativeMapView.cancelTransitions();
            double pitch = MapView.this.getTilt();
            pitch -= 0.1 * (double)detector.getShovePixelsDelta();
            pitch = Math.max(0.0, Math.min(60.0, pitch));
            MapView.this.setTilt(pitch, null);
            return true;
        }
    }

    private class RotateGestureListener
    extends RotateGestureDetector.SimpleOnRotateGestureListener {
        long mBeginTime = 0L;
        float mTotalAngle = 0.0f;
        boolean mStarted = false;

        private RotateGestureListener() {
        }

        @Override
        public boolean onRotateBegin(RotateGestureDetector detector) {
            if (!MapView.this.mRotateEnabled) {
                return false;
            }
            MapView.this.resetTrackingModes();
            this.mBeginTime = detector.getEventTime();
            return true;
        }

        @Override
        public void onRotateEnd(RotateGestureDetector detector) {
            this.mBeginTime = 0L;
            this.mTotalAngle = 0.0f;
            this.mStarted = false;
        }

        @Override
        public boolean onRotate(RotateGestureDetector detector) {
            if (!MapView.this.mRotateEnabled) {
                return false;
            }
            this.mTotalAngle += detector.getRotationDegreesDelta();
            if (!MapView.this.mZoomStarted && (this.mTotalAngle > 10.0f || this.mTotalAngle < -10.0f)) {
                this.mStarted = true;
            }
            long time = detector.getEventTime();
            long interval = time - this.mBeginTime;
            if (!this.mStarted && interval <= (long)ViewConfiguration.getTapTimeout()) {
                return false;
            }
            if (!this.mStarted) {
                return false;
            }
            MapView.this.mNativeMapView.cancelTransitions();
            double bearing = MapView.this.mNativeMapView.getBearing();
            bearing += (double)detector.getRotationDegreesDelta();
            if (MapView.this.mUserLocationView.getMyLocationTrackingMode() == 0) {
                MapView.this.mNativeMapView.setBearing(bearing, detector.getFocusX() / MapView.this.mScreenDensity, detector.getFocusY() / MapView.this.mScreenDensity);
            } else {
                MapView.this.mNativeMapView.setBearing(bearing, (float)(MapView.this.getWidth() / 2) / MapView.this.mScreenDensity, (float)(MapView.this.getHeight() / 2) / MapView.this.mScreenDensity);
            }
            return true;
        }
    }

    private class ScaleGestureListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        long mBeginTime = 0L;
        float mScaleFactor = 1.0f;

        private ScaleGestureListener() {
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            if (!MapView.this.mZoomEnabled) {
                return false;
            }
            MapView.this.resetTrackingModes();
            this.mBeginTime = detector.getEventTime();
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            this.mBeginTime = 0L;
            this.mScaleFactor = 1.0f;
            MapView.this.mZoomStarted = false;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            if (!MapView.this.mZoomEnabled) {
                return false;
            }
            this.mScaleFactor *= detector.getScaleFactor();
            if (this.mScaleFactor > 1.05f || this.mScaleFactor < 0.95f) {
                MapView.this.mZoomStarted = true;
            }
            long time = detector.getEventTime();
            long interval = time - this.mBeginTime;
            if (!MapView.this.mZoomStarted && interval <= (long)ViewConfiguration.getTapTimeout()) {
                return false;
            }
            if (!MapView.this.mZoomStarted) {
                return false;
            }
            MapView.this.mNativeMapView.cancelTransitions();
            MapView.this.mQuickZoom = !MapView.this.mTwoTap;
            if (MapView.this.mScrollEnabled && !MapView.this.mQuickZoom && MapView.this.mUserLocationView.getMyLocationTrackingMode() == 0) {
                MapView.this.mNativeMapView.scaleBy(detector.getScaleFactor(), detector.getFocusX() / MapView.this.mScreenDensity, detector.getFocusY() / MapView.this.mScreenDensity);
            } else {
                MapView.this.mNativeMapView.scaleBy(detector.getScaleFactor(), (float)(MapView.this.getWidth() / 2) / MapView.this.mScreenDensity, (float)(MapView.this.getHeight() / 2) / MapView.this.mScreenDensity);
            }
            return true;
        }
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public boolean onDown(MotionEvent event) {
            if (MapView.this.mZoomControlsEnabled && MapView.this.mZoomEnabled) {
                MapView.this.mZoomButtonsController.setVisible(true);
            }
            return true;
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            if (!MapView.this.mZoomEnabled) {
                return false;
            }
            switch (e.getAction()) {
                case 0: {
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    if (MapView.this.mQuickZoom) {
                        MapView.this.mQuickZoom = false;
                        break;
                    }
                    if (MapView.this.mUserLocationView.getMyLocationTrackingMode() == 0) {
                        MapView.this.zoom(true, e.getX(), e.getY());
                        break;
                    }
                    MapView.this.zoom(true, MapView.this.getWidth() / 2, MapView.this.getHeight() / 2);
                }
            }
            return true;
        }

        public boolean onSingleTapUp(MotionEvent e) {
            MapView.this.mNativeMapView.cancelTransitions();
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            PointF tapPoint = new PointF(e.getX(), e.getY());
            float toleranceSides = 15.0f * MapView.this.mScreenDensity;
            float toleranceTop = 20.0f * MapView.this.mScreenDensity;
            float toleranceBottom = 5.0f * MapView.this.mScreenDensity;
            RectF tapRect = new RectF(tapPoint.x - toleranceSides, tapPoint.y + toleranceTop, tapPoint.x + toleranceSides, tapPoint.y - toleranceBottom);
            List<LatLng> corners = Arrays.asList(MapView.this.fromScreenLocation(new PointF(tapRect.left, tapRect.bottom)), MapView.this.fromScreenLocation(new PointF(tapRect.left, tapRect.top)), MapView.this.fromScreenLocation(new PointF(tapRect.right, tapRect.top)), MapView.this.fromScreenLocation(new PointF(tapRect.right, tapRect.bottom)));
            BoundingBox tapBounds = BoundingBox.fromLatLngs(corners);
            List nearbyMarkers = MapView.this.getMarkersInBounds(tapBounds);
            long newSelectedMarkerId = -1L;
            if (nearbyMarkers != null && nearbyMarkers.size() > 0) {
                Collections.sort(nearbyMarkers);
                for (Marker nearbyMarker : nearbyMarkers) {
                    boolean found = false;
                    for (Marker selectedMarker : MapView.this.mSelectedMarkers) {
                        if (!selectedMarker.equals(nearbyMarker)) continue;
                        found = true;
                    }
                    if (found) continue;
                    newSelectedMarkerId = nearbyMarker.getId();
                    break;
                }
                MapView.this.mMarkersNearLastTap = nearbyMarkers;
            }
            if (newSelectedMarkerId >= 0L) {
                int count = MapView.this.mAnnotations.size();
                for (int i = 0; i < count; ++i) {
                    Annotation annotation = (Annotation)MapView.this.mAnnotations.get(i);
                    if (!(annotation instanceof Marker) || annotation.getId() != newSelectedMarkerId) continue;
                    if (MapView.this.mSelectedMarkers.isEmpty() || !MapView.this.mSelectedMarkers.contains(annotation)) {
                        MapView.this.selectMarker((Marker)annotation);
                    }
                    break;
                }
            } else {
                MapView.this.deselectMarkers();
                if (MapView.this.mOnMapClickListener != null) {
                    LatLng point = MapView.this.fromScreenLocation(tapPoint);
                    MapView.this.mOnMapClickListener.onMapClick(point);
                }
            }
            return true;
        }

        public void onLongPress(MotionEvent e) {
            if (MapView.this.mOnMapLongClickListener != null && !MapView.this.mQuickZoom) {
                LatLng point = MapView.this.fromScreenLocation(new PointF(e.getX(), e.getY()));
                MapView.this.mOnMapLongClickListener.onMapLongClick(point);
            }
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (!MapView.this.mScrollEnabled) {
                return false;
            }
            MapView.this.resetTrackingModes();
            float ease = 0.25f;
            double speed = Math.sqrt((velocityX *= ease) * velocityX + (velocityY *= ease) * velocityY);
            double deceleration = 2500.0;
            double duration = speed / (deceleration * (double)ease);
            MapView.this.mNativeMapView.cancelTransitions();
            MapView.this.mNativeMapView.moveBy((double)velocityX * duration / 2.0 / (double)MapView.this.mScreenDensity, (double)velocityY * duration / 2.0 / (double)MapView.this.mScreenDensity, (long)(duration * 1000.0));
            if (MapView.this.mOnFlingListener != null) {
                MapView.this.mOnFlingListener.onFling();
            }
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (!MapView.this.mScrollEnabled) {
                return false;
            }
            MapView.this.resetTrackingModes();
            MapView.this.mNativeMapView.cancelTransitions();
            MapView.this.mNativeMapView.moveBy(-distanceX / MapView.this.mScreenDensity, -distanceY / MapView.this.mScreenDensity);
            if (MapView.this.mOnScrollListener != null) {
                MapView.this.mOnScrollListener.onScroll();
            }
            return true;
        }
    }

    private class SurfaceTextureListener
    implements TextureView.SurfaceTextureListener {
        private SurfaceTextureListener() {
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            MapView.this.mNativeMapView.createSurface(new Surface(surface));
            MapView.this.mNativeMapView.resizeFramebuffer(width, height);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            if (MapView.this.mNativeMapView != null) {
                MapView.this.mNativeMapView.destroySurface();
            }
            return true;
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            MapView.this.mNativeMapView.resizeFramebuffer(width, height);
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            MapView.this.mCompassView.update(MapView.this.getDirection());
            MapView.this.mUserLocationView.update();
            for (InfoWindow infoWindow : MapView.this.mInfoWindows) {
                infoWindow.update();
            }
        }
    }

    public static interface CancelableCallback {
        public void onCancel();

        public void onFinish();
    }

    public static interface OnMyBearingTrackingModeChangeListener {
        public void onMyBearingTrackingModeChange(int var1);
    }

    public static interface OnMyLocationTrackingModeChangeListener {
        public void onMyLocationTrackingModeChange(int var1);
    }

    public static interface OnMyLocationChangeListener {
        public void onMyLocationChange(@Nullable Location var1);
    }

    public static interface InfoWindowAdapter {
        @Nullable
        public View getInfoWindow(@NonNull Marker var1);
    }

    public static interface OnMapChangedListener {
        public void onMapChanged(int var1);
    }

    public static interface OnInfoWindowClickListener {
        public boolean onMarkerClick(@NonNull Marker var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(@NonNull Marker var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(@NonNull LatLng var1);
    }

    public static interface OnMapClickListener {
        public void onMapClick(@NonNull LatLng var1);
    }

    public static interface OnFpsChangedListener {
        public void onFpsChanged(double var1);
    }

    public static interface OnScrollListener {
        public void onScroll();
    }

    public static interface OnFlingListener {
        public void onFling();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MapChange {
    }
}

