/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PointF;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.InfoWindowView;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.views.MapView;
import java.lang.ref.WeakReference;

public class InfoWindow {
    private WeakReference<Marker> mBoundMarker;
    private WeakReference<MapView> mMapView;
    private float mMarkerHeightOffset;
    private float mViewWidthOffset;
    private PointF mCoordinates;
    private boolean mIsVisible;
    protected View mView;
    static int mTitleId = 0;
    static int mDescriptionId = 0;
    static int mSubDescriptionId = 0;
    static int mImageId = 0;

    InfoWindow(int layoutResId, MapView mapView) {
        View view = LayoutInflater.from((Context)mapView.getContext()).inflate(layoutResId, (ViewGroup)mapView, false);
        if (mTitleId == 0) {
            InfoWindow.setResIds(mapView.getContext());
        }
        this.initialize(view, mapView);
    }

    InfoWindow(View view, MapView mapView) {
        this.initialize(view, mapView);
    }

    private void initialize(View view, MapView mapView) {
        this.mMapView = new WeakReference<MapView>(mapView);
        this.mIsVisible = false;
        this.mView = view;
        this.mView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent e) {
                if (e.getAction() == 1) {
                    boolean handledDefaultClick = false;
                    MapView.OnInfoWindowClickListener onInfoWindowClickListener = ((MapView)((Object)InfoWindow.this.mMapView.get())).getOnInfoWindowClickListener();
                    if (onInfoWindowClickListener != null) {
                        handledDefaultClick = onInfoWindowClickListener.onMarkerClick(InfoWindow.this.getBoundMarker());
                    }
                    if (!handledDefaultClick) {
                        InfoWindow.this.close();
                    }
                }
                return true;
            }
        });
    }

    InfoWindow open(Marker boundMarker, LatLng position, int offsetX, int offsetY) {
        this.setBoundMarker(boundMarker);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
        this.mView.measure(0, 0);
        this.mMarkerHeightOffset = -this.mView.getMeasuredHeight() + offsetY;
        this.mCoordinates = ((MapView)((Object)this.mMapView.get())).toScreenLocation(position);
        float x = this.mCoordinates.x - (float)(this.mView.getMeasuredWidth() / 2) + (float)offsetX;
        float y = this.mCoordinates.y - (float)this.mView.getMeasuredHeight() + (float)offsetY;
        if (this.mView instanceof InfoWindowView) {
            Resources resources = ((MapView)((Object)this.mMapView.get())).getContext().getResources();
            float rightSideInfowWindow = x + (float)this.mView.getMeasuredWidth();
            float leftSideInfoWindow = x;
            float mapRight = ((MapView)((Object)this.mMapView.get())).getRight();
            float mapLeft = ((MapView)((Object)this.mMapView.get())).getLeft();
            float marginHorizontal = resources.getDimension(R.dimen.infowindow_margin);
            float tipViewOffset = resources.getDimension(R.dimen.infowindow_tipview_width) / 2.0f;
            float tipViewMarginLeft = (float)(this.mView.getMeasuredWidth() / 2) - tipViewOffset;
            boolean outOfBoundsLeft = false;
            boolean outOfBoundsRight = false;
            if (rightSideInfowWindow > mapRight) {
                outOfBoundsRight = true;
                x -= rightSideInfowWindow - mapRight;
                tipViewMarginLeft += rightSideInfowWindow - mapRight + tipViewOffset;
                rightSideInfowWindow = x + (float)this.mView.getMeasuredWidth();
            }
            if (leftSideInfoWindow < mapLeft) {
                outOfBoundsLeft = true;
                x += mapLeft - leftSideInfoWindow;
                tipViewMarginLeft -= mapLeft - leftSideInfoWindow + tipViewOffset;
                leftSideInfoWindow = x;
            }
            if (outOfBoundsRight && mapRight - rightSideInfowWindow < marginHorizontal) {
                tipViewMarginLeft += marginHorizontal - (mapRight - rightSideInfowWindow) - tipViewOffset;
                leftSideInfoWindow = x -= marginHorizontal - (mapRight - rightSideInfowWindow);
            }
            if (outOfBoundsLeft && leftSideInfoWindow - mapLeft < marginHorizontal) {
                x += marginHorizontal - (leftSideInfoWindow - mapLeft);
                tipViewMarginLeft -= marginHorizontal - (leftSideInfoWindow - mapLeft) - tipViewOffset;
            }
            InfoWindowView infoWindowView = (InfoWindowView)this.mView;
            infoWindowView.setTipViewMarginLeft((int)tipViewMarginLeft);
        }
        this.mView.setX(x);
        this.mView.setY(y);
        this.mViewWidthOffset = x - this.mCoordinates.x - (float)offsetX;
        this.close();
        ((MapView)((Object)this.mMapView.get())).addView(this.mView, (ViewGroup.LayoutParams)lp);
        this.mIsVisible = true;
        return this;
    }

    InfoWindow close() {
        if (this.mIsVisible) {
            this.mIsVisible = false;
            ((ViewGroup)this.mView.getParent()).removeView(this.mView);
            this.setBoundMarker(null);
            this.onClose();
        }
        return this;
    }

    void adaptDefaultMarker(Marker overlayItem) {
        String title = overlayItem.getTitle();
        ((TextView)this.mView.findViewById(mTitleId)).setText((CharSequence)title);
        String snippet = overlayItem.getSnippet();
        ((TextView)this.mView.findViewById(mDescriptionId)).setText((CharSequence)snippet);
    }

    private void onClose() {
        ((MapView)((Object)this.mMapView.get())).deselectMarker(this.getBoundMarker());
    }

    InfoWindow setBoundMarker(Marker boundMarker) {
        this.mBoundMarker = new WeakReference<Marker>(boundMarker);
        return this;
    }

    Marker getBoundMarker() {
        if (this.mBoundMarker == null) {
            return null;
        }
        return (Marker)this.mBoundMarker.get();
    }

    private static void setResIds(Context context) {
        String packageName = context.getPackageName();
        mTitleId = context.getResources().getIdentifier("id/infowindow_title", null, packageName);
        mDescriptionId = context.getResources().getIdentifier("id/infowindow_description", null, packageName);
        mSubDescriptionId = context.getResources().getIdentifier("id/infowindow_subdescription", null, packageName);
        mImageId = context.getResources().getIdentifier("id/infowindow_image", null, packageName);
    }

    public void update() {
        MapView mapView = (MapView)((Object)this.mMapView.get());
        Marker marker = (Marker)this.mBoundMarker.get();
        if (mapView != null && marker != null) {
            this.mCoordinates = mapView.toScreenLocation(marker.getPosition());
            this.mView.setX(this.mCoordinates.x + this.mViewWidthOffset);
            this.mView.setY(this.mCoordinates.y + this.mMarkerHeightOffset);
        }
    }
}

