/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.content.Context;
import android.graphics.PointF;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.views.MapView;

public class InfoWindow {
    private Marker boundMarker;
    private MapView mMapView;
    private boolean mIsVisible;
    protected View mView;
    static int mTitleId = 0;
    static int mDescriptionId = 0;
    static int mSubDescriptionId = 0;
    static int mImageId = 0;

    public InfoWindow(int layoutResId, MapView mapView) {
        this.mMapView = mapView;
        this.mIsVisible = false;
        Context context = mapView.getContext();
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mView = inflater.inflate(layoutResId, (ViewGroup)mapView, false);
        if (mTitleId == 0) {
            InfoWindow.setResIds(mapView.getContext());
        }
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent e) {
                if (e.getAction() == 1) {
                    InfoWindow.this.close();
                }
                return true;
            }
        });
    }

    public InfoWindow(View view, MapView mapView) {
        this.mMapView = mapView;
        this.mIsVisible = false;
        ViewGroup parent = (ViewGroup)mapView.getParent();
        Context context = mapView.getContext();
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mView = view;
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent e) {
                if (e.getAction() == 1) {
                    InfoWindow.this.close();
                }
                return true;
            }
        });
    }

    public InfoWindow open(Marker object, LatLng position, int offsetX, int offsetY) {
        this.onOpen(object);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
        this.mView.measure(0, 0);
        PointF coords = this.mMapView.toScreenLocation(position);
        double y = this.mMapView.getTopOffsetPixelsForAnnotationSymbol(object.sprite);
        coords.y = (float)this.mMapView.getHeight() - coords.y;
        lp.leftMargin = (int)coords.x - this.mView.getMeasuredWidth() / 2;
        lp.topMargin = (int)coords.y - this.mView.getMeasuredHeight() + (int)(y *= (double)this.mMapView.getScreenDensity());
        this.close();
        this.mMapView.addView(this.mView, (ViewGroup.LayoutParams)lp);
        this.mIsVisible = true;
        return this;
    }

    public InfoWindow close() {
        if (this.mIsVisible) {
            this.mIsVisible = false;
            ((ViewGroup)this.mView.getParent()).removeView(this.mView);
            this.setBoundMarker(null);
            this.onClose();
        }
        return this;
    }

    public View getView() {
        return this.mView;
    }

    public MapView getMapView() {
        return this.mMapView;
    }

    public void onOpen(Marker overlayItem) {
        String title = overlayItem.getTitle();
        ((TextView)this.mView.findViewById(mTitleId)).setText((CharSequence)title);
        String snippet = overlayItem.getSnippet();
        ((TextView)this.mView.findViewById(mDescriptionId)).setText((CharSequence)snippet);
    }

    public void onClose() {
    }

    public InfoWindow setBoundMarker(Marker aBoundMarker) {
        this.boundMarker = aBoundMarker;
        return this;
    }

    public Marker getBoundMarker() {
        return this.boundMarker;
    }

    private static void setResIds(Context context) {
        String packageName = context.getPackageName();
        mTitleId = context.getResources().getIdentifier("id/infowindow_title", null, packageName);
        mDescriptionId = context.getResources().getIdentifier("id/infowindow_description", null, packageName);
        mSubDescriptionId = context.getResources().getIdentifier("id/infowindow_subdescription", null, packageName);
        mImageId = context.getResources().getIdentifier("id/infowindow_image", null, packageName);
    }

    public void setOnTouchListener(View.OnTouchListener listener) {
        this.mView.setOnTouchListener(listener);
    }
}

