/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.views;

import android.graphics.PointF;
import android.view.Surface;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.geometry.BoundingBox;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngZoom;
import com.mapbox.mapboxsdk.geometry.ProjectedMeters;
import com.mapbox.mapboxsdk.views.MapView;
import java.util.List;

class NativeMapView {
    private long mNativeMapViewPtr = 0L;
    private MapView mMapView;

    public NativeMapView(MapView mapView, String cachePath, String dataPath, String apkPath, float pixelRatio, int availableProcessors, long totalMemory) {
        if (availableProcessors < 0) {
            throw new IllegalArgumentException("availableProcessors cannot be negative.");
        }
        if (totalMemory < 0L) {
            throw new IllegalArgumentException("totalMemory cannot be negative.");
        }
        this.mMapView = mapView;
        this.mNativeMapViewPtr = this.nativeCreate(cachePath, dataPath, apkPath, pixelRatio, availableProcessors, totalMemory);
    }

    public void initializeDisplay() {
        this.nativeInitializeDisplay(this.mNativeMapViewPtr);
    }

    public void terminateDisplay() {
        this.nativeTerminateDisplay(this.mNativeMapViewPtr);
    }

    public void initializeContext() {
        this.nativeInitializeContext(this.mNativeMapViewPtr);
    }

    public void terminateContext() {
        this.nativeTerminateContext(this.mNativeMapViewPtr);
    }

    public void createSurface(Surface surface) {
        this.nativeCreateSurface(this.mNativeMapViewPtr, surface);
    }

    public void destroySurface() {
        this.nativeDestroySurface(this.mNativeMapViewPtr);
    }

    public void pause() {
        this.nativePause(this.mNativeMapViewPtr);
    }

    public void resume() {
        this.nativeResume(this.mNativeMapViewPtr);
    }

    public void update() {
        this.nativeUpdate(this.mNativeMapViewPtr);
    }

    public void invalidate() {
        this.nativeOnInvalidate(this.mNativeMapViewPtr);
    }

    public void resizeView(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be negative.");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be negative.");
        }
        if (width > 65535) {
            throw new IllegalArgumentException("width cannot be greater than 65535.");
        }
        if (height > 65535) {
            throw new IllegalArgumentException("height cannot be greater than 65535.");
        }
        this.nativeViewResize(this.mNativeMapViewPtr, width, height);
    }

    public void resizeFramebuffer(int fbWidth, int fbHeight) {
        if (fbWidth < 0) {
            throw new IllegalArgumentException("fbWidth cannot be negative.");
        }
        if (fbHeight < 0) {
            throw new IllegalArgumentException("fbHeight cannot be negative.");
        }
        if (fbWidth > 65535) {
            throw new IllegalArgumentException("fbWidth cannot be greater than 65535.");
        }
        if (fbHeight > 65535) {
            throw new IllegalArgumentException("fbHeight cannot be greater than 65535.");
        }
        this.nativeFramebufferResize(this.mNativeMapViewPtr, fbWidth, fbHeight);
    }

    public void addClass(String clazz) {
        this.nativeAddClass(this.mNativeMapViewPtr, clazz);
    }

    public void removeClass(String clazz) {
        this.nativeRemoveClass(this.mNativeMapViewPtr, clazz);
    }

    public boolean hasClass(String clazz) {
        return this.nativeHasClass(this.mNativeMapViewPtr, clazz);
    }

    public void setClasses(List<String> classes) {
        this.nativeSetClasses(this.mNativeMapViewPtr, classes);
    }

    public List<String> getClasses() {
        return this.nativeGetClasses(this.mNativeMapViewPtr);
    }

    public void setDefaultTransitionDuration() {
        this.setDefaultTransitionDuration(0L);
    }

    public long getDefaultTransitionDuration() {
        return this.nativeGetDefaultTransitionDuration(this.mNativeMapViewPtr);
    }

    public void setDefaultTransitionDuration(long milliseconds) {
        if (milliseconds < 0L) {
            throw new IllegalArgumentException("milliseconds cannot be negative.");
        }
        this.nativeSetDefaultTransitionDuration(this.mNativeMapViewPtr, milliseconds);
    }

    public void setStyleUrl(String url) {
        this.nativeSetStyleUrl(this.mNativeMapViewPtr, url);
    }

    public void setStyleJson(String newStyleJson) {
        this.setStyleJson(newStyleJson, "");
    }

    public void setStyleJson(String newStyleJson, String base) {
        this.nativeSetStyleJson(this.mNativeMapViewPtr, newStyleJson, base);
    }

    public String getStyleJson() {
        return this.nativeGetStyleJson(this.mNativeMapViewPtr);
    }

    public void setAccessToken(String accessToken) {
        this.nativeSetAccessToken(this.mNativeMapViewPtr, accessToken);
    }

    public String getAccessToken() {
        return this.nativeGetAccessToken(this.mNativeMapViewPtr);
    }

    public void cancelTransitions() {
        this.nativeCancelTransitions(this.mNativeMapViewPtr);
    }

    public void setGestureInProgress(boolean inProgress) {
        this.nativeSetGestureInProgress(this.mNativeMapViewPtr, inProgress);
    }

    public void moveBy(double dx, double dy) {
        this.moveBy(dx, dy, 0L);
    }

    public void moveBy(double dx, double dy, long duration) {
        this.nativeMoveBy(this.mNativeMapViewPtr, dx, dy, duration);
    }

    public void setLatLng(LatLng latLng) {
        this.setLatLng(latLng, 0L);
    }

    public void setLatLng(LatLng latLng, long duration) {
        this.nativeSetLatLng(this.mNativeMapViewPtr, latLng, duration);
    }

    public LatLng getLatLng() {
        return this.nativeGetLatLng(this.mNativeMapViewPtr);
    }

    public void resetPosition() {
        this.nativeResetPosition(this.mNativeMapViewPtr);
    }

    public void scaleBy(double ds) {
        this.scaleBy(ds, -1.0, -1.0);
    }

    public void scaleBy(double ds, double cx, double cy) {
        this.scaleBy(ds, cx, cy, 0L);
    }

    public void scaleBy(double ds, double cx, double cy, long duration) {
        this.nativeScaleBy(this.mNativeMapViewPtr, ds, cx, cy, duration);
    }

    public void setScale(double scale) {
        this.setScale(scale, -1.0, -1.0);
    }

    public void setScale(double scale, double cx, double cy) {
        this.setScale(scale, cx, cy, 0L);
    }

    public void setScale(double scale, double cx, double cy, long duration) {
        this.nativeSetScale(this.mNativeMapViewPtr, scale, cx, cy, duration);
    }

    public double getScale() {
        return this.nativeGetScale(this.mNativeMapViewPtr);
    }

    public void setZoom(double zoom) {
        this.setZoom(zoom, 0L);
    }

    public void setZoom(double zoom, long duration) {
        this.nativeSetZoom(this.mNativeMapViewPtr, zoom, duration);
    }

    public double getZoom() {
        return this.nativeGetZoom(this.mNativeMapViewPtr);
    }

    public void setLatLngZoom(LatLngZoom latLngZoom) {
        this.setLatLngZoom(latLngZoom, 0L);
    }

    public void setLatLngZoom(LatLngZoom latLngZoom, long duration) {
        this.nativeSetLatLngZoom(this.mNativeMapViewPtr, latLngZoom, duration);
    }

    public LatLngZoom getLatLngZoom() {
        return this.nativeGetLatLngZoom(this.mNativeMapViewPtr);
    }

    public void resetZoom() {
        this.nativeResetZoom(this.mNativeMapViewPtr);
    }

    public double getMinZoom() {
        return this.nativeGetMinZoom(this.mNativeMapViewPtr);
    }

    public double getMaxZoom() {
        return this.nativeGetMaxZoom(this.mNativeMapViewPtr);
    }

    public void rotateBy(double sx, double sy, double ex, double ey) {
        this.rotateBy(sx, sy, ex, ey, 0L);
    }

    public void rotateBy(double sx, double sy, double ex, double ey, long duration) {
        this.nativeRotateBy(this.mNativeMapViewPtr, sx, sy, ex, ey, duration);
    }

    public void setBearing(double degrees) {
        this.setBearing(degrees, 0L);
    }

    public void setBearing(double degrees, long duration) {
        this.nativeSetBearing(this.mNativeMapViewPtr, degrees, duration);
    }

    public void setBearing(double degrees, double cx, double cy) {
        this.nativeSetBearing(this.mNativeMapViewPtr, degrees, cx, cy);
    }

    public double getBearing() {
        return this.nativeGetBearing(this.mNativeMapViewPtr);
    }

    public void resetNorth() {
        this.nativeResetNorth(this.mNativeMapViewPtr);
    }

    public long addMarker(Marker marker) {
        return this.nativeAddMarker(this.mNativeMapViewPtr, marker);
    }

    public long addPolyline(Polyline polyline) {
        return this.nativeAddPolyline(this.mNativeMapViewPtr, polyline);
    }

    public long addPolygon(Polygon polygon) {
        return this.nativeAddPolygon(this.mNativeMapViewPtr, polygon);
    }

    public long[] addPolygons(List<Polygon> polygon) {
        return this.nativeAddPolygons(this.mNativeMapViewPtr, polygon);
    }

    public void removeAnnotation(long id) {
        this.nativeRemoveAnnotation(this.mNativeMapViewPtr, id);
    }

    public void removeAnnotations(long[] ids) {
        this.nativeRemoveAnnotations(this.mNativeMapViewPtr, ids);
    }

    public long[] getAnnotationsInBounds(BoundingBox bbox) {
        return this.nativeGetAnnotationsInBounds(this.mNativeMapViewPtr, bbox);
    }

    public void setSprite(String symbol, int width, int height, float scale, byte[] pixels) {
        this.nativeSetSprite(this.mNativeMapViewPtr, symbol, width, height, scale, pixels);
    }

    public void onLowMemory() {
        this.nativeOnLowMemory(this.mNativeMapViewPtr);
    }

    public void setDebug(boolean debug) {
        this.nativeSetDebug(this.mNativeMapViewPtr, debug);
    }

    public void toggleDebug() {
        this.nativeToggleDebug(this.mNativeMapViewPtr);
    }

    public boolean getDebug() {
        return this.nativeGetDebug(this.mNativeMapViewPtr);
    }

    public void setCollisionDebug(boolean debug) {
        this.nativeSetCollisionDebug(this.mNativeMapViewPtr, debug);
    }

    public void toggleCollisionDebug() {
        this.nativeToggleCollisionDebug(this.mNativeMapViewPtr);
    }

    public boolean getCollisionDebug() {
        return this.nativeGetCollisionDebug(this.mNativeMapViewPtr);
    }

    public boolean isFullyLoaded() {
        return this.nativeIsFullyLoaded(this.mNativeMapViewPtr);
    }

    public void setReachability(boolean status) {
        this.nativeSetReachability(this.mNativeMapViewPtr, status);
    }

    public double getMetersPerPixelAtLatitude(double lat, double zoom) {
        return this.nativeGetMetersPerPixelAtLatitude(this.mNativeMapViewPtr, lat, zoom);
    }

    public ProjectedMeters projectedMetersForLatLng(LatLng latLng) {
        return this.nativeProjectedMetersForLatLng(this.mNativeMapViewPtr, latLng);
    }

    public LatLng latLngForProjectedMeters(ProjectedMeters projectedMeters) {
        return this.nativeLatLngForProjectedMeters(this.mNativeMapViewPtr, projectedMeters);
    }

    public PointF pixelForLatLng(LatLng latLng) {
        return this.nativePixelForLatLng(this.mNativeMapViewPtr, latLng);
    }

    public LatLng latLngForPixel(PointF pixel) {
        return this.nativeLatLngForPixel(this.mNativeMapViewPtr, pixel);
    }

    public double getTopOffsetPixelsForAnnotationSymbol(String symbolName) {
        return this.nativeGetTopOffsetPixelsForAnnotationSymbol(this.mNativeMapViewPtr, symbolName);
    }

    protected void onInvalidate() {
        this.mMapView.onInvalidate();
    }

    protected void onMapChanged(int rawChange) {
        this.mMapView.onMapChanged(rawChange);
    }

    protected void onFpsChanged(double fps) {
        this.mMapView.onFpsChanged(fps);
    }

    protected void finalize() throws Throwable {
        this.nativeDestroy(this.mNativeMapViewPtr);
        this.mNativeMapViewPtr = 0L;
        super.finalize();
    }

    private native long nativeCreate(String var1, String var2, String var3, float var4, int var5, long var6);

    private native void nativeDestroy(long var1);

    private native void nativeInitializeDisplay(long var1);

    private native void nativeTerminateDisplay(long var1);

    private native void nativeInitializeContext(long var1);

    private native void nativeTerminateContext(long var1);

    private native void nativeCreateSurface(long var1, Surface var3);

    private native void nativeDestroySurface(long var1);

    private native void nativePause(long var1);

    private native void nativeResume(long var1);

    private native void nativeUpdate(long var1);

    private native void nativeOnInvalidate(long var1);

    private native void nativeViewResize(long var1, int var3, int var4);

    private native void nativeFramebufferResize(long var1, int var3, int var4);

    private native void nativeAddClass(long var1, String var3);

    private native void nativeRemoveClass(long var1, String var3);

    private native boolean nativeHasClass(long var1, String var3);

    private native void nativeSetClasses(long var1, List<String> var3);

    private native List<String> nativeGetClasses(long var1);

    private native void nativeSetDefaultTransitionDuration(long var1, long var3);

    private native long nativeGetDefaultTransitionDuration(long var1);

    private native void nativeSetStyleUrl(long var1, String var3);

    private native void nativeSetStyleJson(long var1, String var3, String var4);

    private native String nativeGetStyleJson(long var1);

    private native void nativeSetAccessToken(long var1, String var3);

    private native String nativeGetAccessToken(long var1);

    private native void nativeCancelTransitions(long var1);

    private native void nativeSetGestureInProgress(long var1, boolean var3);

    private native void nativeMoveBy(long var1, double var3, double var5, long var7);

    private native void nativeSetLatLng(long var1, LatLng var3, long var4);

    private native LatLng nativeGetLatLng(long var1);

    private native void nativeResetPosition(long var1);

    private native void nativeScaleBy(long var1, double var3, double var5, double var7, long var9);

    private native void nativeSetScale(long var1, double var3, double var5, double var7, long var9);

    private native double nativeGetScale(long var1);

    private native void nativeSetZoom(long var1, double var3, long var5);

    private native double nativeGetZoom(long var1);

    private native void nativeSetLatLngZoom(long var1, LatLngZoom var3, long var4);

    private native LatLngZoom nativeGetLatLngZoom(long var1);

    private native void nativeResetZoom(long var1);

    private native double nativeGetMinZoom(long var1);

    private native double nativeGetMaxZoom(long var1);

    private native void nativeRotateBy(long var1, double var3, double var5, double var7, double var9, long var11);

    private native void nativeSetBearing(long var1, double var3, long var5);

    private native void nativeSetBearing(long var1, double var3, double var5, double var7);

    private native double nativeGetBearing(long var1);

    private native void nativeResetNorth(long var1);

    private native long nativeAddMarker(long var1, Marker var3);

    private native long nativeAddPolyline(long var1, Polyline var3);

    private native long nativeAddPolygon(long var1, Polygon var3);

    private native long[] nativeAddPolygons(long var1, List<Polygon> var3);

    private native void nativeRemoveAnnotation(long var1, long var3);

    private native void nativeRemoveAnnotations(long var1, long[] var3);

    private native long[] nativeGetAnnotationsInBounds(long var1, BoundingBox var3);

    private native void nativeSetSprite(long var1, String var3, int var4, int var5, float var6, byte[] var7);

    private native void nativeOnLowMemory(long var1);

    private native void nativeSetDebug(long var1, boolean var3);

    private native void nativeToggleDebug(long var1);

    private native boolean nativeGetDebug(long var1);

    private native void nativeSetCollisionDebug(long var1, boolean var3);

    private native void nativeToggleCollisionDebug(long var1);

    private native boolean nativeGetCollisionDebug(long var1);

    private native boolean nativeIsFullyLoaded(long var1);

    private native void nativeSetReachability(long var1, boolean var3);

    private native double nativeGetMetersPerPixelAtLatitude(long var1, double var3, double var5);

    private native ProjectedMeters nativeProjectedMetersForLatLng(long var1, LatLng var3);

    private native LatLng nativeLatLngForProjectedMeters(long var1, ProjectedMeters var3);

    private native PointF nativePixelForLatLng(long var1, LatLng var3);

    private native LatLng nativeLatLngForPixel(long var1, PointF var3);

    private native double nativeGetTopOffsetPixelsForAnnotationSymbol(long var1, String var3);

    static {
        System.loadLibrary("mapbox-gl");
    }
}

