/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.graphics.Point;
import android.view.View;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.InfoWindow;
import com.mapbox.mapboxsdk.geometry.LatLng;

public class Marker
extends Annotation {
    float anchorU;
    float anchorV;
    boolean draggable;
    boolean flat;
    float infoWindowAnchorU;
    float infoWindowAnchorV;
    LatLng position;
    float rotation;
    String snippet;
    String sprite = "default_marker";
    String title;
    private InfoWindow infoWindow = null;
    private boolean infoWindowShown = false;

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Marker)) {
            return false;
        }
        double lat = this.position.getLatitude();
        double lng = this.position.getLongitude();
        LatLng otherPosition = ((Marker)other).getPosition();
        double otherLat = otherPosition.getLatitude();
        double otherLng = otherPosition.getLongitude();
        return lat == otherLat && otherLng == lng;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    public Point getAnchor() {
        return new Point((int)this.anchorU, (int)this.anchorV);
    }

    public float getAnchorU() {
        return this.anchorU;
    }

    public float getAnchorV() {
        return this.anchorV;
    }

    public LatLng getPosition() {
        return this.position;
    }

    public float getRotation() {
        return this.rotation;
    }

    public String getSnippet() {
        return this.snippet;
    }

    public String getTitle() {
        return this.title;
    }

    public void hideInfoWindow() {
        if (this.infoWindow != null) {
            this.infoWindow.close();
        }
        this.infoWindowShown = false;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public boolean isInfoWindowShown() {
        return this.infoWindowShown;
    }

    public void setAnchor(float u, float v) {
        this.anchorU = u;
        this.anchorV = v;
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    public void setFlat(boolean flat) {
        this.flat = flat;
    }

    public void setInfoWindowAnchor(float u, float v) {
        this.infoWindowAnchorU = u;
        this.infoWindowAnchorV = v;
    }

    public void setPosition(LatLng latlng) {
        this.position = this.position;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public void setSnippet(String snippet) {
        this.snippet = snippet;
    }

    public void setSprite(String sprite) {
        this.sprite = sprite;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void showInfoWindow() {
        if (!this.isVisible() || this.mapView == null) {
            return;
        }
        this.getInfoWindow().open(this, this.getPosition(), (int)this.anchorU, (int)this.anchorV);
        this.getInfoWindow().setBoundMarker(this);
        this.infoWindowShown = true;
    }

    public void setInfoWindowOnTouchListener(View.OnTouchListener listener) {
        if (listener == null) {
            return;
        }
        this.getInfoWindow().setOnTouchListener(listener);
    }

    private InfoWindow getInfoWindow() {
        if (this.infoWindow == null) {
            this.infoWindow = new InfoWindow(R.layout.infowindow, this.mapView);
        }
        return this.infoWindow;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible && this.infoWindowShown) {
            this.hideInfoWindow();
        }
    }
}

