/*
 * Decompiled with CFR 0.152.
 */
package com.spatialdev.osm.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import com.mapbox.mapboxsdk.views.MapView;
import com.mapbox.mapboxsdk.views.util.Projection;
import com.spatialdev.osm.model.OSMElement;
import com.spatialdev.osm.model.OSMNode;
import com.spatialdev.osm.model.OSMWay;
import com.spatialdev.osm.renderer.OSMLine;
import com.spatialdev.osm.renderer.OSMPolygon;
import java.util.List;

public abstract class OSMPath {
    protected Paint paint = new Paint();
    protected final Path path = new Path();
    private float strokeWidth = 10.0f;
    protected final double[] tempPoint = new double[2];
    protected double[][] projectedPoints;
    protected MapView mapView;
    protected Rect viewPortBounds;
    protected boolean pathLineToReady = false;

    public static OSMPath createOSMPath(OSMElement element, MapView mv) {
        if (element instanceof OSMWay) {
            OSMWay w = (OSMWay)element;
            if (w.isClosed()) {
                return new OSMPolygon(w, mv);
            }
            return new OSMLine(w, mv);
        }
        return null;
    }

    protected OSMPath(OSMWay w, MapView mv) {
        List<OSMNode> nodes = w.getNodes();
        this.projectNodes(nodes);
        this.mapView = mv;
        this.paint.setAntiAlias(true);
    }

    private void projectNodes(List<OSMNode> nodes) {
        this.projectedPoints = new double[nodes.size()][2];
        int i = 0;
        for (OSMNode n : nodes) {
            this.projectedPoints[i++] = Projection.latLongToPixelXY(n.getLat(), n.getLng());
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public OSMPath setPaint(Paint pPaint) {
        this.paint = pPaint;
        return this;
    }

    public void setStrokeWidth(float width) {
        this.strokeWidth = width;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public abstract void select();

    public abstract void deselect();

    public void draw(Canvas c) {
        double[] screenPoint;
        double[] projectedPoint;
        int size = this.projectedPoints.length;
        if (size < 2) {
            return;
        }
        Projection pj = this.mapView.getProjection();
        this.viewPortBounds = pj.fromPixelsToProjected(pj.getScreenRect());
        this.path.rewind();
        for (int i = size - 1; i > 0; --i) {
            projectedPoint = this.projectedPoints[i];
            screenPoint = pj.toMapPixelsTranslated(projectedPoint, this.tempPoint);
            this.clipOrDrawPath(this.path, projectedPoint, this.projectedPoints[i - 1], screenPoint);
        }
        projectedPoint = this.projectedPoints[0];
        screenPoint = pj.toMapPixelsTranslated(projectedPoint, this.tempPoint);
        this.clipOrDrawPath(this.path, projectedPoint, null, screenPoint);
        this.pathLineToReady = false;
        this.paint.setStrokeWidth(this.strokeWidth / this.mapView.getScale());
        c.drawPath(this.path, this.paint);
    }

    abstract void clipOrDrawPath(Path var1, double[] var2, double[] var3, double[] var4);
}

